/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.bigimage.thresholding;

import algorithms.danyfel80.bigimage.thresholding.BigImageThresholder;
import icy.gui.dialog.MessageDialog;
import java.io.File;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;

public class BigImageThresholding
extends EzPlug
implements EzStoppable {
    EzVarFile inInputFile = new EzVarFile("Input file", "");
    EzVarFile inOutputFile = new EzVarFile("Output file", "");
    EzVarDouble inMinValue = new EzVarDouble("Minimum value", 0.0, 0.0, 255.0, Double.MIN_VALUE);
    EzVarDouble inMaxValue = new EzVarDouble("Maximum value", 1.0, 0.0, 255.0, Double.MIN_VALUE);
    BigImageThresholder thresholder;

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inInputFile);
        this.addEzComponent((EzComponent)this.inOutputFile);
        this.addEzComponent((EzComponent)this.inMinValue);
        this.addEzComponent((EzComponent)this.inMaxValue);
    }

    protected void execute() {
        if (this.validateInput() != 0) {
            return;
        }
        System.out.println("valid input");
        File inputFile = (File)this.inInputFile.getValue();
        File outputFile = (File)this.inOutputFile.getValue();
        double minValue = (Double)this.inMinValue.getValue();
        double maxValue = (Double)this.inMaxValue.getValue();
        this.thresholder = new BigImageThresholder(inputFile, outputFile, minValue, maxValue);
        System.out.println("Thresholder created");
        this.thresholder.execute();
        System.out.println("Thresholder executed");
    }

    private int validateInput() {
        if (this.inInputFile.getValue() == null || !((File)this.inInputFile.getValue()).exists()) {
            MessageDialog.showDialog((String)"Error", (String)"Select a valid input file. (Error: -1)", (int)0);
            return -1;
        }
        if (this.inOutputFile.getValue() == null || ((File)this.inOutputFile.getValue()).getParentFile() == null || !((File)this.inOutputFile.getValue()).getParentFile().exists()) {
            MessageDialog.showDialog((String)"Error", (String)"Select a valid output file. (Error: -2)", (int)0);
            return -2;
        }
        if ((Double)this.inMinValue.getValue() < 0.0 || (Double)this.inMinValue.getValue() > 255.0) {
            MessageDialog.showDialog((String)"Error", (String)"Select a valid min value between 0 and 255. (Error: -3)", (int)0);
            return -3;
        }
        if ((Double)this.inMaxValue.getValue() < 0.0 || (Double)this.inMaxValue.getValue() > 255.0) {
            MessageDialog.showDialog((String)"Error", (String)"Select a valid max value between 0 and 255. (Error: -4)", (int)0);
            return -4;
        }
        return 0;
    }

    public void stopExecution() {
        if (this.thresholder != null) {
            this.thresholder.stopExecution();
        }
    }

    public void clean() {
    }
}

