/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.BUnwarpper;
import algorithms.danyfel80.registration.bunwarp.BigBUnwarpper;
import algorithms.danyfel80.registration.bunwarp.MaximumScaleDeformationEnum;
import algorithms.danyfel80.registration.bunwarp.MinimumScaleDeformationEnum;
import algorithms.danyfel80.registration.bunwarp.RegistrationModeEnum;
import icy.gui.dialog.MessageDialog;
import icy.roi.ROI2D;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.importer.LociImporterPlugin;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class BigImageBUnwarp
extends BUnwarp {
    EzVarFile inSrcFile = new EzVarFile("Source file", "");
    EzVarFile inTgtFile = new EzVarFile("Target file", "");
    EzVarEnum<RegistrationModeEnum> inMode = new EzVarEnum("Mode", (Enum[])RegistrationModeEnum.values(), (Enum)RegistrationModeEnum.ACCURATE);
    EzVarInteger inSubsampleFactor = new EzVarInteger("Image Subsampling Factor", 0, 0, 7, 1);
    EzVarFile inSrcResultFile = new EzVarFile("File to apply source transformation", "");
    EzVarFile inTgtResultFile = new EzVarFile("File to apply target transformation", "");
    EzVarEnum<MinimumScaleDeformationEnum> inIniDef = new EzVarEnum("Initial deformation", (Enum[])MinimumScaleDeformationEnum.values(), (Enum)MinimumScaleDeformationEnum.COARSE);
    EzVarEnum<MaximumScaleDeformationEnum> inFnlDef = new EzVarEnum("Final Deformation", (Enum[])MaximumScaleDeformationEnum.values(), (Enum)MaximumScaleDeformationEnum.VERY_FINE);
    EzVarDouble inDivWeight = new EzVarDouble("Divergence Weight");
    EzVarDouble inCurlWeight = new EzVarDouble("Curl Weight");
    EzVarDouble inImageWeight = new EzVarDouble("Image Weight");
    EzVarDouble inConsistencyWeight = new EzVarDouble("Consistency Weight");
    EzGroup weightsGroup = new EzGroup("Weights", new EzComponent[]{this.inDivWeight, this.inCurlWeight, this.inImageWeight, this.inConsistencyWeight});
    EzVarDouble inStopThreshold = new EzVarDouble("Stop Threshold");
    EzVarBoolean inShowProcess = new EzVarBoolean("Show Process", false);
    EzGroup outputFileGroup = new EzGroup("Transformed output", new EzComponent[]{this.inSrcResultFile, this.inTgtResultFile});
    EzGroup advancedParamsGroup = new EzGroup("Advanced Parameters", new EzComponent[]{this.inIniDef, this.inFnlDef, this.outputFileGroup, this.weightsGroup, this.inStopThreshold, this.inShowProcess});
    Thread but;
    BUnwarpper bu;

    public void declareInput(VarList inputMap) {
        inputMap.add(this.inSrcFile.name, this.inSrcFile.getVariable());
        inputMap.add(this.inTgtFile.name, this.inTgtFile.getVariable());
        inputMap.add(this.inSrcResultFile.name, this.inSrcResultFile.getVariable());
        inputMap.add(this.inTgtResultFile.name, this.inTgtResultFile.getVariable());
        inputMap.add(this.inMode.name, this.inMode.getVariable());
        inputMap.add(this.inSubsampleFactor.name, this.inSubsampleFactor.getVariable());
        inputMap.add(this.inIniDef.name, this.inIniDef.getVariable());
        inputMap.add(this.inFnlDef.name, this.inFnlDef.getVariable());
        inputMap.add(this.inDivWeight.name, this.inDivWeight.getVariable());
        inputMap.add(this.inCurlWeight.name, this.inCurlWeight.getVariable());
        inputMap.add(this.inImageWeight.name, this.inImageWeight.getVariable());
        inputMap.add(this.inConsistencyWeight.name, this.inConsistencyWeight.getVariable());
        inputMap.add(this.inStopThreshold.name, this.inStopThreshold.getVariable());
        inputMap.add(this.inShowProcess.name, this.inShowProcess.getVariable());
        this.inDivWeight.setValue((Object)0.0);
        this.inCurlWeight.setValue((Object)0.0);
        this.inImageWeight.setValue((Object)1.0);
        this.inConsistencyWeight.setValue((Object)10.0);
        this.inStopThreshold.setValue((Object)0.01);
    }

    public void declareOutput(VarList outputMap) {
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inSrcFile);
        this.addEzComponent((EzComponent)this.inTgtFile);
        this.addEzComponent((EzComponent)this.inMode);
        this.addEzComponent((EzComponent)this.inSubsampleFactor);
        this.outputFileGroup.setFoldedState(true);
        this.weightsGroup.setFoldedState(true);
        this.advancedParamsGroup.setFoldedState(true);
        this.addEzComponent((EzComponent)this.advancedParamsGroup);
        this.inSrcFile.setToolTipText("Source(floating) image file used to perform the registration.");
        this.inTgtFile.setToolTipText("Target(fixed) image file used to perform the registration.");
        this.inSrcResultFile.setToolTipText("Image file used to apply source transformation.");
        this.inTgtResultFile.setToolTipText("Image file used to apply target transformation.");
        this.inMode.setToolTipText("Mode of interpolation: Mono uses source -> target transformation. Fast or Accurate use source <-> target transformation.");
        this.inSubsampleFactor.setToolTipText("Level of subsampling of the source and target sequences to perform the registration.");
        this.inIniDef.setToolTipText("Sets the initial transformation detail.");
        this.inFnlDef.setToolTipText("Sets the final transformation detail.");
        this.inDivWeight.setToolTipText("Weight related to the divergence of the tensors in the transformation. Higher value means result will have less divergence.");
        this.inCurlWeight.setToolTipText("Weight related to the curl of the tensors in the transformation. Higher value means result will have less curl.");
        this.inImageWeight.setToolTipText("Weight related to image intensities. Higher value means image intensities will have more impact on the result.");
        this.inConsistencyWeight.setToolTipText("When the mode is set to Fast or Accurate, this weight represents the similarity constraint on the s->t and t->s transformations. The higher the value, the more similar the transformations will be.");
        this.inStopThreshold.setToolTipText("This is the optimization stop criteria. When the optimization changes the transformation less than the given value, the process ends and the result is shown.");
        this.inShowProcess.setToolTipText("If checked, more details of the transformation will be shown at the end of the procedure.");
        this.inDivWeight.setValue((Object)0.0);
        this.inCurlWeight.setValue((Object)0.0);
        this.inImageWeight.setValue((Object)1.0);
        this.inConsistencyWeight.setValue((Object)10.0);
        this.inStopThreshold.setValue((Object)0.01);
        this.inMode.addVarChangeListener((EzVarListener)new EzVarListener<RegistrationModeEnum>(){

            public void variableChanged(EzVar<RegistrationModeEnum> source, RegistrationModeEnum newValue) {
                BigImageBUnwarp.this.inConsistencyWeight.setEnabled(newValue != RegistrationModeEnum.MONO);
            }
        });
    }

    protected void execute() {
        this.isPluginInterrupted = false;
        if (this.validateInput() != 0) {
            return;
        }
        String srcPath = ((File)this.inSrcFile.getValue()).getPath();
        String tgtPath = ((File)this.inTgtFile.getValue()).getPath();
        String transformedSrcPath = this.inSrcResultFile.getValue() == null ? ((File)this.inSrcFile.getValue()).getPath() : ((File)this.inSrcResultFile.getValue()).getPath();
        String transformedTgtPath = this.inTgtResultFile.getValue() == null ? ((File)this.inTgtFile.getValue()).getPath() : ((File)this.inTgtResultFile.getValue()).getPath();
        String srcResultPath = FilenameUtils.getFullPath((String)srcPath);
        srcResultPath = String.valueOf(srcResultPath) + FilenameUtils.getBaseName((String)srcPath);
        srcResultPath = String.valueOf(srcResultPath) + "_BUnwarp.tif";
        String tgtResultPath = FilenameUtils.getFullPath((String)tgtPath);
        tgtResultPath = String.valueOf(tgtResultPath) + FilenameUtils.getBaseName((String)tgtPath);
        tgtResultPath = String.valueOf(tgtResultPath) + "_BUnwarp.tif";
        String transformedSrcResultPath = FilenameUtils.getFullPath((String)transformedSrcPath);
        transformedSrcResultPath = String.valueOf(transformedSrcResultPath) + FilenameUtils.getBaseName((String)transformedSrcPath);
        transformedSrcResultPath = String.valueOf(transformedSrcResultPath) + "_BUnwarp.tif";
        String transformedTgtResultPath = FilenameUtils.getFullPath((String)transformedTgtPath);
        transformedTgtResultPath = String.valueOf(transformedTgtResultPath) + FilenameUtils.getBaseName((String)transformedTgtPath);
        transformedTgtResultPath = String.valueOf(transformedTgtResultPath) + "_BUnwarp.tif";
        long startTime = System.nanoTime();
        List<ROI2DPoint> srcLandmarks = null;
        List<ROI2DPoint> tgtLandmarks = null;
        ROI2D srcMask = null;
        ROI2D tgtMask = null;
        BigBUnwarpper bu = new BigBUnwarpper(srcPath, tgtPath, transformedSrcPath, transformedTgtPath, srcResultPath, tgtResultPath, transformedSrcResultPath, transformedTgtResultPath, srcLandmarks, tgtLandmarks, srcMask, tgtMask, (Integer)this.inSubsampleFactor.getValue(), ((MinimumScaleDeformationEnum)((Object)this.inIniDef.getValue())).getNumber(), ((MaximumScaleDeformationEnum)((Object)this.inFnlDef.getValue())).getNumber(), (Double)this.inDivWeight.getValue(), (Double)this.inCurlWeight.getValue(), 0.0, (Double)this.inImageWeight.getValue(), (Double)this.inConsistencyWeight.getValue(), (Double)this.inStopThreshold.getValue(), (Boolean)this.inShowProcess.getValue(), ((RegistrationModeEnum)((Object)this.inMode.getValue())).getNumber(), this);
        this.but = new Thread(bu);
        this.but.start();
        try {
            this.but.join();
            this.but = null;
        }
        catch (InterruptedException e) {
            System.err.println("Thread interrupted: " + e.getMessage());
        }
        long endTime = System.nanoTime();
        long totalTime = endTime - startTime;
        System.out.println(String.format("Done (%d millisecs)", totalTime / 1000000L));
    }

    private int validateInput() {
        LociImporterPlugin p = new LociImporterPlugin();
        if (!p.acceptFile(((File)this.inSrcFile.getValue()).getPath())) {
            MessageDialog.showDialog((String)"Error", (String)"Invalid source file.", (int)0);
            return 1;
        }
        if (!p.acceptFile(((File)this.inTgtFile.getValue()).getPath())) {
            MessageDialog.showDialog((String)"Error", (String)"Invalid target file.", (int)0);
            return 1;
        }
        return 0;
    }

    public void stopExecution() {
        this.isPluginInterrupted = true;
        if (this.but != null && this.but.isAlive()) {
            try {
                this.but.join();
                this.but = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void clean() {
    }

    @Override
    public void restoreAll() {
        if (this.getUI() != null) {
            this.getUI().setProgressBarMessage("");
            this.getUI().setProgressBarValue(0.0);
        }
        Runtime.getRuntime().gc();
    }
}

