/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.bigimage;

import algorithms.danyfel80.bigimage.BigImageLoader;
import algorithms.danyfel80.bigimage.BigImageSaver;
import algorithms.danyfel80.bigimage.BigImageUtil;
import algorithms.danyfel80.icyBufferedImage.util.IcyBufferedImageCursor;
import icy.common.listener.RichProgressListener;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class BigImageToTiffConverter
implements Callable<Void> {
    List<RichProgressListener> listeners = new LinkedList<RichProgressListener>();
    boolean isInterrupted;
    File inputFile;
    File outputFile;
    boolean[] channels;

    public BigImageToTiffConverter(File inputFile, File outputFile, boolean[] convertChannels) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.channels = convertChannels;
    }

    public void addProgressListener(RichProgressListener listener) {
        this.listeners.add(listener);
    }

    public void interrupt() {
        this.isInterrupted = true;
    }

    @Override
    public Void call() throws Exception {
        this.isInterrupted = false;
        String convertingMessage = "Converting Tiles";
        int imgSizeC = 0;
        imgSizeC = BigImageUtil.getSequenceChannelCount(this.inputFile.getAbsolutePath());
        Dimension imgSize = BigImageUtil.getSequenceSize(this.inputFile.getAbsolutePath());
        DataType imgType = BigImageUtil.getSequenceDataType(this.inputFile.getAbsolutePath());
        int numProc = Runtime.getRuntime().availableProcessors();
        long ram = Runtime.getRuntime().freeMemory();
        long maxTileSideSize = ram / (long)imgSizeC;
        maxTileSideSize /= (long)numProc;
        maxTileSideSize /= (long)imgType.getSize();
        maxTileSideSize = (long)Math.ceil(Math.sqrt(maxTileSideSize));
        int tileSideSize = 16;
        while (maxTileSideSize > (long)(tileSideSize * 16)) {
            tileSideSize *= 16;
        }
        Dimension tileDimension = new Dimension(tileSideSize, tileSideSize);
        System.out.println(String.format("Reading image with tiles of %d by %d pixels.", tileDimension.width, tileDimension.height));
        Dimension imageTileGridDimension = new Dimension((int)Math.ceil((double)imgSize.width / (double)tileDimension.width), (int)Math.ceil((double)imgSize.height / (double)tileDimension.height));
        BigImageSaver saver = null;
        int numComponents = 0;
        boolean[] blArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            numComponents += b ? 1 : 0;
            ++n2;
        }
        saver = new BigImageSaver(this.outputFile, imgSize, numComponents, DataType.UBYTE, tileDimension);
        ThreadPoolExecutor conversionTP = (ThreadPoolExecutor)Executors.newFixedThreadPool(numProc);
        ExecutorCompletionService<Rectangle> conversionCS = new ExecutorCompletionService<Rectangle>(conversionTP);
        int y = 0;
        while (y < imageTileGridDimension.height) {
            int tileHeight = tileDimension.height;
            tileHeight = y * tileHeight + tileHeight < imgSize.height ? tileHeight : imgSize.height - y * tileHeight;
            int x = 0;
            while (x < imageTileGridDimension.width) {
                int tileWidth = tileDimension.width;
                tileWidth = x * tileWidth + tileWidth < imgSize.width ? tileWidth : imgSize.width - x * tileWidth;
                Rectangle tileRectangle = new Rectangle(x * tileDimension.width, y * tileDimension.height, tileWidth, tileHeight);
                conversionCS.submit(new TileConversionTask(saver, tileRectangle));
                ++x;
            }
            ++y;
        }
        conversionTP.shutdown();
        int totalProgress = imageTileGridDimension.width * imageTileGridDimension.height;
        int currentProgress = 0;
        try {
            try {
                while (currentProgress < totalProgress) {
                    conversionCS.take().get();
                    ++currentProgress;
                    for (RichProgressListener listener : this.listeners) {
                        listener.notifyProgress(currentProgress, totalProgress, String.valueOf(convertingMessage) + String.format("(%d/%d)", currentProgress, totalProgress), null);
                    }
                }
            }
            catch (ExecutionException e) {
                conversionTP.shutdownNow();
                throw e;
            }
        }
        finally {
            saver.closeWriter();
        }
        return null;
    }

    public class TileConversionTask
    implements Callable<Rectangle> {
        BigImageSaver saver;
        Rectangle tileRectangle;

        public TileConversionTask(BigImageSaver saver, Rectangle tileRectangle) {
            this.saver = saver;
            this.tileRectangle = tileRectangle;
        }

        @Override
        public Rectangle call() throws Exception {
            if (BigImageToTiffConverter.this.isInterrupted) {
                return null;
            }
            Sequence tile = null;
            BigImageLoader loader = new BigImageLoader();
            tile = loader.loadDownsampledImage(BigImageToTiffConverter.this.inputFile.getAbsolutePath(), this.tileRectangle, this.tileRectangle.width, this.tileRectangle.height, false);
            IcyBufferedImage tileImage = tile.getFirstImage();
            if (BigImageToTiffConverter.this.isInterrupted) {
                return null;
            }
            int numComponents = 0;
            boolean[] blArray = BigImageToTiffConverter.this.channels;
            int n = BigImageToTiffConverter.this.channels.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = blArray[n2];
                numComponents += b ? 1 : 0;
                ++n2;
            }
            IcyBufferedImage resultTileImage = new IcyBufferedImage(tileImage.getSizeX(), tileImage.getSizeY(), numComponents, tileImage.getDataType_());
            IcyBufferedImageCursor tileCursor = new IcyBufferedImageCursor(tile, 0, 0);
            IcyBufferedImageCursor resultTileCursor = new IcyBufferedImageCursor(resultTileImage);
            int c = 0;
            int rc = 0;
            while (c < BigImageToTiffConverter.this.channels.length) {
                if (BigImageToTiffConverter.this.channels[c]) {
                    int x = 0;
                    while (x < this.tileRectangle.width) {
                        int y = 0;
                        while (y < this.tileRectangle.height) {
                            resultTileCursor.set(x, y, rc, tileCursor.get(x, y, c));
                            ++y;
                        }
                        ++x;
                    }
                    ++rc;
                }
                ++c;
            }
            resultTileCursor.commitChanges();
            if (BigImageToTiffConverter.this.isInterrupted) {
                return null;
            }
            this.saver.saveTile(resultTileImage, this.tileRectangle.getLocation());
            return this.tileRectangle;
        }
    }
}

