/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.bigimage.thresholding;

import algorithms.danyfel80.bigimage.BigImageLoader;
import algorithms.danyfel80.bigimage.BigImageSaver;
import algorithms.danyfel80.bigimage.BigImageUtil;
import icy.common.exception.UnsupportedFormatException;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.lut.LUT;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import loci.common.services.ServiceException;
import loci.formats.FormatException;

public class BigImageThresholder {
    boolean isInterrupted;
    final File inputFile;
    final File outputFile;
    final double minValue;
    final double maxValue;
    private int progress;
    private ProgressFrame progressFrame;

    public BigImageThresholder(File inputFile, File outputFile, double minValue, double maxValue) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.minValue = Math.min(minValue, maxValue);
        this.maxValue = Math.max(minValue, maxValue);
    }

    public void execute() {
        this.isInterrupted = false;
        this.progress = 0;
        this.progressFrame = new ProgressFrame("Starting thresholding...");
        Dimension imgSize = BigImageUtil.getSequenceSize(this.inputFile.getAbsolutePath());
        int imgSizeC = 0;
        try {
            BigImageUtil.getSequenceChannelCount(this.inputFile.getAbsolutePath());
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
            return;
        }
        int numProc = Runtime.getRuntime().availableProcessors();
        long ram = Runtime.getRuntime().freeMemory();
        long maxTileSideSize = ram / (long)(imgSizeC + 1);
        maxTileSideSize /= (long)numProc;
        maxTileSideSize = (long)Math.ceil(Math.sqrt(maxTileSideSize));
        maxTileSideSize /= 2L;
        long tileSideSize = 16L;
        while (maxTileSideSize > tileSideSize * 16L) {
            tileSideSize *= 16L;
        }
        Dimension tileCount = new Dimension(imgSize.width / (int)tileSideSize, imgSize.height / (int)tileSideSize);
        if ((long)tileCount.width * tileSideSize < (long)imgSize.width) {
            ++tileCount.width;
        }
        if ((long)tileCount.height * tileSideSize < (long)imgSize.height) {
            ++tileCount.height;
        }
        Dimension tileSize = new Dimension((int)tileSideSize, (int)tileSideSize);
        if (tileSize.width > imgSize.width) {
            tileSize.width = imgSize.width;
        }
        if (tileSize.height > imgSize.height) {
            tileSize.height = imgSize.height;
        }
        Dimension residualTileSize = new Dimension(imgSize.width % (int)tileSideSize, imgSize.height % (int)tileSideSize);
        System.out.println(String.format("Thresholder reading tile size: (%d px, %d px)", tileSize.width, tileSize.height));
        BigImageSaver saver = null;
        try {
            saver = new BigImageSaver(this.outputFile, imgSize, 1, DataType.UBYTE, tileSize);
        }
        catch (IOException | ServiceException | FormatException e) {
            e.printStackTrace();
            return;
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        this.progressFrame.setLength((double)(tileCount.width * tileCount.height));
        int i = 0;
        while (i < tileCount.width) {
            int tileSizeX = (i + 1) * tileSize.width > imgSize.width ? residualTileSize.width : tileSize.width;
            int j = 0;
            while (j < tileCount.height) {
                int tileSizeY = (j + 1) * tileSize.height > imgSize.height ? residualTileSize.height : tileSize.height;
                Point currTilePos = new Point(i * tileSize.width, j * tileSize.height);
                Dimension currTileSize = new Dimension(tileSizeX, tileSizeY);
                Rectangle currTileRect = new Rectangle(currTilePos, currTileSize);
                threadPool.submit(new TileThresholder(this.inputFile.getAbsolutePath(), currTileRect, saver, this.minValue, this.maxValue));
                ++j;
            }
            ++i;
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            saver.closeWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.progressFrame.close();
    }

    public void stopExecution() {
        this.isInterrupted = true;
    }

    private class TileThresholder
    implements Runnable {
        private final Rectangle currTileRect;
        private final BigImageSaver saver;
        private final double minValue;
        private final double maxValue;

        public TileThresholder(String absolutePath, Rectangle currTileRect, BigImageSaver saver, double minValue, double maxValue) {
            this.currTileRect = currTileRect;
            this.saver = saver;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (BigImageThresholder.this.isInterrupted) {
                return;
            }
            Sequence tile = null;
            try {
                BigImageLoader loader = new BigImageLoader();
                tile = loader.loadDownsampledImage(BigImageThresholder.this.inputFile.getAbsolutePath(), this.currTileRect, this.currTileRect.width, this.currTileRect.height, false);
            }
            catch (UnsupportedFormatException | IOException e) {
                System.err.println("Error loading tile: " + this.currTileRect);
                e.printStackTrace();
                return;
            }
            if (BigImageThresholder.this.isInterrupted) {
                return;
            }
            LUT lut = tile.createCompatibleLUT();
            int i = 0;
            while (i < lut.getNumChannel()) {
                lut.getLutChannel(i).setMin(this.minValue);
                lut.getLutChannel(i).setMax(this.maxValue);
                lut.getLutChannel(i).setMinBound(this.minValue);
                lut.getLutChannel(i).setMaxBound(this.maxValue);
                ++i;
            }
            Sequence bi = SequenceUtil.convertColor((Sequence)tile, (int)10, (LUT)lut);
            try {
                System.out.println("saving " + this.currTileRect);
                this.saver.saveTile(bi.getFirstImage(), this.currTileRect.getLocation());
            }
            catch (IOException | ServiceException | FormatException e) {
                e.printStackTrace();
                return;
            }
            BigImageThresholder bigImageThresholder = BigImageThresholder.this;
            synchronized (bigImageThresholder) {
                BigImageThresholder bigImageThresholder2 = BigImageThresholder.this;
                bigImageThresholder2.progress = bigImageThresholder2.progress + 1;
                BigImageThresholder.this.progressFrame.setMessage(String.format("Thresholding... tile %d/%d", BigImageThresholder.this.progress, (int)BigImageThresholder.this.progressFrame.getLength()));
                BigImageThresholder.this.progressFrame.setPosition((double)BigImageThresholder.this.progress);
            }
        }
    }
}

