/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.bigimage.BigImageSaver;
import algorithms.danyfel80.registration.bunwarp.BSplineModel;
import algorithms.danyfel80.registration.bunwarp.ProgressBar;
import icy.common.exception.UnsupportedFormatException;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.model.enums.PixelType;
import org.apache.commons.io.FilenameUtils;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.importer.LociImporterPlugin;

public class BigImageTools {
    public static Dimension getSequenceSize(String path) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            int imgSizeX = (Integer)imgProps.getPixelsSizeX(0).getValue();
            int imgSizeY = (Integer)imgProps.getPixelsSizeY(0).getValue();
            Dimension dimension = new Dimension(imgSizeX, imgSizeY);
            return dimension;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getSequenceChannelCount(String path) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            int n = (Integer)imgProps.getPixelsSizeC(0).getValue();
            return n;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static DataType getSequenceDataType(String path) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            DataType dataType = DataType.getDataTypeFromPixelType((PixelType)imgProps.getPixelsType(0));
            return dataType;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Sequence loadSubsampledSequence(String path, String name) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            int imgSizeX = (Integer)imgProps.getPixelsSizeX(0).getValue();
            int imgSizeY = (Integer)imgProps.getPixelsSizeY(0).getValue();
            int maxResolution = Math.max(imgSizeX, imgSizeY);
            int resolution = 0;
            while (maxResolution > 2000) {
                maxResolution /= 2;
                ++resolution;
            }
            IcyBufferedImage imageDS = importer.getImage(0, resolution, 0, 0);
            Sequence sequenceDS = new Sequence(imageDS);
            if (maxResolution > 1000) {
                sequenceDS = SequenceUtil.scale((Sequence)sequenceDS, (int)((int)Math.round((double)imageDS.getSizeX() / 2.0)), (int)((int)Math.round((double)imageDS.getSizeY() / 2.0)));
            }
            sequenceDS.setName(name);
            Sequence sequence = sequenceDS;
            return sequence;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Sequence loadImageTile(String path, String name, Rectangle tile) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            IcyBufferedImage imageDS = importer.getImage(0, 0, tile, 0, 0);
            Sequence sequenceDS = new Sequence(imageDS);
            sequenceDS.setName(name);
            Sequence sequence = sequenceDS;
            return sequence;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Rectangle computeTransformationUsedArea(int intervals, double[][] cx, double[][] cy, Dimension targetFullSize) {
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        int nproc = Runtime.getRuntime().availableProcessors();
        int blockHeight = targetFullSize.height / nproc;
        if (targetFullSize.height % 2 != 0) {
            ++blockHeight;
        }
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        Rectangle[] usedBoxes = new Rectangle[nThreads];
        int i = 0;
        while (i < nThreads) {
            int y0 = i * blockHeight;
            if (nThreads - 1 == i) {
                blockHeight = targetFullSize.height - i * blockHeight;
            }
            rects[i] = new Rectangle(0, y0, targetFullSize.width, blockHeight);
            usedBoxes[i] = new Rectangle();
            threads[i] = new Thread(new TransformBoundingBoxComputationOnTile(swx, swy, intervals, targetFullSize, rects[i], usedBoxes[i]));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            try {
                threads[i].join();
                threads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Rectangle usedBox = new Rectangle(usedBoxes[0]);
        int i2 = 1;
        while (i2 < usedBoxes.length) {
            usedBox.x = Math.min(usedBox.x, usedBoxes[i2].x);
            usedBox.y = Math.min(usedBox.y, usedBoxes[i2].y);
            usedBox.width = Math.max(usedBox.width, usedBoxes[i2].width);
            usedBox.height = Math.max(usedBox.height, usedBoxes[i2].height);
            rects[i2] = null;
            usedBoxes[i2] = null;
            ++i2;
        }
        return usedBox;
    }

    public static Sequence applyTransformationToImage(String srcResultPath, String srcPath, String transformedSrcPath, String tgtPath, int intervals, double[][] cx, double[][] cy, Dimension registeredTgtDimension) {
        int srcChannels = BigImageTools.getSequenceChannelCount(srcPath);
        DataType srcDataType = BigImageTools.getSequenceDataType(srcPath);
        Dimension transformedSrcDimension = BigImageTools.getSequenceSize(transformedSrcPath);
        int transformedSrcChannels = BigImageTools.getSequenceChannelCount(transformedSrcPath);
        DataType transformedSrcDataType = BigImageTools.getSequenceDataType(transformedSrcPath);
        Dimension tgtDimension = BigImageTools.getSequenceSize(tgtPath);
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        Dimension tileDimension = new Dimension(500, 500);
        Dimension tgtTileCount = new Dimension((int)Math.ceil((double)tgtDimension.width / (double)tileDimension.width), (int)Math.ceil((double)tgtDimension.height / (double)tileDimension.height));
        int totalTgtTileCount = tgtTileCount.width * tgtTileCount.height;
        Sequence resultSeq = new Sequence(new IcyBufferedImage(tgtTileCount.width * tileDimension.width, tgtTileCount.height * tileDimension.height, transformedSrcChannels, transformedSrcDataType));
        resultSeq.beginUpdate();
        double[][] resultData = Array2DUtil.arrayToDoubleArray((Object)resultSeq.getDataXYC(0, 0), (boolean)resultSeq.isSignedDataType());
        int c = 0;
        while (c < resultData.length) {
            int y = 0;
            while (y < resultSeq.getHeight()) {
                int yOff = y * resultSeq.getSizeX();
                int x = 0;
                while (x < resultSeq.getWidth()) {
                    resultData[c][x + yOff] = 100.0;
                    ++x;
                }
                ++y;
            }
            ++c;
        }
        int numProc = Runtime.getRuntime().availableProcessors();
        TileTransformProcessing[] threads = new TileTransformProcessing[numProc];
        int tileNo = 0;
        while (tileNo < totalTgtTileCount) {
            int thr = 0;
            while (thr < numProc && tileNo < totalTgtTileCount) {
                Rectangle tileRect = new Rectangle(tileNo % tgtTileCount.width * tileDimension.width, tileNo / tgtTileCount.width * tileDimension.height, tileDimension.width, tileDimension.height);
                threads[thr] = new TileTransformProcessing(intervals, swx, swy, tgtDimension, registeredTgtDimension, tileRect, srcPath, srcChannels, srcDataType, transformedSrcPath, transformedSrcChannels, transformedSrcDataType, transformedSrcDimension, new Point(0, 0));
                ++thr;
                ++tileNo;
            }
            int usedThr = thr;
            thr = 0;
            while (thr < usedThr) {
                threads[thr].start();
                ++thr;
            }
            thr = 0;
            while (thr < usedThr) {
                TileTransformProcessing thread = threads[thr];
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                double[][] resultTileData = Array2DUtil.arrayToDoubleArray((Object)thread.transformedResultTile.getDataXYC(), (boolean)thread.transformedResultTile.isSignedDataType());
                int y = 0;
                int v = ((TileTransformProcessing)thread).tileRect.y;
                while (y < ((TileTransformProcessing)thread).tileRect.height) {
                    int y_offset = y * ((TileTransformProcessing)thread).tileRect.width;
                    int v_offset = v * resultSeq.getWidth();
                    int x = 0;
                    int u = ((TileTransformProcessing)thread).tileRect.x;
                    while (x < ((TileTransformProcessing)thread).tileRect.width) {
                        int c2 = 0;
                        while (c2 < resultData.length) {
                            resultData[c2][u + v_offset] = resultTileData[c2][x + y_offset];
                            ++c2;
                        }
                        ++x;
                        ++u;
                    }
                    ++y;
                    ++v;
                }
                threads[thr] = null;
                ++thr;
            }
        }
        Array2DUtil.doubleArrayToSafeArray((double[][])resultData, (Object)resultSeq.getDataXYC(0, 0), (boolean)resultSeq.isSignedDataType());
        resultSeq.dataChanged();
        resultSeq.endUpdate();
        return resultSeq;
    }

    private static Rectangle computeTransformSourceTileArea(int intervals, BSplineModel swx, BSplineModel swy, Rectangle rect, Dimension srcDimension, Dimension tgtDimension, Dimension registeredTgtDimension) {
        Rectangle area = new Rectangle();
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        boolean first = true;
        double factorX = (double)tgtDimension.width / (double)registeredTgtDimension.width;
        double factorY = (double)tgtDimension.height / (double)registeredTgtDimension.height;
        int tileEndHeight = rect.y + rect.height;
        int tileEndWidth = rect.x + rect.width;
        int v = rect.y - 2;
        while (v < tileEndHeight + 2) {
            double tv = (double)(v * intervals) / (double)(tgtDimension.height - 1) + 1.0;
            int u = rect.x - 2;
            while (u < tileEndWidth + 2) {
                double tu = (double)(u * intervals) / (double)(tgtDimension.width - 1) + 1.0;
                double x = swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false) * factorX;
                double y = swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false) * factorY;
                if (x >= 0.0 && x < (double)srcDimension.width && y >= 0.0 && y < (double)srcDimension.height) {
                    if (first) {
                        first = false;
                        minX = x;
                        minY = y;
                        maxX = x;
                        maxY = y;
                    } else {
                        minX = Math.min(minX, x);
                        minY = Math.min(minY, y);
                        maxX = Math.max(maxX, x);
                        maxY = Math.max(maxY, y);
                    }
                }
                ++u;
            }
            ++v;
        }
        area.x = first ? 0 : (int)Math.floor(minX);
        area.y = first ? 0 : (int)Math.floor(minY);
        area.width = first ? 0 : (int)Math.ceil(maxX - minX);
        area.height = first ? 0 : (int)Math.ceil(maxY - minY);
        return area;
    }

    public static Sequence getInterpolatedImage(Sequence srcSeq) {
        IcyBufferedImage ibi = srcSeq.getFirstImage();
        BSplineModel[] models = new BSplineModel[srcSeq.getSizeC()];
        int i = 0;
        while (i < models.length) {
            models[i] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)ibi, (int)i), false, 1);
            models[i].setPyramidDepth(0);
            models[i].startPyramids();
            ++i;
        }
        i = 0;
        while (i < models.length) {
            try {
                models[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Sequence result = new Sequence(new IcyBufferedImage(ibi.getWidth(), ibi.getHeight(), ibi.getSizeC(), ibi.getDataType_()));
        result.beginUpdate();
        double[][] resultData = Array2DUtil.arrayToDoubleArray((Object)result.getDataXYC(0, 0), (boolean)result.isSignedDataType());
        int y = 0;
        while (y < ibi.getSizeY()) {
            int yOff = y * ibi.getSizeX();
            int x = 0;
            while (x < ibi.getSizeX()) {
                int c = 0;
                while (c < resultData.length) {
                    resultData[c][x + yOff] = models[c].prepareForInterpolationAndInterpolateI(x, y, false, false);
                    ++c;
                }
                ++x;
            }
            ++y;
        }
        Array2DUtil.doubleArrayToSafeArray((double[][])resultData, (Object)result.getDataXYC(0, 0), (boolean)result.isSignedDataType());
        result.dataChanged();
        result.endUpdate();
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void applyAndSaveTransformationToBigImage(String srcResultPath, String transformedSrcResultPath, String srcPath, String transformedSrcPath, String tgtPath, int intervals, double[][] cx, double[][] cy, Dimension registeredTgtDimension, BUnwarp plugin, Rectangle resultTile) throws ServiceException, IOException, FormatException, InterruptedException, ExecutionException {
        ProgressBar.setProgressBarMessage("Transforming original image...");
        ProgressBar.setProgressBarValue(0.0);
        Dimension transformedSrcDimension = BigImageTools.getSequenceSize(transformedSrcPath);
        int transformedSrcChannels = BigImageTools.getSequenceChannelCount(transformedSrcPath);
        DataType transformedSrcDataType = BigImageTools.getSequenceDataType(transformedSrcPath);
        int srcChannels = BigImageTools.getSequenceChannelCount(srcPath);
        DataType srcDataType = BigImageTools.getSequenceDataType(srcPath);
        Dimension tgtDimension = BigImageTools.getSequenceSize(tgtPath);
        if (resultTile == null) {
            resultTile = new Rectangle(new Point(0, 0), tgtDimension);
        }
        if ((resultTile = resultTile.intersection(new Rectangle(new Point(0, 0), tgtDimension))).isEmpty()) {
            return;
        }
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        System.gc();
        long ram = Runtime.getRuntime().freeMemory();
        int numProc = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        System.out.println("Available memory: " + ram + " bytes, Available processors: " + numProc);
        ram /= (long)transformedSrcChannels;
        double szMax = Math.sqrt(ram /= (long)numProc);
        int tileSize = 16;
        while (szMax > (double)(tileSize * 16)) {
            tileSize *= 16;
        }
        System.out.println("Image size: " + transformedSrcDimension.width + "px*" + transformedSrcDimension.height + "px. Tile size: " + tileSize);
        Dimension tileDimension = new Dimension(tileSize, tileSize);
        if (tileDimension.width > resultTile.width) {
            tileDimension.width = resultTile.width;
        }
        if (tileDimension.height > resultTile.height) {
            tileDimension.height = resultTile.height;
        }
        Dimension tgtTileCount = new Dimension(resultTile.width / tileDimension.width, resultTile.height / tileDimension.height);
        if (tgtTileCount.width * tileDimension.width < resultTile.width) {
            ++tgtTileCount.width;
        }
        if (tgtTileCount.height * tileDimension.height < resultTile.height) {
            ++tgtTileCount.height;
        }
        int totalTgtTileCount = tgtTileCount.width * tgtTileCount.height;
        final BigImageSaver resultSaver = new BigImageSaver(new File(srcResultPath), resultTile.getSize(), srcChannels, srcDataType, tileDimension);
        final BigImageSaver transformedResultSaver = new BigImageSaver(new File(transformedSrcResultPath), resultTile.getSize(), transformedSrcChannels, transformedSrcDataType, tileDimension);
        String maskResultPath = FilenameUtils.getFullPath((String)transformedSrcResultPath);
        maskResultPath = String.valueOf(maskResultPath) + FilenameUtils.getBaseName((String)transformedSrcResultPath);
        maskResultPath = String.valueOf(maskResultPath) + "_mask.";
        maskResultPath = String.valueOf(maskResultPath) + FilenameUtils.getExtension((String)transformedSrcResultPath);
        final BigImageSaver maskSaver = new BigImageSaver(new File(maskResultPath), resultTile.getSize(), 1, DataType.UBYTE, tileDimension);
        int numThreads = Math.max((numProc + 1) / 2, 1);
        ExecutorService transformExecutor = Executors.newFixedThreadPool(numThreads);
        ExecutorCompletionService<TileTransformProcessing> transformCs = new ExecutorCompletionService<TileTransformProcessing>(transformExecutor);
        ExecutorService saveExecutor = Executors.newFixedThreadPool(numProc);
        ExecutorCompletionService saveCs = new ExecutorCompletionService(saveExecutor);
        int tileNo = 0;
        try {
            block20: {
                block19: {
                    if (!true) break block19;
                    if (tileNo >= totalTgtTileCount) return;
                    if (plugin.isPluginInterrumped()) break block20;
                }
                do {
                    int thr = 0;
                    while (thr < numThreads && tileNo < totalTgtTileCount && !plugin.isPluginInterrumped()) {
                        ProgressBar.setProgressBarMessage("Processing tile " + (tileNo + 1) + " of " + totalTgtTileCount);
                        ProgressBar.setProgressBarValue((double)tileNo / (double)totalTgtTileCount);
                        Rectangle tileRect = new Rectangle(tileNo % tgtTileCount.width * tileDimension.width, tileNo / tgtTileCount.width * tileDimension.height, tileDimension.width, tileDimension.height);
                        if (tileRect.x + tileRect.width > resultTile.width) {
                            tileRect.width -= tileRect.x + tileRect.width - resultTile.width;
                        }
                        if (tileRect.y + tileRect.height > resultTile.height) {
                            tileRect.height -= tileRect.y + tileRect.height - resultTile.height;
                        }
                        TileTransformProcessing task = new TileTransformProcessing(intervals, swx, swy, resultTile.getSize(), registeredTgtDimension, tileRect, srcPath, srcChannels, srcDataType, transformedSrcPath, transformedSrcChannels, transformedSrcDataType, transformedSrcDimension, resultTile.getLocation());
                        transformCs.submit(task, task);
                        ++thr;
                        ++tileNo;
                    }
                    int usedThr = thr;
                    thr = 0;
                    while (thr < usedThr) {
                        final Future transFuture = transformCs.take();
                        saveCs.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    TileTransformProcessing task = (TileTransformProcessing)transFuture.get();
                                    System.out.println("printing tile " + task.tileRect);
                                    TileSaveProcessing saveTask = new TileSaveProcessing(task.resultTile, task.transformedResultTile, task.maskTile, task.tileRect.getLocation(), resultSaver, transformedResultSaver, maskSaver);
                                    saveTask.run();
                                }
                                catch (InterruptedException | ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                        }, null);
                        ++thr;
                    }
                    thr = 0;
                    while (thr < usedThr) {
                        saveCs.take().get();
                        ++thr;
                    }
                    System.out.println("finished pool");
                    if (tileNo >= totalTgtTileCount) return;
                } while (!plugin.isPluginInterrumped());
            }
            return;
        }
        finally {
            saveExecutor.shutdownNow();
            saveExecutor.awaitTermination(0L, TimeUnit.SECONDS);
            transformExecutor.shutdownNow();
            transformExecutor.awaitTermination(0L, TimeUnit.SECONDS);
            resultSaver.closeWriter();
            transformedResultSaver.closeWriter();
            maskSaver.closeWriter();
        }
    }

    private static class TileSaveProcessing
    implements Runnable {
        private IcyBufferedImage resultTile;
        private IcyBufferedImage transformedResultTile;
        private IcyBufferedImage maskTile;
        private Point position;
        BigImageSaver saver;
        BigImageSaver transformedSaver;
        BigImageSaver maskSaver;

        public TileSaveProcessing(IcyBufferedImage resultTile, IcyBufferedImage transformedResultTile, IcyBufferedImage maskTile, Point position, BigImageSaver saver, BigImageSaver transformedSaver, BigImageSaver maskSaver) {
            this.resultTile = resultTile;
            this.transformedResultTile = transformedResultTile;
            this.maskTile = maskTile;
            this.position = position;
            this.saver = saver;
            this.transformedSaver = transformedSaver;
            this.maskSaver = maskSaver;
        }

        @Override
        public void run() {
            try {
                this.saver.saveTile(this.resultTile, this.position);
                this.transformedSaver.saveTile(this.transformedResultTile, this.position);
                this.maskSaver.saveTile(this.maskTile, this.position);
            }
            catch (IOException | ServiceException | FormatException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TileTransformProcessing
    extends Thread {
        private final BSplineModel swx;
        private final BSplineModel swy;
        private final int intervals;
        private final Dimension tgtFullDim;
        private final Dimension tgtRegisteredDim;
        private final Rectangle tileRect;
        private IcyBufferedImage transformedResultTile;
        private IcyBufferedImage resultTile;
        private IcyBufferedImage maskTile;
        private final String srcPath;
        private final int srcChannels;
        private final DataType srcDataType;
        private final String transformedSrcPath;
        private final int transformedSrcChannels;
        private final DataType transformedSrcDataType;
        private final Dimension transformedSrcDimension;
        private final Point fullSizePosition;

        public TileTransformProcessing(int intervals, BSplineModel swx, BSplineModel swy, Dimension tgtFullDim, Dimension tgtRegisteredDim, Rectangle tileRect, String srcPath, int srcChannels, DataType srcDataType, String transformedSrcPath, int transformedSrcChannels, DataType transformedSrcDataType, Dimension transformedSrcDimension, Point fullSizePosition) {
            this.swx = swx;
            this.swy = swy;
            this.intervals = intervals;
            this.tgtFullDim = tgtFullDim;
            this.tgtRegisteredDim = tgtRegisteredDim;
            this.tileRect = tileRect;
            this.srcPath = srcPath;
            this.srcChannels = srcChannels;
            this.srcDataType = srcDataType;
            this.transformedSrcPath = transformedSrcPath;
            this.transformedSrcChannels = transformedSrcChannels;
            this.transformedSrcDataType = transformedSrcDataType;
            this.transformedSrcDimension = transformedSrcDimension;
            this.fullSizePosition = fullSizePosition == null ? new Point(0, 0) : fullSizePosition;
        }

        @Override
        public void run() {
            IcyBufferedImage transformedSrcTile;
            IcyBufferedImage srcTile;
            Rectangle srcRect = BigImageTools.computeTransformSourceTileArea(this.intervals, this.swx, this.swy, this.tileRect, this.transformedSrcDimension, this.tgtFullDim, this.tgtRegisteredDim);
            srcRect.x += this.fullSizePosition.x;
            srcRect.y += this.fullSizePosition.y;
            if (srcRect.width * srcRect.height > 0) {
                srcTile = BigImageTools.loadImageTile(this.srcPath, "img1", srcRect).getFirstImage();
                transformedSrcTile = BigImageTools.loadImageTile(this.transformedSrcPath, "img", srcRect).getFirstImage();
            } else {
                transformedSrcTile = new IcyBufferedImage(2, 2, this.transformedSrcChannels, this.transformedSrcDataType);
                srcTile = new IcyBufferedImage(2, 2, this.srcChannels, this.transformedSrcDataType);
            }
            srcRect.x -= this.fullSizePosition.x;
            srcRect.y -= this.fullSizePosition.y;
            double[][] srcTileData = Array2DUtil.arrayToDoubleArray((Object)srcTile.getDataXYC(), (boolean)srcTile.isSignedDataType());
            double[][] transformedSrcTileData = Array2DUtil.arrayToDoubleArray((Object)transformedSrcTile.getDataXYC(), (boolean)transformedSrcTile.isSignedDataType());
            double factorX = (double)this.tgtFullDim.width / (double)this.tgtRegisteredDim.width;
            double factorY = (double)this.tgtFullDim.height / (double)this.tgtRegisteredDim.height;
            int tileEndHeight = this.tileRect.y + this.tileRect.height;
            int tileEndWidth = this.tileRect.x + this.tileRect.width;
            this.transformedResultTile = new IcyBufferedImage(this.tileRect.width, this.tileRect.height, this.transformedSrcChannels, this.transformedSrcDataType);
            this.resultTile = new IcyBufferedImage(this.tileRect.width, this.tileRect.height, this.srcChannels, this.srcDataType);
            this.maskTile = new IcyBufferedImage(this.tileRect.width, this.tileRect.height, 1, DataType.UBYTE);
            this.transformedResultTile.beginUpdate();
            this.resultTile.beginUpdate();
            this.maskTile.beginUpdate();
            double[][] transformedResultData = Array2DUtil.arrayToDoubleArray((Object)this.transformedResultTile.getDataXYC(), (boolean)this.transformedResultTile.isSignedDataType());
            double[][] resultData = Array2DUtil.arrayToDoubleArray((Object)this.resultTile.getDataXYC(), (boolean)this.resultTile.isSignedDataType());
            byte[] maskData = this.maskTile.getDataXYAsByte(0);
            Rectangle srcLimits = new Rectangle();
            boolean firstLim = true;
            int v_rect = 0;
            int v = this.tileRect.y;
            while (v < tileEndHeight) {
                int v_offset = v_rect * this.tileRect.width;
                double tv = (double)(v * this.intervals) / (double)(this.tgtFullDim.height - 1) + 1.0;
                int u_rect = 0;
                int u = this.tileRect.x;
                while (u < tileEndWidth) {
                    int c;
                    double tu = (double)(u * this.intervals) / (double)(this.tgtFullDim.width - 1) + 1.0;
                    double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false) * factorX;
                    double y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false) * factorY;
                    double srcTileX = x - (double)srcRect.x;
                    double srcTileY = y - (double)srcRect.y;
                    srcTileX = Math.round(srcTileX);
                    srcTileY = Math.round(srcTileY);
                    if (firstLim) {
                        firstLim = false;
                        srcLimits.x = (int)srcTileX;
                        srcLimits.y = (int)srcTileY;
                        srcLimits.width = (int)srcTileX;
                        srcLimits.height = (int)srcTileY;
                    } else {
                        srcLimits.x = Math.min(srcLimits.x, (int)srcTileX);
                        srcLimits.y = Math.min(srcLimits.y, (int)srcTileY);
                        srcLimits.width = Math.max(srcLimits.width, (int)srcTileX);
                        srcLimits.height = Math.max(srcLimits.height, (int)srcTileY);
                    }
                    if (srcTileX >= 0.0 && srcTileX < (double)srcRect.width && srcTileY >= 0.0 && srcTileY < (double)srcRect.height) {
                        maskData[u_rect + v_offset] = (byte)DataType.UBYTE.getMaxValue();
                        c = 0;
                        while (c < this.transformedResultTile.getSizeC()) {
                            transformedResultData[c][u_rect + v_offset] = transformedSrcTileData[c][(int)(srcTileX + srcTileY * (double)transformedSrcTile.getSizeX())];
                            ++c;
                        }
                        c = 0;
                        while (c < this.resultTile.getSizeC()) {
                            resultData[c][u_rect + v_offset] = srcTileData[c][(int)(srcTileX + srcTileY * (double)srcTile.getSizeX())];
                            ++c;
                        }
                    } else {
                        maskData[u_rect + v_offset] = 0;
                        c = 0;
                        while (c < this.transformedResultTile.getSizeC()) {
                            transformedResultData[c][u_rect + v_offset] = 0.0;
                            ++c;
                        }
                        c = 0;
                        while (c < this.resultTile.getSizeC()) {
                            resultData[c][u_rect + v_offset] = 0.0;
                            ++c;
                        }
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
            this.maskTile.dataChanged();
            this.maskTile.endUpdate();
            Array2DUtil.doubleArrayToSafeArray((double[][])transformedResultData, (Object)this.transformedResultTile.getDataXYC(), (boolean)this.transformedResultTile.isSignedDataType());
            this.transformedResultTile.dataChanged();
            this.transformedResultTile.endUpdate();
            Array2DUtil.doubleArrayToSafeArray((double[][])resultData, (Object)this.resultTile.getDataXYC(), (boolean)this.resultTile.isSignedDataType());
            this.resultTile.dataChanged();
            this.resultTile.endUpdate();
        }
    }

    private static class TransformBoundingBoxComputationOnTile
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final int intervals;
        final Dimension targetFullSize;
        final Rectangle tileBox;
        final Rectangle tileBoundingBox;

        public TransformBoundingBoxComputationOnTile(BSplineModel swx, BSplineModel swy, int intervals, Dimension targetFullSize, Rectangle tileBox, Rectangle tileBoundingBox) {
            this.swx = swx;
            this.swy = swy;
            this.intervals = intervals;
            this.targetFullSize = targetFullSize;
            this.tileBox = tileBox;
            this.tileBoundingBox = tileBoundingBox;
        }

        @Override
        public void run() {
            int tileEndHeight = this.tileBox.y + this.tileBox.height;
            int tileEndWidth = this.tileBox.x + this.tileBox.width;
            int v_rect = 0;
            int v = this.tileBox.y;
            while (v < tileEndHeight) {
                double tv = (double)(v * this.intervals) / (double)(this.targetFullSize.height - 1) + 1.0;
                int u_rect = 0;
                int u = this.tileBox.x;
                while (u < tileEndWidth) {
                    double tu = (double)(u * this.intervals) / (double)(this.targetFullSize.width - 1) + 1.0;
                    double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (v_rect == 0 && u_rect == 0) {
                        this.tileBoundingBox.x = (int)Math.floor(x);
                        this.tileBoundingBox.y = (int)Math.floor(y);
                        this.tileBoundingBox.width = (int)Math.ceil(x);
                        this.tileBoundingBox.height = (int)Math.ceil(y);
                    } else {
                        this.tileBoundingBox.x = Math.min(this.tileBoundingBox.x, (int)Math.floor(x));
                        this.tileBoundingBox.y = Math.min(this.tileBoundingBox.y, (int)Math.floor(y));
                        this.tileBoundingBox.width = Math.max(this.tileBoundingBox.width, (int)Math.ceil(x));
                        this.tileBoundingBox.height = Math.max(this.tileBoundingBox.height, (int)Math.ceil(y));
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
            this.tileBoundingBox.width -= this.tileBoundingBox.x;
            this.tileBoundingBox.height -= this.tileBoundingBox.y;
        }
    }
}

