/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

public class MathTools {
    private static final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    private static final int MAX_SVD_ITERATIONS = 1000;

    public static double nChooseK(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (k == 0) {
            return 1.0;
        }
        if (k == 1) {
            return n;
        }
        if (k > n / 2) {
            k = n - k;
        }
        double prod = 1.0;
        int i = 1;
        while (i <= k) {
            prod *= (double)((n - k + i) / i);
            ++i;
        }
        return prod;
    }

    public static void singularValueDecomposition(double[][] U, double[] W, double[][] V) {
        int k;
        int j;
        double h;
        double f;
        double s;
        int lines = U.length;
        int columns = U[0].length;
        double[] rv1 = new double[columns];
        int l = 0;
        int nm = 0;
        double norm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        int i = 0;
        while (i < columns) {
            int k2;
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < lines) {
                k2 = i;
                while (k2 < lines) {
                    scale += Math.abs(U[k2][i]);
                    ++k2;
                }
                if (scale != 0.0) {
                    k2 = i;
                    while (k2 < lines) {
                        double[] dArray = U[k2];
                        int n = i;
                        dArray[n] = dArray[n] / scale;
                        s += U[k2][i] * U[k2][i];
                        ++k2;
                    }
                    f = U[i][i];
                    g = 0.0 <= f ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    U[i][i] = f - g;
                    j = l;
                    while (j < columns) {
                        s = 0.0;
                        k = i;
                        while (k < lines) {
                            s += U[k][i] * U[k][j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < lines) {
                            double[] dArray = U[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * U[k][i];
                            ++k;
                        }
                        ++j;
                    }
                    k2 = i;
                    while (k2 < lines) {
                        double[] dArray = U[k2];
                        int n = i;
                        dArray[n] = dArray[n] * scale;
                        ++k2;
                    }
                }
            }
            W[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < lines && i != columns - 1) {
                k2 = l;
                while (k2 < columns) {
                    scale += Math.abs(U[i][k2]);
                    ++k2;
                }
                if (scale != 0.0) {
                    k2 = l;
                    while (k2 < columns) {
                        double[] dArray = U[i];
                        int n = k2;
                        dArray[n] = dArray[n] / scale;
                        s += U[i][k2] * U[i][k2];
                        ++k2;
                    }
                    f = U[i][l];
                    g = 0.0 <= f ? -Math.sqrt(s) : Math.sqrt(s);
                    h = f * g - s;
                    U[i][l] = f - g;
                    k2 = l;
                    while (k2 < columns) {
                        rv1[k2] = U[i][k2] / h;
                        ++k2;
                    }
                    j = l;
                    while (j < lines) {
                        s = 0.0;
                        k = l;
                        while (k < columns) {
                            s += U[j][k] * U[i][k];
                            ++k;
                        }
                        k = l;
                        while (k < columns) {
                            double[] dArray = U[j];
                            int n = k;
                            dArray[n] = dArray[n] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k2 = l;
                    while (k2 < columns) {
                        double[] dArray = U[i];
                        int n = k2++;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            norm = Math.abs(W[i]) + Math.abs(rv1[i]) < norm ? norm : Math.abs(W[i]) + Math.abs(rv1[i]);
            ++i;
        }
        i = columns - 1;
        while (i >= 0) {
            if (i < columns - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < columns) {
                        V[j][i] = U[i][j] / (U[i][l] * g);
                        ++j;
                    }
                    j = l;
                    while (j < columns) {
                        s = 0.0;
                        k = l;
                        while (k < columns) {
                            s += U[i][k] * V[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < columns) {
                            if (s != 0.0) {
                                double[] dArray = V[k];
                                int n = j;
                                dArray[n] = dArray[n] + s * V[k][i];
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < columns) {
                    V[j][i] = 0.0;
                    V[i][j] = 0.0;
                    ++j;
                }
            }
            V[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = lines < columns ? lines - 1 : columns - 1;
        while (i >= 0) {
            l = i + 1;
            g = W[i];
            j = l;
            while (j < columns) {
                U[i][j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < columns) {
                    s = 0.0;
                    k = l;
                    while (k < lines) {
                        s += U[k][i] * U[k][j];
                        ++k;
                    }
                    f = s * g / U[i][i];
                    k = i;
                    while (k < lines) {
                        if (f != 0.0) {
                            double[] dArray = U[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * U[k][i];
                        }
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < lines) {
                    double[] dArray = U[j];
                    int n = i;
                    dArray[n] = dArray[n] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < lines) {
                    U[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = U[i];
            int n = i--;
            dArray[n] = dArray[n] + 1.0;
        }
        int k3 = columns - 1;
        while (k3 >= 0) {
            int its = 1;
            while (its <= 1000) {
                int j2;
                double z;
                double y;
                double c;
                boolean flag = true;
                l = k3;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + norm == norm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(W[nm]) + norm == norm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    int i2 = l;
                    while (i2 <= k3) {
                        f = s * rv1[i2];
                        int n = i2;
                        rv1[n] = rv1[n] * c;
                        if (Math.abs(f) + norm == norm) break;
                        g = W[i2];
                        W[i2] = h = MathTools.EuclideanNorm(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        int j3 = 0;
                        while (j3 < lines) {
                            y = U[j3][nm];
                            z = U[j3][i2];
                            U[j3][nm] = y * c + z * s;
                            U[j3][i2] = z * c - y * s;
                            ++j3;
                        }
                        ++i2;
                    }
                }
                z = W[k3];
                if (l == k3) {
                    if (!(z < 0.0)) break;
                    W[k3] = -z;
                    j2 = 0;
                    while (j2 < columns) {
                        V[j2][k3] = -V[j2][k3];
                        ++j2;
                    }
                    break;
                }
                if (its == 1000) {
                    return;
                }
                double x = W[l];
                nm = k3 - 1;
                y = W[nm];
                g = rv1[nm];
                h = rv1[k3];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = MathTools.EuclideanNorm(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + (0.0 <= f ? Math.abs(g) : -Math.abs(g))) - h)) / x;
                s = 1.0;
                c = 1.0;
                j2 = l;
                while (j2 <= nm) {
                    int i3 = j2 + 1;
                    g = rv1[i3];
                    y = W[i3];
                    h = s * g;
                    g = c * g;
                    rv1[j2] = z = MathTools.EuclideanNorm(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < columns) {
                        x = V[jj][j2];
                        z = V[jj][i3];
                        V[jj][j2] = x * c + z * s;
                        V[jj][i3] = z * c - x * s;
                        ++jj;
                    }
                    W[j2] = z = MathTools.EuclideanNorm(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < lines) {
                        y = U[jj][j2];
                        z = U[jj][i3];
                        U[jj][j2] = y * c + z * s;
                        U[jj][i3] = z * c - y * s;
                        ++jj;
                    }
                    ++j2;
                }
                rv1[l] = 0.0;
                rv1[k3] = f;
                W[k3] = x;
                ++its;
            }
            --k3;
        }
    }

    public static double EuclideanNorm(double a, double b) {
        double absa = Math.abs(a);
        double absb = Math.abs(b);
        if (absb < absa) {
            return absa * Math.sqrt(1.0 + absb * absb / (absa * absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + absa * absa / (absb * absb));
    }

    public static double Bspline03(double x) {
        if ((x = Math.abs(x)) < 1.0) {
            return 0.5 * x * x * (x - 2.0) + 0.6666666865348816;
        }
        if (x < 2.0) {
            return (x -= 2.0) * x * x / -6.0;
        }
        return 0.0;
    }

    public static boolean invertMatrixSVD(int Ydim, int Xdim, double[][] B, double[][] iB) {
        int j;
        boolean underconstrained = false;
        double[] W = new double[Xdim];
        double[][] V = new double[Xdim][Xdim];
        MathTools.singularValueDecomposition(B, W, V);
        int Nzeros = 0;
        int k = 0;
        while (k < Xdim) {
            if (Math.abs(W[k]) < FLT_EPSILON) {
                W[k] = 0.0;
                ++Nzeros;
            } else {
                W[k] = 1.0 / W[k];
            }
            ++k;
        }
        if (Ydim - Nzeros < Xdim) {
            underconstrained = true;
        }
        int i = 0;
        while (i < Xdim) {
            j = 0;
            while (j < Xdim) {
                double[] dArray = V[i];
                int n = j;
                dArray[n] = dArray[n] * W[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < Xdim) {
            j = 0;
            while (j < Ydim) {
                iB[i][j] = 0.0;
                int k2 = 0;
                while (k2 < Xdim) {
                    double[] dArray = iB[i];
                    int n = j;
                    dArray[n] = dArray[n] + V[i][k2] * B[j][k2];
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        return underconstrained;
    }

    public static double[] linearLeastSquares(double[][] A, double[] b) {
        double s;
        int j;
        if (A == null || A.length == 0) {
            return null;
        }
        int lines = A.length;
        int columns = A[0].length;
        double[][] Q = new double[lines][columns];
        double[][] R = new double[columns][columns];
        double[] x = new double[columns];
        int i = 0;
        while (i < lines) {
            j = 0;
            while (j < columns) {
                Q[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        MathTools.QRdecomposition(Q, R);
        i = 0;
        while (i < columns) {
            s = 0.0;
            j = 0;
            while (j < lines) {
                s += Q[j][i] * b[j];
                ++j;
            }
            x[i] = s;
            ++i;
        }
        i = columns - 1;
        while (i >= 0) {
            s = R[i][i];
            if (s * s == 0.0) {
                x[i] = 0.0;
            } else {
                int n = i;
                x[n] = x[n] / s;
            }
            j = i - 1;
            while (j >= 0) {
                int n = j;
                x[n] = x[n] - R[j][i] * x[i];
                --j;
            }
            --i;
        }
        return x;
    }

    public static void QRdecomposition(double[][] Q, double[][] R) {
        int lines = Q.length;
        int columns = Q[0].length;
        double[][] A = new double[lines][columns];
        int j = 0;
        while (j < columns) {
            double s;
            int i = 0;
            while (i < lines) {
                A[i][j] = Q[i][j];
                ++i;
            }
            int k = 0;
            while (k < j) {
                s = 0.0;
                int i2 = 0;
                while (i2 < lines) {
                    s += A[i2][j] * Q[i2][k];
                    ++i2;
                }
                i2 = 0;
                while (i2 < lines) {
                    double[] dArray = Q[i2];
                    int n = j;
                    dArray[n] = dArray[n] - s * Q[i2][k];
                    ++i2;
                }
                ++k;
            }
            s = 0.0;
            i = 0;
            while (i < lines) {
                s += Q[i][j] * Q[i][j];
                ++i;
            }
            s = s * s == 0.0 ? 0.0 : 1.0 / Math.sqrt(s);
            i = 0;
            while (i < lines) {
                double[] dArray = Q[i];
                int n = j;
                dArray[n] = dArray[n] * s;
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < columns) {
            int j2 = 0;
            while (j2 < i) {
                R[i][j2] = 0.0;
                ++j2;
            }
            j2 = i;
            while (j2 < columns) {
                R[i][j2] = 0.0;
                int k = 0;
                while (k < lines) {
                    double[] dArray = R[i];
                    int n = j2;
                    dArray[n] = dArray[n] + Q[k][i] * A[k][j2];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
    }
}

