/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import plugins.adufour.ezplug.EzPlug;

public class ProgressBar {
    private static final long TIME_QUANTUM = 50L;
    private static volatile long lastTime = System.currentTimeMillis();
    private static volatile int completed = 0;
    private static volatile int workload = 0;
    private static EzPlug plugin;

    public static synchronized void setPlugin(EzPlug plugin) {
        ProgressBar.plugin = plugin;
    }

    public static synchronized void addWorkload(int batch) {
        workload += batch;
    }

    public static synchronized void resetProgressBar() {
        long timeStamp = System.currentTimeMillis();
        if (timeStamp - lastTime < 50L) {
            try {
                Thread.sleep(50L - timeStamp + lastTime);
            }
            catch (InterruptedException e) {
                System.err.println("Unexpected interruption exception" + e);
            }
        }
        lastTime = timeStamp;
        completed = 0;
        workload = 0;
        if (plugin != null && plugin.getUI() != null) {
            plugin.getUI().setProgressBarValue(1.0);
        }
    }

    public static synchronized void skipProgressBar(int stride) {
        completed += stride - 1;
        ProgressBar.stepProgressBar();
    }

    public static synchronized void stepProgressBar() {
        long timeStamp = System.currentTimeMillis();
        if (50L <= timeStamp - lastTime | ++completed == workload) {
            lastTime = timeStamp;
            if (plugin != null && plugin.getUI() != null) {
                plugin.getUI().setProgressBarValue((double)completed / (double)workload);
            }
        }
    }

    public static synchronized void workloadDone(int batch) {
        workload -= batch;
        completed -= batch;
    }

    public static synchronized void setProgressBarMessage(String message) {
        if (plugin != null && plugin.getUI() != null) {
            plugin.getUI().setProgressBarMessage(message);
        }
    }

    public static synchronized void setProgressBarValue(double value) {
        if (plugin != null && plugin.getUI() != null) {
            plugin.getUI().setProgressBarValue(value);
        }
    }
}

