/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.bigimage;

import algorithms.danyfel80.bigimage.BigImageToTiffConverter;
import algorithms.danyfel80.bigimage.BigImageUtil;
import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.RichProgressListener;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarIntegerArrayNative;
import plugins.adufour.ezplug.EzVarListener;

public class BigImageConvertToTiff
extends EzPlug
implements Block,
EzStoppable {
    EzVarFile varInFile;
    EzVarIntegerArrayNative varInChannels;
    BigImageToTiffConverter converter;

    protected void initialize() {
        this.varInFile = new EzVarFile("File", null);
        this.varInChannels = new EzVarIntegerArrayNative("Using channels", (int[][])new int[][]{{1, 1, 1}}, true);
        this.varInFile.addVarChangeListener((EzVarListener)new EzVarListener<File>(){

            public void variableChanged(EzVar<File> source, File newValue) {
                if (newValue != null && newValue.exists()) {
                    int sizeC = 0;
                    try {
                        sizeC = BigImageUtil.getSequenceChannelCount(newValue.getPath());
                    }
                    catch (UnsupportedFormatException | IOException e) {
                        MessageDialog.showDialog((String)"Error", (String)e.getMessage(), (int)0);
                        return;
                    }
                    BigImageConvertToTiff.this.varInChannels.setValue((Object)IntStream.range(0, sizeC).map(x -> 1).toArray());
                }
            }
        });
        this.addEzComponent((EzComponent)this.varInFile);
        this.addEzComponent((EzComponent)this.varInChannels);
    }

    protected void execute() {
        try {
            this.validateInput();
        }
        catch (Exception e) {
            MessageDialog.showDialog((String)"Error", (String)e.getMessage(), (int)0);
            return;
        }
        File inFile = (File)this.varInFile.getValue();
        File outFile = Paths.get(FilenameUtils.getFullPath((String)inFile.getAbsolutePath()), String.valueOf(FilenameUtils.getBaseName((String)inFile.getAbsolutePath())) + ".tif").toFile();
        int[] intChannels = (int[])this.varInChannels.getValue();
        boolean[] channels = new boolean[intChannels.length];
        IntStream.range(0, intChannels.length).forEach(i -> {
            boolean bl = blArray[i] = intChannels[i] != 0;
        });
        this.converter = new BigImageToTiffConverter(inFile, outFile, channels);
        this.converter.addProgressListener(new RichProgressListener(){

            @Override
            public boolean notifyProgress(double position, double length, String comment, Object data) {
                if (BigImageConvertToTiff.this.getUI() != null) {
                    BigImageConvertToTiff.this.getUI().setProgressBarValue(position / length);
                    BigImageConvertToTiff.this.getUI().setProgressBarMessage(comment);
                }
                return true;
            }
        });
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> futureRun = executor.submit(this.converter);
        try {
            try {
                futureRun.get();
            }
            catch (InterruptedException | ExecutionException e) {
                MessageDialog.showDialog((String)"Error", (String)e.getMessage(), (int)0);
                e.printStackTrace();
                executor.shutdownNow();
                return;
            }
        }
        finally {
            executor.shutdownNow();
        }
        new AnnounceFrame("Conversion done", 3);
    }

    private void validateInput() throws IllegalArgumentException, UnsupportedFormatException, IOException {
        if (this.varInFile.getValue() == null || !((File)this.varInFile.getValue()).exists()) {
            throw new IllegalArgumentException("Invalid File: null file or doesn't exist.");
        }
        int sizeC = BigImageUtil.getSequenceChannelCount(((File)this.varInFile.getValue()).getPath());
        if (((int[])this.varInChannels.getValue()).length != sizeC) {
            throw new IllegalArgumentException("Using channels has less channels than those in the image file");
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
    }

    public void declareOutput(VarList outputMap) {
    }

    public void stopExecution() {
        if (this.converter != null) {
            this.converter.interrupt();
        }
    }
}

