/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.bigimage;

import algorithms.danyfel80.bigimage.BigImageSaver;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;

public class SaveBigImage
extends EzPlug {
    EzVarSequence inSeq = new EzVarSequence("Sequence");
    EzVarFile inFile = new EzVarFile("File", "");
    EzVarInteger inTileSize = new EzVarInteger("Tile size");

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inSeq);
        this.addEzComponent((EzComponent)this.inFile);
        this.addEzComponent((EzComponent)this.inTileSize);
    }

    protected void execute() {
        block25: {
            int tileSize;
            IcyBufferedImage ibi = ((Sequence)this.inSeq.getValue()).getFirstImage();
            File file = (File)this.inFile.getValue();
            int tileSizeX = tileSize = ((Integer)this.inTileSize.getValue()).intValue();
            int tileSizeY = tileSize;
            this.getUI().setProgressBarMessage("Saving");
            int sizeX = ibi.getWidth();
            int sizeY = ibi.getHeight();
            if (tileSizeX <= 0) {
                tileSizeX = sizeX;
            }
            if (tileSizeY <= 0) {
                tileSizeY = sizeY;
            }
            int n = sizeX / tileSizeX;
            int m = sizeY / tileSizeY;
            if (n == 0) {
                tileSizeX = sizeX;
                n = 1;
            }
            if (m == 0) {
                tileSizeY = sizeY;
                m = 1;
            }
            int diffWidth = sizeX - n * tileSizeX;
            int diffHeight = sizeY - m * tileSizeY;
            if (diffWidth > 0) {
                ++n;
            }
            if (diffHeight > 0) {
                ++m;
            }
            BigImageSaver saver = null;
            try {
                saver = new BigImageSaver(file, new Dimension(ibi.getWidth(), ibi.getHeight()), ibi.getSizeC(), ibi.getDataType_(), new Dimension(tileSizeX, tileSizeY));
            }
            catch (IOException | ServiceException | FormatException e1) {
                e1.printStackTrace();
                return;
            }
            try {
                try {
                    int i = 0;
                    while (i < m) {
                        int h;
                        int y;
                        if (diffHeight > 0 && i == m - 1) {
                            y = sizeY - diffHeight;
                            h = diffHeight;
                        } else {
                            y = tileSizeY * i;
                            h = tileSizeY;
                        }
                        int j = 0;
                        while (j < n) {
                            int w;
                            int x;
                            if (diffWidth > 0 && j == n - 1) {
                                x = sizeX - diffWidth;
                                w = diffWidth;
                            } else {
                                x = tileSizeX * j;
                                w = tileSizeX;
                            }
                            Rectangle rect = new Rectangle(x, y, w, h);
                            Point point = new Point(x, y);
                            saver.saveTile(IcyBufferedImageUtil.getSubImage((IcyBufferedImage)ibi, (Rectangle)rect), point);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (IOException | ServiceException | FormatException e) {
                    e.printStackTrace();
                    try {
                        saver.closeWriter();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    saver.closeWriter();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                saver.closeWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.getUI().setProgressBarMessage("Done");
    }

    public void clean() {
    }
}

