/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.bigimage;

import algorithms.danyfel80.bigimage.BigImageUtil;
import icy.common.exception.UnsupportedFormatException;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.model.enums.PixelType;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.ezplug.EzGUI;
import plugins.kernel.importer.LociImporterPlugin;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class BigImageLoader {
    private EzGUI pluginGUI = null;
    private ProgressFrame progressFrame = null;
    private boolean isInterrupted;

    public void setPluginGUI(EzGUI pluginGUI) {
        this.pluginGUI = pluginGUI;
    }

    private void setProgress(double progress) {
        if (this.pluginGUI != null) {
            this.pluginGUI.setProgressBarValue(progress);
        }
    }

    private void setStatusMessage(String message) {
        if (this.pluginGUI != null) {
            this.pluginGUI.setProgressBarMessage(message);
        }
    }

    public void interrupt() {
        this.isInterrupted = true;
    }

    public Sequence loadDownsampledImage(String path, Rectangle tile, int resultMaxWidth, int resultMaxHeight, boolean showProgressBar) throws UnsupportedFormatException, IOException {
        this.isInterrupted = false;
        double progress = 0.0;
        this.setProgress(progress);
        if (showProgressBar) {
            this.progressFrame = new ProgressFrame("Loading image...");
        }
        String xmlPath = String.valueOf(FilenameUtils.getFullPath((String)path)) + FilenameUtils.getBaseName((String)path) + ".xml";
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            String imgName = FilenameUtils.getBaseName((String)path);
            int imgSizeX = (Integer)imgProps.getPixelsSizeX(0).getValue();
            int imgSizeY = (Integer)imgProps.getPixelsSizeY(0).getValue();
            Dimension imgSize = new Dimension(imgSizeX, imgSizeY);
            int imgSizeC = (Integer)imgProps.getPixelsSizeC(0).getValue();
            DataType imgDataType = DataType.getDataTypeFromPixelType((PixelType)imgProps.getPixelsType(0));
            if (tile == null) {
                tile = new Rectangle(0, 0, imgSizeX, imgSizeY);
            } else {
                if (tile.x < 0) {
                    tile.width += tile.x;
                    tile.x = 0;
                }
                if (tile.y < 0) {
                    tile.height += tile.y;
                    tile.y = 0;
                }
                if (tile.x > imgSizeX || tile.y > imgSizeY) {
                    return null;
                }
                if (tile.x + tile.width > imgSizeX) {
                    tile.width = imgSizeX - tile.x;
                }
                if (tile.y + tile.height > imgSizeY) {
                    tile.height = imgSizeY - tile.y;
                }
            }
            System.out.println("tile to extract: " + tile);
            if (resultMaxWidth == 0) {
                resultMaxWidth = tile.width;
            }
            if (resultMaxHeight == 0) {
                resultMaxHeight = tile.height;
            }
            System.gc();
            long ram = Runtime.getRuntime().freeMemory();
            int nProc = Runtime.getRuntime().availableProcessors();
            if (showProgressBar) {
                System.out.println("Available memory: " + ram + " bytes, Available processors: " + nProc);
            }
            double szMax = Math.sqrt(ram /= (long)imgSizeC);
            int tileSize = (int)Math.ceil(szMax / (double)nProc);
            while (tile.width / resultMaxWidth > 2 * tileSize) {
                tileSize *= 2;
            }
            while (tile.height / resultMaxHeight > 2 * tileSize) {
                tileSize *= 2;
            }
            System.out.println("Tile size: " + tileSize);
            double tmpSizeX = tile.getWidth();
            double tmpSizeY = tile.getHeight();
            double tileTmpSizeX = tileSize;
            double tileTmpSizeY = tileSize;
            double scaleFactor = 1.0;
            while (tmpSizeX > (double)resultMaxWidth || tmpSizeY > (double)resultMaxHeight) {
                tmpSizeX /= 2.0;
                tmpSizeY /= 2.0;
                tileTmpSizeX /= 2.0;
                tileTmpSizeY /= 2.0;
                scaleFactor /= 2.0;
            }
            if (showProgressBar) {
                System.out.println("output resolution: " + scaleFactor);
            }
            int outTileSizeX = (int)Math.round(tileTmpSizeX);
            int outTileSizeY = (int)Math.round(tileTmpSizeY);
            int outSizeX = tile.width / tileSize * outTileSizeX;
            int outSizeY = tile.height / tileSize * outTileSizeY;
            if (tile.width % tileSize > 0) {
                outSizeX += (int)Math.round((double)(tile.width % tileSize) * scaleFactor);
            }
            if (tile.height % tileSize > 0) {
                outSizeY += (int)Math.round((double)(tile.height % tileSize) * scaleFactor);
            }
            if (showProgressBar) {
                System.out.println("Result image size: " + outSizeX + "px*" + outSizeY + "px. Tile size: " + outTileSizeX + "px*" + outTileSizeY + "px");
            }
            Sequence result = new Sequence(new IcyBufferedImage(outSizeX, outSizeY, imgSizeC, imgDataType));
            result.beginUpdate();
            IcyBufferedImage resultImg = result.getFirstImage();
            TileLoaderThread[] threads = new TileLoaderThread[nProc];
            Point[] points = new Point[nProc];
            int currProc = 0;
            int totalTilesX = tile.width / tileSize + (tile.width % tileSize > 0 ? 1 : 0);
            int totalTilesY = tile.height / tileSize + (tile.height % tileSize > 0 ? 1 : 0);
            int totalTiles = totalTilesX * totalTilesY;
            int treatedTiles = 0;
            int posX = tile.x;
            int posTileX = 0;
            while (posX < tile.x + tile.width && posX < imgSizeX) {
                int tileSizeX = posX + tileSize <= imgSizeX ? tileSize : imgSizeX - posX;
                tileSizeX = posX + tileSizeX <= tile.x + tile.width ? tileSizeX : tile.x + tile.width - posX;
                int outCurrTileSizeX = posTileX + outTileSizeX <= outSizeX ? outTileSizeX : outSizeX - posTileX;
                int posY = tile.y;
                int posTileY = 0;
                while (posY < tile.y + tile.height && posY < imgSizeY) {
                    if (this.isInterrupted) break;
                    int tileSizeY = posY + tileSize <= imgSizeY ? tileSize : imgSizeY - posY;
                    tileSizeY = posY + tileSizeY <= tile.y + tile.height ? tileSizeY : tile.y + tile.height - posY;
                    int outCurrTileSizeY = posTileY + outTileSizeY <= outSizeY ? outTileSizeY : outSizeY - posTileY;
                    threads[currProc] = new TileLoaderThread(path, new Rectangle(posX, posY, tileSizeX, tileSizeY), new Dimension(outCurrTileSizeX, outCurrTileSizeY), imgSize);
                    points[currProc] = new Point(posTileX, posTileY);
                    threads[currProc++].start();
                    if (currProc >= nProc || posX + tileSizeX >= imgSizeX && posY + tileSizeY >= imgSizeY || posX + tileSizeX >= tile.x + tile.width && posY + tileSizeY >= tile.y + tile.height) {
                        int p = 0;
                        while (p < currProc) {
                            try {
                                progress = (double)treatedTiles / (double)totalTiles;
                                this.setProgress(progress);
                                if (showProgressBar) {
                                    this.progressFrame.setPosition(progress * 100.0);
                                    this.progressFrame.setMessage(String.format("Loading image: %d%%, tile: %d/%d", (int)(progress * 100.0), treatedTiles, totalTiles));
                                }
                                this.setStatusMessage(String.format("Loading image: %d%%, tile: %d/%d", (int)(progress * 100.0), treatedTiles, totalTiles));
                                threads[p].join();
                                resultImg.copyData(threads[p].resultImage, null, new Point(points[p].x, points[p].y));
                                threads[p] = null;
                                points[p] = null;
                                ++treatedTiles;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ++p;
                        }
                        currProc = 0;
                    }
                    posY += tileSizeY;
                    posTileY += outCurrTileSizeY;
                }
                if (this.isInterrupted) break;
                posX += tileSizeX;
                posTileX += outCurrTileSizeX;
            }
            if (showProgressBar) {
                System.out.println("Treated Tiles" + treatedTiles);
            }
            result.setImage(0, 0, (BufferedImage)resultImg);
            result.addROIs(this.loadROIs(xmlPath, tile, scaleFactor), false);
            result.dataChanged();
            result.endUpdate();
            result.setName(imgName);
            Runtime.getRuntime().gc();
            Sequence sequence = result;
            return sequence;
        }
        catch (UnsupportedFormatException | IOException e) {
            throw e;
        }
        finally {
            importer.close();
            this.setStatusMessage("Done loading");
            this.setProgress(1.0);
            if (showProgressBar) {
                this.progressFrame.dispose();
            }
        }
    }

    public ROI2D loadDownsampledMask(Sequence srcSeq, String srcPath, Rectangle tile, int resultMaxWidth, int resultMaxHeight, boolean showProgressBar) throws UnsupportedFormatException, IOException {
        String maskPath = FilenameUtils.getFullPath((String)srcPath);
        maskPath = String.valueOf(maskPath) + FilenameUtils.getBaseName((String)srcPath) + "_mask.";
        maskPath = String.valueOf(maskPath) + FilenameUtils.getExtension((String)srcPath);
        BooleanMask2D boolMask = new BooleanMask2D();
        if (new File(maskPath).exists()) {
            Sequence maskSeq = this.loadDownsampledImage(maskPath, tile, resultMaxWidth, resultMaxHeight, showProgressBar);
            double[] maskData = Array1DUtil.arrayToDoubleArray((Object)maskSeq.getDataXY(0, 0, 0), (boolean)maskSeq.isSignedDataType());
            boolMask.mask = new boolean[maskData.length];
            int i = 0;
            while (i < maskData.length) {
                boolMask.mask[i] = maskData[i] > 0.0;
                ++i;
            }
            boolMask.bounds = new Rectangle(maskSeq.getBounds2D());
        } else {
            boolMask.mask = new boolean[srcSeq.getSizeX() * srcSeq.getSizeY()];
            int i = 0;
            while (i < boolMask.mask.length) {
                boolMask.mask[i] = true;
                ++i;
            }
            boolMask.bounds = new Rectangle(srcSeq.getBounds2D());
        }
        return new ROI2DArea(boolMask);
    }

    public List<ROI> loadROIs(String xmlPath, Rectangle rect, double scale) {
        File xmlFile = new File(xmlPath);
        Document doc = XMLUtil.loadDocument((File)xmlFile);
        Element root = XMLUtil.getRootElement((Document)doc);
        if (root == null) {
            return new ArrayList<ROI>();
        }
        Node rois = XMLUtil.getChild((Node)root, (String)"rois");
        List<ROI> roiList = rois != null ? ROI.loadROIsFromXML((Node)rois) : new ArrayList();
        roiList = BigImageUtil.getROIsInTile(roiList, rect);
        for (ROI roi : roiList) {
            Point5D pos = roi.getPosition5D();
            pos.setX(pos.getX() - (double)rect.x);
            pos.setY(pos.getY() - (double)rect.y);
            roi.setPosition5D(pos);
            BigImageUtil.scaleROI(roi, scale);
        }
        return roiList;
    }

    private static class TileLoaderThread
    extends Thread {
        private final String path;
        private final Rectangle rect;
        private final Dimension outDimension;
        private final Dimension fullDimension;
        private IcyBufferedImage resultImage;
        private final double scaleX;
        private final double scaleY;

        public TileLoaderThread(String path, Rectangle rect, Dimension outDimension, Dimension fullDimension) {
            this.path = path;
            this.rect = rect;
            this.outDimension = outDimension;
            this.fullDimension = fullDimension;
            this.resultImage = null;
            this.scaleX = rect.width / outDimension.width;
            this.scaleY = rect.height / outDimension.height;
        }

        @Override
        public void run() {
            LociImporterPlugin importer = new LociImporterPlugin();
            try {
                importer.open(this.path, 0);
                Dimension scaledExtractedDim = new Dimension(this.outDimension);
                Point scaledPosition = new Point(0, 0);
                Rectangle bigRect = new Rectangle(this.rect);
                if (this.rect.x - 3 >= 0) {
                    bigRect.x -= 3;
                    scaledExtractedDim.width += (int)(3.0 / this.scaleX);
                    scaledPosition.x += (int)(3.0 / this.scaleX);
                }
                if (this.rect.y - 3 >= 0) {
                    bigRect.y -= 3;
                    scaledExtractedDim.height += (int)(3.0 / this.scaleY);
                    scaledPosition.y += (int)(3.0 / this.scaleY);
                }
                if (this.rect.x + this.rect.width + 3 < this.fullDimension.width) {
                    bigRect.width += 3;
                    scaledExtractedDim.width += (int)(3.0 / this.scaleX);
                }
                if (this.rect.y + this.rect.height + 3 < this.fullDimension.height) {
                    bigRect.height += 3;
                    scaledExtractedDim.height += (int)(3.0 / this.scaleY);
                }
                this.resultImage = importer.getImage(0, 0, bigRect, 0, 0);
                if ((double)this.resultImage.getWidth() != scaledExtractedDim.getWidth() || this.resultImage.getHeight() != scaledExtractedDim.height) {
                    this.resultImage = IcyBufferedImageUtil.scale((IcyBufferedImage)this.resultImage, (int)scaledExtractedDim.width, (int)scaledExtractedDim.height);
                }
                IcyBufferedImageUtil.getSubImage((IcyBufferedImage)this.resultImage, (int)scaledPosition.x, (int)scaledPosition.y, (int)this.outDimension.width, (int)this.outDimension.height);
                importer.close();
            }
            catch (UnsupportedFormatException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

