/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.bigimage;

import icy.common.exception.UnsupportedFormatException;
import icy.painter.Anchor2D;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.type.DataType;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.model.enums.PixelType;
import plugins.kernel.importer.LociImporterPlugin;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class BigImageUtil {
    public static Dimension getSequenceSize(String path) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            int imgSizeX = (Integer)imgProps.getPixelsSizeX(0).getValue();
            int imgSizeY = (Integer)imgProps.getPixelsSizeY(0).getValue();
            Dimension dimension = new Dimension(imgSizeX, imgSizeY);
            return dimension;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getSequenceChannelCount(String path) throws UnsupportedFormatException, IOException {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            int n = (Integer)imgProps.getPixelsSizeC(0).getValue();
            return n;
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static DataType getSequenceDataType(String path) {
        LociImporterPlugin importer = new LociImporterPlugin();
        try {
            importer.open(path, 0);
            OMEXMLMetadataImpl imgProps = importer.getMetaData();
            DataType dataType = DataType.getDataTypeFromPixelType((PixelType)imgProps.getPixelsType(0));
            return dataType;
        }
        catch (UnsupportedFormatException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                importer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static List<ROI> getROIsInTile(List<ROI> rois, Rectangle tile) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        ROI2DRectangle rectROI = new ROI2DRectangle((Rectangle2D)tile);
        for (ROI roi : rois) {
            ArrayList<Object> ROIsToIntersect = new ArrayList<Object>();
            ROIsToIntersect.add(roi);
            ROIsToIntersect.add(rectROI);
            result.add(ROIUtil.getIntersection(ROIsToIntersect));
        }
        return result;
    }

    public static void scaleROI(ROI roi, double scale) {
        if (roi instanceof ROI2DShape) {
            BigImageUtil.scaleROI2DShape((ROI2DShape)roi, scale);
        } else if (roi instanceof ROI2DArea) {
            BigImageUtil.scaleROI2DArea((ROI2DArea)roi, scale);
        } else {
            throw new IllegalArgumentException("the specified element cannot be scaled");
        }
    }

    private static void scaleROI2DShape(ROI2DShape roi, double scale) {
        List pts = roi.getControlPoints();
        Point pos = roi.getPosition();
        for (Anchor2D pt : pts) {
            double posX = pt.getX() - ((Point2D)pos).getX();
            double posY = pt.getY() - ((Point2D)pos).getY();
            pt.moveTo((posX *= scale) + ((Point2D)pos).getX(), (posY *= scale) + ((Point2D)pos).getY());
            roi.controlPointPositionChanged(pt);
        }
        ((Point2D)pos).setLocation(((Point2D)pos).getX() * scale, ((Point2D)pos).getY() * scale);
        roi.setPosition2D((Point2D)pos);
    }

    private static void scaleROI2DArea(ROI2DArea roi, double scale) {
        Rectangle bounds = roi.getBounds();
        boolean[] mask = roi.getBooleanMask(bounds, true);
        Rectangle scaledBounds = new Rectangle((int)((double)bounds.x * scale), (int)((double)bounds.y * scale), (int)((double)bounds.width * scale), (int)((double)bounds.height * scale));
        boolean[] scaledMask = new boolean[scaledBounds.width * scaledBounds.height];
        int y = 0;
        while (y < scaledBounds.height) {
            int yOff = y * scaledBounds.width;
            int scaledYOff = (int)((double)y / scale * (double)bounds.width);
            int x = 0;
            while (x < scaledBounds.width) {
                scaledMask[x + yOff] = mask[(int)((double)x / scale) + scaledYOff];
                ++x;
            }
            ++y;
        }
        roi.setAsBooleanMask(scaledBounds, scaledMask);
    }
}

