/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.icyBufferedImage.util;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.TypeUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class IcyBufferedImageCursor {
    IcyBufferedImage plane;
    int[] planeSize;
    DataType planeType;
    AtomicBoolean planeChanged;
    Object volumeData;

    public IcyBufferedImageCursor(IcyBufferedImage vol) {
        this.plane = vol;
        this.planeSize = new int[]{vol.getSizeX(), vol.getSizeY()};
        this.planeType = vol.getDataType_();
        this.volumeData = vol.getDataXYC();
        this.planeChanged = new AtomicBoolean(false);
    }

    public IcyBufferedImageCursor(Sequence seq, int t, int z) {
        this(seq.getImage(t, z));
    }

    public synchronized double get(int x, int y, int c) {
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                return TypeUtil.toDouble((byte)((byte[][])this.volumeData)[c][x + y * this.planeSize[0]], (boolean)this.planeType.isSigned());
            }
            case USHORT: 
            case SHORT: {
                return TypeUtil.toDouble((short)((short[][])this.volumeData)[c][x + y * this.planeSize[0]], (boolean)this.planeType.isSigned());
            }
            case UINT: 
            case INT: {
                return TypeUtil.toDouble((int)((int[][])this.volumeData)[c][x + y * this.planeSize[0]], (boolean)this.planeType.isSigned());
            }
            case FLOAT: {
                return ((float[][])this.volumeData)[c][x + y * this.planeSize[0]];
            }
            case DOUBLE: {
                return ((double[][])this.volumeData)[c][x + y * this.planeSize[0]];
            }
        }
        throw new RuntimeException("Unsupported data type: " + this.planeType);
    }

    public synchronized void set(int x, int y, int c, double val) {
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][])this.volumeData)[c][x + y * this.planeSize[0]] = (byte)val;
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][])this.volumeData)[c][x + y * this.planeSize[0]] = (short)val;
                break;
            }
            case UINT: 
            case INT: {
                ((int[][])this.volumeData)[c][x + y * this.planeSize[0]] = (int)val;
                break;
            }
            case FLOAT: {
                ((float[][])this.volumeData)[c][x + y * this.planeSize[0]] = (float)val;
                break;
            }
            case DOUBLE: {
                ((double[][])this.volumeData)[c][x + y * this.planeSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.planeChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int c, double val) {
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                ((byte[][])this.volumeData)[c][x + y * this.planeSize[0]] = (byte)this.getSafeValue(val);
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[][])this.volumeData)[c][x + y * this.planeSize[0]] = (short)this.getSafeValue(val);
                break;
            }
            case UINT: 
            case INT: {
                ((int[][])this.volumeData)[c][x + y * this.planeSize[0]] = (int)this.getSafeValue(val);
                break;
            }
            case FLOAT: {
                ((float[][])this.volumeData)[c][x + y * this.planeSize[0]] = (float)this.getSafeValue(val);
                break;
            }
            case DOUBLE: {
                ((double[][])this.volumeData)[c][x + y * this.planeSize[0]] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.planeChanged.set(true);
    }

    private double getSafeValue(double val) {
        return Math.min(Math.max(val, this.planeType.getMaxValue()), this.planeType.getMinValue());
    }

    public synchronized void commitChanges() {
        this.plane.dataChanged();
    }
}

