/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.MathTools;
import algorithms.danyfel80.registration.bunwarp.MiscTools;
import algorithms.danyfel80.registration.bunwarp.ProgressBar;
import icy.image.IcyBufferedImage;
import java.util.Stack;

public class BSplineModel
extends Thread {
    private static final int minImageSize = 4;
    public static final int MAX_OUTPUT_SIZE = 1024;
    private IcyBufferedImage ibi = null;
    private final Stack<Object> cPyramid = new Stack();
    private final Stack<Object> imgPyramid = new Stack();
    private double[] originalImage = null;
    private double[] image = null;
    private double[] coefficient = null;
    private int width;
    private int height;
    private double[] currentImage;
    private double[] currentCoefficient;
    private int currentWidth;
    private int currentHeight;
    private int pyramidDepth;
    private int currentDepth;
    private boolean isTarget;
    private boolean coefficientsAreMirrored;
    private int maxImageSubsamplingFactor = 1;
    public int[] xIndex;
    public int[] yIndex;
    private double[] xWeight;
    private double[] yWeight;
    private double[] dxWeight;
    private double[] dyWeight;
    private double[] d2xWeight;
    private double[] d2yWeight;
    private boolean fromCurrent;
    private int widthToUse;
    private int heightToUse;
    private boolean isSubsampledOutput = false;
    private int subWidth = 0;
    private int subHeight = 0;
    private double[] subImage = null;
    private double[] subCoeffs = null;
    private int originalWidth = 0;
    private int originalHeight = 0;
    public int[][] prec_xIndex;
    public int[][] prec_yIndex;
    private double[][] prec_xWeight;
    private double[][] prec_yWeight;
    private double[][] prec_dxWeight;
    private double[][] prec_dyWeight;
    private double[][] prec_d2xWeight;
    private double[][] prec_d2yWeight;

    public BSplineModel(IcyBufferedImage ibi, boolean isTarget, int maxImageSubsamplingFactor) {
        this.ibi = ibi;
        this.isTarget = isTarget;
        this.maxImageSubsamplingFactor = maxImageSubsamplingFactor;
        this.width = ibi.getWidth();
        this.height = ibi.getHeight();
        this.coefficientsAreMirrored = true;
        this.xIndex = new int[4];
        this.yIndex = new int[4];
        this.xWeight = new double[4];
        this.yWeight = new double[4];
        this.dxWeight = new double[4];
        this.dyWeight = new double[4];
        this.d2xWeight = new double[4];
        this.d2yWeight = new double[4];
    }

    public BSplineModel(double[] c, int Ydim, int Xdim, int offset) {
        this.currentHeight = this.height = Ydim;
        this.currentWidth = this.width = Xdim;
        this.coefficientsAreMirrored = false;
        this.coefficient = new double[this.height * this.width];
        System.arraycopy(c, offset, this.coefficient, 0, this.height * this.width);
        this.xIndex = new int[4];
        this.yIndex = new int[4];
        this.xWeight = new double[4];
        this.yWeight = new double[4];
        this.dxWeight = new double[4];
        this.dyWeight = new double[4];
        this.d2xWeight = new double[4];
        this.d2yWeight = new double[4];
    }

    public BSplineModel(double[][] c) {
        this.currentHeight = this.height = c.length;
        this.currentWidth = this.width = c[0].length;
        this.coefficientsAreMirrored = false;
        this.coefficient = new double[this.height * this.width];
        int k = 0;
        int y = 0;
        while (y < this.height) {
            System.arraycopy(c[y], 0, this.coefficient, k, this.width);
            ++y;
            k += this.width;
        }
        this.xIndex = new int[4];
        this.yIndex = new int[4];
        this.xWeight = new double[4];
        this.yWeight = new double[4];
        this.dxWeight = new double[4];
        this.dyWeight = new double[4];
        this.d2xWeight = new double[4];
        this.d2yWeight = new double[4];
    }

    public double[] getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double[] getCurrentImage() {
        return this.currentImage;
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public double getFactorHeight() {
        return (double)this.currentHeight / (double)this.height;
    }

    public double getFactorWidth() {
        return (double)this.currentWidth / (double)this.width;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public double[] getSubImage() {
        return this.subImage;
    }

    boolean isSubOutput() {
        return this.isSubsampledOutput;
    }

    int getSubWidth() {
        return this.subWidth;
    }

    int getSubHeight() {
        return this.subHeight;
    }

    public double[] getOriginalImage() {
        return this.originalImage;
    }

    public int getOriginalImageWidth() {
        return this.originalWidth;
    }

    public int getOriginalImageHeight() {
        return this.originalHeight;
    }

    public double getWeightI(int l, int m) {
        return this.yWeight[l] * this.xWeight[m];
    }

    public double precomputedGetWeightDx(int l, int m, int u, int v) {
        return this.prec_yWeight[v][l] * this.prec_dxWeight[u][m];
    }

    public double precomputedGetWeightDxDx(int l, int m, int u, int v) {
        return this.prec_yWeight[v][l] * this.prec_d2xWeight[u][m];
    }

    public double precomputedGetWeightDxDy(int l, int m, int u, int v) {
        return this.prec_dyWeight[v][l] * this.prec_dxWeight[u][m];
    }

    public double precomputedGetWeightDy(int l, int m, int u, int v) {
        return this.prec_dyWeight[v][l] * this.prec_xWeight[u][m];
    }

    public double precomputedGetWeightDyDy(int l, int m, int u, int v) {
        return this.prec_d2yWeight[v][l] * this.prec_xWeight[u][m];
    }

    public double precomputedGetWeightI(int l, int m, int u, int v) {
        return this.prec_yWeight[v][l] * this.prec_xWeight[u][m];
    }

    public void setPyramidDepth(int pyramidDepth) {
        int proposedPyramidDepth = pyramidDepth;
        int currentWidth = this.width;
        int currentHeight = this.height;
        int scale = 0;
        while (currentWidth >= 4 && currentHeight >= 4) {
            currentWidth /= 2;
            currentHeight /= 2;
            ++scale;
        }
        if (proposedPyramidDepth > --scale) {
            proposedPyramidDepth = scale;
        }
        this.pyramidDepth = proposedPyramidDepth;
    }

    public void startPyramids() {
        this.subWidth = this.width;
        this.subHeight = this.height;
        if (this.width > 1024 || this.height > 1024) {
            this.isSubsampledOutput = true;
            do {
                this.subWidth /= 2;
                this.subHeight /= 2;
            } while (this.subWidth > 1024 || this.subHeight > 1024);
        } else {
            this.isSubsampledOutput = false;
        }
        super.setDaemon(true);
        super.start();
    }

    @Override
    public void run() {
        super.run();
        if (this.image == null && this.ibi != null) {
            this.originalImage = new double[this.width * this.height];
            this.originalHeight = this.height;
            this.originalWidth = this.width;
            MiscTools.extractImage(this.ibi, this.originalImage);
            if (this.maxImageSubsamplingFactor != 0) {
                float scaleFactor = 1.0f / (float)this.maxImageSubsamplingFactor;
                this.ibi = MiscTools.scale(this.ibi, scaleFactor);
                this.width = this.ibi.getWidth();
                this.height = this.ibi.getHeight();
                this.image = new double[this.width * this.height];
                MiscTools.extractImage(this.ibi, this.image);
            } else {
                this.image = this.originalImage;
            }
            if (this.width <= this.subWidth) {
                this.subWidth = this.width;
                this.subHeight = this.height;
                this.subImage = this.image;
            }
        }
        this.coefficient = this.getBasicFromCardinal2D();
        if (this.coefficient != null) {
            this.buildCoefficientPyramid();
        } else {
            this.buildEmptyCoefficientPyramid();
        }
        if (this.isTarget || this.isSubsampledOutput) {
            this.buildImagePyramid();
        }
    }

    private double[] getBasicFromCardinal2D() {
        if (this.image == null) {
            return null;
        }
        double[] basic = new double[this.width * this.height];
        double[] hLine = new double[this.width];
        double[] vLine = new double[this.height];
        int y = 0;
        while (y < this.height) {
            this.extractRow(this.image, y, hLine);
            this.samplesToInterpolationCoefficient1D(hLine, 3, 0.0);
            this.putRow(basic, y, hLine);
            ++y;
        }
        int x = 0;
        while (x < this.width) {
            this.extractColumn(basic, this.width, x, vLine);
            this.samplesToInterpolationCoefficient1D(vLine, 3, 0.0);
            this.putColumn(basic, this.width, x, vLine);
            ++x;
        }
        return basic;
    }

    private void extractRow(double[] array, int y, double[] row) {
        y *= row.length;
        int i = 0;
        while (i < row.length) {
            row[i] = array[y++];
            ++i;
        }
    }

    private void samplesToInterpolationCoefficient1D(double[] c, int degree, double tolerance) {
        double[] z = new double[]{};
        double lambda = 1.0;
        switch (degree) {
            case 3: {
                z = new double[]{Math.sqrt(3.0) - 2.0};
                break;
            }
            case 7: {
                z = new double[]{-0.5352804307964382, -0.12255461519232669, -0.009148694809608277};
            }
        }
        if (c.length == 1) {
            return;
        }
        int k = 0;
        while (k < z.length) {
            lambda *= (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
            ++k;
        }
        int n = 0;
        while (n < c.length) {
            int n2 = n++;
            c[n2] = c[n2] * lambda;
        }
        k = 0;
        while (k < z.length) {
            c[0] = this.getInitialCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
            int n3 = 1;
            while (n3 < c.length) {
                int n4 = n3;
                c[n4] = c[n4] + z[k] * c[n3 - 1];
                ++n3;
            }
            c[c.length - 1] = this.getInitialAntiCausalCoefficientMirrorOffBounds(c, z[k], tolerance);
            n3 = c.length - 2;
            while (n3 >= 0) {
                c[n3] = z[k] * (c[n3 + 1] - c[n3]);
                --n3;
            }
            ++k;
        }
    }

    private double getInitialCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
        double z1 = z;
        double zn = Math.pow(z, c.length);
        double sum = (1.0 + z) * (c[0] + zn * c[c.length - 1]);
        int horizon = c.length;
        if (0.0 < tolerance) {
            horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
            horizon = horizon < c.length ? horizon : c.length;
        }
        zn *= zn;
        int n = 1;
        while (n < horizon - 1) {
            sum += ((z1 *= z) + (zn /= z)) * c[n];
            ++n;
        }
        return sum / (1.0 - Math.pow(z, 2 * c.length));
    }

    private double getInitialAntiCausalCoefficientMirrorOffBounds(double[] c, double z, double tolerance) {
        return z * c[c.length - 1] / (z - 1.0);
    }

    private void putRow(double[] array, int y, double[] row) {
        y *= row.length;
        int i = 0;
        while (i < row.length) {
            array[y++] = row[i];
            ++i;
        }
    }

    private void extractColumn(double[] array, int width, int x, double[] column) {
        int i = 0;
        while (i < column.length) {
            column[i] = array[x];
            ++i;
            x += width;
        }
    }

    private void putColumn(double[] array, int width, int x, double[] column) {
        int i = 0;
        while (i < column.length) {
            array[x] = column[i];
            ++i;
            x += width;
        }
    }

    private void buildCoefficientPyramid() {
        double[] fullDual = new double[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        this.basicToCardinal2D(this.coefficient, fullDual, this.width, this.height, 7);
        int depth = 1;
        while (depth <= this.pyramidDepth && !super.isInterrupted()) {
            ProgressBar.setProgressBarMessage("Building coefficients pyramid...");
            ProgressBar.setProgressBarValue((double)depth / (double)this.pyramidDepth);
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            halfWidth /= 2;
            halfHeight /= 2;
            if (fullWidth <= 4 || fullHeight <= 4) {
                if (this.isSubsampledOutput) {
                    System.out.println("Coefficients pyramid " + fullWidth + "x" + fullHeight);
                }
                this.cPyramid.push(fullDual);
                this.cPyramid.push(new Integer(fullHeight));
                this.cPyramid.push(new Integer(fullWidth));
                halfWidth *= 2;
                halfHeight *= 2;
            } else {
                double[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
                double[] halfCoefficient = this.getBasicFromCardinal2D(halfDual, halfWidth, halfHeight, 7);
                if (this.isSubsampledOutput) {
                    System.out.println("Coefficients pyramid " + halfWidth + "x" + halfHeight);
                }
                this.cPyramid.push(halfCoefficient);
                this.cPyramid.push(new Integer(halfHeight));
                this.cPyramid.push(new Integer(halfWidth));
                fullDual = halfDual;
                if (this.isSubsampledOutput && halfWidth == this.subWidth) {
                    this.subCoeffs = halfCoefficient;
                }
            }
            ++depth;
        }
        this.currentDepth = this.pyramidDepth + 1;
    }

    private void basicToCardinal2D(double[] basic, double[] cardinal, int width, int height, int degree) {
        double[] hLine = new double[width];
        double[] vLine = new double[height];
        double[] hData = new double[width];
        double[] vData = new double[height];
        double[] h = null;
        switch (degree) {
            case 3: {
                h = new double[]{0.6666666666666666, 0.16666666666666666};
                break;
            }
            case 7: {
                h = new double[]{0.4793650793650794, 0.2363095238095238, 0.023809523809523808, 1.984126984126984E-4};
                break;
            }
            default: {
                h = new double[]{1.0};
            }
        }
        int y = 0;
        while (y < height && !super.isInterrupted()) {
            this.extractRow(basic, y, hLine);
            this.symmetricFirMirrorOffBounds1D(h, hLine, hData);
            this.putRow(cardinal, y, hData);
            ++y;
        }
        int x = 0;
        while (x < width && !super.isInterrupted()) {
            this.extractColumn(cardinal, width, x, vLine);
            this.symmetricFirMirrorOffBounds1D(h, vLine, vData);
            this.putColumn(cardinal, width, x, vData);
            ++x;
        }
    }

    private void symmetricFirMirrorOffBounds1D(double[] h, double[] c, double[] s) {
        block0 : switch (h.length) {
            case 2: {
                if (2 <= c.length) {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]);
                    int i = 1;
                    while (i < s.length - 1) {
                        s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]);
                        ++i;
                    }
                    s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]);
                    break;
                }
                s[0] = (h[0] + 2.0 * h[1]) * c[0];
                break;
            }
            case 4: {
                if (6 <= c.length) {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                    s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                    s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[4]) + h[3] * (c[0] + c[5]);
                    int i = 3;
                    while (i < s.length - 3) {
                        s[i] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]) + h[3] * (c[i - 3] + c[i + 3]);
                        ++i;
                    }
                    s[s.length - 3] = h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]) + h[3] * (c[c.length - 6] + c[c.length - 1]);
                    s[s.length - 2] = h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) + h[3] * (c[c.length - 5] + c[c.length - 2]);
                    s[s.length - 1] = h[0] * c[c.length - 1] + h[1] * (c[c.length - 2] + c[c.length - 1]) + h[2] * (c[c.length - 3] + c[c.length - 2]) + h[3] * (c[c.length - 4] + c[c.length - 3]);
                    break;
                }
                switch (c.length) {
                    case 5: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[4]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + (h[2] + h[3]) * (c[0] + c[4]);
                        s[3] = h[0] * c[3] + h[1] * (c[2] + c[4]) + h[2] * (c[1] + c[4]) + h[3] * (c[0] + c[3]);
                        s[4] = h[0] * c[4] + h[1] * (c[3] + c[4]) + h[2] * (c[2] + c[3]) + h[3] * (c[1] + c[2]);
                        break block0;
                    }
                    case 4: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + h[3] * (c[2] + c[3]);
                        s[1] = h[0] * c[1] + h[1] * (c[0] + c[2]) + h[2] * (c[0] + c[3]) + h[3] * (c[1] + c[3]);
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[3]) + h[2] * (c[0] + c[3]) + h[3] * (c[0] + c[2]);
                        s[3] = h[0] * c[3] + h[1] * (c[2] + c[3]) + h[2] * (c[1] + c[2]) + h[3] * (c[0] + c[1]);
                        break block0;
                    }
                    case 3: {
                        s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]) + 2.0 * h[3] * c[2];
                        s[1] = h[0] * c[1] + (h[1] + h[2]) * (c[0] + c[2]) + 2.0 * h[3] * c[1];
                        s[2] = h[0] * c[2] + h[1] * (c[1] + c[2]) + h[2] * (c[0] + c[1]) + 2.0 * h[3] * c[0];
                        break block0;
                    }
                    case 2: {
                        s[0] = (h[0] + h[1] + h[3]) * c[0] + (h[1] + 2.0 * h[2] + h[3]) * c[1];
                        s[1] = (h[0] + h[1] + h[3]) * c[1] + (h[1] + 2.0 * h[2] + h[3]) * c[0];
                        break block0;
                    }
                    case 1: {
                        s[0] = (h[0] + 2.0 * (h[1] + h[2] + h[3])) * c[0];
                    }
                }
            }
        }
    }

    private double[] getHalfDual2D(double[] fullDual, int fullWidth, int fullHeight) {
        int halfWidth = fullWidth / 2;
        int halfHeight = fullHeight / 2;
        double[] hLine = new double[fullWidth];
        double[] hData = new double[halfWidth];
        double[] vLine = new double[fullHeight];
        double[] vData = new double[halfHeight];
        double[] demiDual = new double[halfWidth * fullHeight];
        double[] halfDual = new double[halfWidth * halfHeight];
        int y = 0;
        while (y < fullHeight && !super.isInterrupted()) {
            this.extractRow(fullDual, y, hLine);
            this.reduceDual1D(hLine, hData);
            this.putRow(demiDual, y, hData);
            ++y;
        }
        int x = 0;
        while (x < halfWidth && !super.isInterrupted()) {
            this.extractColumn(demiDual, halfWidth, x, vLine);
            this.reduceDual1D(vLine, vData);
            this.putColumn(halfDual, halfWidth, x, vData);
            ++x;
        }
        return halfDual;
    }

    private void reduceDual1D(double[] c, double[] s) {
        double[] h = new double[]{0.375, 0.25, 0.0625};
        if (2 <= s.length) {
            s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
            int i = 2;
            int j = 1;
            while (j < s.length - 1) {
                s[j] = h[0] * c[i] + h[1] * (c[i - 1] + c[i + 1]) + h[2] * (c[i - 2] + c[i + 2]);
                i += 2;
                ++j;
            }
            s[s.length - 1] = c.length == 2 * s.length ? h[0] * c[c.length - 2] + h[1] * (c[c.length - 3] + c[c.length - 1]) + h[2] * (c[c.length - 4] + c[c.length - 1]) : h[0] * c[c.length - 3] + h[1] * (c[c.length - 4] + c[c.length - 2]) + h[2] * (c[c.length - 5] + c[c.length - 1]);
        } else {
            switch (c.length) {
                case 3: {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + h[2] * (c[1] + c[2]);
                    break;
                }
                case 2: {
                    s[0] = h[0] * c[0] + h[1] * (c[0] + c[1]) + 2.0 * h[2] * c[1];
                }
            }
        }
    }

    private double[] getBasicFromCardinal2D(double[] cardinal, int width, int height, int degree) {
        double[] basic = new double[width * height];
        double[] hLine = new double[width];
        double[] vLine = new double[height];
        int y = 0;
        while (y < height && !super.isInterrupted()) {
            this.extractRow(cardinal, y, hLine);
            this.samplesToInterpolationCoefficient1D(hLine, degree, 0.0);
            this.putRow(basic, y, hLine);
            ++y;
        }
        int x = 0;
        while (x < width && !super.isInterrupted()) {
            this.extractColumn(basic, width, x, vLine);
            this.samplesToInterpolationCoefficient1D(vLine, degree, 0.0);
            this.putColumn(basic, width, x, vLine);
            ++x;
        }
        return basic;
    }

    private void buildEmptyCoefficientPyramid() {
        int halfWidth = this.width;
        int halfHeight = this.height;
        double[] fullDual = new double[]{};
        double[] halfCoefficient = new double[]{};
        int depth = 1;
        while (depth <= this.pyramidDepth && !super.isInterrupted()) {
            ProgressBar.setProgressBarMessage("Building coefficients pyramid...");
            ProgressBar.setProgressBarValue((double)depth / (double)this.pyramidDepth);
            int fullWidth = halfWidth;
            int fullHeight = halfHeight;
            halfWidth /= 2;
            halfHeight /= 2;
            if (fullWidth <= 4 || fullHeight <= 4) {
                if (this.isSubsampledOutput) {
                    System.out.println("Coefficients pyramid " + fullWidth + "x" + fullHeight);
                }
                this.cPyramid.push(fullDual);
                this.cPyramid.push(new Integer(fullHeight));
                this.cPyramid.push(new Integer(fullWidth));
                halfWidth *= 2;
                halfHeight *= 2;
            } else {
                if (this.isSubsampledOutput) {
                    System.out.println("Coefficients pyramid " + halfWidth + "x" + halfHeight);
                }
                this.cPyramid.push(halfCoefficient);
                this.cPyramid.push(new Integer(halfHeight));
                this.cPyramid.push(new Integer(halfWidth));
                if (this.isSubsampledOutput && halfWidth == this.subWidth) {
                    this.subCoeffs = halfCoefficient;
                }
            }
            ++depth;
        }
        this.currentDepth = this.pyramidDepth + 1;
    }

    private void buildImagePyramid() {
        int fullHeight;
        int fullWidth;
        double[] fullDual = new double[this.width * this.height];
        int halfWidth = this.width;
        int halfHeight = this.height;
        this.cardinalToDual2D(this.image, fullDual, this.width, this.height, 3);
        int depth = 1;
        while (depth <= this.pyramidDepth && !super.isInterrupted()) {
            ProgressBar.setProgressBarMessage("Building image pyramid...");
            ProgressBar.setProgressBarValue((double)depth / (double)this.pyramidDepth);
            fullWidth = halfWidth;
            fullHeight = halfHeight;
            halfWidth /= 2;
            halfHeight /= 2;
            if (fullWidth <= 4 || fullHeight <= 4) {
                if (this.isSubsampledOutput) {
                    System.out.println(" Image pyramid " + fullWidth + "x" + fullHeight);
                }
                this.imgPyramid.push(fullDual);
                this.imgPyramid.push(new Integer(fullHeight));
                this.imgPyramid.push(new Integer(fullWidth));
                halfWidth *= 2;
                halfHeight *= 2;
            } else {
                double[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
                double[] halfImage = new double[halfWidth * halfHeight];
                this.dualToCardinal2D(halfDual, halfImage, halfWidth, halfHeight, 3);
                if (this.isSubsampledOutput) {
                    System.out.println(" Image pyramid " + halfWidth + "x" + halfHeight);
                }
                this.imgPyramid.push(halfImage);
                this.imgPyramid.push(new Integer(halfHeight));
                this.imgPyramid.push(new Integer(halfWidth));
                fullDual = halfDual;
                if (this.isSubsampledOutput && halfWidth == this.subWidth) {
                    this.subImage = halfDual;
                }
            }
            ++depth;
        }
        while (halfWidth > this.subWidth) {
            fullWidth = halfWidth;
            fullHeight = halfHeight;
            double[] halfDual = this.getHalfDual2D(fullDual, fullWidth, fullHeight);
            double[] halfImage = new double[(halfWidth /= 2) * (halfHeight /= 2)];
            this.dualToCardinal2D(halfDual, halfImage, halfWidth, halfHeight, 3);
            fullDual = halfDual;
            if (!this.isSubsampledOutput || halfWidth != this.subWidth) continue;
            this.subImage = halfDual;
        }
    }

    private void cardinalToDual2D(double[] cardinal, double[] dual, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(cardinal, width, height, degree), dual, width, height, 2 * degree + 1);
    }

    private void dualToCardinal2D(double[] dual, double[] cardinal, int width, int height, int degree) {
        this.basicToCardinal2D(this.getBasicFromCardinal2D(dual, width, height, 2 * degree + 1), cardinal, width, height, degree);
    }

    public void popFromPyramid() {
        if (this.cPyramid.isEmpty()) {
            this.currentWidth = this.width;
            this.currentHeight = this.height;
            this.currentCoefficient = this.coefficient;
        } else {
            this.currentWidth = (Integer)this.cPyramid.pop();
            this.currentHeight = (Integer)this.cPyramid.pop();
            this.currentCoefficient = (double[])this.cPyramid.pop();
        }
        if (this.currentDepth > 0) {
            --this.currentDepth;
        }
        if (this.isTarget && !this.imgPyramid.isEmpty()) {
            if (this.currentWidth != (Integer)this.imgPyramid.pop()) {
                System.out.println("I cannot understand");
            }
            if (this.currentHeight != (Integer)this.imgPyramid.pop()) {
                System.out.println("I cannot understand");
            }
            this.currentImage = (double[])this.imgPyramid.pop();
        } else {
            this.currentImage = this.image;
        }
    }

    public void precomputedPrepareForInterpolation(int Ydim, int Xdim, int intervals) {
        int k;
        double tu;
        double tv;
        this.prec_xIndex = new int[Xdim][4];
        this.prec_yIndex = new int[Ydim][4];
        this.prec_xWeight = new double[Xdim][4];
        this.prec_yWeight = new double[Ydim][4];
        this.prec_dxWeight = new double[Xdim][4];
        this.prec_dyWeight = new double[Ydim][4];
        this.prec_d2xWeight = new double[Xdim][4];
        this.prec_d2yWeight = new double[Ydim][4];
        boolean ORIGINAL = false;
        int v = 0;
        while (v < Ydim) {
            tv = (double)(v * intervals) / (double)(Ydim - 1) + 1.0;
            tu = 1.0;
            this.prepareForInterpolation(1.0, tv, ORIGINAL);
            k = 0;
            while (k < 4) {
                this.prec_yIndex[v][k] = this.yIndex[k];
                this.prec_yWeight[v][k] = this.yWeight[k];
                this.prec_dyWeight[v][k] = this.dyWeight[k];
                this.prec_d2yWeight[v][k] = this.d2yWeight[k];
                ++k;
            }
            ++v;
        }
        int u = 0;
        while (u < Xdim) {
            tv = 1.0;
            tu = (double)(u * intervals) / (double)(Xdim - 1) + 1.0;
            this.prepareForInterpolation(tu, 1.0, ORIGINAL);
            k = 0;
            while (k < 4) {
                this.prec_xIndex[u][k] = this.xIndex[k];
                this.prec_xWeight[u][k] = this.xWeight[k];
                this.prec_dxWeight[u][k] = this.dxWeight[k];
                this.prec_d2xWeight[u][k] = this.d2xWeight[k];
                ++k;
            }
            ++u;
        }
    }

    public void prepareForInterpolation(double x, double y, boolean fromCurrent) {
        int q;
        this.fromCurrent = fromCurrent;
        if (fromCurrent) {
            this.widthToUse = this.currentWidth;
            this.heightToUse = this.currentHeight;
        } else {
            this.widthToUse = this.width;
            this.heightToUse = this.height;
        }
        int ix = (int)x;
        int iy = (int)y;
        int twiceWidthToUse = 2 * this.widthToUse;
        int twiceHeightToUse = 2 * this.heightToUse;
        int p = 0.0 <= x ? ix + 2 : ix + 1;
        int k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceWidthToUse <= q) {
                    q -= twiceWidthToUse * (q / twiceWidthToUse);
                }
                this.xIndex[k] = this.widthToUse <= q ? twiceWidthToUse - 1 - q : q;
            } else {
                this.xIndex[k] = p < 0 || p >= this.widthToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        p = 0.0 <= y ? iy + 2 : iy + 1;
        k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceHeightToUse <= q) {
                    q -= twiceHeightToUse * (q / twiceHeightToUse);
                }
                this.yIndex[k] = this.heightToUse <= q ? twiceHeightToUse - 1 - q : q;
            } else {
                this.yIndex[k] = p < 0 || p >= this.heightToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        double ex = x - (double)(0.0 <= x ? ix : ix - 1);
        double ey = y - (double)(0.0 <= y ? iy : iy - 1);
        double s = 1.0 - ex;
        this.dxWeight[0] = 0.5 * ex * ex;
        this.xWeight[0] = ex * this.dxWeight[0] / 3.0;
        this.dxWeight[3] = -0.5 * s * s;
        this.xWeight[3] = s * this.dxWeight[3] / -3.0;
        this.dxWeight[1] = 1.0 - 2.0 * this.dxWeight[0] + this.dxWeight[3];
        this.xWeight[1] = MathTools.Bspline03(x - (double)ix - 1.0);
        this.dxWeight[2] = 1.5 * ex * (ex - 1.3333333730697632);
        this.xWeight[2] = 0.6666666865348816 - (2.0 - ex) * this.dxWeight[0];
        this.d2xWeight[0] = ex;
        this.d2xWeight[1] = s - 2.0 * ex;
        this.d2xWeight[2] = ex - 2.0 * s;
        this.d2xWeight[3] = s;
        double t = 1.0 - ey;
        this.dyWeight[0] = 0.5 * ey * ey;
        this.yWeight[0] = ey * this.dyWeight[0] / 3.0;
        this.dyWeight[3] = -0.5 * t * t;
        this.yWeight[3] = t * this.dyWeight[3] / -3.0;
        this.dyWeight[1] = 1.0 - 2.0 * this.dyWeight[0] + this.dyWeight[3];
        this.yWeight[1] = 0.6666666865348816 + (1.0 + ey) * this.dyWeight[3];
        this.dyWeight[2] = 1.5 * ey * (ey - 1.3333333730697632);
        this.yWeight[2] = 0.6666666865348816 - (2.0 - ey) * this.dyWeight[0];
        this.d2yWeight[0] = ey;
        this.d2yWeight[1] = t - 2.0 * ey;
        this.d2yWeight[2] = ey - 2.0 * t;
        this.d2yWeight[3] = t;
    }

    public void setCoefficients(double[] c, int Ydim, int Xdim, int offset) {
        System.arraycopy(c, offset, this.coefficient, 0, Ydim * Xdim);
    }

    public double precomputedInterpolateI(int u, int v) {
        double ival = 0.0;
        int j = 0;
        while (j < 4) {
            double s = 0.0;
            int iy = this.prec_yIndex[v][j];
            if (iy != -1) {
                int p = iy * this.widthToUse;
                int i = 0;
                while (i < 4) {
                    int ix = this.prec_xIndex[u][i];
                    if (ix != -1) {
                        s = this.fromCurrent ? (s += this.prec_xWeight[u][i] * this.currentCoefficient[p + ix]) : (s += this.prec_xWeight[u][i] * this.coefficient[p + ix]);
                    }
                    ++i;
                }
                ival += this.prec_yWeight[v][j] * s;
            }
            ++j;
        }
        return ival;
    }

    public double prepareForInterpolationAndInterpolateIAndD(double x, double y, double[] D, boolean fromSub, boolean fromCurrent) {
        int q;
        int widthToUse = 0;
        int heightToUse = 0;
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double[] xWeight = new double[4];
        double[] dxWeight = new double[4];
        double[] yWeight = new double[4];
        double[] dyWeight = new double[4];
        if (fromSub && this.subCoeffs != null) {
            widthToUse = this.subWidth;
            heightToUse = this.subHeight;
        } else if (fromCurrent) {
            widthToUse = this.currentWidth;
            heightToUse = this.currentHeight;
        } else {
            widthToUse = this.width;
            heightToUse = this.height;
        }
        int ix = (int)x;
        int iy = (int)y;
        int twiceWidthToUse = 2 * widthToUse;
        int twiceHeightToUse = 2 * heightToUse;
        int p = 0.0 <= x ? ix + 2 : ix + 1;
        int k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceWidthToUse <= q) {
                    q -= twiceWidthToUse * (q / twiceWidthToUse);
                }
                xIndex[k] = widthToUse <= q ? twiceWidthToUse - 1 - q : q;
            } else {
                xIndex[k] = p < 0 || p >= widthToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        p = 0.0 <= y ? iy + 2 : iy + 1;
        k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceHeightToUse <= q) {
                    q -= twiceHeightToUse * (q / twiceHeightToUse);
                }
                yIndex[k] = heightToUse <= q ? twiceHeightToUse - 1 - q : q;
            } else {
                yIndex[k] = p < 0 || p >= heightToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        double ex = x - (double)(0.0 <= x ? ix : ix - 1);
        double ey = y - (double)(0.0 <= y ? iy : iy - 1);
        double s = 1.0 - ex;
        dxWeight[0] = 0.5 * ex * ex;
        xWeight[0] = ex * dxWeight[0] / 3.0;
        dxWeight[3] = -0.5 * s * s;
        xWeight[3] = s * dxWeight[3] / -3.0;
        dxWeight[1] = 1.0 - 2.0 * dxWeight[0] + dxWeight[3];
        xWeight[1] = MathTools.Bspline03(x - (double)ix - 1.0);
        dxWeight[2] = 1.5 * ex * (ex - 1.3333333730697632);
        xWeight[2] = 0.6666666865348816 - (2.0 - ex) * dxWeight[0];
        double t = 1.0 - ey;
        dyWeight[0] = 0.5 * ey * ey;
        yWeight[0] = ey * dyWeight[0] / 3.0;
        dyWeight[3] = -0.5 * t * t;
        yWeight[3] = t * dyWeight[3] / -3.0;
        dyWeight[1] = 1.0 - 2.0 * dyWeight[0] + dyWeight[3];
        yWeight[1] = 0.6666666865348816 + (1.0 + ey) * dyWeight[3];
        dyWeight[2] = 1.5 * ey * (ey - 1.3333333730697632);
        yWeight[2] = 0.6666666865348816 - (2.0 - ey) * dyWeight[0];
        double ival = 0.0;
        int j = 0;
        while (j < 4) {
            s = 0.0;
            iy = yIndex[j];
            if (iy != -1) {
                p = iy * widthToUse;
                int i = 0;
                while (i < 4) {
                    ix = xIndex[i];
                    if (ix != -1) {
                        s = fromSub && this.subCoeffs != null ? (s += xWeight[i] * this.subCoeffs[p + ix]) : (fromCurrent ? (s += xWeight[i] * this.currentCoefficient[p + ix]) : (s += xWeight[i] * this.coefficient[p + ix]));
                    }
                    ++i;
                }
                ival += yWeight[j] * s;
            }
            ++j;
        }
        D[1] = 0.0;
        D[0] = 0.0;
        j = 0;
        while (j < 4) {
            double sx = 0.0;
            double sy = 0.0;
            iy = yIndex[j];
            if (iy != -1) {
                p = iy * widthToUse;
                int i = 0;
                while (i < 4) {
                    ix = xIndex[i];
                    if (ix != -1) {
                        double c = fromSub && this.subCoeffs != null ? this.subCoeffs[p + ix] : (fromCurrent ? this.currentCoefficient[p + ix] : this.coefficient[p + ix]);
                        sx += dxWeight[i] * c;
                        sy += xWeight[i] * c;
                    }
                    ++i;
                }
                D[0] = D[0] + yWeight[j] * sx;
                D[1] = D[1] + dyWeight[j] * sy;
            }
            ++j;
        }
        return ival;
    }

    public double interpolateI() {
        double ival = 0.0;
        int j = 0;
        while (j < 4) {
            double s = 0.0;
            int iy = this.yIndex[j];
            if (iy != -1) {
                int p = iy * this.widthToUse;
                int i = 0;
                while (i < 4) {
                    int ix = this.xIndex[i];
                    if (ix != -1) {
                        s = this.fromCurrent ? (s += this.xWeight[i] * this.currentCoefficient[p + ix]) : (s += this.xWeight[i] * this.coefficient[p + ix]);
                    }
                    ++i;
                }
                ival += this.yWeight[j] * s;
            }
            ++j;
        }
        return ival;
    }

    public double prepareForInterpolationAndInterpolateI(double x, double y, boolean fromSub, boolean fromCurrent) {
        int q;
        int widthToUse = 0;
        int heightToUse = 0;
        int[] xIndex = new int[4];
        int[] yIndex = new int[4];
        double[] xWeight = new double[4];
        double[] dxWeight = new double[4];
        double[] yWeight = new double[4];
        double[] dyWeight = new double[4];
        if (fromSub && this.subCoeffs != null) {
            widthToUse = this.subWidth;
            heightToUse = this.subHeight;
        } else if (fromCurrent) {
            widthToUse = this.currentWidth;
            heightToUse = this.currentHeight;
        } else {
            widthToUse = this.width;
            heightToUse = this.height;
        }
        int ix = (int)x;
        int iy = (int)y;
        int twiceWidthToUse = 2 * widthToUse;
        int twiceHeightToUse = 2 * heightToUse;
        int p = 0.0 <= x ? ix + 2 : ix + 1;
        int k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceWidthToUse <= q) {
                    q -= twiceWidthToUse * (q / twiceWidthToUse);
                }
                xIndex[k] = widthToUse <= q ? twiceWidthToUse - 1 - q : q;
            } else {
                xIndex[k] = p < 0 || p >= widthToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        p = 0.0 <= y ? iy + 2 : iy + 1;
        k = 0;
        while (k < 4) {
            if (this.coefficientsAreMirrored) {
                int n = q = p < 0 ? -1 - p : p;
                if (twiceHeightToUse <= q) {
                    q -= twiceHeightToUse * (q / twiceHeightToUse);
                }
                yIndex[k] = heightToUse <= q ? twiceHeightToUse - 1 - q : q;
            } else {
                yIndex[k] = p < 0 || p >= heightToUse ? -1 : p;
            }
            --p;
            ++k;
        }
        double ex = x - (double)(0.0 <= x ? ix : ix - 1);
        double ey = y - (double)(0.0 <= y ? iy : iy - 1);
        double s = 1.0 - ex;
        dxWeight[0] = 0.5 * ex * ex;
        xWeight[0] = ex * dxWeight[0] / 3.0;
        dxWeight[3] = -0.5 * s * s;
        xWeight[3] = s * dxWeight[3] / -3.0;
        dxWeight[1] = 1.0 - 2.0 * dxWeight[0] + dxWeight[3];
        xWeight[1] = MathTools.Bspline03(x - (double)ix - 1.0);
        dxWeight[2] = 1.5 * ex * (ex - 1.3333333730697632);
        xWeight[2] = 0.6666666865348816 - (2.0 - ex) * dxWeight[0];
        double t = 1.0 - ey;
        dyWeight[0] = 0.5 * ey * ey;
        yWeight[0] = ey * dyWeight[0] / 3.0;
        dyWeight[3] = -0.5 * t * t;
        yWeight[3] = t * dyWeight[3] / -3.0;
        dyWeight[1] = 1.0 - 2.0 * dyWeight[0] + dyWeight[3];
        yWeight[1] = 0.6666666865348816 + (1.0 + ey) * dyWeight[3];
        dyWeight[2] = 1.5 * ey * (ey - 1.3333333730697632);
        yWeight[2] = 0.6666666865348816 - (2.0 - ey) * dyWeight[0];
        double ival = 0.0;
        int j = 0;
        while (j < 4) {
            s = 0.0;
            iy = yIndex[j];
            if (iy != -1) {
                p = iy * widthToUse;
                int i = 0;
                while (i < 4) {
                    ix = xIndex[i];
                    if (ix != -1) {
                        s = fromSub && this.subCoeffs != null ? (s += xWeight[i] * this.subCoeffs[p + ix]) : (fromCurrent ? (s += xWeight[i] * this.currentCoefficient[p + ix]) : (s += xWeight[i] * this.coefficient[p + ix]));
                    }
                    ++i;
                }
                ival += yWeight[j] * s;
            }
            ++j;
        }
        return ival;
    }
}

