/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.bigimage.BigImageLoader;
import algorithms.danyfel80.registration.bunwarp.BUnwarpper;
import algorithms.danyfel80.registration.bunwarp.ProgressBar;
import algorithms.danyfel80.registration.bunwarp.RegistrationModeEnum;
import icy.common.exception.UnsupportedFormatException;
import icy.main.Icy;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class BigBUnwarpper
implements Runnable {
    private String srcPath;
    private String tgtPath;
    private String transformedSrcPath;
    private String transformedTgtPath;
    private String srcResultPath;
    private String tgtResultPath;
    private String transformedSrcResultPath;
    private String transformedTgtResultPath;
    private List<ROI2DPoint> srcLandmarks;
    private List<ROI2DPoint> tgtLandmarks;
    private ROI2D srcMask;
    private ROI2D tgtMask;
    private int subsampleFactor;
    private int initialDeformation;
    private int finalDeformation;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private boolean showProcess;
    private int mode;
    private BUnwarp plugin;

    public BigBUnwarpper(String srcPath, String tgtPath, String transformedSrcPath, String transformedTgtPath, String srcResultPath, String tgtResultPath, String transformedSrcResultPath, String transformedTgtResultPath, List<ROI2DPoint> srcLandmarks, List<ROI2DPoint> tgtLandmarks, ROI2D srcMask, ROI2D tgtMask, int subsampleFactor, int initialDeformation, int finalDeformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, boolean showProcess, int mode, BUnwarp plugin) {
        this.srcPath = srcPath;
        this.tgtPath = tgtPath;
        this.transformedSrcPath = transformedSrcPath;
        this.transformedTgtPath = transformedTgtPath;
        this.srcResultPath = srcResultPath;
        this.tgtResultPath = tgtResultPath;
        this.transformedSrcResultPath = transformedSrcResultPath;
        this.transformedTgtResultPath = transformedTgtResultPath;
        this.srcLandmarks = srcLandmarks;
        this.tgtLandmarks = tgtLandmarks;
        this.srcMask = srcMask;
        this.tgtMask = tgtMask;
        this.subsampleFactor = subsampleFactor;
        this.initialDeformation = initialDeformation;
        this.finalDeformation = finalDeformation;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.showProcess = showProcess;
        this.mode = mode;
        this.plugin = plugin;
    }

    @Override
    public void run() {
        Sequence tgtSeq;
        Sequence srcSeq;
        ProgressBar.setPlugin(this.plugin);
        try {
            BigImageLoader loader = new BigImageLoader();
            loader.setPluginGUI(this.plugin.getUI());
            ProgressBar.setProgressBarMessage("Loading source image");
            srcSeq = loader.loadDownsampledImage(this.srcPath, null, 1000, 1000, true);
            ProgressBar.setProgressBarMessage("Loading source mask");
            this.srcMask = loader.loadDownsampledMask(srcSeq, this.srcPath, null, 1000, 1000, true);
            ProgressBar.setProgressBarMessage("Loading target image");
            tgtSeq = loader.loadDownsampledImage(this.tgtPath, null, 1000, 1000, true);
            ProgressBar.setProgressBarMessage("Loading target mask");
            this.tgtMask = loader.loadDownsampledMask(tgtSeq, this.tgtPath, null, 1000, 1000, true);
        }
        catch (UnsupportedFormatException | IOException e1) {
            e1.printStackTrace();
            return;
        }
        BUnwarpper bu = new BUnwarpper(srcSeq, tgtSeq, this.srcLandmarks, this.tgtLandmarks, this.srcMask, this.tgtMask, this.subsampleFactor, this.initialDeformation, this.finalDeformation, 0, this.divWeight, this.curlWeight, this.landmarkWeight, this.imageWeight, this.consistencyWeight, this.stopThreshold, this.showProcess ? 2 : 1, this.showProcess, this.mode, this.plugin);
        Thread but = new Thread(bu);
        but.start();
        try {
            but.join();
            but = null;
        }
        catch (InterruptedException e) {
            System.err.println("Thread interrupted: " + e.getMessage());
            return;
        }
        if (this.plugin.isPluginInterrumped()) {
            return;
        }
        try {
            System.out.println("saving to " + this.transformedSrcResultPath + ", based on " + this.transformedSrcPath);
            bu.saveBigRegisteredSource(this.srcResultPath, this.transformedSrcResultPath, this.srcPath, this.transformedSrcPath, this.tgtPath, null);
        }
        catch (IOException | InterruptedException | ExecutionException | ServiceException | FormatException e) {
            e.printStackTrace();
            return;
        }
        if (this.plugin.isPluginInterrumped()) {
            return;
        }
        if (this.mode != RegistrationModeEnum.MONO.getNumber()) {
            try {
                bu.saveBigRegisteredTarget(this.tgtResultPath, this.transformedTgtResultPath, this.tgtPath, this.transformedTgtPath, this.srcPath, null);
            }
            catch (IOException | InterruptedException | ExecutionException | ServiceException | FormatException e) {
                e.printStackTrace();
            }
        }
        bu = null;
        System.gc();
    }

    private static class BUnwarpperTask
    implements Runnable {
        final int maxImageSubsamplingFactor;
        final int minScaleDeformation;
        final int maxScaleDeformation;
        final int minScaleImage;
        final double divWeight;
        final double curlWeight;
        final double landmarkWeight;
        final double imageWeight;
        final double consistencyWeight;
        final double stopThreshold;
        final int outputLevel;
        final boolean showMarquardtOptim;
        final int accurateMode;
        final BUnwarp plugin;
        BUnwarpper unwarp;
        String sourceResultPath;
        String transformedSourceResultPath;
        String sourcePath;
        String transformedSourcePath;
        String targetPath;
        String srcPath;
        Rectangle tile;

        public BUnwarpperTask(int maxImageSubsamplingFactor, int minScaleDeformation, int maxScaleDeformation, int minScaleImage, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurateMode, BUnwarp plugin, String sourceResultPath, String transformedSourceResultPath, String sourcePath, String transformedSourcePath, String srcPath, String targetPath, Rectangle tile) {
            this.maxImageSubsamplingFactor = maxImageSubsamplingFactor;
            this.minScaleDeformation = minScaleDeformation;
            this.maxScaleDeformation = maxScaleDeformation;
            this.minScaleImage = minScaleImage;
            this.divWeight = divWeight;
            this.curlWeight = curlWeight;
            this.landmarkWeight = landmarkWeight;
            this.imageWeight = imageWeight;
            this.consistencyWeight = consistencyWeight;
            this.stopThreshold = stopThreshold;
            this.outputLevel = outputLevel;
            this.showMarquardtOptim = showMarquardtOptim;
            this.accurateMode = accurateMode;
            this.plugin = plugin;
            this.sourceResultPath = sourceResultPath;
            this.transformedSourceResultPath = transformedSourceResultPath;
            this.sourcePath = sourcePath;
            this.transformedSourcePath = transformedSourcePath;
            this.targetPath = targetPath;
            this.srcPath = srcPath;
            this.tile = tile;
        }

        @Override
        public void run() {
            BigImageLoader loader = new BigImageLoader();
            Sequence srcSeq = null;
            ROI2D srcMask = null;
            Sequence tgtSeq = null;
            ROI2D tgtMask = null;
            try {
                ProgressBar.setProgressBarMessage("Loading source tile image");
                srcSeq = loader.loadDownsampledImage(this.sourcePath, this.tile, 1023, 1023, true);
                ProgressBar.setProgressBarMessage("Loading source mask");
                srcMask = loader.loadDownsampledMask(srcSeq, this.srcPath, this.tile, 1023, 1023, true);
                ProgressBar.setProgressBarMessage("Loading target tile image");
                tgtSeq = loader.loadDownsampledImage(this.targetPath, this.tile, 1023, 1023, true);
                ProgressBar.setProgressBarMessage("Loading source mask");
                tgtMask = loader.loadDownsampledMask(tgtSeq, this.targetPath, this.tile, 1000, 1000, true);
            }
            catch (UnsupportedFormatException | IOException e1) {
                e1.printStackTrace();
            }
            if (srcSeq != null) {
                if (srcMask != null) {
                    srcSeq.addROI(srcMask);
                }
                Icy.getMainInterface().addSequence(srcSeq);
            }
            if (tgtSeq != null) {
                if (tgtMask != null) {
                    tgtSeq.addROI(tgtMask);
                }
                Icy.getMainInterface().addSequence(tgtSeq);
            }
            this.unwarp = new BUnwarpper(srcSeq, tgtSeq, new ArrayList<ROI2DPoint>(), new ArrayList<ROI2DPoint>(), srcMask, tgtMask, this.maxImageSubsamplingFactor, this.minScaleDeformation, this.maxScaleDeformation, this.minScaleImage, this.divWeight, this.curlWeight, this.landmarkWeight, this.imageWeight, this.consistencyWeight, this.stopThreshold, this.outputLevel, this.showMarquardtOptim, this.accurateMode, this.plugin);
            Thread thr = new Thread(this.unwarp);
            thr.start();
            try {
                thr.join();
                thr = null;
                System.out.println("saving " + this.tile);
                this.unwarp.saveBigRegisteredSource(this.sourceResultPath, this.transformedSourceResultPath, this.sourcePath, this.transformedSourcePath, this.targetPath, this.tile);
            }
            catch (IOException | InterruptedException | ExecutionException | ServiceException | FormatException e) {
                e.printStackTrace();
            }
        }
    }
}

