/*
 * Decompiled with CFR 0.152.
 */
package algorithms.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.BSplineModel;
import algorithms.danyfel80.registration.bunwarp.BigImageTools;
import algorithms.danyfel80.registration.bunwarp.CumulativeQueue;
import algorithms.danyfel80.registration.bunwarp.MathTools;
import algorithms.danyfel80.registration.bunwarp.MiscTools;
import algorithms.danyfel80.registration.bunwarp.ProgressBar;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.roi.roi2d.ROI2DPoint;

public class Transformation {
    private static final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    private static final boolean PYRAMID = true;
    private static final boolean ORIGINAL = false;
    private final int transformationSplineDegree = 3;
    private Sequence outputSeq1;
    private Sequence outputSeq2;
    private BUnwarp plugin;
    private Sequence sourceSeq;
    private Sequence targetSeq;
    private BSplineModel sourceModel;
    private BSplineModel targetModel;
    private IcyBufferedImage originalSourceIBI;
    private IcyBufferedImage originalTargetIBI;
    private List<ROI2DPoint> sourceLandmarks;
    private List<ROI2DPoint> targetLandmarks;
    private ROI2D sourceMask;
    private ROI2D targetMask;
    private double tweakShear = 0.0;
    private double tweakScale = 0.0;
    private double tweakIso = 0.0;
    private int sourceHeight;
    private int sourceWidth;
    private int targetHeight;
    private int targetWidth;
    private int targetCurrentHeight;
    private int targetCurrentWidth;
    private int sourceCurrentHeight;
    private int sourceCurrentWidth;
    private double targetFactorHeight;
    private double targetFactorWidth;
    private double sourceFactorHeight;
    private double sourceFactorWidth;
    private double partialDirectSimilarityError;
    private double partialDirectRegularizationError;
    private double partialDirectLandmarkError;
    private double partialDirectConsitencyError;
    private double finalDirectSimilarityError;
    private double finalDirectRegularizationError;
    private double finalDirectLandmarkError;
    private double finalDirectConsistencyError;
    private double partialInverseSimilarityError;
    private double partialInverseRegularizationError;
    private double partialInverseLandmarkError;
    private double partialInverseConsitencyError;
    private double finalInverseSimilarityError;
    private double finalInverseRegularizationError;
    private double finalInverseLandmarkError;
    private double finalInverseConsistencyError;
    private int minScaleDeformation;
    private int maxScaleDeformation;
    private int minScaleImage;
    private int outputLevel;
    private boolean showMarquardtOptim;
    private double divWeight;
    private double curlWeight;
    private double landmarkWeight;
    private double imageWeight;
    private double consistencyWeight;
    private double stopThreshold;
    private int accurateMode;
    private int intervals;
    private double[][] cxSourceToTarget = null;
    private double[][] cySourceToTarget = null;
    private double[][] cxTargetToSource = null;
    private double[][] cyTargetToSource = null;
    private BSplineModel swxSourceToTarget = null;
    private BSplineModel swySourceToTarget = null;
    private BSplineModel swxTargetToSource = null;
    private BSplineModel swyTargetToSource = null;
    private double[][] P11_SourceToTarget;
    private double[][] P22_SourceToTarget;
    private double[][] P12_SourceToTarget;
    private double[][] P11_TargetToSource;
    private double[][] P22_TargetToSource;
    private double[][] P12_TargetToSource;

    public Transformation(Sequence sourceSeq, Sequence targetSeq, BSplineModel sourceModel, BSplineModel targetModel, List<ROI2DPoint> sourceLandmarks, List<ROI2DPoint> targetLandmarks, ROI2D sourceMask, ROI2D targetMask, int minScaleDeformation, int maxScaleDeformation, int minScaleImage, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, int outputLevel, boolean showMarquardtOptim, int accurateMode, Sequence outputSequence1, Sequence outputSequence2, BUnwarp plugin) {
        this.sourceSeq = sourceSeq;
        this.targetSeq = targetSeq;
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
        this.sourceLandmarks = sourceLandmarks;
        this.targetLandmarks = targetLandmarks;
        this.sourceMask = sourceMask;
        this.targetMask = targetMask;
        this.minScaleDeformation = minScaleDeformation;
        this.maxScaleDeformation = maxScaleDeformation;
        this.minScaleImage = minScaleDeformation;
        this.divWeight = divWeight;
        this.curlWeight = curlWeight;
        this.landmarkWeight = landmarkWeight;
        this.imageWeight = imageWeight;
        this.consistencyWeight = consistencyWeight;
        this.stopThreshold = stopThreshold;
        this.outputLevel = outputLevel;
        this.showMarquardtOptim = showMarquardtOptim;
        this.accurateMode = accurateMode;
        this.outputSeq1 = outputSequence1;
        this.outputSeq2 = outputSequence2;
        this.plugin = plugin;
        this.originalSourceIBI = sourceSeq.getFirstImage();
        this.originalTargetIBI = targetSeq.getFirstImage();
        this.sourceWidth = sourceModel.getWidth();
        this.sourceHeight = sourceModel.getHeight();
        this.targetWidth = targetModel.getWidth();
        this.targetHeight = targetModel.getHeight();
    }

    public void doUnidirectionalRegistration() {
        int i;
        this.sourceModel.popFromPyramid();
        this.targetModel.popFromPyramid();
        this.targetCurrentHeight = this.targetModel.getCurrentHeight();
        this.targetCurrentWidth = this.targetModel.getCurrentWidth();
        this.targetFactorHeight = this.targetModel.getFactorHeight();
        this.targetFactorWidth = this.targetModel.getFactorWidth();
        this.sourceCurrentHeight = this.sourceModel.getCurrentHeight();
        this.sourceCurrentWidth = this.sourceModel.getCurrentWidth();
        this.sourceFactorHeight = this.sourceModel.getFactorHeight();
        this.sourceFactorWidth = this.sourceModel.getFactorWidth();
        int sizeCorrectionFactor = 0;
        this.intervals = (int)Math.pow(2.0, this.minScaleDeformation + sizeCorrectionFactor);
        this.cxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.cyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.buildRegularizationTemporary(this.intervals, false);
        int K = this.targetLandmarks != null ? this.targetLandmarks.size() : 0;
        double[] dxTargetToSource = new double[K];
        double[] dyTargetToSource = new double[K];
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        double[][] affineMatrix = null;
        affineMatrix = this.computeAffineMatrix(false);
        int i2 = 0;
        while (i2 < this.intervals + 3) {
            double v = (double)((i2 - 1) * (this.targetCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            int j = 0;
            while (j < this.intervals + 3) {
                double u = (double)((j - 1) * (this.targetCurrentWidth - 1)) / (double)this.intervals;
                this.cxTargetToSource[i2][j] = xv + affineMatrix[0][0] * u;
                this.cyTargetToSource[i2][j] = yv + affineMatrix[1][0] * u;
                ++j;
            }
            ++i2;
        }
        int state = this.minScaleDeformation == this.maxScaleDeformation ? 1 : 0;
        int s = this.minScaleDeformation;
        int step = 0;
        this.computeTotalWorkload();
        while (state != -1) {
            int currentDepth = this.targetModel.getCurrentDepth();
            if (state == 0 || state == 1) {
                if (s >= this.minScaleDeformation) {
                    this.intervals = (int)Math.pow(2.0, s + sizeCorrectionFactor);
                    double[][] newcxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    boolean underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        i = 0;
                        while (i < this.intervals + 3) {
                            int j = 0;
                            while (j < this.intervals + 3) {
                                double[] dArray = this.cxTargetToSource[i];
                                int n = j;
                                dArray[n] = dArray[n] + newcxTargetToSource[i][j];
                                double[] dArray2 = this.cyTargetToSource[i];
                                int n2 = j;
                                dArray2[n2] = dArray2[n2] + newcyTargetToSource[i][j];
                                ++j;
                            }
                            ++i;
                        }
                    }
                }
                this.optimizeCoeffs(this.intervals, this.stopThreshold, this.cxTargetToSource, this.cyTargetToSource);
            }
            ++step;
            switch (state) {
                case 0: {
                    if (s < this.maxScaleDeformation) {
                        this.cxTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cxTargetToSource, 1.0);
                        this.cyTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cyTargetToSource, 1.0);
                        ++s;
                        this.intervals *= 2;
                        this.buildRegularizationTemporary(this.intervals, false);
                        if (currentDepth > this.minScaleImage) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.minScaleImage) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.maxScaleDeformation && currentDepth == this.minScaleImage ? 2 : (s == this.maxScaleDeformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    double oldTargetCurrentHeight = this.targetCurrentHeight;
                    double oldTargetCurrentWidth = this.targetCurrentWidth;
                    this.sourceModel.popFromPyramid();
                    this.targetModel.popFromPyramid();
                    this.targetCurrentHeight = this.targetModel.getCurrentHeight();
                    this.targetCurrentWidth = this.targetModel.getCurrentWidth();
                    this.targetFactorHeight = this.targetModel.getFactorHeight();
                    this.targetFactorWidth = this.targetModel.getFactorWidth();
                    this.sourceCurrentHeight = this.sourceModel.getCurrentHeight();
                    this.sourceCurrentWidth = this.sourceModel.getCurrentWidth();
                    this.sourceFactorHeight = this.sourceModel.getFactorHeight();
                    this.sourceFactorWidth = this.sourceModel.getFactorWidth();
                    double targetFactorY = (double)(this.targetCurrentHeight - 1) / (oldTargetCurrentHeight - 1.0);
                    double targetFactorX = (double)(this.targetCurrentWidth - 1) / (oldTargetCurrentWidth - 1.0);
                    int i3 = 0;
                    while (i3 < this.intervals + 3) {
                        int j = 0;
                        while (j < this.intervals + 3) {
                            double[] dArray = this.cxTargetToSource[i3];
                            int n = j;
                            dArray[n] = dArray[n] * targetFactorX;
                            double[] dArray3 = this.cyTargetToSource[i3];
                            int n3 = j++;
                            dArray3[n3] = dArray3[n3] * targetFactorY;
                        }
                        ++i3;
                    }
                    this.buildRegularizationTemporary(this.intervals, false);
                }
            }
            if (state != 0 && state != 1 || s != this.maxScaleDeformation || currentDepth != this.minScaleImage + 1 || this.accurateMode != 1) continue;
            this.stopThreshold /= 10.0;
        }
        if (this.sourceModel.getOriginalImageWidth() > this.targetCurrentWidth) {
            if (this.sourceModel.isSubOutput() || this.targetModel.isSubOutput()) {
                System.out.println("Adapting coefficients from " + this.sourceCurrentWidth + " to " + this.originalSourceIBI.getWidth() + "...");
            }
            double targetFactorY = (this.targetModel.getOriginalImageHeight() - 1) / (this.targetCurrentHeight - 1);
            double targetFactorX = (this.targetModel.getOriginalImageWidth() - 1) / (this.targetCurrentWidth - 1);
            i = 0;
            while (i < this.intervals + 3) {
                int j = 0;
                while (j < this.intervals + 3) {
                    double[] dArray = this.cxTargetToSource[i];
                    int n = j;
                    dArray[n] = dArray[n] * targetFactorX;
                    double[] dArray4 = this.cyTargetToSource[i];
                    int n4 = j++;
                    dArray4[n4] = dArray4[n4] * targetFactorY;
                }
                ++i;
            }
            this.targetCurrentHeight = this.targetModel.getOriginalImageHeight();
            this.targetCurrentWidth = this.targetModel.getOriginalImageWidth();
            this.sourceCurrentHeight = this.sourceModel.getOriginalImageHeight();
            this.sourceCurrentWidth = this.sourceModel.getOriginalImageWidth();
        }
        if (this.outputLevel == 2) {
            if (this.imageWeight != 0.0) {
                System.out.println(" Optimal direct similarity error = " + this.finalDirectSimilarityError);
            }
            if (this.curlWeight != 0.0 || this.divWeight != 0.0) {
                System.out.println(" Optimal direct regularization error = " + this.finalDirectRegularizationError);
            }
            if (this.landmarkWeight != 0.0) {
                System.out.println(" Optimal direct landmark error = " + this.finalDirectLandmarkError);
            }
            if (this.consistencyWeight != 0.0) {
                System.out.println(" Optimal direct consistency error = " + this.finalDirectConsistencyError);
            }
        }
    }

    private void buildRegularizationTemporary(int intervals, boolean bIsReverse) {
        int M = intervals + 3;
        int M2 = M * M;
        double[][] P11 = new double[M2][M2];
        if (bIsReverse) {
            this.P11_SourceToTarget = P11;
        } else {
            this.P11_TargetToSource = P11;
        }
        int i = 0;
        while (i < M2) {
            int j = 0;
            while (j < M2) {
                P11[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.build_Matrix_Rq1q2(intervals, this.divWeight, 2, 0, P11, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.divWeight + this.curlWeight, 1, 1, P11, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.curlWeight, 0, 2, P11, bIsReverse);
        double[][] P22 = new double[M2][M2];
        if (bIsReverse) {
            this.P22_SourceToTarget = P22;
        } else {
            this.P22_TargetToSource = P22;
        }
        int i2 = 0;
        while (i2 < M2) {
            int j = 0;
            while (j < M2) {
                P22[i2][j] = 0.0;
                ++j;
            }
            ++i2;
        }
        this.build_Matrix_Rq1q2(intervals, this.divWeight, 0, 2, P22, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.divWeight + this.curlWeight, 1, 1, P22, bIsReverse);
        this.build_Matrix_Rq1q2(intervals, this.curlWeight, 2, 0, P22, bIsReverse);
        double[][] P12 = new double[M2][M2];
        if (bIsReverse) {
            this.P12_SourceToTarget = P12;
        } else {
            this.P12_TargetToSource = P12;
        }
        int i3 = 0;
        while (i3 < M2) {
            int j = 0;
            while (j < M2) {
                P12[i3][j] = 0.0;
                ++j;
            }
            ++i3;
        }
        this.build_Matrix_Rq1q2q3q4(intervals, 2.0 * this.divWeight, 2, 0, 1, 1, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, 2.0 * this.divWeight, 1, 1, 0, 2, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, -2.0 * this.curlWeight, 0, 2, 1, 1, P12, bIsReverse);
        this.build_Matrix_Rq1q2q3q4(intervals, -2.0 * this.curlWeight, 1, 1, 2, 0, P12, bIsReverse);
    }

    private void build_Matrix_Rq1q2(int intervals, double weight, int q1, int q2, double[][] R, boolean bIsReverse) {
        this.build_Matrix_Rq1q2q3q4(intervals, weight, q1, q2, q1, q2, R, bIsReverse);
    }

    private void build_Matrix_Rq1q2q3q4(int intervals, double weight, int q1, int q2, int q3, int q4, double[][] R, boolean bIsReverse) {
        double[][] etaq1q3 = new double[16][16];
        int Ydim = this.targetModel.getCurrentHeight();
        int Xdim = this.targetModel.getCurrentWidth();
        if (bIsReverse) {
            Ydim = this.sourceModel.getCurrentHeight();
            Xdim = this.sourceModel.getCurrentWidth();
        }
        this.build_Matrix_R_geteta(etaq1q3, q1, q3, Xdim, intervals);
        double[][] etaq2q4 = null;
        if (q2 != q1 || q4 != q3 || Ydim != Xdim) {
            etaq2q4 = new double[16][16];
            this.build_Matrix_R_geteta(etaq2q4, q2, q4, Ydim, intervals);
        } else {
            etaq2q4 = etaq1q3;
        }
        int M = intervals + 1;
        int Mp = intervals + 3;
        int l = -1;
        while (l <= M) {
            int k = -1;
            while (k <= M) {
                int n = -1;
                while (n <= M) {
                    int m = -1;
                    while (m <= M) {
                        int[] ip = new int[2];
                        int[] jp = new int[2];
                        boolean valid_i = this.build_Matrix_R_getetaIndex(l, n, intervals, ip);
                        boolean valid_j = this.build_Matrix_R_getetaIndex(k, m, intervals, jp);
                        if (valid_i && valid_j) {
                            int mn = (n + 1) * Mp + (m + 1);
                            int kl = (l + 1) * Mp + (k + 1);
                            double[] dArray = R[kl];
                            int n2 = mn;
                            dArray[n2] = dArray[n2] + weight * etaq1q3[jp[0]][jp[1]] * etaq2q4[ip[0]][ip[1]];
                        }
                        ++m;
                    }
                    ++n;
                }
                ++k;
            }
            ++l;
        }
    }

    private void build_Matrix_R_geteta(double[][] etaq1q2, int q1, int q2, int dim, int intervals) {
        boolean[][] done = new boolean[16][16];
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                etaq1q2[i][j] = 0.0;
                done[i][j] = false;
                ++j;
            }
            ++i;
        }
        int M = intervals + 1;
        double h = (double)dim / (double)intervals;
        int ki1 = -1;
        while (ki1 <= M) {
            int ki2 = -1;
            while (ki2 <= M) {
                int[] ip = new int[2];
                boolean valid_i = this.build_Matrix_R_getetaIndex(ki1, ki2, intervals, ip);
                if (valid_i && !done[ip[0]][ip[1]]) {
                    etaq1q2[ip[0]][ip[1]] = this.build_Matrix_R_computeIntegral_aa(0.0, dim, ki1, ki2, h, q1, q2);
                    done[ip[0]][ip[1]] = true;
                }
                ++ki2;
            }
            ++ki1;
        }
    }

    private boolean build_Matrix_R_getetaIndex(int ki1, int ki2, int intervals, int[] ip) {
        ip[0] = 0;
        ip[1] = 0;
        int kir = Math.min(intervals, Math.min(ki1, ki2) + 2);
        int kil = Math.max(0, Math.max(ki1, ki2) - 2);
        if (kil >= kir) {
            return false;
        }
        int two_i = 1;
        int i = 0;
        while (i <= 3) {
            double ki = (double)(ki1 + i) - 1.5;
            if ((double)kil <= ki && ki <= (double)kir) {
                ip[0] = ip[0] + two_i;
            }
            if ((double)kil <= (ki = (double)(ki2 + i) - 1.5) && ki <= (double)kir) {
                ip[1] = ip[1] + two_i;
            }
            ++i;
            two_i *= 2;
        }
        ip[0] = ip[0] - 1;
        ip[1] = ip[1] - 1;
        return true;
    }

    private double build_Matrix_R_computeIntegral_aa(double x0, double xF, double s1, double s2, double h, int q1, int q2) {
        double[][] C = new double[3][3];
        int[][] d = new int[3][3];
        double[][] s = new double[3][3];
        C[0][0] = 1.0;
        C[0][1] = 0.0;
        C[0][2] = 0.0;
        C[1][0] = 1.0;
        C[1][1] = -1.0;
        C[1][2] = 0.0;
        C[2][0] = 1.0;
        C[2][1] = -2.0;
        C[2][2] = 1.0;
        d[0][0] = 3;
        d[0][1] = 0;
        d[0][2] = 0;
        d[1][0] = 2;
        d[1][1] = 2;
        d[1][2] = 0;
        d[2][0] = 1;
        d[2][1] = 1;
        d[2][2] = 1;
        s[0][0] = 0.0;
        s[0][1] = 0.0;
        s[0][2] = 0.0;
        s[1][0] = -0.5;
        s[1][1] = 0.5;
        s[1][2] = 0.0;
        s[2][0] = 1.0;
        s[2][1] = 0.0;
        s[2][2] = -1.0;
        double integral = 0.0;
        int k = 0;
        while (k < 3) {
            double ck = C[q1][k];
            if (ck != 0.0) {
                int l = 0;
                while (l < 3) {
                    double cl = C[q2][l];
                    if (cl != 0.0) {
                        integral += ck * cl * this.build_matrix_R_computeIntegral_BB(x0, xF, s1 + s[q1][k], s2 + s[q2][l], h, d[q1][k], d[q2][l]);
                    }
                    ++l;
                }
            }
            ++k;
        }
        return integral;
    }

    private double build_matrix_R_computeIntegral_BB(double x0, double xF, double s1, double s2, double h, int n1, int n2) {
        double xFp = xF / h;
        double x0p = x0 / h;
        double[] c1 = new double[n1 + 2];
        double fact_n1 = 1.0;
        int k = 2;
        while (k <= n1) {
            fact_n1 *= (double)k;
            ++k;
        }
        double sign = 1.0;
        int k2 = 0;
        while (k2 <= n1 + 1) {
            c1[k2] = sign * MathTools.nChooseK(n1 + 1, k2) / fact_n1;
            ++k2;
            sign *= -1.0;
        }
        double[] c2 = new double[n2 + 2];
        double fact_n2 = 1.0;
        int k3 = 2;
        while (k3 <= n2) {
            fact_n2 *= (double)k3;
            ++k3;
        }
        sign = 1.0;
        k3 = 0;
        while (k3 <= n2 + 1) {
            c2[k3] = sign * MathTools.nChooseK(n2 + 1, k3) / fact_n2;
            ++k3;
            sign *= -1.0;
        }
        double n1_2 = (double)(n1 + 1) / 2.0;
        double n2_2 = (double)(n2 + 1) / 2.0;
        double integral = 0.0;
        int k4 = 0;
        while (k4 <= n1 + 1) {
            int l = 0;
            while (l <= n2 + 1) {
                integral += c1[k4] * c2[l] * this.build_matrix_R_computeIntegral_xx(x0p, xFp, s1 + (double)k4 - n1_2, s2 + (double)l - n2_2, n1, n2);
                ++l;
            }
            ++k4;
        }
        return integral * h;
    }

    private double build_matrix_R_computeIntegral_xx(double x0, double xF, double s1, double s2, int q1, int q2) {
        double s2p = s2 - s1;
        double xFp = xF - s1;
        double x0p = x0 - s1;
        if (xFp < 0.0) {
            return 0.0;
        }
        if ((x0p = Math.max(x0p, Math.max(s2p, 0.0))) > xFp) {
            return 0.0;
        }
        double IxFp = 0.0;
        double Ix0p = 0.0;
        int k = 0;
        while (k <= q2) {
            double aux = MathTools.nChooseK(q2, k) / (double)(q1 + k + 1) * Math.pow(-s2p, q2 - k);
            IxFp += Math.pow(xFp, q1 + k + 1) * aux;
            Ix0p += Math.pow(x0p, q1 + k + 1) * aux;
            ++k;
        }
        return IxFp - Ix0p;
    }

    private void computeInitialResidues(double[] dx, double[] dy, boolean bIsReverse) {
        double auxFactorWidth = this.targetModel.getFactorWidth();
        double auxFactorHeight = this.targetModel.getFactorHeight();
        List<ROI2DPoint> auxSourcePh = this.sourceLandmarks;
        List<ROI2DPoint> auxTargetPh = this.targetLandmarks;
        if (bIsReverse) {
            auxFactorWidth = this.sourceModel.getFactorWidth();
            auxFactorHeight = this.sourceModel.getFactorHeight();
            auxSourcePh = this.targetLandmarks;
            auxTargetPh = this.sourceLandmarks;
        }
        ArrayList<Point2D> sourceVector = new ArrayList<Point2D>();
        if (auxSourcePh != null) {
            for (ROI2DPoint roi : auxSourcePh) {
                sourceVector.add(roi.getPoint());
            }
        }
        ArrayList<Point2D> targetVector = new ArrayList<Point2D>();
        if (auxTargetPh != null) {
            for (ROI2DPoint roi : auxTargetPh) {
                targetVector.add(roi.getPoint());
            }
        }
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.size();
        }
        int k = 0;
        while (k < K) {
            Point2D sourcePoint = (Point2D)sourceVector.get(k);
            Point2D targetPoint = (Point2D)targetVector.get(k);
            dx[k] = auxFactorWidth * (sourcePoint.getX() - targetPoint.getX());
            dy[k] = auxFactorHeight * (sourcePoint.getY() - targetPoint.getY());
            ++k;
        }
    }

    private double[][] computeAffineMatrix(boolean bIsReverse) {
        boolean adjust_size = false;
        double[][] D = new double[3][3];
        double[][] H = new double[3][3];
        double[][] U = new double[3][3];
        double[][] V = new double[3][3];
        double[][] X = new double[2][3];
        double[] W = new double[3];
        List<ROI2DPoint> auxSourcePh = this.sourceLandmarks;
        List<ROI2DPoint> auxTargetPh = this.targetLandmarks;
        BSplineModel auxSource = this.sourceModel;
        BSplineModel auxTarget = this.targetModel;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        if (bIsReverse) {
            auxSourcePh = this.targetLandmarks;
            auxTargetPh = this.sourceLandmarks;
            auxSource = this.targetModel;
            auxTarget = this.sourceModel;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
        }
        ArrayList<Point2D> sourceVector = new ArrayList<Point2D>();
        if (auxSourcePh != null) {
            for (ROI2DPoint roi : auxSourcePh) {
                sourceVector.add(roi.getPoint());
            }
        }
        ArrayList<Point2D> targetVector = new ArrayList<Point2D>();
        if (auxTargetPh != null) {
            for (ROI2DPoint roi : auxTargetPh) {
                targetVector.add(roi.getPoint());
            }
        }
        int removeLastPoint = 0;
        int n = targetVector.size();
        switch (n) {
            case 0: {
                int j;
                int i = 0;
                while (i < 2) {
                    j = 0;
                    while (j < 3) {
                        X[i][j] = 0.0;
                        ++j;
                    }
                    ++i;
                }
                if (adjust_size) {
                    X[0][0] = (double)auxSource.getCurrentWidth() / (double)auxTarget.getCurrentWidth();
                    X[1][1] = (double)auxSource.getCurrentHeight() / (double)auxTarget.getCurrentHeight();
                    break;
                }
                X[1][1] = 1.0;
                X[0][0] = 1.0;
                X[0][2] = ((double)auxSource.getCurrentWidth() - (double)auxTarget.getCurrentWidth()) / 2.0;
                X[1][2] = ((double)auxSource.getCurrentHeight() - (double)auxTarget.getCurrentHeight()) / 2.0;
                break;
            }
            case 1: {
                int j;
                int i = 0;
                while (i < 2) {
                    j = 0;
                    while (j < 2) {
                        X[i][j] = i == j ? 1.0f : 0.0f;
                        ++j;
                    }
                    ++i;
                }
                X[0][2] = auxFactorWidth * (((Point2D)sourceVector.get(0)).getX() - ((Point2D)targetVector.get(0)).getX());
                X[1][2] = auxFactorHeight * (((Point2D)sourceVector.get(0)).getY() - ((Point2D)targetVector.get(0)).getY());
                break;
            }
            case 2: {
                double x0 = auxFactorWidth * ((Point2D)sourceVector.get(0)).getX();
                double y0 = auxFactorHeight * ((Point2D)sourceVector.get(0)).getY();
                double x1 = auxFactorWidth * ((Point2D)sourceVector.get(1)).getX();
                double y1 = auxFactorHeight * ((Point2D)sourceVector.get(1)).getY();
                double u0 = auxFactorWidth * ((Point2D)targetVector.get(0)).getX();
                double v0 = auxFactorHeight * ((Point2D)targetVector.get(0)).getY();
                double u1 = auxFactorWidth * ((Point2D)targetVector.get(1)).getX();
                double v1 = auxFactorHeight * ((Point2D)targetVector.get(1)).getY();
                sourceVector.add(new Point2D.Double((int)(x1 + y0 - y1), (int)(x1 + y1 - x0)));
                targetVector.add(new Point2D.Double((int)(u1 + v0 - v1), (int)(u1 + v1 - u0)));
                removeLastPoint = 1;
                n = 3;
            }
            default: {
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        H[i][j] = 0.0;
                        ++j;
                    }
                    ++i;
                }
                int k = 0;
                while (k < n) {
                    Point2D sourcePoint = (Point2D)sourceVector.get(k);
                    Point2D targetPoint = (Point2D)targetVector.get(k);
                    double sx = auxFactorWidth * sourcePoint.getX();
                    double sy = auxFactorHeight * sourcePoint.getY();
                    double tx = auxFactorWidth * targetPoint.getX();
                    double ty = auxFactorHeight * targetPoint.getY();
                    double[] dArray = H[0];
                    dArray[0] = dArray[0] + tx * sx;
                    double[] dArray2 = H[0];
                    dArray2[1] = dArray2[1] + tx * sy;
                    double[] dArray3 = H[0];
                    dArray3[2] = dArray3[2] + tx;
                    double[] dArray4 = H[1];
                    dArray4[0] = dArray4[0] + ty * sx;
                    double[] dArray5 = H[1];
                    dArray5[1] = dArray5[1] + ty * sy;
                    double[] dArray6 = H[1];
                    dArray6[2] = dArray6[2] + ty;
                    double[] dArray7 = H[2];
                    dArray7[0] = dArray7[0] + sx;
                    double[] dArray8 = H[2];
                    dArray8[1] = dArray8[1] + sy;
                    double[] dArray9 = H[2];
                    dArray9[2] = dArray9[2] + 1.0;
                    double[] dArray10 = D[0];
                    dArray10[0] = dArray10[0] + sx * sx;
                    double[] dArray11 = D[0];
                    dArray11[1] = dArray11[1] + sx * sy;
                    double[] dArray12 = D[0];
                    dArray12[2] = dArray12[2] + sx;
                    double[] dArray13 = D[1];
                    dArray13[0] = dArray13[0] + sy * sx;
                    double[] dArray14 = D[1];
                    dArray14[1] = dArray14[1] + sy * sy;
                    double[] dArray15 = D[1];
                    dArray15[2] = dArray15[2] + sy;
                    double[] dArray16 = D[2];
                    dArray16[0] = dArray16[0] + sx;
                    double[] dArray17 = D[2];
                    dArray17[1] = dArray17[1] + sy;
                    double[] dArray18 = D[2];
                    dArray18[2] = dArray18[2] + 1.0;
                    ++k;
                }
                MathTools.singularValueDecomposition(H, W, V);
                if (Math.abs(W[0]) < FLT_EPSILON || Math.abs(W[1]) < FLT_EPSILON || Math.abs(W[2]) < FLT_EPSILON) {
                    return this.computeRotationMatrix(bIsReverse);
                }
                i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        double[] dArray = V[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] / W[j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        U[i][j] = 0.0;
                        int k2 = 0;
                        while (k2 < 3) {
                            double[] dArray = U[i];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + D[i][k2] * V[k2][j];
                            ++k2;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 3) {
                        X[i][j] = 0.0;
                        int k3 = 0;
                        while (k3 < 3) {
                            double[] dArray = X[i];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + U[i][k3] * H[j][k3];
                            ++k3;
                        }
                        ++j;
                    }
                    ++i;
                }
                break block0;
            }
        }
        if (removeLastPoint > 0) {
            int i = 1;
            while (i <= removeLastPoint) {
                sourceVector.remove(n - i);
                targetVector.remove(n - i);
                ++i;
            }
        }
        double centerX = auxSource.getCurrentWidth();
        double centerY = auxSource.getCurrentHeight();
        AffineTransform matrix = new AffineTransform(X[0][0], X[1][0], X[0][1], X[1][1], X[0][2], X[1][2]);
        this.regularizeMatrix(matrix, centerX, centerY);
        X[0][0] = matrix.getScaleX();
        X[0][1] = matrix.getShearX();
        X[1][0] = matrix.getShearY();
        X[1][1] = matrix.getScaleY();
        X[0][2] = matrix.getTranslateX();
        X[1][2] = matrix.getTranslateY();
        return X;
    }

    private double[][] computeRotationMatrix(boolean bIsReverse) {
        double[][] X = new double[2][3];
        double[][] H = new double[2][2];
        double[][] V = new double[2][2];
        double[] W = new double[2];
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        List<ROI2DPoint> auxSourcePh = this.sourceLandmarks;
        List<ROI2DPoint> auxTargetPh = this.targetLandmarks;
        if (bIsReverse) {
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            auxSourcePh = this.targetLandmarks;
            auxTargetPh = this.sourceLandmarks;
        }
        ArrayList<Point2D> sourceVector = new ArrayList<Point2D>();
        if (auxSourcePh != null) {
            for (ROI2DPoint roi : auxSourcePh) {
                sourceVector.add(roi.getPoint());
            }
        }
        ArrayList<Point2D> targetVector = new ArrayList<Point2D>();
        if (auxTargetPh != null) {
            for (ROI2DPoint roi : auxTargetPh) {
                targetVector.add(roi.getPoint());
            }
        }
        int n = targetVector.size();
        switch (n) {
            case 0: {
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 3) {
                        X[i][j] = i == j ? 1.0f : 0.0f;
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 2) {
                        X[i][j] = i == j ? 1.0f : 0.0f;
                        ++j;
                    }
                    ++i;
                }
                X[0][2] = auxFactorWidth * (((Point2D)sourceVector.get(0)).getX() - ((Point2D)targetVector.get(0)).getX());
                X[1][2] = auxFactorHeight * (((Point2D)sourceVector.get(0)).getY() - ((Point2D)targetVector.get(0)).getY());
                break;
            }
            default: {
                double xTargetAverage = 0.0;
                double yTargetAverage = 0.0;
                int i = 0;
                while (i < n) {
                    Point2D p = (Point2D)targetVector.get(i);
                    xTargetAverage += auxFactorWidth * p.getX();
                    yTargetAverage += auxFactorHeight * p.getY();
                    ++i;
                }
                xTargetAverage /= (double)n;
                yTargetAverage /= (double)n;
                double[] xCenteredTarget = new double[n];
                double[] yCenteredTarget = new double[n];
                int i2 = 0;
                while (i2 < n) {
                    Point2D p = (Point2D)targetVector.get(i2);
                    xCenteredTarget[i2] = auxFactorWidth * p.getX() - xTargetAverage;
                    yCenteredTarget[i2] = auxFactorHeight * p.getY() - yTargetAverage;
                    ++i2;
                }
                double xSourceAverage = 0.0;
                double ySourceAverage = 0.0;
                int i3 = 0;
                while (i3 < n) {
                    Point2D p = (Point2D)sourceVector.get(i3);
                    xSourceAverage += auxFactorWidth * p.getX();
                    ySourceAverage += auxFactorHeight * p.getY();
                    ++i3;
                }
                xSourceAverage /= (double)n;
                ySourceAverage /= (double)n;
                double[] xCenteredSource = new double[n];
                double[] yCenteredSource = new double[n];
                int i4 = 0;
                while (i4 < n) {
                    Point2D p = (Point2D)sourceVector.get(i4);
                    xCenteredSource[i4] = auxFactorWidth * p.getX() - xSourceAverage;
                    yCenteredSource[i4] = auxFactorHeight * p.getY() - ySourceAverage;
                    ++i4;
                }
                i4 = 0;
                while (i4 < 2) {
                    int j = 0;
                    while (j < 2) {
                        H[i4][j] = 0.0;
                        ++j;
                    }
                    ++i4;
                }
                int k = 0;
                while (k < n) {
                    double[] dArray = H[0];
                    dArray[0] = dArray[0] + xCenteredTarget[k] * xCenteredSource[k];
                    double[] dArray2 = H[0];
                    dArray2[1] = dArray2[1] + xCenteredTarget[k] * yCenteredSource[k];
                    double[] dArray3 = H[1];
                    dArray3[0] = dArray3[0] + yCenteredTarget[k] * xCenteredSource[k];
                    double[] dArray4 = H[1];
                    dArray4[1] = dArray4[1] + yCenteredTarget[k] * yCenteredSource[k];
                    ++k;
                }
                MathTools.singularValueDecomposition(H, W, V);
                if ((H[0][0] * H[1][1] - H[0][1] * H[1][0]) * (V[0][0] * V[1][1] - V[0][1] * V[1][0]) < 0.0) {
                    if (W[0] < W[1]) {
                        double[] dArray = V[0];
                        dArray[0] = dArray[0] * -1.0;
                        double[] dArray5 = V[1];
                        dArray5[0] = dArray5[0] * -1.0;
                    } else {
                        double[] dArray = V[0];
                        dArray[1] = dArray[1] * -1.0;
                        double[] dArray6 = V[1];
                        dArray6[1] = dArray6[1] * -1.0;
                    }
                }
                i4 = 0;
                while (i4 < 2) {
                    int j = 0;
                    while (j < 2) {
                        X[i4][j] = 0.0;
                        int k2 = 0;
                        while (k2 < 2) {
                            double[] dArray = X[i4];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + V[i4][k2] * H[j][k2];
                            ++k2;
                        }
                        ++j;
                    }
                    ++i4;
                }
                X[0][2] = xSourceAverage - X[0][0] * xTargetAverage - X[0][1] * yTargetAverage;
                X[1][2] = ySourceAverage - X[1][0] * xTargetAverage - X[1][1] * yTargetAverage;
            }
        }
        return X;
    }

    public void regularizeMatrix(AffineTransform a, double centerX, double centerY) {
        a.translate(centerX, centerY);
        double a11 = a.getScaleX();
        double a21 = a.getShearY();
        double scaleX = Math.sqrt(a11 * a11 + a21 * a21);
        double rotang = Math.atan2(a21 / scaleX, a11 / scaleX);
        double a12 = a.getShearX();
        double a22 = a.getScaleY();
        double shearX = Math.cos(-rotang) * a12 - Math.sin(-rotang) * a22;
        double scaleY = Math.sin(-rotang) * a12 + Math.cos(-rotang) * a22;
        double transX = Math.cos(-rotang) * a.getTranslateX() - Math.sin(-rotang) * a.getTranslateY();
        double transY = Math.sin(-rotang) * a.getTranslateX() + Math.cos(-rotang) * a.getTranslateY();
        double new_shearX = shearX * (1.0 - this.tweakShear);
        double avgScale = (scaleX + scaleY) / 2.0;
        double aspectRatio = scaleX / scaleY;
        double regAvgScale = avgScale * (1.0 - this.tweakScale) + 1.0 * this.tweakScale;
        double regAspectRatio = aspectRatio * (1.0 - this.tweakIso) + 1.0 * this.tweakIso;
        double new_scaleY = 2.0 * regAvgScale / (regAspectRatio + 1.0);
        double new_scaleX = regAspectRatio * new_scaleY;
        AffineTransform b = Transformation.makeAffineMatrix(new_scaleX, new_scaleY, new_shearX, 0.0, rotang, transX, transY);
        b.translate(-centerX, -centerY);
        a.setTransform(b);
    }

    public static AffineTransform makeAffineMatrix(double scalex, double scaley, double shearx, double sheary, double rotang, double transx, double transy) {
        double m00 = Math.cos(rotang) * scalex - Math.sin(rotang) * sheary;
        double m01 = Math.cos(rotang) * shearx - Math.sin(rotang) * scaley;
        double m02 = Math.cos(rotang) * transx - Math.sin(rotang) * transy;
        double m10 = Math.sin(rotang) * scalex + Math.cos(rotang) * sheary;
        double m11 = Math.sin(rotang) * shearx + Math.cos(rotang) * scaley;
        double m12 = Math.sin(rotang) * transx + Math.cos(rotang) * transy;
        return new AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    private void computeTotalWorkload() {
        int state = this.minScaleDeformation == this.maxScaleDeformation ? 1 : 0;
        int s = this.minScaleDeformation;
        int currentDepth = this.targetModel.getCurrentDepth();
        int workload = 0;
        while (state != -1) {
            if ((state == 0 || state == 1) && this.imageWeight != 0.0) {
                workload += 300 * (currentDepth + 1);
            }
            switch (state) {
                case 0: {
                    if (s < this.maxScaleDeformation) {
                        ++s;
                        if (currentDepth > this.minScaleImage) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.minScaleImage) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.maxScaleDeformation && currentDepth == this.minScaleImage ? 2 : (s == this.maxScaleDeformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    --currentDepth;
                }
            }
        }
        ProgressBar.resetProgressBar();
        ProgressBar.addWorkload(workload);
    }

    private boolean computeCoefficientsScale(int intervals, double[] dx, double[] dy, double[][] cx, double[][] cy, boolean bIsReverse) {
        List<ROI2DPoint> auxTargetPh = bIsReverse ? this.sourceLandmarks : this.targetLandmarks;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.size();
        }
        boolean underconstrained = false;
        if (K > 0) {
            double[][] B = new double[K][(intervals + 3) * (intervals + 3)];
            this.buildMatrixB(intervals, K, B, bIsReverse);
            int Nunk = (intervals + 3) * (intervals + 3);
            double[][] iB = new double[Nunk][K];
            underconstrained = MathTools.invertMatrixSVD(K, Nunk, B, iB);
            int ij = 0;
            int i = 0;
            while (i < intervals + 3) {
                int j = 0;
                while (j < intervals + 3) {
                    cy[i][j] = 0.0;
                    cx[i][j] = 0.0;
                    int k = 0;
                    while (k < K) {
                        double[] dArray = cx[i];
                        int n = j;
                        dArray[n] = dArray[n] + iB[ij][k] * dx[k];
                        double[] dArray2 = cy[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + iB[ij][k] * dy[k];
                        ++k;
                    }
                    ++ij;
                    ++j;
                }
                ++i;
            }
        }
        return underconstrained;
    }

    private void buildMatrixB(int intervals, int K, double[][] B, boolean bIsReverse) {
        List<ROI2DPoint> auxTargetPh = this.targetLandmarks;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        if (bIsReverse) {
            auxTargetPh = this.sourceLandmarks;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
        }
        ArrayList<Point2D> targetVector = new ArrayList<Point2D>();
        if (auxTargetPh != null) {
            for (ROI2DPoint roi : auxTargetPh) {
                targetVector.add(roi.getPoint());
            }
        }
        int k = 0;
        while (k < K) {
            Point2D targetPoint = (Point2D)targetVector.get(k);
            double x = auxFactorWidth * targetPoint.getX();
            double y = auxFactorHeight * targetPoint.getY();
            double[] bx = this.xWeight(x, intervals, true, bIsReverse);
            double[] by = this.yWeight(y, intervals, true, bIsReverse);
            int i = 0;
            while (i < intervals + 3) {
                int j = 0;
                while (j < intervals + 3) {
                    B[k][(intervals + 3) * i + j] = by[i] * bx[j];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private double[] xWeight(double x, int xIntervals, boolean extended, boolean bIsReverse) {
        int auxTargetCurrentWidth = bIsReverse ? this.sourceCurrentWidth : this.targetCurrentWidth;
        int length = xIntervals + 1;
        int j0 = 0;
        int jF = xIntervals;
        if (extended) {
            length += 2;
            --j0;
            ++jF;
        }
        double[] b = new double[length];
        double interX = (double)xIntervals / (double)(auxTargetCurrentWidth - 1);
        int j = j0;
        while (j <= jF) {
            b[j - j0] = MathTools.Bspline03(x * interX - (double)j);
            ++j;
        }
        return b;
    }

    private double[] yWeight(double y, int yIntervals, boolean extended, boolean bIsReverse) {
        int auxTargetCurrentHeight = bIsReverse ? this.sourceCurrentHeight : this.targetCurrentHeight;
        int length = yIntervals + 1;
        int i0 = 0;
        int iF = yIntervals;
        if (extended) {
            length += 2;
            --i0;
            ++iF;
        }
        double[] b = new double[length];
        double interY = (double)yIntervals / (double)(auxTargetCurrentHeight - 1);
        int i = i0;
        while (i <= iF) {
            b[i - i0] = MathTools.Bspline03(y * interY - (double)i);
            ++i;
        }
        return b;
    }

    private boolean computeCoefficientsScaleWithRegularization(int intervals, double[] dx, double[] dy, double[][] cx, double[][] cy, boolean bIsReverse) {
        double[][] P11 = this.P11_TargetToSource;
        double[][] P12 = this.P12_TargetToSource;
        double[][] P22 = this.P22_TargetToSource;
        List<ROI2DPoint> auxTargetPh = this.targetLandmarks;
        if (bIsReverse) {
            auxTargetPh = this.sourceLandmarks;
            P11 = this.P11_SourceToTarget;
            P12 = this.P12_SourceToTarget;
            P22 = this.P22_SourceToTarget;
        }
        boolean underconstrained = true;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.size();
        }
        if (K > 0) {
            double aux;
            int l;
            int M = intervals + 3;
            int M2 = M * M;
            double[][] A = new double[2 * M2][2 * M2];
            double[] b = new double[2 * M2];
            int i = 0;
            while (i < 2 * M2) {
                b[i] = 0.0;
                int j = 0;
                while (j < 2 * M2) {
                    A[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
            double[][] B = new double[K][M2];
            this.buildMatrixB(intervals, K, B, bIsReverse);
            int i2 = 0;
            while (i2 < M2) {
                int j = i2;
                while (j < M2) {
                    double bitbj = 0.0;
                    l = 0;
                    while (l < K) {
                        bitbj += B[l][i2] * B[l][j];
                        ++l;
                    }
                    double d = bitbj *= 2.0;
                    A[j][i2] = d;
                    A[i2][j] = d;
                    A[M2 + j][M2 + i2] = d;
                    A[M2 + i2][M2 + j] = d;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < M2) {
                double bitdx = 0.0;
                double bitdy = 0.0;
                int l2 = 0;
                while (l2 < K) {
                    bitdx += B[l2][i2] * dx[l2];
                    bitdy += B[l2][i2] * dy[l2];
                    ++l2;
                }
                b[i2] = bitdx *= 2.0;
                b[M2 + i2] = bitdy *= 2.0;
                ++i2;
            }
            i2 = 0;
            while (i2 < M2) {
                int j = 0;
                while (j < M2) {
                    aux = P11[i2][j];
                    double[] dArray = A[i2];
                    int n = j;
                    dArray[n] = dArray[n] + aux;
                    double[] dArray2 = A[j];
                    int n2 = i2;
                    dArray2[n2] = dArray2[n2] + aux;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < M2) {
                int j = 0;
                while (j < M2) {
                    aux = P22[i2][j];
                    double[] dArray = A[M2 + i2];
                    int n = M2 + j;
                    dArray[n] = dArray[n] + aux;
                    double[] dArray3 = A[M2 + j];
                    int n3 = M2 + i2;
                    dArray3[n3] = dArray3[n3] + aux;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < M2) {
                int j = 0;
                while (j < M2) {
                    A[i2][M2 + j] = P12[i2][j];
                    A[M2 + i2][j] = P12[j][i2];
                    ++j;
                }
                ++i2;
            }
            double[][] iA = new double[2 * M2][2 * M2];
            underconstrained = MathTools.invertMatrixSVD(2 * M2, 2 * M2, A, iA);
            int ij = 0;
            int i3 = 0;
            while (i3 < intervals + 3) {
                int j = 0;
                while (j < intervals + 3) {
                    cy[i3][j] = 0.0;
                    cx[i3][j] = 0.0;
                    l = 0;
                    while (l < 2 * M2) {
                        double[] dArray = cx[i3];
                        int n = j;
                        dArray[n] = dArray[n] + iA[ij][l] * b[l];
                        double[] dArray4 = cy[i3];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + iA[M2 + ij][l] * b[l];
                        ++l;
                    }
                    ++ij;
                    ++j;
                }
                ++i3;
            }
        }
        return underconstrained;
    }

    private double optimizeCoeffs(int intervals, double thChangef, double[][] cxTargetToSource, double[][] cyTargetToSource, double[][] cxSourceToTarget, double[][] cySourceToTarget) {
        int j;
        if (this.plugin != null && this.plugin.isPluginInterrumped()) {
            return 0.0;
        }
        if (this.sourceModel.isSubOutput()) {
            System.out.println(" -----\n Intervals = " + intervals + "x" + intervals);
            System.out.println(" Source Image Size = " + this.sourceCurrentWidth + "x" + this.sourceCurrentHeight);
        }
        double TINY = FLT_EPSILON;
        double EPS = 3.0E-8f;
        double FIRSTLAMBDA = 1.0;
        int MAXITER_OPTIMCOEFF = 300;
        int CUMULATIVE_SIZE = 5;
        int int3 = intervals + 3;
        int halfM = 2 * int3 * int3;
        int quarterM = halfM / 2;
        int threeQuarterM = quarterM * 3;
        int M = halfM * 2;
        double[] x = new double[M];
        double[] rescuedx = new double[M];
        double[] diffx = new double[M];
        double[] rescuedgrad = new double[M];
        double[] grad = new double[M];
        double[] diffgrad = new double[M];
        double[] Hdx = new double[M];
        double[] rescuedhess = new double[M * M];
        double[] hess = new double[M * M];
        double[] proposedHess = new double[M * M];
        boolean[] optimize = new boolean[M];
        int iter = 1;
        double improvementx = Math.sqrt(TINY);
        double lambda = 1.0;
        CumulativeQueue lastBest = new CumulativeQueue(5);
        int i = 0;
        while (i < M) {
            optimize[i] = true;
            ++i;
        }
        i = 0;
        int p = 0;
        while (i < intervals + 3) {
            j = 0;
            while (j < intervals + 3) {
                x[p] = cxTargetToSource[i][j];
                x[quarterM + p] = cxSourceToTarget[i][j];
                x[halfM + p] = cyTargetToSource[i][j];
                x[threeQuarterM + p] = cySourceToTarget[i][j];
                ++j;
                ++p;
            }
            ++i;
        }
        this.swxTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, 0);
        this.swyTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, halfM);
        this.swxTargetToSource.precomputedPrepareForInterpolation(this.targetModel.getCurrentHeight(), this.targetModel.getCurrentWidth(), intervals);
        this.swyTargetToSource.precomputedPrepareForInterpolation(this.targetModel.getCurrentHeight(), this.targetModel.getCurrentWidth(), intervals);
        this.swxSourceToTarget = new BSplineModel(x, intervals + 3, intervals + 3, quarterM);
        this.swySourceToTarget = new BSplineModel(x, intervals + 3, intervals + 3, threeQuarterM);
        this.swxSourceToTarget.precomputedPrepareForInterpolation(this.sourceModel.getCurrentHeight(), this.sourceModel.getCurrentWidth(), intervals);
        this.swySourceToTarget.precomputedPrepareForInterpolation(this.sourceModel.getCurrentHeight(), this.sourceModel.getCurrentWidth(), intervals);
        double f = this.energyFunction(x, intervals, grad, false, false);
        if (this.showMarquardtOptim) {
            System.out.println("f(1)=" + f);
        }
        i = 0;
        p = 0;
        while (i < M) {
            j = 0;
            while (j < M) {
                hess[p] = i == j ? 1.0 : 0.0;
                ++j;
                ++p;
            }
            ++i;
        }
        double rescuedf = f;
        i = 0;
        p = 0;
        while (i < M) {
            rescuedx[i] = x[i];
            rescuedgrad[i] = grad[i];
            j = 0;
            while (j < M) {
                rescuedhess[p] = hess[p];
                ++j;
                ++p;
            }
            ++i;
        }
        int maxiter = 300 * (this.sourceModel.getCurrentDepth() + 1);
        ProgressBar.stepProgressBar();
        int last_successful_iter = 0;
        boolean stop = this.plugin != null && this.plugin.isPluginInterrumped();
        while (iter < maxiter && !stop) {
            this.Marquardt_it(x, optimize, grad, hess, lambda);
            improvementx = 0.0;
            double max_normx = 0.0;
            i = 0;
            while (i < M) {
                diffx[i] = x[i] - rescuedx[i];
                double distx = Math.abs(diffx[i]);
                improvementx += distx * distx;
                double aux = Math.abs(rescuedx[i]) < Math.abs(x[i]) ? x[i] : rescuedx[i];
                max_normx += aux * aux;
                ++i;
            }
            if (TINY < max_normx) {
                improvementx /= max_normx;
            }
            if ((improvementx = Math.sqrt(Math.sqrt(improvementx))) < Math.sqrt(TINY)) break;
            f = this.energyFunction(x, intervals, grad, false, false);
            ++iter;
            if (this.showMarquardtOptim) {
                System.out.println("f(" + iter + ")=" + f + " lambda=" + lambda);
            }
            ProgressBar.stepProgressBar();
            if (rescuedf > f) {
                this.finalDirectConsistencyError = this.partialDirectConsitencyError;
                this.finalDirectSimilarityError = this.partialDirectSimilarityError;
                this.finalDirectRegularizationError = this.partialDirectRegularizationError;
                this.finalDirectLandmarkError = this.partialDirectLandmarkError;
                this.finalInverseConsistencyError = this.partialInverseConsitencyError;
                this.finalInverseSimilarityError = this.partialInverseSimilarityError;
                this.finalInverseRegularizationError = this.partialInverseRegularizationError;
                this.finalInverseLandmarkError = this.partialInverseLandmarkError;
                lastBest.push_back(rescuedf - f);
                if (lastBest.currentSize() == 5 && lastBest.getSum() / f < thChangef) break;
                if (this.showMarquardtOptim) {
                    System.out.println("  Accepted");
                }
                if (last_successful_iter++ % 10 == 0 && this.outputLevel > -1) {
                    this.updateOutputs(x, intervals);
                }
                i = 0;
                while (i < M) {
                    diffgrad[i] = grad[i] - rescuedgrad[i];
                    ++i;
                }
                i = 0;
                p = 0;
                while (i < M) {
                    Hdx[i] = 0.0;
                    j = 0;
                    while (j < M) {
                        int n = i;
                        Hdx[n] = Hdx[n] + hess[p] * diffx[j];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                double sumdiffx = 0.0;
                double sumdiffg = 0.0;
                double dxHdx = 0.0;
                double dgdx = 0.0;
                boolean skip_update = true;
                i = 0;
                while (i < M) {
                    dgdx += diffgrad[i] * diffx[i];
                    dxHdx += diffx[i] * Hdx[i];
                    sumdiffg += diffgrad[i] * diffgrad[i];
                    sumdiffx += diffx[i] * diffx[i];
                    double gmax = Math.abs(grad[i]) >= Math.abs(rescuedgrad[i]) ? Math.abs(grad[i]) : Math.abs(rescuedgrad[i]);
                    if (gmax != 0.0 && Math.abs(diffgrad[i] - Hdx[i]) > Math.sqrt(3.0E-8f) * gmax) {
                        skip_update = false;
                    }
                    ++i;
                }
                if (dgdx > Math.sqrt((double)3.0E-8f * sumdiffg * sumdiffx) && !skip_update) {
                    double fae = 1.0 / dxHdx;
                    double fac = 1.0 / dgdx;
                    i = 0;
                    p = 0;
                    while (i < M) {
                        j = 0;
                        while (j < M) {
                            proposedHess[p] = i <= j ? hess[p] + fac * diffgrad[i] * diffgrad[j] - fae * (Hdx[i] * Hdx[j]) : proposedHess[j * M + i];
                            ++j;
                            ++p;
                        }
                        ++i;
                    }
                    boolean ill_hessian = false;
                    if (!ill_hessian) {
                        i = 0;
                        p = 0;
                        while (i < M) {
                            j = 0;
                            while (j < M) {
                                hess[p] = proposedHess[p];
                                ++j;
                                ++p;
                            }
                            ++i;
                        }
                    } else if (this.showMarquardtOptim) {
                        System.out.println("Hessian cannot be safely updated, ill-conditioned");
                    }
                } else if (this.showMarquardtOptim) {
                    System.out.println("Hessian cannot be safely updated");
                }
                rescuedf = f;
                i = 0;
                p = 0;
                while (i < M) {
                    rescuedx[i] = x[i];
                    rescuedgrad[i] = grad[i];
                    j = 0;
                    while (j < M) {
                        rescuedhess[p] = hess[p];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                if (1.0E-4 < lambda) {
                    lambda /= 10.0;
                }
            } else {
                i = 0;
                p = 0;
                while (i < M) {
                    x[i] = rescuedx[i];
                    grad[i] = rescuedgrad[i];
                    j = 0;
                    while (j < M) {
                        hess[p] = rescuedhess[p];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                if (!(lambda < 1.0 / TINY)) break;
                if ((lambda *= 10.0) < 1.0) {
                    lambda = 1.0;
                }
            }
            boolean bl = stop = this.plugin != null && this.plugin.isPluginInterrumped();
        }
        i = 0;
        p = 0;
        while (i < intervals + 3) {
            j = 0;
            while (j < intervals + 3) {
                cxTargetToSource[i][j] = x[p];
                cxSourceToTarget[i][j] = x[quarterM + p];
                cyTargetToSource[i][j] = x[halfM + p];
                cySourceToTarget[i][j] = x[threeQuarterM + p];
                ++j;
                ++p;
            }
            ++i;
        }
        ProgressBar.skipProgressBar(maxiter - iter);
        return f;
    }

    private double energyFunction(double[] c, int intervals, double[] grad, boolean only_image, boolean show_error) {
        int M = c.length / 2;
        int halfM = M / 2;
        double[] x1 = new double[M];
        double[] auxGrad1 = new double[M];
        double[] auxGrad2 = new double[M];
        int i = 0;
        int p = 0;
        while (i < halfM) {
            x1[p] = c[i];
            x1[p + halfM] = c[i + M];
            ++i;
            ++p;
        }
        double f = this.evaluateSimilarityMultiThread(x1, intervals, auxGrad1, only_image, false);
        double[] x2 = new double[M];
        int i2 = halfM;
        int p2 = 0;
        while (i2 < M) {
            x2[p2] = c[i2];
            x2[p2 + halfM] = c[i2 + M];
            ++i2;
            ++p2;
        }
        f += this.evaluateSimilarityMultiThread(x2, intervals, auxGrad2, only_image, true);
        i2 = 0;
        p2 = 0;
        while (i2 < halfM) {
            grad[p2] = auxGrad1[i2];
            grad[p2 + halfM] = auxGrad2[i2];
            grad[p2 + M] = auxGrad1[i2 + halfM];
            grad[p2 + M + halfM] = auxGrad2[i2 + halfM];
            ++i2;
            ++p2;
        }
        double f_consistency = 0.0;
        if (this.consistencyWeight != 0.0) {
            double[] vgradcons = new double[grad.length];
            f_consistency = this.evaluateConsistencyMultiThread(intervals, vgradcons);
            int i3 = 0;
            while (i3 < grad.length) {
                int n = i3;
                grad[n] = grad[n] + vgradcons[i3];
                ++i3;
            }
        }
        return f + f_consistency;
    }

    private double evaluateSimilarityMultiThread(double[] c, int intervals, double[] grad, boolean only_image, boolean bIsReverse) {
        int cYdim;
        BSplineModel auxTarget = !bIsReverse ? this.targetModel : this.sourceModel;
        BSplineModel auxSource = !bIsReverse ? this.sourceModel : this.targetModel;
        ROI2D auxTargetMsk = !bIsReverse ? this.targetMask : this.sourceMask;
        ROI2D auxSourceMsk = !bIsReverse ? this.sourceMask : this.targetMask;
        List<ROI2DPoint> auxTargetPh = !bIsReverse ? this.targetLandmarks : this.sourceLandmarks;
        List<ROI2DPoint> auxSourcePh = !bIsReverse ? this.sourceLandmarks : this.targetLandmarks;
        BSplineModel swx = !bIsReverse ? this.swxTargetToSource : this.swxSourceToTarget;
        BSplineModel swy = !bIsReverse ? this.swyTargetToSource : this.swySourceToTarget;
        double auxFactorWidth = !bIsReverse ? this.targetModel.getFactorWidth() : this.sourceFactorWidth;
        double auxFactorHeight = !bIsReverse ? this.targetModel.getFactorHeight() : this.sourceFactorHeight;
        double[][] P11 = !bIsReverse ? this.P11_TargetToSource : this.P11_SourceToTarget;
        double[][] P12 = !bIsReverse ? this.P12_TargetToSource : this.P12_SourceToTarget;
        double[][] P22 = !bIsReverse ? this.P22_TargetToSource : this.P12_SourceToTarget;
        int auxTargetCurrentWidth = !bIsReverse ? this.targetCurrentWidth : this.sourceCurrentWidth;
        int auxTargetCurrentHeight = !bIsReverse ? this.targetCurrentHeight : this.sourceCurrentHeight;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] vgradreg = new double[grad.length];
        double[] vgradland = new double[grad.length];
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        int k = 0;
        while (k < twiceNk) {
            grad[k] = 0.0;
            vgradland[k] = 0.0;
            vgradreg[k] = 0.0;
            ++k;
        }
        double imageSimilarity = 0.0;
        if (this.imageWeight != 0.0) {
            int nproc = Runtime.getRuntime().availableProcessors();
            int block_height = auxTargetCurrentHeight / nproc;
            if (auxTargetCurrentHeight % 2 != 0) {
                ++block_height;
            }
            int nThreads = nproc;
            Thread[] threads = new Thread[nThreads];
            Rectangle[] rects = new Rectangle[nThreads];
            double[][] grad_thread = new double[nThreads][grad.length];
            double[][] result = new double[nThreads][2];
            int n = 0;
            int i = 0;
            while (i < nThreads) {
                int y_start = i * block_height;
                if (nThreads - 1 == i) {
                    block_height = auxTargetCurrentHeight - i * block_height;
                }
                rects[i] = new Rectangle(0, y_start, auxTargetCurrentWidth, block_height);
                threads[i] = new Thread(new EvaluateSimilarityTile(auxTarget, auxSource, auxTargetMsk, auxSourceMsk, swx, swy, auxFactorWidth, auxFactorHeight, intervals, grad_thread[i], result[i], rects[i]));
                threads[i].start();
                ++i;
            }
            i = 0;
            while (i < nThreads) {
                try {
                    threads[i].join();
                    threads[i] = null;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            i = 0;
            while (i < nThreads) {
                imageSimilarity += result[i][0];
                n = (int)((double)n + result[i][1]);
                ++i;
            }
            imageSimilarity /= (double)n;
            i = 0;
            while (i < nThreads) {
                int j = 0;
                while (j < grad.length) {
                    int n2 = j;
                    grad[n2] = grad[n2] + grad_thread[i][j] / (double)n;
                    ++j;
                }
                ++i;
            }
        }
        double regularization = 0.0;
        if (!only_image) {
            int i = 0;
            while (i < Nk) {
                int j = 0;
                while (j < Nk) {
                    regularization += c[i] * P11[i][j] * c[j] + c[Nk + i] * P22[i][j] * c[Nk + j] + c[i] * P12[i][j] * c[Nk + j];
                    int n = i;
                    vgradreg[n] = vgradreg[n] + 2.0 * P11[i][j] * c[j];
                    int n3 = Nk + i;
                    vgradreg[n3] = vgradreg[n3] + 2.0 * P22[i][j] * c[Nk + j];
                    int n4 = i;
                    vgradreg[n4] = vgradreg[n4] + P12[i][j] * c[Nk + j];
                    int n5 = Nk + i;
                    vgradreg[n5] = vgradreg[n5] + P12[j][i] * c[j];
                    ++j;
                }
                ++i;
            }
            regularization *= 1.0 / (double)(auxTargetCurrentHeight * auxTargetCurrentWidth);
            int k2 = 0;
            while (k2 < twiceNk) {
                int n = k2++;
                vgradreg[n] = vgradreg[n] * (1.0 / (double)(auxTargetCurrentHeight * auxTargetCurrentWidth));
            }
        }
        double landmarkError = 0.0;
        int K = 0;
        if (auxTargetPh != null) {
            K = auxTargetPh.size();
        }
        if (this.landmarkWeight != 0.0) {
            ArrayList<Point2D> sourceVector = new ArrayList<Point2D>();
            if (auxSourcePh != null) {
                for (ROI2DPoint roi : auxSourcePh) {
                    sourceVector.add(roi.getPoint());
                }
            }
            ArrayList<Point2D> targetVector = new ArrayList<Point2D>();
            if (auxTargetPh != null) {
                for (ROI2DPoint roi : auxTargetPh) {
                    targetVector.add(roi.getPoint());
                }
            }
            int kp = 0;
            while (kp < K) {
                Point2D sourcePoint = (Point2D)sourceVector.get(kp);
                Point2D targetPoint = (Point2D)targetVector.get(kp);
                double u = auxFactorWidth * targetPoint.getX();
                double v = auxFactorHeight * targetPoint.getY();
                double tu = u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                double tv = v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double dx = auxFactorWidth * sourcePoint.getX() - x;
                double dy = auxFactorHeight * sourcePoint.getY() - y;
                landmarkError += dx * dx + dy * dy;
                int l = 0;
                while (l < 4) {
                    int m = 0;
                    while (m < 4) {
                        if (swx.yIndex[l] != -1 && swx.xIndex[m] != -1) {
                            int k3;
                            int n = k3 = swx.yIndex[l] * cYdim + swx.xIndex[m];
                            vgradland[n] = vgradland[n] - dx * swx.getWeightI(l, m);
                            int n6 = k3 + Nk;
                            vgradland[n6] = vgradland[n6] - dy * swy.getWeightI(l, m);
                        }
                        ++m;
                    }
                    ++l;
                }
                ++kp;
            }
        }
        if (K != 0) {
            landmarkError *= this.landmarkWeight / (double)K;
            double aux = 2.0 * this.landmarkWeight / (double)K;
            int k4 = 0;
            while (k4 < twiceNk) {
                int n = k4++;
                vgradland[n] = vgradland[n] * aux;
            }
        }
        if (only_image) {
            landmarkError = 0.0;
        }
        int k5 = 0;
        while (k5 < twiceNk) {
            int n = k5;
            grad[n] = grad[n] + (vgradreg[k5] + vgradland[k5]);
            ++k5;
        }
        if (this.showMarquardtOptim) {
            String s;
            String string = s = bIsReverse ? new String("(t-s)") : new String("(s-t)");
            if (this.imageWeight != 0.0) {
                System.out.println("    Image          error " + s + ": " + imageSimilarity);
                if (bIsReverse) {
                    this.partialInverseSimilarityError = imageSimilarity;
                } else {
                    this.partialDirectSimilarityError = imageSimilarity;
                }
            }
            if (this.landmarkWeight != 0.0) {
                System.out.println("    Landmark       error " + s + ": " + landmarkError);
                if (bIsReverse) {
                    this.partialInverseLandmarkError = landmarkError;
                } else {
                    this.partialDirectLandmarkError = landmarkError;
                }
            }
            if (this.divWeight != 0.0 || this.curlWeight != 0.0) {
                System.out.println("    Regularization error " + s + ": " + regularization);
                if (bIsReverse) {
                    this.partialInverseRegularizationError = regularization;
                } else {
                    this.partialDirectRegularizationError = regularization;
                }
            }
        }
        return imageSimilarity + landmarkError + regularization;
    }

    private void Marquardt_it(double[] x, boolean[] optimize, double[] gradient, double[] Hessian, double lambda) {
        int M = x.length;
        double[] sortedgradient = new double[M];
        int i = 0;
        while (i < M) {
            sortedgradient[i] = Math.abs(gradient[i]);
            ++i;
        }
        Arrays.sort(sortedgradient);
        double largestGradient = sortedgradient[M - 1];
        double gradient_th = 0.09 * largestGradient;
        int Mused = 0;
        int i2 = 0;
        while (i2 < M) {
            if (sortedgradient[i2] >= gradient_th) {
                ++Mused;
            }
            ++i2;
        }
        double[][] u = new double[Mused][Mused];
        double[] g = new double[Mused];
        double[] update = new double[Mused];
        boolean[] optimizep = new boolean[M];
        System.arraycopy(optimize, 0, optimizep, 0, M);
        lambda += 1.0;
        int m = 0;
        int i3 = 0;
        while (i3 < M) {
            if (optimizep[i3] && Math.abs(gradient[i3]) >= gradient_th) {
                if (++m == Mused) {
                    break;
                }
            } else {
                optimizep[i3] = false;
            }
            ++i3;
        }
        ++i3;
        while (i3 < M) {
            optimizep[i3] = false;
            ++i3;
        }
        int kr = 0;
        int iw = 0;
        int ir = 0;
        while (ir < M) {
            if (optimizep[ir]) {
                int jw = 0;
                int jr = 0;
                while (jr < M) {
                    if (optimizep[jr]) {
                        u[iw][jw++] = Hessian[kr + jr];
                    }
                    ++jr;
                }
                g[iw] = gradient[ir];
                double[] dArray = u[iw];
                int n = iw++;
                dArray[n] = dArray[n] * lambda;
            }
            kr += M;
            ++ir;
        }
        update = MathTools.linearLeastSquares(u, g);
        if (update == null) {
            System.out.println("Error when calculating linear least square solution...");
            return;
        }
        kr = 0;
        int kw = 0;
        while (kw < M) {
            if (optimizep[kw]) {
                int n = kw;
                x[n] = x[n] - update[kr++];
            }
            ++kw;
        }
    }

    private void updateOutputs(double[] c, int intervals) {
        int M = c.length / 2;
        int halfM = M / 2;
        double[] x1 = new double[M];
        int i = 0;
        int p = 0;
        while (i < halfM) {
            x1[p] = c[i];
            x1[p + halfM] = c[i + M];
            ++i;
            ++p;
        }
        double[] x2 = new double[M];
        int i2 = halfM;
        int p2 = 0;
        while (i2 < M) {
            x2[p2] = c[i2];
            x2[p2 + halfM] = c[i2 + M];
            ++i2;
            ++p2;
        }
        this.updateCurrentOutput(x1, intervals, false);
        this.updateCurrentOutput(x2, intervals, true);
    }

    private void updateCurrentOutput(double[] c, int intervals, boolean bIsReverse) {
        int u;
        int cYdim;
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        BSplineModel auxTarget = this.targetModel;
        BSplineModel auxSource = this.sourceModel;
        ROI2D auxTargetMsk = this.targetMask;
        ROI2D auxSourceMsk = this.sourceMask;
        BSplineModel swx = this.swxTargetToSource;
        BSplineModel swy = this.swyTargetToSource;
        int auxTargetWidth = this.targetWidth;
        int auxTargetHeight = this.targetHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxSourceWidth = this.sourceWidth;
        int auxSourceHeight = this.sourceHeight;
        Sequence auxSourceSeq = this.sourceSeq;
        Sequence outputSeq = this.outputSeq1;
        double auxFactorWidth = this.targetFactorWidth;
        double auxFactorHeight = this.targetFactorHeight;
        double subFactorWidth = this.targetModel.isSubOutput() ? this.targetModel.getWidth() / this.targetModel.getSubWidth() : 1;
        double subFactorHeight = this.targetModel.isSubOutput() ? this.targetModel.getHeight() / this.targetModel.getSubHeight() : 1;
        if (bIsReverse) {
            auxTarget = this.sourceModel;
            auxSource = this.targetModel;
            auxTargetMsk = this.sourceMask;
            auxSourceMsk = this.targetMask;
            swx = this.swxSourceToTarget;
            swy = this.swySourceToTarget;
            auxTargetWidth = this.sourceWidth;
            auxTargetHeight = this.sourceHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxSourceWidth = this.targetWidth;
            auxSourceHeight = this.targetHeight;
            auxSourceSeq = this.targetSeq;
            outputSeq = this.outputSeq2;
            auxFactorWidth = this.sourceFactorWidth;
            auxFactorHeight = this.sourceFactorHeight;
            subFactorWidth = this.sourceModel.isSubOutput() ? this.sourceModel.getWidth() / this.sourceModel.getSubWidth() : 1;
            subFactorHeight = this.sourceModel.isSubOutput() ? this.sourceModel.getHeight() / this.sourceModel.getSubHeight() : 1;
        }
        swx.setCoefficients(c, cYdim, cXdim, 0);
        swy.setCoefficients(c, cYdim, cXdim, Nk);
        outputSeq.beginUpdate();
        IcyBufferedImage ibi = outputSeq.getImage(0, 0);
        int uv = 0;
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height = auxTargetHeight / ((int)subFactorHeight * nproc);
        if (auxTargetHeight % 2 != 0) {
            ++block_height;
        }
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        IcyBufferedImage[] ibi_tile = new IcyBufferedImage[nThreads];
        int i = 0;
        while (i < nThreads) {
            int x_start = i * block_height;
            if (nThreads - 1 == i) {
                block_height = auxTargetHeight / (int)subFactorHeight - i * block_height;
            }
            rects[i] = new Rectangle(0, x_start, auxTargetWidth / (int)subFactorWidth, block_height);
            ibi_tile[i] = new IcyBufferedImage(rects[i].width, rects[i].height, 1, DataType.FLOAT);
            threads[i] = new Thread(new OutputTileMaker(swx, swy, auxSource, auxTarget, auxSourceMsk, auxTargetMsk, auxFactorWidth * subFactorWidth, auxFactorHeight * subFactorHeight, auxTargetCurrentHeight, auxTargetCurrentWidth, rects[i], ibi_tile[i]));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            try {
                threads[i].join();
                threads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            ibi.copyData(ibi_tile[i], null, new Point(rects[i].x, rects[i].y));
            ibi_tile[i] = null;
            rects[i] = null;
            ++i;
        }
        outputSeq.setImage(0, 0, (BufferedImage)ibi);
        outputSeq.endUpdate();
        auxTargetHeight = bIsReverse ? this.originalSourceIBI.getHeight() : this.originalTargetIBI.getHeight();
        auxTargetWidth = bIsReverse ? this.originalSourceIBI.getWidth() : this.originalTargetIBI.getWidth();
        auxSourceHeight = bIsReverse ? this.originalTargetIBI.getHeight() : this.originalSourceIBI.getHeight();
        auxSourceWidth = bIsReverse ? this.originalTargetIBI.getWidth() : this.originalSourceIBI.getWidth();
        auxFactorWidth = (double)auxTargetCurrentWidth / (double)auxTargetWidth;
        auxFactorHeight = (double)auxTargetCurrentHeight / (double)auxTargetHeight;
        int stepv = Math.min(Math.max(10, auxTargetHeight / 15), 60);
        int stepu = Math.min(Math.max(10, auxTargetWidth / 15), 60);
        double[][] transformedImage = new double[auxSourceHeight][auxSourceWidth];
        double grid_colour = -1.0E-10;
        uv = 0;
        int v = 0;
        while (v < auxSourceHeight) {
            u = 0;
            while (u < auxSourceWidth) {
                transformedImage[v][u] = auxSource.getOriginalImage()[uv];
                if (transformedImage[v][u] > grid_colour) {
                    grid_colour = transformedImage[v][u];
                }
                ++u;
                ++uv;
            }
            ++v;
        }
        v = 0;
        while (v < auxTargetHeight + stepv) {
            u = 0;
            while (u < auxTargetWidth + stepu) {
                int vv;
                double down_u = (double)u * auxFactorWidth;
                double down_v = (double)v * auxFactorHeight;
                double tv = down_v * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                double tu = down_u * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                double x = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                double y = swy.interpolateI();
                double up_x = x / auxFactorWidth;
                double up_y = y / auxFactorHeight;
                int uh = u + stepu;
                if (uh < auxTargetWidth + stepu) {
                    double down_uh = (double)uh * auxFactorWidth;
                    double tuh = down_uh * (double)intervals / (double)(auxTargetCurrentWidth - 1) + 1.0;
                    swx.prepareForInterpolation(tuh, tv, false);
                    double xh = swx.interpolateI();
                    swy.prepareForInterpolation(tuh, tv, false);
                    double yh = swy.interpolateI();
                    double up_xh = xh / auxFactorWidth;
                    double up_yh = yh / auxFactorHeight;
                    MiscTools.drawLine(transformedImage, (int)Math.round(up_x), (int)Math.round(up_y), (int)Math.round(up_xh), (int)Math.round(up_yh), grid_colour);
                }
                if ((vv = v + stepv) < auxTargetHeight + stepv) {
                    double down_vv = (double)vv * auxFactorHeight;
                    double tvv = down_vv * (double)intervals / (double)(auxTargetCurrentHeight - 1) + 1.0;
                    swx.prepareForInterpolation(tu, tvv, false);
                    double xv = swx.interpolateI();
                    swy.prepareForInterpolation(tu, tvv, false);
                    double yv = swy.interpolateI();
                    double up_xv = xv / auxFactorWidth;
                    double up_yv = yv / auxFactorHeight;
                    MiscTools.drawLine(transformedImage, (int)Math.round(up_x), (int)Math.round(up_y), (int)Math.round(up_xv), (int)Math.round(up_yv), grid_colour);
                }
                u += stepu;
            }
            v += stepv;
        }
        IcyBufferedImage ibig = new IcyBufferedImage(auxSourceWidth, auxSourceHeight, 1, DataType.DOUBLE);
        double[] ibigData = ibig.getDataXYAsDouble(0);
        int v2 = 0;
        while (v2 < auxSourceHeight) {
            int u2 = 0;
            while (u2 < auxSourceWidth) {
                ibigData[u2 + v2 * auxSourceWidth] = transformedImage[v2][u2];
                ++u2;
            }
            ++v2;
        }
        ibig.dataChanged();
        auxSourceSeq.beginUpdate();
        auxSourceSeq.setImage(0, 0, (BufferedImage)ibig);
        auxSourceSeq.endUpdate();
    }

    private double evaluateConsistencyMultiThread(int intervals, double[] grad) {
        double consistencyInverseError;
        double f_direct = 0.0;
        double f_inverse = 0.0;
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height_target = this.targetCurrentHeight / nproc;
        if (this.targetCurrentHeight % 2 != 0) {
            ++block_height_target;
        }
        int block_height_source = this.sourceCurrentHeight / nproc;
        if (this.sourceCurrentHeight % 2 != 0) {
            ++block_height_source;
        }
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rect_target = new Rectangle[nThreads];
        Rectangle[] rect_source = new Rectangle[nThreads];
        double[][] grad_direct = new double[nThreads][grad.length];
        double[][] grad_inverse = new double[nThreads][grad.length];
        double[][] result = new double[nThreads][4];
        int n_direct = 0;
        int n_inverse = 0;
        int i = 0;
        while (i < nThreads) {
            int y_start_target = i * block_height_target;
            int y_start_source = i * block_height_source;
            if (nThreads - 1 == i) {
                block_height_target = this.targetCurrentHeight - i * block_height_target;
                block_height_source = this.sourceCurrentHeight - i * block_height_source;
            }
            rect_target[i] = new Rectangle(0, y_start_target, this.targetCurrentHeight, block_height_target);
            rect_source[i] = new Rectangle(0, y_start_source, this.sourceCurrentHeight, block_height_source);
            threads[i] = new Thread(new EvaluateConsistencyTile(this, grad_direct[i], grad_inverse[i], result[i], rect_target[i], rect_source[i]));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            try {
                threads[i].join();
                threads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            f_direct += result[i][0];
            n_direct = (int)((double)n_direct + result[i][1]);
            f_inverse += result[i][2];
            n_inverse = (int)((double)n_inverse + result[i][3]);
            ++i;
        }
        f_direct /= (double)n_direct;
        f_inverse /= (double)n_inverse;
        i = 0;
        while (i < nThreads) {
            int j = 0;
            while (j < grad.length) {
                int n = j;
                grad[n] = grad[n] + (grad_direct[i][j] / (double)n_direct + grad_inverse[i][j] / (double)n_inverse);
                ++j;
            }
            ++i;
        }
        this.partialDirectConsitencyError = this.consistencyWeight * f_direct;
        this.partialInverseConsitencyError = this.consistencyWeight * f_inverse;
        double consistencyDirectError = n_direct == 0 ? 1.0 / FLT_EPSILON : this.consistencyWeight * f_direct;
        double d = consistencyInverseError = n_inverse == 0 ? 1.0 / FLT_EPSILON : this.consistencyWeight * f_inverse;
        if (this.showMarquardtOptim) {
            System.out.println("    Consistency Error (s-t): " + consistencyDirectError);
            System.out.println("    Consistency Error (t-s): " + consistencyInverseError);
        }
        if (n_direct == 0 || n_inverse == 0) {
            return 1.0 / FLT_EPSILON;
        }
        return this.consistencyWeight * (f_direct + f_inverse);
    }

    private double optimizeCoeffs(int intervals, double thChangef, double[][] cxTargetToSource, double[][] cyTargetToSource) {
        int j;
        if (this.sourceModel.isSubOutput()) {
            System.out.println(" -----\n Intervals = " + intervals + "x" + intervals);
            System.out.println(" Source Image Size = " + this.sourceCurrentWidth + "x" + this.sourceCurrentHeight);
        }
        if (this.plugin != null && this.plugin.isPluginInterrumped()) {
            return 0.0;
        }
        double TINY = FLT_EPSILON;
        double EPS = 3.0E-8f;
        double FIRSTLAMBDA = 1.0;
        int MAXITER_OPTIMCOEFF = 300;
        int CUMULATIVE_SIZE = 5;
        int int3 = intervals + 3;
        int halfM = int3 * int3;
        int M = halfM * 2;
        double[] x = new double[M];
        double[] rescuedx = new double[M];
        double[] diffx = new double[M];
        double[] rescuedgrad = new double[M];
        double[] grad = new double[M];
        double[] diffgrad = new double[M];
        double[] Hdx = new double[M];
        double[] rescuedhess = new double[M * M];
        double[] hess = new double[M * M];
        double[] proposedHess = new double[M * M];
        boolean[] optimize = new boolean[M];
        int iter = 1;
        double improvementx = Math.sqrt(TINY);
        double lambda = 1.0;
        CumulativeQueue lastBest = new CumulativeQueue(5);
        int i = 0;
        while (i < M) {
            optimize[i] = true;
            ++i;
        }
        i = 0;
        int p = 0;
        while (i < intervals + 3) {
            j = 0;
            while (j < intervals + 3) {
                x[p] = cxTargetToSource[i][j];
                x[halfM + p] = cyTargetToSource[i][j];
                ++j;
                ++p;
            }
            ++i;
        }
        this.swxTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, 0);
        this.swyTargetToSource = new BSplineModel(x, intervals + 3, intervals + 3, halfM);
        this.swxTargetToSource.precomputedPrepareForInterpolation(this.targetModel.getCurrentHeight(), this.targetModel.getCurrentWidth(), intervals);
        this.swyTargetToSource.precomputedPrepareForInterpolation(this.targetModel.getCurrentHeight(), this.targetModel.getCurrentWidth(), intervals);
        double f = this.evaluateSimilarityMultiThread(x, intervals, grad, false, false);
        if (this.showMarquardtOptim) {
            System.out.println("f(1)=" + f);
        }
        i = 0;
        p = 0;
        while (i < M) {
            j = 0;
            while (j < M) {
                hess[p] = i == j ? 1.0 : 0.0;
                ++j;
                ++p;
            }
            ++i;
        }
        double rescuedf = f;
        i = 0;
        p = 0;
        while (i < M) {
            rescuedx[i] = x[i];
            rescuedgrad[i] = grad[i];
            j = 0;
            while (j < M) {
                rescuedhess[p] = hess[p];
                ++j;
                ++p;
            }
            ++i;
        }
        int maxiter = 300 * (this.sourceModel.getCurrentDepth() + 1);
        ProgressBar.stepProgressBar();
        int last_successful_iter = 0;
        boolean stop = this.plugin != null && this.plugin.isPluginInterrumped();
        while (iter < maxiter && !stop) {
            this.Marquardt_it(x, optimize, grad, hess, lambda);
            improvementx = 0.0;
            double max_normx = 0.0;
            i = 0;
            while (i < M) {
                diffx[i] = x[i] - rescuedx[i];
                double distx = Math.abs(diffx[i]);
                improvementx += distx * distx;
                double aux = Math.abs(rescuedx[i]) < Math.abs(x[i]) ? x[i] : rescuedx[i];
                max_normx += aux * aux;
                ++i;
            }
            if (TINY < max_normx) {
                improvementx /= max_normx;
            }
            if ((improvementx = Math.sqrt(Math.sqrt(improvementx))) < Math.sqrt(TINY)) break;
            f = this.evaluateSimilarityMultiThread(x, intervals, grad, false, false);
            ++iter;
            if (this.showMarquardtOptim) {
                System.out.println("f(" + iter + ")=" + f + " lambda=" + lambda);
            }
            ProgressBar.stepProgressBar();
            if (rescuedf > f) {
                this.finalDirectConsistencyError = this.partialDirectConsitencyError;
                this.finalDirectSimilarityError = this.partialDirectSimilarityError;
                this.finalDirectRegularizationError = this.partialDirectRegularizationError;
                this.finalDirectLandmarkError = this.partialDirectLandmarkError;
                lastBest.push_back(rescuedf - f);
                if (lastBest.currentSize() == 5 && lastBest.getSum() / f < thChangef) break;
                if (this.showMarquardtOptim) {
                    System.out.println("  Accepted");
                }
                if (last_successful_iter++ % 10 == 0 && this.outputLevel > -1) {
                    this.updateCurrentOutput(x, intervals, false);
                }
                i = 0;
                while (i < M) {
                    diffgrad[i] = grad[i] - rescuedgrad[i];
                    ++i;
                }
                i = 0;
                p = 0;
                while (i < M) {
                    Hdx[i] = 0.0;
                    j = 0;
                    while (j < M) {
                        int n = i;
                        Hdx[n] = Hdx[n] + hess[p] * diffx[j];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                double sumdiffx = 0.0;
                double sumdiffg = 0.0;
                double dxHdx = 0.0;
                double dgdx = 0.0;
                boolean skip_update = true;
                i = 0;
                while (i < M) {
                    dgdx += diffgrad[i] * diffx[i];
                    dxHdx += diffx[i] * Hdx[i];
                    sumdiffg += diffgrad[i] * diffgrad[i];
                    sumdiffx += diffx[i] * diffx[i];
                    double gmax = Math.abs(grad[i]) >= Math.abs(rescuedgrad[i]) ? Math.abs(grad[i]) : Math.abs(rescuedgrad[i]);
                    if (gmax != 0.0 && Math.abs(diffgrad[i] - Hdx[i]) > Math.sqrt(3.0E-8f) * gmax) {
                        skip_update = false;
                    }
                    ++i;
                }
                if (dgdx > Math.sqrt((double)3.0E-8f * sumdiffg * sumdiffx) && !skip_update) {
                    double fae = 1.0 / dxHdx;
                    double fac = 1.0 / dgdx;
                    i = 0;
                    p = 0;
                    while (i < M) {
                        j = 0;
                        while (j < M) {
                            proposedHess[p] = i <= j ? hess[p] + fac * diffgrad[i] * diffgrad[j] - fae * (Hdx[i] * Hdx[j]) : proposedHess[j * M + i];
                            ++j;
                            ++p;
                        }
                        ++i;
                    }
                    boolean ill_hessian = false;
                    if (!ill_hessian) {
                        i = 0;
                        p = 0;
                        while (i < M) {
                            j = 0;
                            while (j < M) {
                                hess[p] = proposedHess[p];
                                ++j;
                                ++p;
                            }
                            ++i;
                        }
                    } else if (this.showMarquardtOptim) {
                        System.out.println("Hessian cannot be safely updated, ill-conditioned");
                    }
                } else if (this.showMarquardtOptim) {
                    System.out.println("Hessian cannot be safely updated");
                }
                rescuedf = f;
                i = 0;
                p = 0;
                while (i < M) {
                    rescuedx[i] = x[i];
                    rescuedgrad[i] = grad[i];
                    j = 0;
                    while (j < M) {
                        rescuedhess[p] = hess[p];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                if (1.0E-4 < lambda) {
                    lambda /= 10.0;
                }
            } else {
                i = 0;
                p = 0;
                while (i < M) {
                    x[i] = rescuedx[i];
                    grad[i] = rescuedgrad[i];
                    j = 0;
                    while (j < M) {
                        hess[p] = rescuedhess[p];
                        ++j;
                        ++p;
                    }
                    ++i;
                }
                if (!(lambda < 1.0 / TINY)) break;
                if ((lambda *= 10.0) < 1.0) {
                    lambda = 1.0;
                }
            }
            boolean bl = stop = this.plugin != null && this.plugin.isPluginInterrumped();
        }
        i = 0;
        p = 0;
        while (i < intervals + 3) {
            j = 0;
            while (j < intervals + 3) {
                cxTargetToSource[i][j] = x[p];
                cyTargetToSource[i][j] = x[halfM + p];
                ++j;
                ++p;
            }
            ++i;
        }
        ProgressBar.skipProgressBar(maxiter - iter);
        return f;
    }

    private double[][] propagateCoeffsToNextLevel(int intervals, double[][] c, double expansionFactor) {
        int k;
        int j;
        double[][] cs_expand = new double[(intervals *= 2) + 7][intervals + 7];
        int i = 0;
        while (i < intervals + 7) {
            int j2 = 0;
            while (j2 < intervals + 7) {
                if (i % 2 == 0 || j2 % 2 == 0) {
                    cs_expand[i][j2] = 0.0;
                } else {
                    int ipc = (i - 1) / 2;
                    int jpc = (j2 - 1) / 2;
                    cs_expand[i][j2] = c[ipc][jpc];
                }
                ++j2;
            }
            ++i;
        }
        double[][] u2n = new double[4][];
        u2n[0] = null;
        u2n[1] = new double[3];
        u2n[1][0] = 0.5;
        u2n[1][1] = 1.0;
        u2n[1][2] = 0.5;
        u2n[2] = null;
        u2n[3] = new double[5];
        u2n[3][0] = 0.125;
        u2n[3][1] = 0.5;
        u2n[3][2] = 0.75;
        u2n[3][3] = 0.5;
        u2n[3][4] = 0.125;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 2;
        int[] half_length_u2n = nArray;
        int kh = half_length_u2n[3];
        double[][] cs_expand_aux = new double[intervals + 7][intervals + 7];
        int i2 = 1;
        while (i2 < intervals + 7) {
            j = 0;
            while (j < intervals + 7) {
                cs_expand_aux[i2][j] = 0.0;
                k = -kh;
                while (k <= kh) {
                    if (j + k >= 0 && j + k <= intervals + 6) {
                        double[] dArray = cs_expand_aux[i2];
                        int n = j;
                        dArray[n] = dArray[n] + u2n[3][k + kh] * cs_expand[i2][j + k];
                    }
                    ++k;
                }
                ++j;
            }
            i2 += 2;
        }
        i2 = 0;
        while (i2 < intervals + 7) {
            j = 0;
            while (j < intervals + 7) {
                cs_expand[i2][j] = 0.0;
                k = -kh;
                while (k <= kh) {
                    if (i2 + k >= 0 && i2 + k <= intervals + 6) {
                        double[] dArray = cs_expand[i2];
                        int n = j;
                        dArray[n] = dArray[n] + u2n[3][k + kh] * cs_expand_aux[i2 + k][j];
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        double[][] newc = new double[intervals + 3][intervals + 3];
        int i3 = 0;
        while (i3 < intervals + 3) {
            int j3 = 0;
            while (j3 < intervals + 3) {
                newc[i3][j3] = cs_expand[i3 + 2][j3 + 2] * expansionFactor;
                ++j3;
            }
            ++i3;
        }
        return newc;
    }

    public void showDirectResults() {
        this.showTransformationMultiThread(this.intervals, this.cxTargetToSource, this.cyTargetToSource, false);
    }

    private void showTransformationMultiThread(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        Sequence outputSeq = !bIsReverse ? this.outputSeq1 : this.outputSeq2;
        ProgressBar.setProgressBarMessage("Calculating result window...");
        Sequence result_imp = this.applyTransformationMultiThread(intervals, cx, cy, bIsReverse);
        this.plugin.removeSequence(outputSeq);
        outputSeq = result_imp;
        this.plugin.addSequence(outputSeq);
    }

    private Sequence applyTransformationMultiThread(int intervals, double[][] cx, double[][] cy, boolean bIsReverse) {
        ROI2D auxTargetMsk = this.targetMask;
        ROI2D auxSourceMsk = this.sourceMask;
        int auxTargetWidth = this.originalTargetIBI.getWidth();
        int auxTargetHeight = this.originalTargetIBI.getHeight();
        IcyBufferedImage originalIBI = this.originalSourceIBI;
        if (bIsReverse) {
            auxTargetMsk = this.sourceMask;
            auxSourceMsk = this.targetMask;
            auxTargetWidth = this.originalSourceIBI.getWidth();
            auxTargetHeight = this.originalSourceIBI.getHeight();
            originalIBI = this.originalTargetIBI;
        }
        Sequence is = new Sequence();
        String s = bIsReverse ? new String("Target") : new String("Source");
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        BSplineModel[] sourceModels = new BSplineModel[originalIBI.getSizeC()];
        int c = 0;
        while (c < originalIBI.getSizeC()) {
            sourceModels[c] = new BSplineModel(IcyBufferedImageUtil.extractChannel((IcyBufferedImage)originalIBI, (int)c), false, 1);
            sourceModels[c].setPyramidDepth(0);
            sourceModels[c].startPyramids();
            ++c;
        }
        try {
            c = 0;
            while (c < originalIBI.getSizeC()) {
                sourceModels[c].join();
                ++c;
            }
        }
        catch (InterruptedException e) {
            System.err.println("Unexpected interruption exception " + e);
        }
        IcyBufferedImage ibi = new IcyBufferedImage(auxTargetWidth, auxTargetHeight, originalIBI.getSizeC(), originalIBI.getDataType_());
        IcyBufferedImage ibi_mask = new IcyBufferedImage(auxTargetWidth, auxTargetHeight, originalIBI.getSizeC(), originalIBI.getDataType_());
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height = auxTargetHeight / nproc;
        if (auxTargetHeight % 2 != 0) {
            ++block_height;
        }
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        IcyBufferedImage[] ibi_tile = new IcyBufferedImage[nThreads];
        IcyBufferedImage[] ibi_mask_tile = new IcyBufferedImage[nThreads];
        int i = 0;
        while (i < nThreads) {
            int y_start = i * block_height;
            if (nThreads - 1 == i) {
                block_height = auxTargetHeight - i * block_height;
            }
            rects[i] = new Rectangle(0, y_start, auxTargetWidth, block_height);
            ibi_tile[i] = new IcyBufferedImage(rects[i].width, rects[i].height, originalIBI.getSizeC(), originalIBI.getDataType_());
            ibi_mask_tile[i] = new IcyBufferedImage(rects[i].width, rects[i].height, originalIBI.getSizeC(), originalIBI.getDataType_());
            threads[i] = new Thread(new ColorResultTileMaker(swx, swy, sourceModels, auxTargetWidth, auxTargetHeight, auxTargetMsk, auxSourceMsk, rects[i], ibi_tile[i], ibi_mask_tile[i]));
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            try {
                threads[i].join();
                threads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < nThreads) {
            ibi.copyData(ibi_tile[i], null, new Point(rects[i].x, rects[i].y));
            ibi_tile[i] = null;
            ibi_mask.copyData(ibi_mask_tile[i], null, new Point(rects[i].x, rects[i].y));
            ibi_mask_tile[i] = null;
            rects[i] = null;
            ++i;
        }
        ibi.dataChanged();
        is.beginUpdate();
        is.setName("Registered " + s + " Image");
        is.addImage((BufferedImage)ibi);
        is.addImage((BufferedImage)(bIsReverse ? this.originalSourceIBI : this.originalTargetIBI));
        is.addImage((BufferedImage)ibi_mask);
        if (this.outputLevel == 2) {
            this.computeDeformationVectors(intervals, cx, cy, is, bIsReverse);
            this.computeDeformationGrid(intervals, cx, cy, is, bIsReverse);
        }
        is.endUpdate();
        return is;
    }

    private void computeDeformationVectors(int intervals, double[][] cx, double[][] cy, Sequence is, boolean bIsReverse) {
        ROI2D auxTargetMsk = this.targetMask;
        ROI2D auxSourceMsk = this.sourceMask;
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetMsk = this.sourceMask;
            auxSourceMsk = this.targetMask;
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        int stepv = Math.min(Math.max(10, auxTargetCurrentHeight / 15), 30);
        int stepu = Math.min(Math.max(10, auxTargetCurrentWidth / 15), 30);
        double[][] transformedImage = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        int v = 0;
        while (v < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                transformedImage[v][u] = is.getDataTypeMax();
                ++u;
            }
            ++v;
        }
        double[][] transformation_x = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        double[][] transformation_y = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        this.computeDeformation(intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
        int v2 = 0;
        while (v2 < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                if (auxTargetMsk == null || auxTargetMsk.contains((double)u, (double)v2)) {
                    double x = transformation_x[v2][u];
                    double y = transformation_y[v2][u];
                    if (auxSourceMsk == null || auxSourceMsk.contains(x, y)) {
                        MiscTools.drawArrow(transformedImage, u, v2, (int)Math.round(x), (int)Math.round(y), 0.0, 2);
                    }
                }
                u += stepu;
            }
            v2 += stepv;
        }
        IcyBufferedImage fp = new IcyBufferedImage(auxTargetCurrentWidth, auxTargetCurrentHeight, is.getSizeC(), is.getDataType_());
        double[][] fpData = Array2DUtil.arrayToDoubleArray((Object)fp.getDataXYC(), (boolean)fp.isSignedDataType());
        int v3 = 0;
        while (v3 < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                int c = 0;
                while (c < is.getSizeC()) {
                    fpData[c][u + v3 * auxTargetCurrentWidth] = transformedImage[v3][u];
                    ++c;
                }
                ++u;
            }
            ++v3;
        }
        Array2DUtil.doubleArrayToSafeArray((double[][])fpData, (Object)fp.getDataXYC(), (boolean)fp.isSignedDataType());
        fp.dataChanged();
        is.addImage((BufferedImage)fp);
    }

    private void computeDeformation(int intervals, double[][] cx, double[][] cy, double[][] transformation_x, double[][] transformation_y, boolean bIsReverse) {
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        Thread x_thread = new Thread(new ConcurrentDeformation(cx, auxTargetCurrentHeight, auxTargetCurrentWidth, transformation_x, intervals));
        Thread y_thread = new Thread(new ConcurrentDeformation(cy, auxTargetCurrentHeight, auxTargetCurrentWidth, transformation_y, intervals));
        x_thread.start();
        y_thread.start();
        try {
            x_thread.join();
            y_thread.join();
            x_thread = null;
            y_thread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void computeDeformationGrid(int intervals, double[][] cx, double[][] cy, Sequence is, boolean bIsReverse) {
        int auxTargetCurrentHeight = this.targetCurrentHeight;
        int auxTargetCurrentWidth = this.targetCurrentWidth;
        if (bIsReverse) {
            auxTargetCurrentHeight = this.sourceCurrentHeight;
            auxTargetCurrentWidth = this.sourceCurrentWidth;
        }
        int stepv = Math.min(Math.max(10, auxTargetCurrentHeight / 15), 30);
        int stepu = Math.min(Math.max(10, auxTargetCurrentWidth / 15), 30);
        double[][] transformedImage = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        int v = 0;
        while (v < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                transformedImage[v][u] = is.getDataTypeMax();
                ++u;
            }
            ++v;
        }
        double[][] transformation_x = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        double[][] transformation_y = new double[auxTargetCurrentHeight][auxTargetCurrentWidth];
        this.computeDeformation(intervals, cx, cy, transformation_x, transformation_y, bIsReverse);
        int v2 = 0;
        while (v2 < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                int vv;
                double x = transformation_x[v2][u];
                double y = transformation_y[v2][u];
                int uh = u + stepu;
                if (uh < auxTargetCurrentWidth) {
                    double xh = transformation_x[v2][uh];
                    double yh = transformation_y[v2][uh];
                    MiscTools.drawLine(transformedImage, (int)Math.round(x), (int)Math.round(y), (int)Math.round(xh), (int)Math.round(yh), 0.0);
                }
                if ((vv = v2 + stepv) < auxTargetCurrentHeight) {
                    double xv = transformation_x[vv][u];
                    double yv = transformation_y[vv][u];
                    MiscTools.drawLine(transformedImage, (int)Math.round(x), (int)Math.round(y), (int)Math.round(xv), (int)Math.round(yv), 0.0);
                }
                u += stepu;
            }
            v2 += stepv;
        }
        IcyBufferedImage fp = new IcyBufferedImage(auxTargetCurrentWidth, auxTargetCurrentHeight, is.getSizeC(), is.getDataType_());
        double[][] fpData = Array2DUtil.arrayToDoubleArray((Object)fp.getDataXYC(), (boolean)fp.isSignedDataType());
        int v3 = 0;
        while (v3 < auxTargetCurrentHeight) {
            int u = 0;
            while (u < auxTargetCurrentWidth) {
                int c = 0;
                while (c < fp.getSizeC()) {
                    fpData[c][u + v3 * auxTargetCurrentWidth] = transformedImage[v3][u];
                    ++c;
                }
                ++u;
            }
            ++v3;
        }
        Array2DUtil.doubleArrayToSafeArray((double[][])fpData, (Object)fp.getDataXYC(), (boolean)fp.isSignedDataType());
        fp.dataChanged();
        is.addImage((BufferedImage)fp);
    }

    public void doBidirectionalRegistration() {
        this.sourceModel.popFromPyramid();
        this.targetModel.popFromPyramid();
        int sizeCorrectionFactor = 0;
        this.targetCurrentHeight = this.targetModel.getCurrentHeight();
        this.targetCurrentWidth = this.targetModel.getCurrentWidth();
        this.targetFactorHeight = this.targetModel.getFactorHeight();
        this.targetFactorWidth = this.targetModel.getFactorWidth();
        this.sourceCurrentHeight = this.sourceModel.getCurrentHeight();
        this.sourceCurrentWidth = this.sourceModel.getCurrentWidth();
        this.sourceFactorHeight = this.sourceModel.getFactorHeight();
        this.sourceFactorWidth = this.sourceModel.getFactorWidth();
        this.intervals = (int)Math.pow(2.0, this.minScaleDeformation + sizeCorrectionFactor);
        this.cxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.cyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
        this.buildRegularizationTemporary(this.intervals, false);
        this.buildRegularizationTemporary(this.intervals, true);
        int K = this.targetLandmarks != null ? this.targetLandmarks.size() : 0;
        double[] dxTargetToSource = new double[K];
        double[] dyTargetToSource = new double[K];
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        this.computeInitialResidues(dxTargetToSource, dyTargetToSource, false);
        double[][] affineMatrix = null;
        affineMatrix = this.computeAffineMatrix(false);
        int i = 0;
        while (i < this.intervals + 3) {
            double v = (double)((i - 1) * (this.targetCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            int j = 0;
            while (j < this.intervals + 3) {
                double u = (double)((j - 1) * (this.targetCurrentWidth - 1)) / (double)this.intervals;
                this.cxTargetToSource[i][j] = xv + affineMatrix[0][0] * u;
                this.cyTargetToSource[i][j] = yv + affineMatrix[1][0] * u;
                ++j;
            }
            ++i;
        }
        int K2 = this.sourceLandmarks != null ? this.sourceLandmarks.size() : 0;
        double[] dxSourceToTarget = new double[K2];
        double[] dySourceToTarget = new double[K2];
        this.computeInitialResidues(dxSourceToTarget, dySourceToTarget, true);
        this.computeInitialResidues(dxSourceToTarget, dySourceToTarget, true);
        this.cxSourceToTarget = new double[this.intervals + 3][this.intervals + 3];
        this.cySourceToTarget = new double[this.intervals + 3][this.intervals + 3];
        affineMatrix = this.computeAffineMatrix(true);
        int i2 = 0;
        while (i2 < this.intervals + 3) {
            double v = (double)((i2 - 1) * (this.sourceCurrentHeight - 1)) / (double)this.intervals;
            double xv = affineMatrix[0][2] + affineMatrix[0][1] * v;
            double yv = affineMatrix[1][2] + affineMatrix[1][1] * v;
            int j = 0;
            while (j < this.intervals + 3) {
                double u = (double)((j - 1) * (this.sourceCurrentWidth - 1)) / (double)this.intervals;
                this.cxSourceToTarget[i2][j] = xv + affineMatrix[0][0] * u;
                this.cySourceToTarget[i2][j] = yv + affineMatrix[1][0] * u;
                ++j;
            }
            ++i2;
        }
        int state = this.minScaleDeformation == this.maxScaleDeformation ? 1 : 0;
        int s = this.minScaleDeformation;
        int step = 0;
        this.computeTotalWorkload();
        while (state != -1) {
            int currentDepth = this.targetModel.getCurrentDepth();
            if (state == 0 || state == 1) {
                if (s >= this.minScaleDeformation) {
                    int j;
                    int i3;
                    this.intervals = (int)Math.pow(2.0, s + sizeCorrectionFactor);
                    double[][] newcxTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcyTargetToSource = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcxSourceToTarget = new double[this.intervals + 3][this.intervals + 3];
                    double[][] newcySourceToTarget = new double[this.intervals + 3][this.intervals + 3];
                    boolean underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxTargetToSource, dyTargetToSource, newcxTargetToSource, newcyTargetToSource, false);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        i3 = 0;
                        while (i3 < this.intervals + 3) {
                            j = 0;
                            while (j < this.intervals + 3) {
                                double[] dArray = this.cxTargetToSource[i3];
                                int n = j;
                                dArray[n] = dArray[n] + newcxTargetToSource[i3][j];
                                double[] dArray2 = this.cyTargetToSource[i3];
                                int n2 = j;
                                dArray2[n2] = dArray2[n2] + newcyTargetToSource[i3][j];
                                ++j;
                            }
                            ++i3;
                        }
                    }
                    underconstrained = true;
                    underconstrained = this.divWeight == 0.0 && this.curlWeight == 0.0 ? this.computeCoefficientsScale(this.intervals, dxSourceToTarget, dySourceToTarget, newcxSourceToTarget, newcySourceToTarget, true) : this.computeCoefficientsScaleWithRegularization(this.intervals, dxSourceToTarget, dySourceToTarget, newcxSourceToTarget, newcySourceToTarget, true);
                    if (!underconstrained || step == 0 && this.landmarkWeight != 0.0) {
                        i3 = 0;
                        while (i3 < this.intervals + 3) {
                            j = 0;
                            while (j < this.intervals + 3) {
                                double[] dArray = this.cxSourceToTarget[i3];
                                int n = j;
                                dArray[n] = dArray[n] + newcxSourceToTarget[i3][j];
                                double[] dArray3 = this.cySourceToTarget[i3];
                                int n3 = j;
                                dArray3[n3] = dArray3[n3] + newcySourceToTarget[i3][j];
                                ++j;
                            }
                            ++i3;
                        }
                    }
                }
                this.optimizeCoeffs(this.intervals, this.stopThreshold, this.cxTargetToSource, this.cyTargetToSource, this.cxSourceToTarget, this.cySourceToTarget);
            }
            ++step;
            switch (state) {
                case 0: {
                    if (s < this.maxScaleDeformation) {
                        this.cxTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cxTargetToSource, 1.0);
                        this.cyTargetToSource = this.propagateCoeffsToNextLevel(this.intervals, this.cyTargetToSource, 1.0);
                        this.cxSourceToTarget = this.propagateCoeffsToNextLevel(this.intervals, this.cxSourceToTarget, 1.0);
                        this.cySourceToTarget = this.propagateCoeffsToNextLevel(this.intervals, this.cySourceToTarget, 1.0);
                        ++s;
                        this.intervals *= 2;
                        this.buildRegularizationTemporary(this.intervals, false);
                        this.buildRegularizationTemporary(this.intervals, true);
                        if (currentDepth > this.minScaleImage) {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    if (currentDepth > this.minScaleImage) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (state == 1) {
                        state = s == this.maxScaleDeformation && currentDepth == this.minScaleImage ? 2 : (s == this.maxScaleDeformation ? 1 : 0);
                    } else if (state == 2) {
                        state = currentDepth == 0 ? -1 : 2;
                    }
                    if (currentDepth == 0) break;
                    double oldTargetCurrentHeight = this.targetCurrentHeight;
                    double oldTargetCurrentWidth = this.targetCurrentWidth;
                    double oldSourceCurrentHeight = this.sourceCurrentHeight;
                    double oldSourceCurrentWidth = this.sourceCurrentWidth;
                    this.sourceModel.popFromPyramid();
                    this.targetModel.popFromPyramid();
                    this.targetCurrentHeight = this.targetModel.getCurrentHeight();
                    this.targetCurrentWidth = this.targetModel.getCurrentWidth();
                    this.targetFactorHeight = this.targetModel.getFactorHeight();
                    this.targetFactorWidth = this.targetModel.getFactorWidth();
                    this.sourceCurrentHeight = this.sourceModel.getCurrentHeight();
                    this.sourceCurrentWidth = this.sourceModel.getCurrentWidth();
                    this.sourceFactorHeight = this.sourceModel.getFactorHeight();
                    this.sourceFactorWidth = this.sourceModel.getFactorWidth();
                    double targetFactorY = (double)(this.targetCurrentHeight - 1) / (oldTargetCurrentHeight - 1.0);
                    double targetFactorX = (double)(this.targetCurrentWidth - 1) / (oldTargetCurrentWidth - 1.0);
                    double sourceFactorY = (double)(this.sourceCurrentHeight - 1) / (oldSourceCurrentHeight - 1.0);
                    double sourceFactorX = (double)(this.sourceCurrentWidth - 1) / (oldSourceCurrentWidth - 1.0);
                    int i4 = 0;
                    while (i4 < this.intervals + 3) {
                        int j = 0;
                        while (j < this.intervals + 3) {
                            double[] dArray = this.cxTargetToSource[i4];
                            int n = j;
                            dArray[n] = dArray[n] * targetFactorX;
                            double[] dArray4 = this.cyTargetToSource[i4];
                            int n4 = j;
                            dArray4[n4] = dArray4[n4] * targetFactorY;
                            double[] dArray5 = this.cxSourceToTarget[i4];
                            int n5 = j;
                            dArray5[n5] = dArray5[n5] * sourceFactorX;
                            double[] dArray6 = this.cySourceToTarget[i4];
                            int n6 = j++;
                            dArray6[n6] = dArray6[n6] * sourceFactorY;
                        }
                        ++i4;
                    }
                    this.buildRegularizationTemporary(this.intervals, false);
                    this.buildRegularizationTemporary(this.intervals, true);
                }
            }
            if (state != 0 && state != 1 || s != this.maxScaleDeformation || currentDepth != this.minScaleImage + 1 || this.accurateMode != 1) continue;
            this.stopThreshold /= 10.0;
        }
        if (this.sourceModel.getOriginalImageWidth() > this.sourceCurrentWidth) {
            if (this.sourceModel.isSubOutput() || this.targetModel.isSubOutput()) {
                System.out.println("Adapting coefficients from " + this.sourceCurrentWidth + " to " + this.sourceModel.getOriginalImageWidth() + "...");
            }
            double targetFactorY = (this.targetModel.getOriginalImageHeight() - 1) / (this.targetCurrentHeight - 1);
            double targetFactorX = (this.targetModel.getOriginalImageWidth() - 1) / (this.targetCurrentWidth - 1);
            double sourceFactorY = (this.sourceModel.getOriginalImageHeight() - 1) / (this.sourceCurrentHeight - 1);
            double sourceFactorX = (this.sourceModel.getOriginalImageWidth() - 1) / (this.sourceCurrentWidth - 1);
            int i5 = 0;
            while (i5 < this.intervals + 3) {
                int j = 0;
                while (j < this.intervals + 3) {
                    double[] dArray = this.cxTargetToSource[i5];
                    int n = j;
                    dArray[n] = dArray[n] * targetFactorX;
                    double[] dArray7 = this.cyTargetToSource[i5];
                    int n7 = j;
                    dArray7[n7] = dArray7[n7] * targetFactorY;
                    double[] dArray8 = this.cxSourceToTarget[i5];
                    int n8 = j;
                    dArray8[n8] = dArray8[n8] * sourceFactorX;
                    double[] dArray9 = this.cySourceToTarget[i5];
                    int n9 = j++;
                    dArray9[n9] = dArray9[n9] * sourceFactorY;
                }
                ++i5;
            }
            this.targetCurrentHeight = this.targetModel.getOriginalImageHeight();
            this.targetCurrentWidth = this.targetModel.getOriginalImageWidth();
            this.sourceCurrentHeight = this.sourceModel.getOriginalImageHeight();
            this.sourceCurrentWidth = this.sourceModel.getOriginalImageWidth();
        }
        if (this.outputLevel == 2) {
            if (this.imageWeight != 0.0) {
                System.out.println(" Optimal direct similarity error = " + this.finalDirectSimilarityError);
                System.out.println(" Optimal inverse similarity error = " + this.finalInverseSimilarityError);
            }
            if (this.curlWeight != 0.0 || this.divWeight != 0.0) {
                System.out.println(" Optimal direct regularization error = " + this.finalDirectRegularizationError);
                System.out.println(" Optimal inverse regularization error = " + this.finalInverseRegularizationError);
            }
            if (this.landmarkWeight != 0.0) {
                System.out.println(" Optimal direct landmark error = " + this.finalDirectLandmarkError);
                System.out.println(" Optimal inverse landmark error = " + this.finalInverseLandmarkError);
            }
            if (this.consistencyWeight != 0.0) {
                System.out.println(" Optimal direct consistency error = " + this.finalDirectConsistencyError);
                System.out.println(" Optimal inverse consistency error = " + this.finalInverseConsistencyError);
            }
        }
    }

    public void showInverseResults() {
        this.showTransformationMultiThread(this.intervals, this.cxSourceToTarget, this.cySourceToTarget, true);
    }

    public void getRegisteredSource(Sequence srcTgtSeq) {
        this.applyTransformationMT(srcTgtSeq, this.targetSeq, this.intervals, this.cxTargetToSource, this.cyTargetToSource);
    }

    public void getRegisteredTarget(Sequence tgtTgtSeq) {
        this.applyTransformationMT(tgtTgtSeq, this.sourceSeq, this.intervals, this.cxSourceToTarget, this.cySourceToTarget);
    }

    private void applyTransformationMT(Sequence source, Sequence target, int intervals, double[][] cx, double[][] cy) {
        MiscTools.applyTransformationToSourceMT(source, target, intervals, cx, cy);
    }

    public Sequence getRegisteredSource(String srcResultPath, String srcPath, String transformedSrcPath, String tgtPath) {
        return BigImageTools.applyTransformationToImage(srcResultPath, srcPath, transformedSrcPath, tgtPath, this.intervals, this.cxTargetToSource, this.cyTargetToSource, new Dimension(this.targetWidth, this.targetHeight));
    }

    public Sequence getRegisteredTarget(String tgtResultPath, String srcPath, String tgtPath, String transformedTgtPath) {
        return BigImageTools.applyTransformationToImage(tgtResultPath, tgtPath, transformedTgtPath, srcPath, this.intervals, this.cxSourceToTarget, this.cySourceToTarget, new Dimension(this.sourceWidth, this.sourceHeight));
    }

    public double[][] getCxSourceToTarget() {
        return this.cxSourceToTarget;
    }

    public double[][] getCySourceToTarget() {
        return this.cySourceToTarget;
    }

    public double[][] getCxTargetToSource() {
        return this.cxTargetToSource;
    }

    public double[][] getCyTargetToSource() {
        return this.cyTargetToSource;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void saveBigRegisteredSource(String srcResultPath, String transformedSrcResultPath, String srcPath, String transformedSrcPath, String tgtPath, Rectangle tile) throws ServiceException, IOException, FormatException, InterruptedException, ExecutionException {
        BigImageTools.applyAndSaveTransformationToBigImage(srcResultPath, transformedSrcResultPath, srcPath, transformedSrcPath, tgtPath, this.intervals, this.cxTargetToSource, this.cyTargetToSource, new Dimension(this.targetWidth, this.targetHeight), this.plugin, tile);
    }

    public void saveBigRegisteredTarget(String tgtResultPath, String transformedTgtResultPath, String tgtPath, String transformedTgtPath, String srcPath, Rectangle tile) throws ServiceException, IOException, FormatException, InterruptedException, ExecutionException {
        BigImageTools.applyAndSaveTransformationToBigImage(tgtResultPath, transformedTgtResultPath, tgtPath, transformedTgtPath, srcPath, this.intervals, this.cxSourceToTarget, this.cySourceToTarget, new Dimension(this.targetWidth, this.targetHeight), this.plugin, tile);
    }

    private class ColorResultTileMaker
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel[] sourceModels;
        final int auxTargetCurrentWidth;
        final int auxTargetCurrentHeight;
        final ROI2D auxTargetMsk;
        final ROI2D auxSourceMsk;
        final Rectangle rect;
        private final IcyBufferedImage ibiTile;
        private final IcyBufferedImage ibiMaskTile;

        ColorResultTileMaker(BSplineModel swx, BSplineModel swy, BSplineModel[] sourceModels, int auxTargetCurrentWidth, int auxTargetCurrentHeight, ROI2D auxTargetMsk, ROI2D auxSourceMsk, Rectangle rect, IcyBufferedImage fpB, IcyBufferedImage cp_mask) {
            this.swx = swx;
            this.swy = swy;
            this.sourceModels = sourceModels;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.rect = rect;
            this.ibiTile = fpB;
            this.ibiMaskTile = cp_mask;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            double[][] ibiData = Array2DUtil.arrayToDoubleArray((Object)this.ibiTile.getDataXYC(), (boolean)this.ibiTile.isSignedDataType());
            double[][] ibiMaskData = Array2DUtil.arrayToDoubleArray((Object)this.ibiMaskTile.getDataXYC(), (boolean)this.ibiMaskTile.isSignedDataType());
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * Transformation.this.intervals) / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    double tu = (double)(u * Transformation.this.intervals) / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                    double transformation_x_v_u = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double transformation_y_v_u = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (this.auxTargetMsk != null && !this.auxTargetMsk.contains((double)u, (double)v)) {
                        int c = 0;
                        while (c < this.ibiTile.getSizeC()) {
                            ibiData[c][u_rect + v_offset] = 0.0;
                            ibiMaskData[c][u_rect + v_offset] = 0.0;
                            ++c;
                        }
                    } else {
                        int c;
                        double x = transformation_x_v_u;
                        double y = transformation_y_v_u;
                        if (this.auxSourceMsk == null || this.auxSourceMsk.contains(x, y)) {
                            c = 0;
                            while (c < this.ibiTile.getSizeC()) {
                                ibiData[c][u_rect + v_offset] = this.sourceModels[c].prepareForInterpolationAndInterpolateI(x, y, false, false);
                                ibiMaskData[c][u_rect + v_offset] = this.ibiMaskTile.getDataTypeMax();
                                ++c;
                            }
                        } else {
                            c = 0;
                            while (c < this.ibiTile.getSizeC()) {
                                ibiData[c][u_rect + v_offset] = 0.0;
                                ibiMaskData[c][u_rect + v_offset] = 0.0;
                                ++c;
                            }
                        }
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
            Array2DUtil.doubleArrayToSafeArray((double[][])ibiData, (Object)this.ibiTile.getDataXYC(), (boolean)this.ibiTile.isSignedDataType());
            Array2DUtil.doubleArrayToSafeArray((double[][])ibiMaskData, (Object)this.ibiMaskTile.getDataXYC(), (boolean)this.ibiMaskTile.isSignedDataType());
        }
    }

    private class ConcurrentDeformation
    extends Thread {
        final double[][] c;
        final int auxTargetCurrentHeight;
        final int auxTargetCurrentWidth;
        final double[][] transformation;
        final int intervals;

        ConcurrentDeformation(double[][] c, int auxTargetCurrentHeight, int auxTargetCurrentWidth, double[][] transformation2, int intervals) {
            this.c = c;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.transformation = transformation2;
            this.intervals = intervals;
        }

        @Override
        public void run() {
            BSplineModel sw = new BSplineModel(this.c);
            int v = 0;
            while (v < this.auxTargetCurrentHeight) {
                double tv = (double)(v * this.intervals) / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                int u = 0;
                while (u < this.auxTargetCurrentWidth) {
                    double tu = (double)(u * this.intervals) / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                    this.transformation[v][u] = sw.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    ++u;
                }
                ++v;
            }
        }
    }

    private class EvaluateConsistencyTile
    implements Runnable {
        final Transformation transf;
        final double[] grad_direct;
        final double[] grad_inverse;
        final double[] result;
        final Rectangle rect_target;
        final Rectangle rect_source;

        EvaluateConsistencyTile(Transformation transf, double[] grad_direct, double[] grad_inverse, double[] result, Rectangle rect_target, Rectangle rect_source) {
            this.transf = transf;
            this.grad_direct = grad_direct;
            this.grad_inverse = grad_inverse;
            this.result = result;
            this.rect_target = rect_target;
            this.rect_source = rect_source;
        }

        @Override
        public void run() {
            int cYdim;
            int cXdim = cYdim = this.transf.intervals + 3;
            int Nk = cYdim * cXdim;
            int twiceNk = 2 * Nk;
            int k = 0;
            while (k < this.grad_direct.length) {
                this.grad_direct[k] = 0.0;
                ++k;
            }
            int YdimT = this.rect_target.y + this.rect_target.height;
            int XdimT = this.rect_target.x + this.rect_target.width;
            BSplineModel swx_direct = this.transf.swxTargetToSource;
            BSplineModel swy_direct = this.transf.swyTargetToSource;
            BSplineModel swx_inverse = this.transf.swxSourceToTarget;
            BSplineModel swy_inverse = this.transf.swySourceToTarget;
            double f_direct = 0.0;
            int n_direct = 0;
            int v = this.rect_target.y;
            while (v < YdimT) {
                int u = this.rect_target.x;
                while (u < XdimT) {
                    if (this.transf.targetMask == null || this.transf.targetMask.contains((double)u / this.transf.targetFactorWidth, (double)v / this.transf.targetFactorHeight)) {
                        int x = (int)Math.round(swx_direct.precomputedInterpolateI(u, v));
                        int y = (int)Math.round(swy_direct.precomputedInterpolateI(u, v));
                        if (x >= 0 && x < this.transf.sourceCurrentWidth && y >= 0 && y < this.transf.sourceCurrentHeight) {
                            int m;
                            double x2 = swx_inverse.precomputedInterpolateI(x, y);
                            double y2 = swy_inverse.precomputedInterpolateI(x, y);
                            double aux1 = (double)u - x2;
                            double aux2 = (double)v - y2;
                            f_direct += aux1 * aux1 + aux2 * aux2;
                            int l = 0;
                            while (l < 4) {
                                m = 0;
                                while (m < 4) {
                                    if (swx_direct.prec_yIndex[v][l] != -1 && swx_direct.prec_xIndex[u][m] != -1) {
                                        int k2;
                                        double dddx = swx_direct.precomputedGetWeightI(l, m, u, v);
                                        double dixx = swx_inverse.precomputedGetWeightDx(l, m, x, y);
                                        double diyy = swy_inverse.precomputedGetWeightDy(l, m, x, y);
                                        double weightIx = (dixx + diyy) * dddx;
                                        double dddy = swy_direct.precomputedGetWeightI(l, m, u, v);
                                        double dixy = swx_inverse.precomputedGetWeightDy(l, m, x, y);
                                        double diyx = swy_inverse.precomputedGetWeightDx(l, m, x, y);
                                        double weightIy = (diyx + dixy) * dddy;
                                        int n = k2 = swx_direct.prec_yIndex[v][l] * cYdim + swx_direct.prec_xIndex[u][m];
                                        this.grad_direct[n] = this.grad_direct[n] + -aux1 * weightIx;
                                        int n2 = k2 + twiceNk;
                                        this.grad_direct[n2] = this.grad_direct[n2] + -aux2 * weightIy;
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                            l = 0;
                            while (l < 4) {
                                m = 0;
                                while (m < 4) {
                                    if (swx_inverse.prec_yIndex[y][l] != -1 && swx_inverse.prec_xIndex[x][m] != -1) {
                                        double weightI = swx_inverse.precomputedGetWeightI(l, m, x, y);
                                        int k3 = swx_inverse.prec_yIndex[y][l] * cYdim + swx_inverse.prec_xIndex[x][m];
                                        int n = k3 + Nk;
                                        this.grad_direct[n] = this.grad_direct[n] + -aux1 * weightI;
                                        int n3 = k3 + Nk + twiceNk;
                                        this.grad_direct[n3] = this.grad_direct[n3] + -aux2 * weightI;
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                            ++n_direct;
                        }
                    }
                    ++u;
                }
                ++v;
            }
            if (n_direct != 0) {
                double aux = Transformation.this.consistencyWeight * 2.0;
                int k4 = 0;
                while (k4 < this.grad_direct.length) {
                    int n = k4++;
                    this.grad_direct[n] = this.grad_direct[n] * aux;
                }
            }
            int k5 = 0;
            while (k5 < this.grad_inverse.length) {
                this.grad_inverse[k5] = 0.0;
                ++k5;
            }
            int YdimS = this.rect_source.y + this.rect_source.height;
            int XdimS = this.rect_source.x + this.rect_source.width;
            double f_inverse = 0.0;
            int n_inverse = 0;
            int v2 = this.rect_source.y;
            while (v2 < YdimS) {
                int u = this.rect_source.x;
                while (u < XdimS) {
                    if (this.transf.sourceMask == null || this.transf.sourceMask.contains((double)u / this.transf.sourceFactorWidth, (double)v2 / this.transf.sourceFactorHeight)) {
                        int x = (int)Math.round(swx_inverse.precomputedInterpolateI(u, v2));
                        int y = (int)Math.round(swy_inverse.precomputedInterpolateI(u, v2));
                        if (x >= 0 && x < this.transf.targetCurrentWidth && y >= 0 && y < this.transf.targetCurrentHeight) {
                            int m;
                            double x2 = swx_direct.precomputedInterpolateI(x, y);
                            double y2 = swy_direct.precomputedInterpolateI(x, y);
                            double aux1 = (double)u - x2;
                            double aux2 = (double)v2 - y2;
                            f_inverse += aux1 * aux1 + aux2 * aux2;
                            int l = 0;
                            while (l < 4) {
                                m = 0;
                                while (m < 4) {
                                    if (swx_direct.prec_yIndex[y][l] != -1 && swx_direct.prec_xIndex[x][m] != -1) {
                                        int k6;
                                        double weightI = swx_direct.precomputedGetWeightI(l, m, x, y);
                                        int n = k6 = swx_direct.prec_yIndex[y][l] * cYdim + swx_direct.prec_xIndex[x][m];
                                        this.grad_inverse[n] = this.grad_inverse[n] + -aux1 * weightI;
                                        int n4 = k6 + twiceNk;
                                        this.grad_inverse[n4] = this.grad_inverse[n4] + -aux2 * weightI;
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                            l = 0;
                            while (l < 4) {
                                m = 0;
                                while (m < 4) {
                                    if (swx_inverse.prec_yIndex[v2][l] != -1 && swx_inverse.prec_xIndex[u][m] != -1) {
                                        double diix = swx_inverse.precomputedGetWeightI(l, m, u, v2);
                                        double ddxx = swx_direct.precomputedGetWeightDx(l, m, x, y);
                                        double ddyy = swy_direct.precomputedGetWeightDy(l, m, x, y);
                                        double weightIx = (ddxx + ddyy) * diix;
                                        double diiy = swy_inverse.precomputedGetWeightI(l, m, u, v2);
                                        double ddxy = swx_direct.precomputedGetWeightDy(l, m, x, y);
                                        double ddyx = swy_direct.precomputedGetWeightDx(l, m, x, y);
                                        double weightIy = (ddyx + ddxy) * diiy;
                                        int k7 = swx_inverse.prec_yIndex[v2][l] * cYdim + swx_inverse.prec_xIndex[u][m];
                                        int n = k7 + Nk;
                                        this.grad_inverse[n] = this.grad_inverse[n] + -aux1 * weightIx;
                                        int n5 = k7 + Nk + twiceNk;
                                        this.grad_inverse[n5] = this.grad_inverse[n5] + -aux2 * weightIy;
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                            ++n_inverse;
                        }
                    }
                    ++u;
                }
                ++v2;
            }
            if (n_inverse != 0) {
                double aux = Transformation.this.consistencyWeight * 2.0;
                int k8 = 0;
                while (k8 < this.grad_inverse.length) {
                    int n = k8++;
                    this.grad_inverse[n] = this.grad_inverse[n] * aux;
                }
            }
            this.result[0] = f_direct;
            this.result[1] = n_direct;
            this.result[2] = f_inverse;
            this.result[3] = n_inverse;
        }
    }

    private class EvaluateSimilarityTile
    implements Runnable {
        final BSplineModel auxTarget;
        final BSplineModel auxSource;
        final ROI2D auxTargetMsk;
        final ROI2D auxSourceMsk;
        final BSplineModel swx;
        final BSplineModel swy;
        final double auxFactorWidth;
        final double auxFactorHeight;
        final int intervals;
        final double[] grad;
        final double[] result;
        final Rectangle rect;

        EvaluateSimilarityTile(BSplineModel auxTarget, BSplineModel auxSource, ROI2D auxTargetMsk, ROI2D auxSourceMsk, BSplineModel swx, BSplineModel swy, double auxFactorWidth, double auxFactorHeight, int intervals, double[] grad, double[] result, Rectangle rect) {
            this.auxTarget = auxTarget;
            this.auxSource = auxSource;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.swx = swx;
            this.swy = swy;
            this.auxFactorWidth = auxFactorWidth;
            this.auxFactorHeight = auxFactorHeight;
            this.intervals = intervals;
            this.grad = grad;
            this.result = result;
            this.rect = rect;
        }

        @Override
        public void run() {
            int cYdim;
            int cXdim = cYdim = this.intervals + 3;
            int Nk = cYdim * cXdim;
            int twiceNk = 2 * Nk;
            double imageSimilarity = 0.0;
            int uv = this.rect.y * this.rect.width + this.rect.x;
            int Ydim = this.rect.y + this.rect.height;
            int Xdim = this.rect.x + this.rect.width;
            int n = 0;
            double[] I1D = new double[2];
            double[] targetCurrentImage = this.auxTarget.getCurrentImage();
            int v = this.rect.y;
            while (v < Ydim) {
                int u = this.rect.x;
                while (u < Xdim) {
                    if (this.auxTargetMsk == null || this.auxTargetMsk.contains((double)u / this.auxFactorWidth, (double)v / this.auxFactorHeight)) {
                        double I2 = targetCurrentImage[uv];
                        double x = this.swx.precomputedInterpolateI(u, v);
                        double y = this.swy.precomputedInterpolateI(u, v);
                        if (this.auxSourceMsk == null || this.auxSourceMsk.contains(x / this.auxFactorWidth, y / this.auxFactorHeight)) {
                            double I1 = this.auxSource.prepareForInterpolationAndInterpolateIAndD(x, y, I1D, false, true);
                            double I1dx = I1D[0];
                            double I1dy = I1D[1];
                            double error = I2 - I1;
                            double error2 = error * error;
                            imageSimilarity += error2;
                            int l = 0;
                            while (l < 4) {
                                int m = 0;
                                while (m < 4) {
                                    if (this.swx.prec_yIndex[v][l] != -1 && this.swx.prec_xIndex[u][m] != -1) {
                                        double weightI = this.swx.precomputedGetWeightI(l, m, u, v);
                                        int k = this.swx.prec_yIndex[v][l] * cYdim + this.swx.prec_xIndex[u][m];
                                        double aux = -error * weightI;
                                        int n2 = k;
                                        this.grad[n2] = this.grad[n2] + aux * I1dx;
                                        int n3 = k + Nk;
                                        this.grad[n3] = this.grad[n3] + aux * I1dy;
                                    }
                                    ++m;
                                }
                                ++l;
                            }
                            ++n;
                        }
                    }
                    ++u;
                    ++uv;
                }
                ++v;
            }
            if (n != 0) {
                imageSimilarity *= Transformation.this.imageWeight;
                double aux = Transformation.this.imageWeight * 2.0;
                int k = 0;
                while (k < twiceNk) {
                    int n4 = k++;
                    this.grad[n4] = this.grad[n4] * aux;
                }
            } else {
                imageSimilarity = 1.0 / FLT_EPSILON;
            }
            this.result[0] = imageSimilarity;
            this.result[1] = n;
        }
    }

    private class OutputTileMaker
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel auxSource;
        final BSplineModel auxTarget;
        final ROI2D auxTargetMsk;
        final ROI2D auxSourceMsk;
        final double auxFactorWidth;
        final double auxFactorHeight;
        final int auxTargetCurrentHeight;
        final int auxTargetCurrentWidth;
        final Rectangle rect;
        private final IcyBufferedImage fp;

        OutputTileMaker(BSplineModel swx, BSplineModel swy, BSplineModel auxSource, BSplineModel auxTarget, ROI2D auxSourceMsk, ROI2D auxTargetMsk, double auxFactorWidth, double auxFactorHeight, int auxTargetCurrentHeight, int auxTargetCurrentWidth, Rectangle rect, IcyBufferedImage fp) {
            this.swx = swx;
            this.swy = swy;
            this.auxSource = auxSource;
            this.auxTarget = auxTarget;
            this.auxTargetMsk = auxTargetMsk;
            this.auxSourceMsk = auxSourceMsk;
            this.auxFactorWidth = auxFactorWidth;
            this.auxFactorHeight = auxFactorHeight;
            this.auxTargetCurrentWidth = auxTargetCurrentWidth;
            this.auxTargetCurrentHeight = auxTargetCurrentHeight;
            this.rect = rect;
            this.fp = fp;
        }

        @Override
        public void run() {
            int uv = this.rect.y * this.rect.width + this.rect.x;
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            int subFactorT = this.auxTarget.getOriginalImageWidth() / this.auxTarget.getSubWidth();
            int subFactorS = this.auxSource.getOriginalImageWidth() / this.auxSource.getSubWidth();
            boolean fromSubT = this.auxTarget.isSubOutput();
            boolean fromSubS = this.auxSource.isSubOutput();
            double[] tImage = fromSubT ? this.auxTarget.getSubImage() : this.auxTarget.getImage();
            float[] f_array = this.fp.getDataXYAsFloat(0);
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    if (this.auxTargetMsk == null || this.auxTargetMsk.contains((double)(u * subFactorT), (double)(v * subFactorT))) {
                        double down_u = (double)u * this.auxFactorWidth;
                        double down_v = (double)v * this.auxFactorHeight;
                        double tv = down_v * (double)Transformation.this.intervals / (double)(this.auxTargetCurrentHeight - 1) + 1.0;
                        double tu = down_u * (double)Transformation.this.intervals / (double)(this.auxTargetCurrentWidth - 1) + 1.0;
                        double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, fromSubT, false);
                        double y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, fromSubT, false);
                        double up_x = x / this.auxFactorWidth;
                        double up_y = y / this.auxFactorHeight;
                        if (this.auxSourceMsk == null || this.auxSourceMsk.contains(up_x * (double)subFactorS, up_y * (double)subFactorS)) {
                            double sourceValue = this.auxSource.prepareForInterpolationAndInterpolateI(up_x, up_y, fromSubS, false);
                            f_array[u_rect + v_offset] = (float)(tImage[uv] - sourceValue);
                        } else {
                            f_array[u_rect + v_offset] = 0.0f;
                        }
                    } else {
                        f_array[u_rect + v_offset] = 0.0f;
                    }
                    ++u;
                    ++uv;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }
}

