/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.registration.bunwarp;

import algorithms.danyfel80.registration.bunwarp.BUnwarpper;
import algorithms.danyfel80.registration.bunwarp.MaximumScaleDeformationEnum;
import algorithms.danyfel80.registration.bunwarp.MinimumScaleDeformationEnum;
import algorithms.danyfel80.registration.bunwarp.RegistrationModeEnum;
import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.danyfel80.registration.bunwarp.BUnwarp;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class BUnwarpSimple
extends BUnwarp {
    EzVarSequence inSrcSeq = new EzVarSequence("Source");
    EzVarSequence inTgtSeq = new EzVarSequence("Target");
    EzVarEnum<RegistrationModeEnum> inMode = new EzVarEnum("Mode", (Enum[])RegistrationModeEnum.values(), (Enum)RegistrationModeEnum.ACCURATE);
    EzVarInteger inSubsampleFactor = new EzVarInteger("Image Subsampling Factor", 0, 0, 7, 1);
    EzVarSequence inSrcTgtSeq = new EzVarSequence("Transformation Source");
    EzVarSequence inTgtTgtSeq = new EzVarSequence("Transformation Target");
    EzVarEnum<MinimumScaleDeformationEnum> inIniDef = new EzVarEnum("Initial deformation", (Enum[])MinimumScaleDeformationEnum.values(), (Enum)MinimumScaleDeformationEnum.VERY_COARSE);
    EzVarEnum<MaximumScaleDeformationEnum> inFnlDef = new EzVarEnum("Final Deformation", (Enum[])MaximumScaleDeformationEnum.values(), (Enum)MaximumScaleDeformationEnum.FINE);
    EzVarDouble inDivWeight = new EzVarDouble("Divergence Weight");
    EzVarDouble inCurlWeight = new EzVarDouble("Curl Weight");
    EzVarDouble inLandmarkWeight = new EzVarDouble("Landmark Weight");
    EzVarDouble inImageWeight = new EzVarDouble("Image Weight");
    EzVarDouble inConsistencyWeight = new EzVarDouble("Consistency Weight");
    EzGroup weightsGroup = new EzGroup("Weights", new EzComponent[]{this.inDivWeight, this.inCurlWeight, this.inLandmarkWeight, this.inImageWeight, this.inConsistencyWeight});
    EzVarDouble inStopThreshold = new EzVarDouble("Stop Threshold");
    EzVarBoolean inShowProcess = new EzVarBoolean("Show Process", false);
    EzGroup outputSequenceGroup = new EzGroup("Transformed Output", new EzComponent[]{this.inSrcTgtSeq, this.inTgtTgtSeq});
    EzGroup advancedParamsGroup = new EzGroup("Advanced Parameters", new EzComponent[]{this.inIniDef, this.inFnlDef, this.outputSequenceGroup, this.weightsGroup, this.inStopThreshold, this.inShowProcess});
    VarSequence outSrcSeq = new VarSequence("Source Registered", null);
    VarSequence outTgtSeq = new VarSequence("Target Registered", null);
    Var<double[][]> outCxSourceToTarget = new Var("Cx Source to Target", (Object)new double[1][1]);
    Var<double[][]> outCySourceToTarget = new Var("Cy Source to Target", (Object)new double[1][1]);
    Var<double[][]> outCxTargetToSource = new Var("Cx Target to Source", (Object)new double[1][1]);
    Var<double[][]> outCyTargetToSource = new Var("Cy Target to Source", (Object)new double[1][1]);
    VarInteger outIntervals = new VarInteger("Transform intervals", 0);
    Sequence srcSeq;
    Sequence tgtSeq;
    Sequence srcTgtSeq;
    Sequence tgtTgtSeq;
    IcyBufferedImage originalSrcIBI;
    IcyBufferedImage originalTgtIBI;
    BUnwarpper bu;
    Thread but;

    public void declareInput(VarList inputMap) {
        inputMap.add(this.inSrcSeq.name, (Var)this.inSrcSeq.getVariable());
        inputMap.add(this.inTgtSeq.name, (Var)this.inTgtSeq.getVariable());
        inputMap.add(this.inSrcTgtSeq.name, (Var)this.inSrcTgtSeq.getVariable());
        inputMap.add(this.inTgtTgtSeq.name, (Var)this.inTgtTgtSeq.getVariable());
        inputMap.add(this.inMode.name, this.inMode.getVariable());
        inputMap.add(this.inSubsampleFactor.name, this.inSubsampleFactor.getVariable());
        inputMap.add(this.inIniDef.name, this.inIniDef.getVariable());
        inputMap.add(this.inFnlDef.name, this.inFnlDef.getVariable());
        inputMap.add(this.inDivWeight.name, this.inDivWeight.getVariable());
        inputMap.add(this.inCurlWeight.name, this.inCurlWeight.getVariable());
        inputMap.add(this.inLandmarkWeight.name, this.inLandmarkWeight.getVariable());
        inputMap.add(this.inImageWeight.name, this.inImageWeight.getVariable());
        inputMap.add(this.inConsistencyWeight.name, this.inConsistencyWeight.getVariable());
        inputMap.add(this.inStopThreshold.name, this.inStopThreshold.getVariable());
        inputMap.add(this.inShowProcess.name, this.inShowProcess.getVariable());
        this.inDivWeight.setValue((Object)0.0);
        this.inCurlWeight.setValue((Object)0.0);
        this.inLandmarkWeight.setValue((Object)0.0);
        this.inImageWeight.setValue((Object)1.0);
        this.inConsistencyWeight.setValue((Object)10.0);
        this.inStopThreshold.setValue((Object)0.01);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.outSrcSeq.getName(), (Var)this.outSrcSeq);
        outputMap.add(this.outTgtSeq.getName(), (Var)this.outTgtSeq);
        outputMap.add(this.outCxSourceToTarget.getName(), this.outCxSourceToTarget);
        outputMap.add(this.outCySourceToTarget.getName(), this.outCySourceToTarget);
        outputMap.add(this.outCxTargetToSource.getName(), this.outCxTargetToSource);
        outputMap.add(this.outCyTargetToSource.getName(), this.outCyTargetToSource);
        outputMap.add(this.outIntervals.getName(), (Var)this.outIntervals);
    }

    protected void initialize() {
        this.inSrcSeq.setToolTipText("Source(floating) sequence used to perform the registration.");
        this.inTgtSeq.setToolTipText("Target(fixed) sequence used to perform the registration.");
        this.inMode.setToolTipText("Mode of interpolation: Mono uses source -> target transformation. Fast or Accurate use source <-> target transformation.");
        this.inSubsampleFactor.setToolTipText("Level of subsampling of the source and target sequences to perform the registration.");
        this.inSrcTgtSeq.setToolTipText("Sequence used to apply source transformation.");
        this.inTgtTgtSeq.setToolTipText("Sequence used to apply target transformation.");
        this.inIniDef.setToolTipText("Sets the initial transformation detail.");
        this.inFnlDef.setToolTipText("Sets the final transformation detail.");
        this.inDivWeight.setToolTipText("Weight related to the divergence of the tensors in the transformation. Higher value means result will have less divergence.");
        this.inCurlWeight.setToolTipText("Weight related to the curl of the tensors in the transformation. Higher value means result will have less curl.");
        this.inLandmarkWeight.setToolTipText("Weight related to landmarks present on the sequence. Higher value means landmarks have more impact on the result. Landmarks must be ROI2DPoints in the sequence.");
        this.inImageWeight.setToolTipText("Weight related to image intensities. Higher value means image intensities will have more impact on the result.");
        this.inConsistencyWeight.setToolTipText("When the mode is set to Fast or Accurate, this weight represents the similarity constraint on the s->t and t->s transformations. The higher the value, the more similar the transformations will be.");
        this.inStopThreshold.setToolTipText("This is the optimization stop criteria. When the optimization changes the transformation less than the given value, the process ends and the result is shown.");
        this.inShowProcess.setToolTipText("If checked, more details of the transformation will be shown at the end of the procedure.");
        this.addEzComponent((EzComponent)this.inSrcSeq);
        this.addEzComponent((EzComponent)this.inTgtSeq);
        this.addEzComponent((EzComponent)this.inMode);
        this.addEzComponent((EzComponent)this.inSubsampleFactor);
        this.outputSequenceGroup.setFoldedState(true);
        this.weightsGroup.setFoldedState(true);
        this.advancedParamsGroup.setFoldedState(true);
        this.addEzComponent((EzComponent)this.advancedParamsGroup);
        this.inDivWeight.setValue((Object)0.0);
        this.inCurlWeight.setValue((Object)0.0);
        this.inLandmarkWeight.setValue((Object)0.0);
        this.inImageWeight.setValue((Object)1.0);
        this.inConsistencyWeight.setValue((Object)10.0);
        this.inStopThreshold.setValue((Object)0.01);
        this.inMode.addVarChangeListener((EzVarListener)new EzVarListener<RegistrationModeEnum>(){

            public void variableChanged(EzVar<RegistrationModeEnum> source, RegistrationModeEnum newValue) {
                BUnwarpSimple.this.inConsistencyWeight.setEnabled(newValue != RegistrationModeEnum.MONO);
            }
        });
        this.inMode.setValue((Object)RegistrationModeEnum.MONO);
    }

    protected void execute() {
        BUnwarpper buLocal;
        ArrayList<Point2D.Double> pts;
        this.isPluginInterrupted = false;
        if (this.validateInput() != 0) {
            return;
        }
        this.srcSeq = (Sequence)this.inSrcSeq.getValue();
        this.tgtSeq = (Sequence)this.inTgtSeq.getValue();
        this.srcTgtSeq = (Sequence)this.inSrcTgtSeq.getValue();
        this.tgtTgtSeq = (Sequence)this.inTgtTgtSeq.getValue();
        if (this.srcTgtSeq == null) {
            this.srcTgtSeq = this.srcSeq;
        }
        if (this.tgtTgtSeq == null) {
            this.tgtTgtSeq = this.tgtSeq;
        }
        this.originalSrcIBI = this.srcSeq.getFirstImage();
        this.originalTgtIBI = this.tgtSeq.getFirstImage();
        List srcLandmarks = this.srcSeq.getROIs(ROI2DPoint.class);
        List tgtLandmarks = this.tgtSeq.getROIs(ROI2DPoint.class);
        Comparator<ROI> comp = new Comparator<ROI>(){

            @Override
            public int compare(ROI o1, ROI o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        srcLandmarks.sort(comp);
        tgtLandmarks.sort(comp);
        ROI2DPolygon srcMask = null;
        ROI2DPolygon tgtMask = null;
        if (this.srcSeq.getROICount(ROI2DPolygon.class) > 0) {
            srcMask = (ROI2DPolygon)this.srcSeq.getROIs(ROI2DPolygon.class).get(0);
        }
        if (this.tgtSeq.getROICount(ROI2DPolygon.class) > 0) {
            tgtMask = (ROI2DPolygon)this.tgtSeq.getROIs(ROI2DPolygon.class).get(0);
        }
        if (srcMask == null) {
            pts = new ArrayList<Point2D.Double>();
            pts.add(new Point2D.Double(0.0, 0.0));
            pts.add(new Point2D.Double(0.0, this.srcSeq.getHeight()));
            pts.add(new Point2D.Double(this.srcSeq.getWidth(), this.srcSeq.getHeight()));
            pts.add(new Point2D.Double(this.srcSeq.getWidth(), 0.0));
            srcMask = new ROI2DPolygon(pts);
        }
        if (tgtMask == null) {
            pts = new ArrayList();
            pts.add(new Point2D.Double(0.0, 0.0));
            pts.add(new Point2D.Double(0.0, this.tgtSeq.getHeight()));
            pts.add(new Point2D.Double(this.tgtSeq.getWidth(), this.tgtSeq.getHeight()));
            pts.add(new Point2D.Double(this.tgtSeq.getWidth(), 0.0));
            tgtMask = new ROI2DPolygon(pts);
        }
        this.bu = buLocal = new BUnwarpper(this.srcSeq, this.tgtSeq, srcLandmarks, tgtLandmarks, (ROI2D)srcMask, (ROI2D)tgtMask, (Integer)this.inSubsampleFactor.getValue(), ((MinimumScaleDeformationEnum)((Object)this.inIniDef.getValue())).getNumber(), ((MaximumScaleDeformationEnum)((Object)this.inFnlDef.getValue())).getNumber(), 0, (Double)this.inDivWeight.getValue(), (Double)this.inCurlWeight.getValue(), (Double)this.inLandmarkWeight.getValue(), (Double)this.inImageWeight.getValue(), (Double)this.inConsistencyWeight.getValue(), (Double)this.inStopThreshold.getValue(), (Boolean)this.inShowProcess.getValue() != false ? 2 : 1, (Boolean)this.inShowProcess.getValue(), ((RegistrationModeEnum)((Object)this.inMode.getValue())).getNumber(), this);
        this.but = new Thread(this.bu);
        this.but.start();
        try {
            this.but.join();
            this.but = null;
        }
        catch (InterruptedException e) {
            System.err.println("Thread interrupted: " + e.getMessage());
        }
        if (!this.isPluginInterrupted) {
            Sequence srcTgtCopySeq = SequenceUtil.getCopy((Sequence)this.srcTgtSeq);
            this.bu.getRegisteredSource(srcTgtCopySeq);
            this.outSrcSeq.setValue(this.srcTgtSeq);
            this.addSequence(srcTgtCopySeq);
            this.outCxSourceToTarget.setValue((Object)this.bu.getCxSourceToTarget());
            this.outCySourceToTarget.setValue((Object)this.bu.getCxSourceToTarget());
            this.outIntervals.setValue((Object)this.bu.getIntervals());
            if (this.inMode.getValue() != RegistrationModeEnum.MONO) {
                Sequence tgtTgtCopySeq = SequenceUtil.getCopy((Sequence)this.tgtTgtSeq);
                this.bu.getRegisteredTarget(tgtTgtCopySeq);
                this.outTgtSeq.setValue(tgtTgtCopySeq);
                this.addSequence(tgtTgtCopySeq);
                this.outCxTargetToSource.setValue((Object)this.bu.getCxSourceToTarget());
                this.outCyTargetToSource.setValue((Object)this.bu.getCxSourceToTarget());
            }
        }
    }

    private int validateInput() {
        if (this.inSrcSeq.getValue() == null || this.inTgtSeq.getValue() == null) {
            MessageDialog.showDialog((String)"Error", (String)"Please choose two valid images", (int)0);
            return 1;
        }
        if (((Sequence)this.inSrcSeq.getValue()).getROICount(ROI2DPolygon.class) > 1 || ((Sequence)this.inTgtSeq.getValue()).getROICount(ROI2DPolygon.class) > 1) {
            MessageDialog.showDialog((String)"Error", (String)"Please define a single mask for each input sequence.", (int)0);
            return 2;
        }
        return 0;
    }

    public void stopExecution() {
        this.isPluginInterrupted = true;
        if (this.but != null && this.but.isAlive()) {
            try {
                this.but.join();
                this.but = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void clean() {
    }

    @Override
    public void restoreAll() {
        this.ungrayInputImages();
        if (this.getUI() != null) {
            this.getUI().setProgressBarMessage("");
            this.getUI().setProgressBarValue(0.0);
        }
        Runtime.getRuntime().gc();
    }

    private void ungrayInputImages() {
        this.srcSeq.setImage(0, 0, (BufferedImage)this.originalSrcIBI);
        this.tgtSeq.setImage(0, 0, (BufferedImage)this.originalTgtIBI);
    }
}

