package plugins.ylemontag.sequencecomparator.gui;

import icy.gui.main.MainAdapter;
import icy.gui.main.MainEvent;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceAdapter;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.util.ArrayList;
import java.util.WeakHashMap;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import plugins.ylemontag.sequencecomparator.LocalComparisonPool;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Component displaying the list of all opened sequences that can be used as
 * a reference
 */
public class ReferenceSequenceComponent extends JComboBox
{
	private static final long serialVersionUID = 1L;
	
	private DefaultComboBoxModel _model;
	private WeakHashMap<Sequence, SequenceListener> _sequenceChangeListeners;
	
	/**
	 * Constructor
	 */
	public ReferenceSequenceComponent()
	{
		super();
		_sequenceChangeListeners = new WeakHashMap<Sequence, SequenceListener>();
		_model = new DefaultComboBoxModel();
		setModel(_model);
		initModel();
		Icy.getMainInterface().addListener(new MainAdapter()
		{	
			@Override
			public void sequenceOpened(MainEvent event) {
				Sequence seq = (Sequence)event.getSource();
				registerSequence(seq);
			}
			
			@Override
			public void sequenceClosed(MainEvent event) {
				Sequence seq = (Sequence)event.getSource();
				unregisterSequence(seq);
			}
		});
	}
	
	/**
	 * Return the selected object
	 */
	public Sequence getSelectedObject()
	{
		return (Sequence)getSelectedItem();
	}
	
	/**
	 * Feed the model with the list of opened sequences
	 */
	private void initModel()
	{
		ArrayList<Sequence> sequences = Icy.getMainInterface().getSequences();
		for(Sequence seq : sequences) {
			registerSequence(seq);
		}
	}
	
	/**
	 * Append a sequence to the list if it can be used as a reference
	 */
	private void registerSequence(Sequence seq)
	{
		if(LocalComparisonPool.getAllErrorMaps().contains(seq)) {
			return;
		}
		_model.addElement(seq);
		SequenceListener l = new SequenceAdapter()
		{
			@Override
			public void sequenceChanged(SequenceEvent sequenceEvent) {
				ReferenceSequenceComponent.this.repaint();
			}
		};
		_sequenceChangeListeners.put(seq, l);
		seq.addListener(l);
	}
	
	/**
	 * Remove a sequence from the list
	 */
	private void unregisterSequence(Sequence seq)
	{
		SequenceListener l = _sequenceChangeListeners.get(seq);
		if(l!=null) {
			seq.removeListener(l);
		}
		_model.removeElement(seq);
	}
}
