package plugins.ylemontag.sequencecomparator;

import plugins.ylemontag.ssim.SSIMCalculator;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Used in the ComparatorFactory to set the parameters that may be required
 * when creating a new instance of a comparator
 */
public interface ParameterProvider
{
	/**
	 * Parameter associated to the PSNR comparator
	 */
	public double getPSNRDynamicRange();
	
	/**
	 * Parameters associated to SSIM-based comparators
	 */
	public SSIMCalculator getSSIMCalculator();
}
