package plugins.spop.trackprocessorZclip;

import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.nchenouard.spot.Detection;

public class TrackProcessorZClip extends PluginTrackManagerProcessor
  implements ActionListener, SequenceListener, ViewerListener
{
  
  JTextField clipZTextField = new JTextField(" 5");


  public TrackProcessorZClip()
  {
    setName("Track Z Clipper");

    this.panel.setLayout(new GridLayout(1, 1));
        
    JPanel clipZPanel = new JPanel(new FlowLayout(3));
    clipZPanel.add(new JLabel("Show Detections in "));
    clipZPanel.add(this.clipZTextField);
    clipZPanel.add(new JLabel("slices before & after current Z slice"));
    this.panel.add(clipZPanel);

  
  }

  public void Compute()
  {
    if (this.trackPool.getDisplaySequence() != null)
    {
      this.trackPool.getDisplaySequence().removeListener(this);
      this.trackPool.getDisplaySequence().addListener(this);

      ((Viewer)this.trackPool.getDisplaySequence().getViewers().get(0)).removeListener(this);
      ((Viewer)this.trackPool.getDisplaySequence().getViewers().get(0)).addListener(this);
    }

    if (isEnabled())
    {
            
      int clipZValue = 5;
      try
      {
        clipZValue = new Integer(this.clipZTextField.getText()).intValue();
      }
      catch (Exception e)
      {
        clipZValue = 5;
      }

      ArrayList<Viewer> viewerList = Icy.getMainInterface().getViewers(this.trackPool.getDisplaySequence());
            
      int z = 0;
      try
      {
        z = ((Viewer)viewerList.get(0)).getZ();
      }
      catch (IndexOutOfBoundsException e)
      {
        z = 0;
      }
      catch (NullPointerException e)
      {
        z = 0;
      }
             

	    for (Detection d : this.trackPool.getAllDetection())
	    {
	      if (d.getZ() < z - clipZValue) d.setEnabled(false);
	      if (d.getZ() > z + clipZValue) d.setEnabled(false);
	     
	    }
     
    }
  }

  public void actionPerformed(ActionEvent e)
  {
    this.trackPool.fireTrackEditorProcessorChange();
  }

  public void Close()
  {
  }

  public void displaySequenceChanged()
  {
    for (Sequence sequence : Icy.getMainInterface().getSequences())
    {
      sequence.removeListener(this);
    }

    Sequence displaySequence = this.trackPool.getDisplaySequence();
    if (displaySequence != null)
    {
      this.trackPool.getDisplaySequence().addListener(this);
    }
  }

  public void sequenceChanged(SequenceEvent sequenceEvent)
  {
    for (Viewer viewer : Icy.getMainInterface().getViewers())
    {
      viewer.removeListener(this);
    }
    ((Viewer)this.trackPool.getDisplaySequence().getViewers().get(0)).addListener(this);
  }

  public void sequenceClosed(Sequence sequence)
  {
  }

  public void viewerChanged(ViewerEvent event)
  {
    if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED)
    {
      this.trackPool.fireTrackEditorProcessorChange();
    }
  }

  public void viewerClosed(Viewer viewer)
  {
  }
}