package plugins.fab.screenshot;

import java.awt.image.BufferedImage;
import java.io.IOException;

import loci.formats.FormatException;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarSequence;
import icy.canvas.Canvas2D;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;

/**
 * 
 * @author Fabrice de Chaumont
 *
 */
public class ScreenShot extends EzPlug {

	EzVarSequence sequenceChooser = new EzVarSequence("");
	
	EzVarDouble magnificationGUI = new EzVarDouble("Magnification" , 1 , 0 , 10000, 0.01 );
	
	@Override
	protected void initialize() {

		addEzComponent( sequenceChooser );
		addEzComponent( magnificationGUI );
		
	}

	@Override
	protected void execute() {
		
		ThreadUtil.invokeNow( new Runnable() {
			
			@Override
			public void run() {

				double magnification = magnificationGUI.getValue();
				Sequence sequence = sequenceChooser.getValue();
				
				Viewer viewer = new Viewer( sequence , false );
				viewer.setCanvas( new Canvas2D( viewer ) );
				Canvas2D canvas = (Canvas2D) viewer.getCanvas();

				viewer.setSize( (int)(sequence.getWidth() * magnification) , (int)(sequence.getHeight() * magnification ));									
				
				Viewer currentViewer = Icy.getMainInterface().getViewers( sequence ).get( 0 );
								
				copyLayerState( currentViewer, viewer );				
				
				canvas.setScale( magnification , magnification , true, false );
				canvas.setOffset( 0 , 0, false );
				BufferedImage renderedImage = canvas.getRenderedImage( currentViewer.getT() , currentViewer.getZ() , true );

				// Output
				
				Sequence outSeq = new Sequence( IcyBufferedImage.createFrom( renderedImage ) );
				addSequence( outSeq );
				
				viewer.close();
				
			}
		});
		
		
		
	}
	
	/**
	 * Copy the sourceViewer layer visibility in the target Viewer.
	 */
	void copyLayerState( Viewer sourceViewer , Viewer targetViewer )
	{
		Canvas2D sourceCanvas = (Canvas2D) sourceViewer.getCanvas();
		Canvas2D targetCanvas = (Canvas2D) targetViewer.getCanvas();
		
		for ( Painter painter : sourceViewer.getSequence().getPainters() )
		{
			targetCanvas.getLayer( painter ).setVisible( sourceCanvas.getLayer( painter ).isVisible() );
			targetCanvas.getLayer( painter ).setAlpha( sourceCanvas.getLayer( painter ).getAlpha() );			
		}
		
	}
	

	@Override
	public void clean() {
		
	}
}
