package plugins.adufour.activemeshes;

import icy.swimmingPool.SwimmingObject;

import java.util.ArrayList;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class MeshProcessor extends EzPlug
{
    EzVarSwimmingObject<TrackGroup> reader = new EzVarSwimmingObject<TrackGroup>("Object to extract:");
    
    @Override
    protected void initialize()
    {
        addEzComponent(reader);
    }
    
    @Override
    protected void execute()
    {
        SwimmingObject swObject = reader.getValue();
        // the reader automatically restricts to TrackGroup objects
        // => a direct cast is ok
        TrackGroup trackGroup = (TrackGroup) swObject.getObject();
        
        // each track of a group is a time-line "segment"
        ArrayList<TrackSegment> segments = trackGroup.getTrackSegmentList();
        
        // there are as many segments as objects
        
        for (int track = 0; track < segments.size(); track++)
        {
            System.out.println("processing track #" + track);
            TrackSegment segment = segments.get(track);
            
            // Each segment holds the list of detections for one single object at all known time points
            ArrayList<Detection> detections = segment.getDetectionList();
            
            for (int det = 0; det < detections.size(); det++)
            {
                Detection detection = detections.get(det);
                System.out.println(" -> processing detection #" + det + "(T=" + detection.getT() + ")");
                
                // a Detection is just an interface masking the real object type
                if (detection instanceof Mesh)
                {
                    Mesh mesh = (Mesh) detection;
                    
                    process(mesh);
                }
            }
        }
    }
    
    @Override
    public void clean()
    {
    }
    
    private void process(Mesh mesh)
    {
        // TODO have fun!
    }
    
}
