package plugins.fab.ringroi;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;

import java.awt.Color;
import java.util.ArrayList;

import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;

public class RingROI extends EzPlug {

	EzVarSequence sequenceVar = new EzVarSequence("Input Sequence");
	EzVarBoolean colorRingVar = new EzVarBoolean("Color ring", true );
	ArrayList<ROIDescriptor> ROIDescriptorList;
	
	@Override
	public void clean() {
		

	}

	class ROIDescriptor
	{
		int surface;
		ROI2D roi;

		public ROIDescriptor(int roiSurface, ROI2D roiInput)
		{
			this.surface = roiSurface;
			this.roi = roiInput;
		}
	}
	
	@Override
	protected void execute() {

		Sequence sequence = sequenceVar.getValue();
		
		ArrayList<ROI2D> ROIList = sequence.getROI2Ds();
		ArrayList<ROI2D> ROIListOutPut = new ArrayList<ROI2D>();
		
		ROIDescriptorList = new ArrayList<ROIDescriptor>();
		
		// order ROI by size
				
		for ( ROI2D roiInput : ROIList )
		{
			ROIDescriptor roiDescriptor = new ROIDescriptor( getROISurface( roiInput ) , roiInput );	
			ROIDescriptorList.add( roiDescriptor );
		}
		
		// for each ROI, soustract the most bigger of the smaller existing ROI.

		for ( ROI2D roiInput : ROIList )
		{
			ROI2D roiSubstract = getROItoSubstract( roiInput , ROIList );
			
			if ( roiSubstract != null )
			{
				ROI2D ring = ROI2D.substract( roiInput , roiSubstract );
				ROIListOutPut.add( ring );
			}else
			{
				ROIListOutPut.add( roiInput );
			}
		}
				
		sequence.removeAllROI();
		
		if ( colorRingVar.getValue() )
		{
			float hue=0;
			for ( ROI2D roi  : ROIListOutPut )
			{				
				hue+= 1f / ROIListOutPut.size();			
				roi.setColor( Color.getHSBColor( hue , 1 , 1 ) );				
			}
		}
		
		for( ROI2D roi : ROIListOutPut )
		{
			sequence.addROI(roi);
		}		
		
	}

	private ROI2D getROItoSubstract(ROI2D roiInput, ArrayList<ROI2D> ROIList) {

		int surfaceInput = 0;
		for ( ROIDescriptor roiDescriptor : ROIDescriptorList )
		{
			if ( roiDescriptor.roi == roiInput )
			{
				surfaceInput = roiDescriptor.surface;
				break;
			}
		}

		int bestSurface = 0;
		ROI2D bestROI = null;
		
		for ( ROIDescriptor roiDescriptor : ROIDescriptorList )
		{
			int surface = roiDescriptor.surface; //getROISurface( roi );

			if ( surface > bestSurface && surface < surfaceInput )
			{
				bestSurface = surface;
				bestROI = roiDescriptor.roi;
			}
		}

		return bestROI;
		
	}

	int getROISurface( ROI roi )
	{
		if( roi instanceof ROI2D )
		{
			ROI2D roi2D = (ROI2D) roi;
			boolean[] bool = roi2D.getAsBooleanMask( roi2D.getBounds() );

			int surface = 0;
			for ( int x = 0 ; x < bool.length ; x++ )
			{
				if ( bool[x] ) surface++;
			}
			return surface;
		}
		return 0;
	}
	
	@Override
	protected void initialize() {

		addEzComponent( sequenceVar );
		addEzComponent( colorRingVar );
		
	}

}
