/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.compactionProfiler;

import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import plugins.nchenouard.particleTracking.DetectionChooser;
import plugins.nchenouard.spot.DetectionResult;

public class PanelCompaction
extends JPanel {
    private static final long serialVersionUID = 1480638258136975891L;
    public JButton compactionStartButton = new JButton("Start");
    public JButton compactionStopButton = new JButton("Stop");
    Dimension boxDim = new Dimension(127, 23);
    JRadioButton Intensity = new JRadioButton("Test the intensity compaction");
    JRadioButton Surface = new JRadioButton("Test the surface compaction");
    ButtonGroup buttonGroup = new ButtonGroup();
    JButton startButton = new JButton("Start");
    JCheckBox displayConvexHull = new JCheckBox("Display surface", false);
    JCheckBox saveResults = new JCheckBox("Save results in XLS files", false);
    JTextField compactionTextField = new JTextField("0.8");
    JLabel errorLabel = new JLabel("");
    JLabel compactionNumber = new JLabel("compaction coefficient");
    static DetectionChooser detectionChooser;
    JCheckBox erasePreExistingTrackCheckBox = new JCheckBox("Erase pre-exisiting tracks", true);

    public DetectionResult getDetectionResult() {
        return detectionChooser.getSelectedDetectionResult();
    }

    public PanelCompaction() {
        this.setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel(new FlowLayout(4));
        buttonPane.add(this.compactionStartButton);
        buttonPane.add(this.compactionStopButton);
        detectionChooser = new DetectionChooser();
        JPanel detectionChooserPanel = new JPanel();
        detectionChooserPanel.setLayout(new BoxLayout(detectionChooserPanel, 3));
        detectionChooserPanel.setBorder(new TitledBorder("Detection source"));
        detectionChooserPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{detectionChooser}));
        detectionChooserPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.erasePreExistingTrackCheckBox}));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        this.buttonGroup.add(this.Intensity);
        this.buttonGroup.add(this.Surface);
        this.Intensity.setSelected(true);
        ComponentUtil.setFixedHeight((Component)this.compactionTextField, (int)22);
        this.errorLabel.setAlignmentX(0.0f);
        this.errorLabel.setForeground(Color.red);
        centerPanel.add(Box.createVerticalStrut(5));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.Intensity, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.Surface, Box.createHorizontalGlue()}));
        centerPanel.add(Box.createVerticalStrut(5));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalGlue(), this.compactionNumber, this.compactionTextField, this.errorLabel, Box.createHorizontalGlue()}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.displayConvexHull}));
        centerPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.saveResults}));
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{detectionChooserPanel}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{centerPanel}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{buttonPane}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    public boolean erasePreExistingTrack() {
        return this.erasePreExistingTrackCheckBox.isSelected();
    }

    public double getCompactionNumber() {
        double number;
        try {
            number = Double.parseDouble(this.compactionTextField.getText());
            if (this.errorLabel.getText().length() > 0) {
                this.errorLabel.setText("");
            }
        }
        catch (NumberFormatException nfe) {
            number = 0.8;
            this.errorLabel.setText("value not recognized");
        }
        return number;
    }
}

