/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.compactionProfiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Point
implements Comparable {
    private int x;
    private int y;

    public Point() {
        int borneMax = 499;
        this.x = (int)(Math.random() * (double)borneMax + 1.0);
        this.y = (int)(Math.random() * (double)borneMax + 1.0);
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static boolean isLeft(Point a, Point b, Point c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) >= 0;
    }

    public int compareTo(Object o) {
        Point other = (Point)o;
        int otherX = other.getX();
        if (this.x < otherX) {
            return -1;
        }
        if (this.x == otherX) {
            return 0;
        }
        return 1;
    }

    public static List<Point> getListePointsOrdonnee(int nombrePoints) {
        ArrayList<Point> liste = new ArrayList<Point>();
        int i = 0;
        while (i < nombrePoints) {
            liste.add(new Point());
            ++i;
        }
        Collections.sort(liste);
        return liste;
    }

    public static List<Point> GrahamConvexHull(List<Point> liste) {
        ArrayList<Point> lUpper = new ArrayList<Point>();
        ArrayList<Point> lLower = new ArrayList<Point>();
        int n = liste.size();
        lUpper.add(liste.get(0));
        lUpper.add(liste.get(1));
        int i = 2;
        while (i < n) {
            lUpper.add(liste.get(i));
            while (lUpper.size() > 2 && Point.isLeft((Point)lUpper.get(lUpper.size() - 3), (Point)lUpper.get(lUpper.size() - 2), (Point)lUpper.get(lUpper.size() - 1))) {
                lUpper.remove(lUpper.get(lUpper.size() - 2));
            }
            ++i;
        }
        lLower.add(liste.get(n - 1));
        lLower.add(liste.get(n - 2));
        i = n - 1;
        while (i >= 0) {
            lLower.add(liste.get(i));
            while (lLower.size() > 2 && Point.isLeft((Point)lLower.get(lLower.size() - 3), (Point)lLower.get(lLower.size() - 2), (Point)lLower.get(lLower.size() - 1))) {
                lLower.remove(lLower.get(lLower.size() - 2));
            }
            --i;
        }
        lLower.remove(0);
        lLower.remove(lLower.size() - 1);
        lUpper.addAll(lLower);
        return lUpper;
    }
}

