/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;

public class StackFolderOpener {
    private static boolean grayscale;
    private static boolean halfSize;
    private int n;
    private int start;
    private int increment;
    private String filter;

    public ImageStack open(String string) {
        return this.open(string, true);
    }

    public ImageStack open(String string, boolean bl) {
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return null;
        }
        StringSorter.sort((String[])stringArray);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ImageStack imageStack = null;
        try {
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                ImagePlus imagePlus;
                if (stringArray[n4].endsWith(".txt") || (imagePlus = new Opener().openImage(string, stringArray[n4])) == null) continue;
                n = imagePlus.getWidth();
                n2 = imagePlus.getHeight();
                n3 = imagePlus.getType();
                break;
            }
            this.increment = 1;
            this.n = stringArray.length;
            this.start = 1;
            n4 = 0;
            int n5 = 0;
            for (int i = this.start - 1; i < stringArray.length; ++i) {
                ColorModel colorModel;
                if (!stringArray[i].endsWith(".tif") || n5++ % this.increment != 0) continue;
                ImagePlus imagePlus = new Opener().openImage(string, stringArray[i]);
                if (imagePlus != null && imageStack == null) {
                    n = imagePlus.getWidth();
                    n2 = imagePlus.getHeight();
                    n3 = imagePlus.getType();
                    colorModel = imagePlus.getProcessor().getColorModel();
                    imageStack = new ImageStack(n, n2, colorModel);
                }
                if (imagePlus == null) {
                    if (bl) {
                        IJ.log((String)(stringArray[i] + ": unable to open"));
                    }
                } else if (imagePlus.getWidth() != n || imagePlus.getHeight() != n2) {
                    if (bl) {
                        IJ.log((String)(stringArray[i] + ": wrong dimensions"));
                    }
                } else if (imagePlus.getType() != n3) {
                    if (bl) {
                        IJ.log((String)(stringArray[i] + ": wrong type"));
                    }
                } else {
                    n4 = imageStack.getSize() + 1;
                    if (bl) {
                        IJ.showStatus((String)(n4 + "/" + this.n));
                    }
                    if (bl) {
                        IJ.showProgress((double)((double)n4 / (double)this.n));
                    }
                    colorModel = imagePlus.getProcessor();
                    if (grayscale) {
                        if (this.nonStandardLut((ImageProcessor)colorModel)) {
                            colorModel = new ColorProcessor(imagePlus.getImage());
                        }
                        colorModel = colorModel.convertToByte(true);
                    }
                    imageStack.addSlice(imagePlus.getTitle(), (ImageProcessor)colorModel);
                }
                if (n4 < this.n) {
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (bl) {
                IJ.outOfMemory((String)"FolderOpener");
            }
            imageStack.trim();
        }
        if (bl) {
            IJ.showProgress((double)1.0);
        }
        return imageStack;
    }

    boolean nonStandardLut(ImageProcessor imageProcessor) {
        ColorModel colorModel = imageProcessor.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n = indexColorModel.getMapSize();
        if (n != 256) {
            return true;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = true;
        int n2 = (byArray[1] & 0xFF) - (byArray[0] & 0xFF);
        for (int i = 0; i < 256; ++i) {
            if (byArray[i] != byArray2[i] || byArray2[i] != byArray3[i]) {
                bl = false;
                break;
            }
            if (i <= 0 || (byArray[i] & 0xFF) - (byArray[i - 1] & 0xFF) == n2) continue;
            bl = false;
            break;
        }
        return !bl;
    }
}

