/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.Date;

public final class Chrono {
    protected Date D1 = new Date();
    protected Date D2 = new Date();
    protected int nb_tasks;

    public Chrono() {
        this.nb_tasks = -1;
    }

    public Chrono(int n) {
        this.nb_tasks = n;
    }

    public void start() {
        this.D1 = new Date();
        this.D2 = new Date();
    }

    public void stop() {
        this.D2 = new Date();
    }

    public long delay() {
        return this.D2.getTime() - this.D1.getTime();
    }

    public String delayString() {
        return this.timeString(this.delay());
    }

    public long remain(int n) {
        long l = this.D2.getTime() - this.D1.getTime();
        long l2 = (long)((float)l * ((float)this.nb_tasks / (float)n - 1.0f));
        return l2;
    }

    public String remainString(int n) {
        return this.timeString(this.remain(n));
    }

    public long totalTimeEstimate(int n) {
        long l = this.delay();
        long l2 = (long)((float)l * ((float)this.nb_tasks / (float)n));
        return l2;
    }

    public String totalTimeEstimateString(int n) {
        return this.timeString(this.totalTimeEstimate(n));
    }

    private String timeString(long l) {
        String string;
        if (l < 1000L) {
            string = new String(l + " ms");
        } else {
            long l2 = l / 1000L;
            long l3 = l - l2 * 1000L;
            if (l2 < 60L) {
                string = new String(l2 + " s " + l3 + " ms");
            } else {
                long l4 = l2 / 60L;
                long l5 = l2 - l4 * 60L;
                if (l4 < 60L) {
                    string = new String(l4 + " min " + l5 + " s");
                } else {
                    long l6 = l4 / 60L;
                    long l7 = l4 - l6 * 60L;
                    if (l6 < 24L) {
                        string = new String(l6 + " h " + l7 + " min " + l5 + " s");
                    } else {
                        long l8 = l6 / 24L;
                        string = new String(l8 + " j " + l6 + " h " + l7 + " min " + l5 + " s");
                    }
                }
            }
        }
        return string;
    }
}

