package plugins.ylemontag.gaussiannoiseestimator;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarSequence;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block interface for Gaussian noise estimation
 */
public class GaussianNoiseEstimatorBlock extends Plugin implements Block, PluginBundled
{
	private VarSequence          _input             = new VarSequence         ("Input"             , null);
	private VarDoubleArrayNative _standardDeviation = new VarDoubleArrayNative("Standard deviation", null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_input);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_standardDeviation);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return GaussianNoiseEstimatorPlugin.class.getName();
	}
	
	@Override
	public void run()
	{
		Sequence in = _input.getValue(true);
		GaussianNoiseEstimator.Result out = GaussianNoiseEstimator.computeStandardDeviation(in);
		_standardDeviation.setValue(out.get());
	}
}
