package plugins.ylemontag.gaussiannoiseestimator;

import icy.gui.frame.progress.AnnounceFrame;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDimensionPicker;
import plugins.adufour.ezplug.EzVarSequence;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Estimation of the standard deviation of the Gaussian additive noise that
 * affects a sequence
 */
public class GaussianNoiseEstimatorPlugin extends EzPlug
{
	private EzVarSequence        _seq;
	private EzVarDimensionPicker _t  ;
	private EzVarDimensionPicker _z  ;
	private EzVarDimensionPicker _c  ;
	
	@Override
	protected void initialize()
	{
		_seq = new EzVarSequence("Input");
		_t   = new EzVarDimensionPicker("t", DimensionId.T, _seq);
		_z   = new EzVarDimensionPicker("z", DimensionId.Z, _seq);
		_c   = new EzVarDimensionPicker("c", DimensionId.C, _seq);
		addEzComponent(_seq);
		addEzComponent(_t  );
		addEzComponent(_z  );
		addEzComponent(_c  );
	}
	
	@Override
	protected void execute()
	{
		// Retrieve the inputs
		Sequence seq = _seq.getValue(true);
		int      t   = _t  .getValue(true);
		int      z   = _z  .getValue(true);
		int      c   = _c  .getValue(true);
		
		// Core computation
		double standardDeviation = GaussianNoiseEstimator.computeStandardDeviation(seq, t, z, c);
		
		// Display the result
		new AnnounceFrame("Standard deviation is: " + standardDeviation);
	}
	
	@Override
	public void clean() {}
}
