package plugins.fab.timestamp;

import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.AnnounceFrame;
import icy.math.UnitUtil;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.util.GraphicsUtil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TimeStampPainter implements Painter {

	enum DisplayStyle { FRAME, TIME };
	
	
	String timeStampText;
	int x;
	int y;
	Font font;
	DisplayStyle displayStyle= DisplayStyle.FRAME;
	Rectangle2D textBound = new Rectangle2D.Double( 0, 0 , 0 , 0 );
	int fontSize = 20;
	
	
	public TimeStampPainter( Sequence sequence ) {
		x = 20;
		y = sequence.getHeight() - 20;
		font = new Font( "Arial" , Font.BOLD , fontSize );
	}
	
	private boolean isPointInTextArea(Point2D imagePoint) {

		return textBound.contains( imagePoint );
	}
	
	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if ( g == null ) return;
	
		g.setColor( Color.white );
		g.setFont( font );
		
		switch ( displayStyle )
		{
		case FRAME:
			timeStampText = "Current frame: "+canvas.getPositionT();	
			break;
		case TIME:
			double secondsOME = canvas.getPositionT() * sequence.getTimeInterval();
			secondsOME = (int)( secondsOME * 1000 );
			secondsOME /=1000d;
			timeStampText = ""+ UnitUtil.displayTimeAsStringWithUnits( secondsOME * 1000d , false );			
			
			if ( secondsOME == 0 )
			{
				timeStampText = "0 ms";
			}
			break;
		}
		
		g.drawString( timeStampText , x , y );
			
		Rectangle2D r = GraphicsUtil.getStringBounds( g , font , timeStampText );
		r.setRect( r.getX() + x, r.getY() + y, r.getWidth(), r.getHeight() );
		textBound = r;
	}
	
	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {

	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
			
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	int displaySelectionIndex = 0;
	
	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
		if ( e.isConsumed() ) return;		
		
		if ( e.getKeyChar() == 'm' )
		{
			x = (int) imagePoint.getX();
			y = (int) imagePoint.getY();
			canvas.getSequence().painterChanged( this );
			return;
		}
		
		
		//if ( !isPointInTextArea( imagePoint ) ) return;
		
		if ( e.getKeyChar() == 't' )
		{
			displaySelectionIndex++;
			if ( displaySelectionIndex >= DisplayStyle.values().length )
			{
				displaySelectionIndex = 0;
			}
			
			displayStyle = DisplayStyle.values()[displaySelectionIndex];
			
		}
		
		if ( e.getKeyChar() == '+' )
		{
			fontSize++;
		}
		
		if ( e.getKeyChar() == '-' )
		{
			fontSize--;
			if( fontSize < 2 ) fontSize = 2;
		}
		
		if ( e.getKeyChar() == 'k' )
		{
			canvas.getSequence().removePainter( this );
			new AnnounceFrame( "Time Stamp removed", 2 );
		}
		
		font = new Font( "Arial" , Font.BOLD , fontSize );
		canvas.getSequence().painterChanged( this );
		
		e.consume();
		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
	}

	
	
}
