package plugins.fab.trackmanager.processors;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.dialog.MessageDialog;
import icy.gui.util.GuiUtil;
import icy.image.colormap.FireColorMap;
import icy.sequence.Sequence;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.fab.trackmanager.processors.TrackProcessorTrackLength.DistanceResult;
import plugins.nchenouard.spot.Detection;

public class TrackProcessorTrackLength extends PluginTrackManagerProcessor implements ActionListener {

//	JTextField clipTextField = new JTextField("  3");
//	JCheckBox futureCheckBox = new JCheckBox( "Display future.",false );

	JButton exportDataToXLS = new JButton( "Export all to XLS");
	JCheckBox useSequenceScaleButton  = new JCheckBox("Use current display sequence XYZ scale", true );
	JPanel chartpanel = new JPanel();
	JFreeChart chart;
	JRadioButton totalLengthButton = new JRadioButton("Total length" , true );
	JRadioButton displacementButton = new JRadioButton("Displacement");
	
	public TrackProcessorTrackLength() {
		
		setName( "Track length" );

		panel.setLayout( new BoxLayout( panel , BoxLayout.PAGE_AXIS ) );
		panel.add( chartpanel );
	
		panel.add( GuiUtil.createLineBoxPanel( totalLengthButton, displacementButton ) );
		panel.add( GuiUtil.createLineBoxPanel( useSequenceScaleButton ) );
		panel.add( GuiUtil.createLineBoxPanel( exportDataToXLS ) );
		
//		JPanel controlPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));

//		controlPanel.add( totalLengthButton );
//		controlPanel.add( displacementButton );
//		controlPanel.add( useSequenceScaleButton );
//		controlPanel.add( exportDataToXLS );
//		panel.add(controlPanel);
		ButtonGroup group = new ButtonGroup();
		
		group.add( totalLengthButton );
		group.add( displacementButton );
		
		
		exportDataToXLS.addActionListener( this );
		totalLengthButton.addActionListener( this );
		displacementButton.addActionListener( this );
		useSequenceScaleButton.addActionListener( this );
	}

	@Override
	public void Compute() {
		
		if ( isEnabled() )
		{			

			HashMap<TrackSegment, DistanceResult> results = computeTrackLength();
			
			XYSeriesCollection xyDataset = new XYSeriesCollection();
			XYSeries series = new XYSeries("Track ");
							
			xyDataset.addSeries( series );
			
			String graphNameText="";
			String scaleText = "";
			
			if ( totalLengthButton.isSelected() )
			{
				graphNameText = "Length of tracks";				
			}
			if ( displacementButton.isSelected() )
			{
				graphNameText = "Displacement of tracks";				
			}

			if ( useSequenceScaleButton.isSelected() )
			{
				graphNameText += " (scaled)";				
				scaleText = "Micrometer";
			}else
			{
				scaleText = "Arbitrary unit";			
			}
			
			for ( TrackSegment ts : results.keySet() )
			{
				DistanceResult distanceResult = results.get( ts );
				double value ;
				if ( useSequenceScaleButton.isSelected() )
				{
					if ( totalLengthButton.isSelected() )
					{
						value = distanceResult.scaledDistance;
					}
					else
					{
						value = distanceResult.scaledDisplacement;
					}
				}else
				{
					if ( totalLengthButton.isSelected() )
					{
						value = distanceResult.distance;
					}
					else
					{
						value = distanceResult.displacement;
					}
				}
				
				series.add( trackPool.getTrackSegmentList().indexOf( ts ), value );			
			}

			
			chart = ChartFactory.createHistogram( //title, xAxisLabel, yAxisLabel, dataset, orientation, legend, tooltips, urls)
					graphNameText,
					"Track #",
					scaleText,
					xyDataset,
					PlotOrientation.VERTICAL,
					false, // display legend
					true,
					false
			);

			chartpanel.removeAll();		
			
			chartpanel.add( new ChartPanel(  chart , 400 , 200 , 400 , 200 , 400 , 200 , false , false, true , true , true, true) );		
			panel.updateUI();
			
		}
		
	}

	@Override
	public void Close() {}

	public HashMap<TrackSegment, DistanceResult> computeTrackLength()
	{
		HashMap<TrackSegment, DistanceResult> resultMap = new HashMap<TrackSegment, DistanceResult>(); 
		
		for (TrackSegment ts:trackPool.getTrackSegmentList())
		{
			if ( !ts.isAllDetectionEnabled() ) continue;
			
			ArrayList<Detection> detections = ts.getDetectionList();
			DistanceResult distanceResult = new DistanceResult();
			
			Detection previousDetection = null;
			
			//System.out.println("--");
			for (Detection d: detections )
			{
				if ( previousDetection == null )
				{
					previousDetection = d;
					continue;
				}
				//System.out.println( getDistance( previousDetection, d , false ) );
				distanceResult.distance += getDistance( previousDetection, d , false );
				distanceResult.scaledDistance += getDistance( previousDetection, d , true );
				previousDetection = d;
			}		
			
			distanceResult.displacement = getDistance( ts.getFirstDetection(), ts.getLastDetection(), false );
			distanceResult.scaledDisplacement = getDistance( ts.getFirstDetection(), ts.getLastDetection(), true );
			distanceResult.numberOfFrame = ts.getDetectionList().size();
			
			Sequence sequence = trackPool.getDisplaySequence(); 
			if ( sequence !=null )
			{
				distanceResult.time = distanceResult.numberOfFrame * trackPool.getDisplaySequence().getTimeInterval();
			}
			
			resultMap.put( ts , distanceResult );					
		}		
		
		return resultMap;
	}
	
	public double getDistance( Detection a, Detection b , boolean useSequenceScale )
	{
		double xScale = 1;
		double yScale = 1;
		double zScale = 1;
		
		Sequence sequence = trackPool.getDisplaySequence();		
		
		if ( useSequenceScale && sequence!=null )
		{
			xScale = trackPool.getDisplaySequence().getPixelSizeX(); // microMetre
			yScale = trackPool.getDisplaySequence().getPixelSizeY();
			zScale = trackPool.getDisplaySequence().getPixelSizeZ();
		}
		
		double distance = Math.sqrt( 
				Math.pow( xScale * ( a.getX() - b.getX() ) , 2 )
				+ Math.pow( yScale * ( a.getY() - b.getY() ), 2 )
				+ Math.pow( zScale * ( a.getZ() - b.getZ() ), 2 ) );

		return distance;
	}


	@Override
	public void displaySequenceChanged() {

	}

	@Override
	public void actionPerformed(ActionEvent e) {

		if ( e.getSource() == exportDataToXLS )
		{
			exportDataToXLS();			
		}else
		{			
			trackPool.fireTrackEditorProcessorChange();
		}

	}

	private void exportDataToXLS() {
		
		HashMap<TrackSegment, DistanceResult> results = computeTrackLength();

		JFileChooser chooser = new JFileChooser();
		chooser.setDialogTitle("Select xls file.");		
		int returnVal = chooser.showOpenDialog(null);
		if(returnVal != JFileChooser.APPROVE_OPTION) return;
		
		File file = chooser.getSelectedFile();

		file = new File( FileUtil.setExtension( file.getAbsolutePath(), ".xls") );
		XlsManager xls = null;
		try {
			 xls = new XlsManager( file );
		} catch (IOException e) {
		
			MessageDialog.showDialog( "Cannot open file." , MessageDialog.ERROR_MESSAGE );
			return;
		}		
		xls.createNewPage("Results");
				
		xls.setLabel( 0 , 0 , "track#" );
		xls.setLabel( 1 , 0 , "distance" );
		xls.setLabel( 2 , 0 , "scaled distance (micro meter)" );
		xls.setLabel( 3 , 0 , "displacement" );
		xls.setLabel( 4 , 0 , "scaled displacement (micro meter)" );
		xls.setLabel( 5 , 0 , "length(second)" );
		xls.setLabel( 6 , 0 , "length(nb frame)" );
		xls.setLabel( 7 , 0 , "disabled" );
		
		//series.add( trackPool.getTrackSegmentList().indexOf( ts ), value );

		for ( TrackSegment ts : trackPool.getTrackSegmentList() )
		{			
			DistanceResult distanceResult = results.get( ts );
			int index = trackPool.getTrackSegmentList().indexOf( ts );
			xls.setNumber(0, index+1, index );
			
			if ( distanceResult == null )
			{
				xls.setLabel(7, index+1, "disabled" );	
				continue;
			}
			
			xls.setNumber(1, index+1, distanceResult.distance );
			xls.setNumber(2, index+1, distanceResult.scaledDistance );
			xls.setNumber(3, index+1, distanceResult.displacement );
			xls.setNumber(4, index+1, distanceResult.scaledDisplacement );
			xls.setNumber(5, index+1, distanceResult.time );
			xls.setNumber(6, index+1, distanceResult.numberOfFrame );
		}
		
		xls.SaveAndClose();
		
	}

	public class DistanceResult
	{
		double distance;
		double scaledDistance;
		double displacement;
		double scaledDisplacement;
		double time;
		int numberOfFrame;
	}
	
}
