
package plugins.fab.manualtnt.toremove;
//a
/**
 * @(#) WaveletInfo.java
 * 2002/10/25   
 *
 * @version 1.0
 * @author Zhang Bo
 */

/**
 * A class representing the wavelet's information.
 * Now, we can only support real wavelet.
 */
/**
 * ************************************** ATTENTION *************************************
 * LFD is the low-pass decomposition reverse filter, i.e. \bar{h}
 * LFR is the low-pass reconstruction reverse filter, i.e. \tilde{h}
 * HFD is the high-pass decomposition reverse filter, i.e. \bar{g}
 * HFR is the high-pass reconstruction reverse filter, i.e. \tilde{g}
 * We supppose to use the classical fast wavelet transform so that at least semi-orthogonal wavelets are required.
 * For a filter of odd length, we can centralize the filter in the filtering and this is also hold for dyadic transform
 * But for a filter with even length, in the case of non-supersamplisation of filter (e.g. DWT or the last step in dyadic transform), 
 * the reconstruction filter should compromise the shifted phase of decomposition filter. So the origin of the reconstruction
 * filter should be shifted. For our implementation of SIWaveletTransformVolumeOp, we consider the origin of decomposition filter
 * as f[(f.length-1)/2], so if anyone want to create the reconstruction operator, the origin should be at f[f.length/2].
 * Reference :  A Wavelet Tour of Signal Processing, 2nd edition {Mallat}
 * **************************************************************************************
 */
public final class WaveletInfo
{
	/** Wavelet Type - Haar */
	public static final int TYPE_HAAR = 0;     // Haar wavelet
	/** Wavelet Type - Symlet4 */
	public static final int TYPE_SYM4 = 1;     // Symlet 4 wavelet
	/** Wavelet Type - RBio2.2 */
	public static final int TYPE_RBIO22 = 2;   // Reverse B-Spline Biorthogonal 2.2 Wavelet
	/** Wavelet Type - RBio3.1 */
	public static final int TYPE_RBIO31 = 3;   // Reverse B-Spline Biorthogonal 3.1 Wavelet
	/** Wavelet Type - RBio3.3 */
	public static final int TYPE_RBIO33 = 4;   // Reverse B-Spline Biorthogonal 3.3 Wavelet
	/** Wavelet Type - Bior4.4 */	
	public static final int TYPE_BIOR44 = 5;   // B-Spline Biorthogonal 4.4 Wavelet
	/** Wavelet Type - B3 (work only with Bijaoui's transform) */
	public static final int TYPE_B3 = 6;
	/** Wavelet Type - Identity */			   
	public static final int TYPE_NULL = 7;     // Null Wavelet
	/**Wavelet Type - Default Type for X and Y**/
	public static final int TYPE_XYDEFAULT = TYPE_B3;
	/**Wavelet Type - Default Type for Z**/
	public static final int TYPE_ZDEFAULT = TYPE_B3;
	public static final String[] WAVELET_TAGS = {"Haar","Sym4","RBio22", "RBio31", "RBio33", "Bior44", "B3", "No Transform"};
	public static final boolean[] IS_ISOTROPIC = {false, false, false, false, false, true, true};//if a wavelet is isotropic it doesn't need multiple bands fusion
	/* Low-pass Filter - Decomposition hd[n](_h) */
	private static double[][] LFD = 
	{
		{0.7071067812, 0.7071067812},
		{-0.0758, -0.0296, 0.4976, 0.8037, 0.2979, -0.0992, -0.0126, 0.0322},
		{0.3536, 0.7071, 0.3536},
		{0.1768, 0.5303, 0.5303, 0.1768},
		{0, 0, 0.1768, 0.5303, 0.5303, 0.1768, 0, 0},
		{0.03782845555, -0.02384946502, -0.1106244044, 0.3774028556, 0.8526986790, 0.3774028556, -0.1106244044, -0.02384946502, 0.03782845555},
		{0.0625, 0.25, 0.375, 0.25, 0.0625},
		{1}
	};

	/* Low-pass Filter - Reconstruction hr[n](~h) */
	private static double[][] LFR = 
	{
		{0.7071067812, 0.7071067812},
		{0.0322, -0.0126, -0.0992, 0.2979, 0.8037, 0.4976, -0.0296, -0.0758},
		{-0.1768, 0.3536, 1.0607, 0.3536, -0.1768},
		{-0.3536, 1.0607, 1.0607, -0.3536},
		{0.0663, -0.1989, -0.1547, 0.9944, 0.9944, -0.1547, -0.1989, 0.0663},
		{-0.06453888263, -0.04068941761, 0.4180922732, 0.7884856164, 0.4180922732, -0.04068941761, -0.06453888263},
		{1},
		{1}
	};

	/* High-pass Filter - Decomposition gd[n](_g) */
	private static double[][] HFD =
	{
		{-0.7071067812, 0.7071067812},
		{-0.0322, -0.0126, 0.0992, 0.2979, -0.8037, 0.4976, 0.0296, -0.0758},
		{-0.1768, -0.3536, 1.0607, -0.3536, -0.1768},
		{0.3536, 1.0607, -1.0607, -0.3536},
		{-0.0663, -0.1989, 0.1547, 0.9944, -0.9944, -0.1547, 0.1989, 0.0663},
		{0.06453888263, -0.04068941761, -0.4180922732, 0.7884856164, -0.4180922732, -0.04068941761, 0.06453888263},
		{0}, // implicitly defined
		{0}
	};

	/* High-pass Filter - Reconstruction gr[n](~g) */
	private static double[][] HFR = 
	{
		{0.7071067812, -0.7071067812},
		{-0.0758, 0.0296, 0.4976, -0.8037, 0.2979, 0.0992, -0.0126, -0.0322},
		{-0.3536, 0.7071, -0.3536},
		{0.1768, -0.5303, 0.5303, -0.1768},
		{0, 0, 0.1768, -0.5303, 0.5303, -0.1768, 0, 0},
		{0.03782845555, 0.02384946502, -0.1106244044, -0.3774028556, 0.8526986790, -0.3774028556, -0.1106244044, 0.02384946502, 0.03782845555},
		{0},
		{0}
	};

	/* Wavelet Vanishing Moments - Decomposition */
	private static int[] WVMD =
	{
		1, 4, 2, 3, 3, 4, 2, 0
	};

	/* Wavelet Vanishing Moments - Reconstruction */
	private static int[] WVMR =
	{
		1, 4, 2, 1, 3, 4, -1, 0
	};

	/* Wavelet Support Length - Decomposition */
	private static int[] WSD = 
	{
		1, 7, 3, 3, 5, 7, 4, 1
	};

	/* Wavelet Support Length - Reconstruction */
	private static int[] WSR = 
	{
		1, 7, 3, 3, 5, 7, -1, 1 
	};

	/* Frame Bounds - Decomposition */
	private static double[][] FBD = 
	{   // Lower, Upper
		{1, 1},
		{1, 1},
		{-1, -1}, // We don't know
		{0.2191, 2.8449},
		{0.4468, 4.9578},
		{-1, -1}, //{0.7393, 2.7515} Bior4.4 avec L(cosw) = 1, i.e. non quasi-orthogonal
		{-1, -1},
		{-1, -1}
	};

	/* Frame Bounds - Reconstruction */
	private static double[][] FBR = 
	{
		// Lower, Upper
		{1, 1},
		{1, 1},
		{-1, -1}, //we don't know
		{0.3515, 4.5629},
		{0.2017, 2.2382},
		{-1, -1}, //{0.3634, 1.3526} Bior4.4 avec L(cosw) = 1, i.e. non quasi-orthogonal
		{-1, -1},
		{-1, -1}
	};

	/* Symmetry - Decomposition */
	private static boolean[] SYMD = 
	{
		true, false, true, true, true, true, true, true
	};

	/* Symmetry - Reconstruction */
	private static boolean[] SYMR = 
	{
		true, false, true, true, true, true, false, true
	};

	/* Orthogonality */
	private static boolean[] ORTHO = 
	{
		true, true, false, false, false, false, false, true
	};

	/* Biorthogonality */
	private static boolean[] BIORTHO = 
	{
		true, true, true, true, true, true, true, true
	};

	/* Quasi-Orthogonality */
	private static boolean[] QORTHO = 
	{
		true, true, false, false, false, true, true, true
	};

	private WaveletInfo() {}
	private static void verify(int t)
	{
		if (t>=TYPE_HAAR && t<=TYPE_NULL) return;
		throw new IllegalArgumentException("Unknown wavelet type");
	}

	/** get decomposition lowpass filter */
	public static double[] getLO_D(int t)
	{
		verify(t);
		return LFD[t];
	}
	/** get reconstruction lowpass filter */ 	
	public static double[] getLO_R(int t)
	{
		verify(t);
		return LFR[t];
	}
	/** get decomposition highpass filter */ 	
	public static double[] getHI_D(int t)
	{
		verify(t);
		return HFD[t];
	}

	/** get reconstruction highpass filter */
	public static double[] getHI_R(int t)
	{
		verify(t);
		return HFR[t];
	}

	/** get decomposition wavelet vanishing moment */ 	
	public static int getVM_D(int t)
	{
		verify(t);
		return WVMD[t];
	}
	/** get reconstruction wavelet vanishing moment */ 	 	
	public static int getVM_R(int t)
	{
		verify(t);
		return WVMR[t];
	}
	/** get decomposition wavelet support */ 	 	
	public static int getSUP_D(int t)
	{
		verify(t);
		return WSD[t];
	}
	/** get reconstruction wavelet support */ 	
	public static int getSUP_R(int t)
	{
		verify(t);
		return WSR[t];
	}
	/** get decomposition wavelet frame bound (not translation invariant) */
	public static double[] getFBD(int t)
	{
		verify(t);
		return FBD[t];
	}
	/** get reconstruction wavelet frame bound (not translation invariant)*/
	public static double[] getFBR(int t)
	{
		verify(t);
		return FBR[t];
	}
	/** if decomposition wavelet is symmetric */
	public static boolean isSYM_D(int t)
	{
		verify(t);
		return SYMD[t];
	}
	/** if reconstruciton wavelet is symmetric */ 	
	public static boolean isSYM_R(int t)
	{
		verify(t);
		return SYMR[t];
	}
	/** if orthogonal wavelet */
	public static boolean isORTHO(int t)
	{
		verify(t);
		return ORTHO[t];
	}
	/** if biorthogonal wavelet */
	public static boolean isBIORTHO(int t)
	{
		verify(t);
		return BIORTHO[t];
	}
	/** if almost orthogonal wavelet */
	public static boolean isQUASI_ORTHO(int t)
	{
		verify(t);
		return QORTHO[t];
	}
}
