


package plugins.fab.manualtnt.toremove;

 /** 
  * Key of the weights in the WaveletEstimeConfig and also 
  * specify the <scale, band> property of an image.
  * 
  * @version 1.0
  * @author Zhang Bo
  */
 public final class _SBKey
 {
 	private int scale;
 	private int band;
 		
 	/** create a key with specified scale and subband.
 	 * s is zero if the it is the0 original image without filtering.
 	 * band is
 	 * 0 means band LxLyLz
 	 * 1 means band LxLyHz (used as details for Starck's version)
 	 * 2 means band LxHyLz (not used in Starck's version)
 	 * 3 means band LxHyHz (not used in Starck's version)
 	 * 4 means band HxLyLz (not used in Starck's version)
 	 * 5 means band HxLyHz (not used in Starck's version)
 	 * 6 means band HxHyLz (not used in Starck's version)
 	 * 7 means band HxHyHz (not used in Starck's version)
 	 */
 	public _SBKey(int s, int b)
 	{
 		scale = s;
 		band = b;
 	}
 		
 	public int getScale() { return scale; }
 	public void setScale(int s) { scale = s; } 
 	public int getBand() { return band; }
 	public void setBand(int b) { band = b; }
 
 	public boolean equals(Object k)
 	{
 		if (!(k instanceof _SBKey)) return (this==k);
 		_SBKey sbk = (_SBKey)k;
 		return ((scale==sbk.getScale()) && (band==sbk.getBand()));
 	}
 		
 	/** For scale>=0 and band>=0, this hash code is 1-1 correspondent 
 	 * with the coordinate(scale, band). 
 	 * We use the property of countable set.
 	 */
 	public int hashCode()
 	{
 		if (scale >= band && band >= 0) return (4*scale*scale-scale-band);
 		if (band >= scale && scale >= 0) return (4*band*band-3*band+scale);
 		return 0;
 	}
 }
