package plugins.fab.manualtnt;

import icy.canvas.IcyCanvas;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.painter.Painter;
import icy.sequence.Sequence;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import javax.swing.Timer;

public class ZOverlayShortcut implements ActionListener, ViewerListener , Painter {

	Timer animationTimer = new Timer( 250 , this );	
	Viewer viewer;
	int z = 0;
	int increment = 1; 
	int pause; // if pause is >0 then no animation (pause during operator inputs)
	
	public ZOverlayShortcut( Viewer viewer ) {
				
		this.viewer = viewer;
		viewer.getSequence().addPainter( this );
		viewer.addListener( this );
		// The animation is disabled.
		// animationTimer.start();
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
	
		
		
//		if ( pause < 0 ) pause = 0;
//		if ( pause > 0 ) return;
//		
//		if ( viewer == null ) return;
//		if ( viewer.getSequence() == null ) return;
//	
//		
//		if ( z >= viewer.getSequence().getSizeZ() )
//		{
//			increment=-1;
//		}
//		
//		if ( z <= 0 )
//		{
//			increment=1;
//		}
//		
//		viewer.setPositionZ( z );
//
//		z+=increment;
	}
	
	@Override
	public void viewerClosed(Viewer viewer) {
		this.viewer = null;
	}
	
	
	@Override
	public void viewerChanged(ViewerEvent event) {}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
	}

	@Override
	public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		
		if ( canvas.getSequence().getSizeZ() == 1 ) return; 
			
		int currentZ = canvas.getViewer().getPositionZ();
		
		if ( e.getKeyChar()=='-' )
		{
			pause = 10;
			
			System.out.println("-");
			if ( currentZ > 2 )
			{
			canvas.getViewer().setPositionZ( currentZ-1 );
			}
		}
		
		if ( e.getKeyChar()=='+' )
		{
			pause = 10;
			System.out.println("-");
			
			if ( currentZ < canvas.getSequence().getSizeZ()-1 )
			{
			canvas.getViewer().setPositionZ( currentZ+1 );
			}
		}
		
		
		
	}

	@Override
	public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
	}
	
	
}
