/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.anisotropyProfiler;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.roi.ROI2DRectangle;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.vecmath.Point3i;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.lagache.anisotropyProfiler.ObjectPoints;
import plugins.lagache.anisotropyProfiler.PrincipalComponentAnalysis;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Point3D;
import plugins.nchenouard.spot.Spot;

public class AnisotropyProfiler
extends EzPlug
implements Block {
    EzVarDouble alpha = new EzVarDouble("Threshold", 0.0, 1.0, 0.01);
    EzVarSwimmingObject<DetectionResult> detections = new EzVarSwimmingObject("Detections");
    private EzVarDouble output = new EzVarDouble("percentage of elongated objects", new Double[]{0.0}, false);
    private EzVarSequence sequence = new EzVarSequence("input Sequence");
    EzVarEnum<MethodType> criterion = new EzVarEnum("Criterion:", (Enum[])MethodType.values());
    protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel", false);
    protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");

    protected void initialize() {
        super.addEzComponent((EzComponent)this.alpha);
        super.addEzComponent((EzComponent)this.sequence);
        super.addEzComponent(this.detections);
        super.addEzComponent((EzComponent)this.output);
        super.addEzComponent(this.criterion);
        this.addEzComponent((EzComponent)new EzGroup("Export", new EzComponent[]{this.exportExcel, this.exportExcelFile}));
        this.exportExcel.addVisibilityTriggerTo((EzComponent)this.exportExcelFile, (Object[])new Boolean[]{true});
        this.getUI().setParametersIOVisible(false);
        this.criterion.addVarChangeListener((EzVarListener)new EzVarListener<MethodType>(){

            public void variableChanged(EzVar<MethodType> source, MethodType newValue) {
                AnisotropyProfiler.this.updateDefaultParams();
            }
        });
    }

    private void updateDefaultParams() {
        MethodType _method = (MethodType)((Object)this.criterion.getValue());
        switch (_method) {
            case Morton: {
                break;
            }
            case Compacity: {
                break;
            }
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.alpha.getVariable());
        inputMap.add(this.detections.getVariable());
        inputMap.add(this.sequence.getVariable());
        inputMap.add(this.criterion.getVariable());
        inputMap.add(this.exportExcel.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.output.getVariable());
    }

    protected void execute() {
        double threshold = 0.0;
        if (this.alpha.getValue() == null) {
            new AnnounceFrame("Please first select criterion threshold");
            return;
        }
        threshold = (Double)this.alpha.getValue();
        MethodType _method = (MethodType)((Object)this.criterion.getValue());
        if (this.detections.getValue() == null) {
            new AnnounceFrame("Please first select a detection");
            return;
        }
        if (this.sequence.getValue() == null) {
            new AnnounceFrame("Please first select a sequence");
            return;
        }
        this.performAnalysis(this.detections, _method, this.exportExcel, threshold, this.sequence, this.output);
    }

    private void performAnalysis(EzVarSwimmingObject<DetectionResult> detections, MethodType method, EzVarBoolean exportExcel, double threshold, EzVarSequence sequence, EzVarDouble output) {
        SwimmingObject test = (SwimmingObject)detections.getValue();
        int row = 0;
        XlsManager xlsManager = null;
        if (((Boolean)exportExcel.getValue()).booleanValue()) {
            int page = 1;
            try {
                File f = (File)this.exportExcelFile.getValue(true);
                if (!FileUtil.getFileExtension((String)f.getPath(), (boolean)false).equalsIgnoreCase("xls")) {
                    f = new File(String.valueOf(f.getPath()) + ".xls");
                }
                xlsManager = new XlsManager(f);
                xlsManager.createNewPage("Page " + page);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            xlsManager.setLabel(0, 0, "Date of XLS page:");
            xlsManager.setLabel(0, ++row, new Date().toString());
            xlsManager.setLabel(0, ++row, "Criterion");
            xlsManager.setLabel(1, row, method.name());
            ++row;
            xlsManager.setLabel(0, ++row, "Threshold");
            xlsManager.setNumber(1, row, threshold);
            ++row;
            xlsManager.setLabel(0, ++row, "ROI number");
            xlsManager.setLabel(1, row, "ROI name");
            xlsManager.setLabel(2, row, "Percentage of elongated objects in the ROI");
            ++row;
        }
        ArrayList roiArrayList = ((Sequence)sequence.getValue()).getROI2Ds();
        DetectionResult detect_ = (DetectionResult)((SwimmingObject)detections.getValue()).getObject();
        Vector detection = detect_.getDetectionsAtT(0);
        Vector cloneDetectionList = (Vector)detection.clone();
        for (ROI2D roi : roiArrayList) {
            if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() != 0) continue;
            for (Spot spot : cloneDetectionList) {
                if (!roi.contains(spot.mass_center.x, spot.mass_center.y)) continue;
                detection.remove(spot);
            }
        }
        HashMap ROI2Detection = new HashMap();
        if (roiArrayList.size() == 0) {
            ROI2Detection.put(new ROI2DRectangle((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(((Sequence)sequence.getValue()).getWidth(), ((Sequence)sequence.getValue()).getHeight()), false), (Vector)detection.clone());
        } else {
            for (ROI2D roi : roiArrayList) {
                ROI2Detection.put(roi, new Vector());
            }
            for (ROI2D roi : roiArrayList) {
                for (Spot spot : detection) {
                    if (!roi.contains(spot.mass_center.x, spot.mass_center.y)) continue;
                    ((Vector)ROI2Detection.get(roi)).add(spot);
                }
            }
        }
        detection.clear();
        int nb = 0;
        double score_final = 0.0;
        for (ROI2D roi : ROI2Detection.keySet()) {
            for (Spot s : (Vector)ROI2Detection.get(roi)) {
                detection.add(s);
            }
        }
        if (detection.size() == 0) {
            new AnnounceFrame("There is no detection associated with the ROI(s)");
            return;
        }
        for (ROI2D roi : ROI2Detection.keySet()) {
            double sum_a = 0.0;
            double sum_t = 0.0;
            double score = 0.0;
            Vector detect = (Vector)ROI2Detection.get(roi);
            for (Spot spot : detect) {
                ObjectPoints objP = new ObjectPoints();
                ConnectedComponent CC = new ConnectedComponent(0);
                for (Point3D point : spot.point3DList) {
                    objP.addPoint(point.x, point.y, point.z);
                    Point3i point_i = new Point3i((int)point.x, (int)point.y, (int)point.z);
                    CC.addPoint(point_i);
                }
                if (spot.point3DList.size() <= 1) continue;
                PrincipalComponentAnalysis pca = new PrincipalComponentAnalysis(objP);
                int perim = CC.getContourPoints(null).length;
                double[] eigVal = pca.eig.getRealEigenvalues();
                boolean added = false;
                switch (method) {
                    case Morton: {
                        double crit1 = (double)(4 * (spot.point3DList.size() - perim)) / (Math.PI * Math.max(eigVal[1], eigVal[2]) * Math.max(eigVal[1], eigVal[2]));
                        if (!(crit1 < threshold)) break;
                        sum_a += (double)spot.point3DList.size();
                        added = true;
                        break;
                    }
                    case Compacity: {
                        double crit2 = Math.PI * 4 * (double)(spot.point3DList.size() - perim) / (double)(perim * perim);
                        if (!(crit2 < threshold)) break;
                        sum_a += (double)spot.point3DList.size();
                    }
                }
                sum_t += (double)spot.point3DList.size();
            }
            if (sum_t != 0.0) {
                score = sum_a / sum_t;
            }
            ++nb;
            score_final += score;
            if (!((Boolean)exportExcel.getValue()).booleanValue()) continue;
            xlsManager.setNumber(0, row, (double)nb);
            xlsManager.setLabel(1, row, roi.getName());
            xlsManager.setNumber(2, row, score);
            ++row;
        }
        score_final /= (double)nb;
        if (((Boolean)exportExcel.getValue()).booleanValue()) {
            xlsManager.setLabel(0, ++row, "Mean percentage of elongated objecys in all ROIs");
            xlsManager.setNumber(1, row, score_final);
            ++row;
        }
        output.setValue((Object)score_final);
        if (((Boolean)exportExcel.getValue()).booleanValue()) {
            xlsManager.SaveAndClose();
        }
    }

    double getROISurface(ROI2D roi) {
        double sum = 0.0;
        Rectangle bounds = roi.getBounds();
        int y = (int)bounds.getMinY();
        while ((double)y < bounds.getMaxY()) {
            int x = (int)bounds.getMinX();
            while ((double)x < bounds.getMaxX()) {
                if (roi.contains((double)x, (double)y)) {
                    sum += 1.0;
                }
                ++x;
            }
            ++y;
        }
        return sum;
    }

    double getROIIntensity(ROI2D roi, Vector<Spot> detect) {
        BooleanMask2D B = roi.getAsBooleanMask(true);
        double sum = 0.0;
        for (Spot S : detect) {
            boolean trouve = false;
            int i = -2;
            while (i < 3) {
                int j = -2;
                while (j < 3) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += (double)S.point3DList.size() * S.meanIntensity;
                        trouve = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return sum;
    }

    double getROINumber(ROI2D roi, Vector<Spot> detect) {
        BooleanMask2D B = roi.getAsBooleanMask(true);
        double sum = 0.0;
        for (Spot S : detect) {
            boolean trouve = false;
            int i = -2;
            while (i < 3) {
                int j = -2;
                while (j < 3) {
                    if (!trouve && B.contains((int)S.mass_center.x + i, (int)S.mass_center.y + j)) {
                        sum += (double)S.point3DList.size();
                        trouve = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return sum;
    }

    public void clean() {
    }

    private static enum MethodType {
        Compacity("Circularity Criterion"),
        Morton("Modified Morton Criterion");

        private final String name;

        private MethodType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

