/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.anisotropyProfiler;

import icy.sequence.Sequence;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import plugins.nherve.matrix.Matrix;

public class ObjectPoints {
    private ArrayList<Point3d> object = new ArrayList();

    public ObjectPoints() {
    }

    public ObjectPoints(Sequence seq, int t) {
        byte[][] data = seq.getDataXYZAsByte(t, 0);
        int z = 0;
        while (z < seq.getSizeZ(t)) {
            int i = 0;
            while (i < data[z].length) {
                if (data[z][i] != 0) {
                    int y = (int)Math.floor(i / seq.getSizeX());
                    int x = i - y * seq.getSizeX();
                    this.object.add(new Point3d((double)x, (double)y, (double)z));
                }
                ++i;
            }
            ++z;
        }
    }

    public void addPoint(double x, double y, double z) {
        this.object.add(new Point3d(x, y, z));
    }

    public Point3d getCenter() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point3d v : this.object) {
            x += v.x;
            y += v.y;
            z += v.z;
        }
        Point3d center = new Point3d(x, y, z);
        center.scale(1.0 / (double)this.object.size());
        return center;
    }

    public Matrix getCovariance() {
        Point3d center = this.getCenter();
        double xx = 0.0;
        double yy = 0.0;
        double zz = 0.0;
        double xy = 0.0;
        double xz = 0.0;
        double yz = 0.0;
        for (Point3d v : this.object) {
            double x = v.x - center.x;
            double y = v.y - center.y;
            double z = v.z - center.z;
            xx += x * x;
            yy += y * y;
            zz += z * z;
            xy += x * y;
            xz += x * z;
            yz += y * z;
        }
        int divisor = this.object.size() - 1;
        double[][] cov = new double[][]{{xx / (double)divisor, xy / (double)divisor, xz / (double)divisor}, {xy / (double)divisor, yy / (double)divisor, yz / (double)divisor}, {xz / (double)divisor, yz / (double)divisor, zz / (double)divisor}};
        return new Matrix((double[][])cov);
    }
}

