/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.anisotropyProfiler;

import icy.sequence.Sequence;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import plugins.lagache.anisotropyProfiler.ObjectPoints;
import plugins.nherve.matrix.EigenvalueDecomposition;
import plugins.nherve.matrix.Matrix;

public class PrincipalComponentAnalysis {
    private ObjectPoints obj;
    public EigenvalueDecomposition eig;

    public PrincipalComponentAnalysis(Sequence seq, int t) {
        this(new ObjectPoints(seq, t));
    }

    public PrincipalComponentAnalysis(ObjectPoints object) {
        this.obj = object;
        this.calculateVD();
    }

    private void calculateVD() {
        Matrix cov = this.obj.getCovariance();
        this.eig = cov.eig();
    }

    public Point3d getCenter() {
        return this.obj.getCenter();
    }

    public String getSortedEigVals() {
        double[] eigVal = this.eig.getRealEigenvalues();
        double[] eigValSorted = this.eig.getRealEigenvalues();
        Arrays.sort(eigValSorted);
        Matrix eigVec = this.eig.getV();
        Vector3d[] vec = new Vector3d[]{new Vector3d(eigVec.get(0, 0), eigVec.get(1, 0), eigVec.get(2, 0)), new Vector3d(eigVec.get(0, 1), eigVec.get(1, 1), eigVec.get(2, 1)), new Vector3d(eigVec.get(0, 2), eigVec.get(1, 2), eigVec.get(2, 2))};
        String eigVecs = "";
        int i = 2;
        while (i >= 0) {
            int j = 0;
            while (j < 3) {
                if (eigValSorted[i] == eigVal[j] && (vec[j].x != 0.0 || vec[j].y != 0.0 || vec[j].z != 0.0)) {
                    eigVecs = String.valueOf(eigVecs) + "," + vec[j].x + "," + vec[j].y + "," + vec[j].z;
                    vec[j] = new Vector3d(0.0, 0.0, 0.0);
                    break;
                }
                ++j;
            }
            --i;
        }
        return String.valueOf(eigValSorted[2]) + "," + eigValSorted[1] + "," + eigValSorted[0] + eigVecs;
    }

    public String toString() {
        String str = "";
        double[] eigVal = this.eig.getRealEigenvalues();
        Matrix eigVec = this.eig.getV();
        Vector3d[] vec = new Vector3d[]{new Vector3d(eigVec.get(0, 0), eigVec.get(1, 0), eigVec.get(2, 0)), new Vector3d(eigVec.get(0, 1), eigVec.get(1, 1), eigVec.get(2, 1)), new Vector3d(eigVec.get(0, 2), eigVec.get(1, 2), eigVec.get(2, 2))};
        int i = 0;
        while (i < 3) {
            str = String.valueOf(str) + "\nEigenvalue: " + eigVal[i] + "\nx: " + vec[i].x + "\ty: " + vec[i].y + "\tz: " + vec[i].z;
            ++i;
        }
        return str;
    }
}

