package plugins.fab.trackgenerator;

import icy.file.FileUtil;
import icy.gui.frame.progress.ProgressFrame;

import java.io.File;

import flanagan.math.PsRandom;

public class BenchmarkGenerationUtil {


	
	static void startBenchmarkComputation(
			File exportFolder,
			boolean enableMicroTubuleComputation,
			Double[] snrArrayMicroTubule,
			Double[] densityArrayMicroTubule,
			int depth_for_microtubule,
			boolean enableVesiculeComputation,
			Double[] snrArrayVesicule,
			Double[] densityArrayVesicule,
			int depth_for_vesicle,
			boolean enableVirusComputation,
			Double[] snrArrayVirus,
			Double[] densityArrayVirus,
			int depth_for_virus,
			boolean enableReceptorComputation,
			Double[] snrArrayReceptor,
			Double[] densityArrayReceptor,
			int depth_for_receptor,
			long randomSeed,
			int width,
			int height,
			int length
			)
	{

		PsRandom ran = new PsRandom( randomSeed );

		if ( enableMicroTubuleComputation )
		{
			exportScenario( ran , Scenario.MICROTUBULE , exportFolder , snrArrayMicroTubule ,
					densityArrayMicroTubule ,
					depth_for_virus , depth_for_microtubule , depth_for_vesicle , depth_for_receptor ,
					randomSeed, width , height, length );
		}
		
		if ( enableVesiculeComputation )
		{
			exportScenario( ran , Scenario.VESICLE , exportFolder , snrArrayVesicule ,
					densityArrayVesicule , 
					depth_for_virus , depth_for_microtubule , depth_for_vesicle , depth_for_receptor ,
					randomSeed , width , height, length );
		}
		
		if ( enableVirusComputation )
		{
			exportScenario( ran , Scenario.VIRUS , exportFolder , snrArrayVirus ,
					densityArrayVirus  , 
					depth_for_virus , depth_for_microtubule , depth_for_vesicle , depth_for_receptor , 
					randomSeed , width , height, length );
		}
		
		if ( enableReceptorComputation )
		{
			exportScenario( ran , Scenario.RECEPTOR , exportFolder , snrArrayReceptor , 
					densityArrayReceptor  ,
					depth_for_virus , depth_for_microtubule , depth_for_vesicle , depth_for_receptor ,
					randomSeed ,  width , height, length );
		}
	}
	
	
	static void exportScenario( PsRandom ran , Scenario scenarioName , File exportFolder,
			Double[] SNRArrayList, Double[] densityArrayList ,
			int depth_for_virus , int depth_for_microtubule , int depth_for_vesicle , int depth_for_receptor , long seed , int width, int height, int length ) {

		ProgressFrame p = new ProgressFrame( scenarioName.name() );

		// creates the output directory		
		FileUtil.createDir( exportFolder );

		float stepDone = 0;
		float allStep = SNRArrayList.length * densityArrayList.length;
		p.setPosition( 0 );

		for ( Double snr : SNRArrayList )
		{
			for ( int densityIndex= 0 ; densityIndex < densityArrayList.length ; densityIndex++ ) // ( Double density : densityArrayList )	
			{
				double density = densityArrayList[densityIndex]; 
				String densityLabel = "";
				switch ( densityIndex )
				{
				case 0: densityLabel="low";
				break;
				case 1: densityLabel="mid";
				break;
				case 2: densityLabel="high";
				break;				
				}
				
				p.setMessage( scenarioName + " scenario : snr: " + snr.intValue() + " density: " + densityLabel );
				// create sequence.

				String fileName = scenarioName + " snr "+ snr.intValue() + " density " + densityLabel;
				String dataSetFolder = exportFolder+FileUtil.separator+scenarioName+FileUtil.separator+ fileName + FileUtil.separator ;

				FileUtil.createDir( dataSetFolder );

				BenchmarkSequence benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark( 
						scenarioName,
						snr,
						density,
						densityLabel,
						depth_for_virus , 
						depth_for_microtubule,
						depth_for_vesicle,
						depth_for_receptor,			
//						depth,
						seed,
						width,
						height,
						length
						);				

				benchmarkSequence.save( dataSetFolder , new File( dataSetFolder+ fileName + ".xml" ) , dataSetFolder+ fileName );

				stepDone++;
				p.setPosition( stepDone * 100f / allStep );
			}
		}

		p.close();

	}
	
	
}
