package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

public class SwitchingBrownianDirectedModel extends MotionModel
{
	double q1;
	PsRandom ran;
	double currentVx, currentVy, currentVz; 
	double Vmin, Vmax;

	double sigmaBrownian;

	double probaDirectedBrownian;
	double probaBrownianDirected;

	boolean isBrownianMotion;
	boolean isMotionPureIn2D;

	public SwitchingBrownianDirectedModel(TGDetection firstDetection, double q1, double Vmin, double Vmax, double currentVx, double currentVy, double currentVz, double sigmaBrownian, double probaDirectedBrownian, double probaBrownianDirected, PsRandom ran, boolean isMotionPureIn2D)
	{
		super(firstDetection);

		this.sigmaBrownian = sigmaBrownian;

		this.q1 = q1;
		this.Vmin = Vmin;
		this.Vmax = Vmax;
		this.currentVx = currentVx;
		this.currentVy  = currentVy;
		this.currentVz = currentVz;

		this.probaBrownianDirected = probaBrownianDirected;
		this.probaDirectedBrownian = probaDirectedBrownian;

		this.ran = ran;
		this.isMotionPureIn2D = isMotionPureIn2D;

		if (probaBrownianDirected>0)
			this.isBrownianMotion = (ran.nextDouble() < (probaDirectedBrownian/probaBrownianDirected));
		else
			this.isBrownianMotion = true;
	}

	@Override
	public TGDetection getNextDetection()
	{
		// move to the next detection
		if (isBrownianMotion)
		{
			TGDetection newDetection = new TGDetection(ran.nextGaussian(currentDetection.x, sigmaBrownian), ran.nextGaussian(currentDetection.y, sigmaBrownian), ran.nextGaussian(currentDetection.z, sigmaBrownian), currentDetection.t+1);
			currentDetection = newDetection;
			
			double noisePosition = ran.nextGaussian(0, 1); 
			double newCurrentVx = currentVx + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  
			double newCurrentVy = currentVy + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  
			double newCurrentVz = currentVz + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  
			
			if (isMotionPureIn2D) {
				newCurrentVz = 0;
			}
			
			double Vel = Math.sqrt(newCurrentVx * newCurrentVx + newCurrentVy * newCurrentVy + newCurrentVz * newCurrentVz);

			if (Vel > Vmin && Vel < Vmax) 
			{
				currentVx = newCurrentVx;
				currentVy = newCurrentVy;
				currentVz = newCurrentVz;
			} 
			
			// switch to another motion model
			this.isBrownianMotion = (ran.nextDouble() > probaBrownianDirected);
			return newDetection;
		}
		else
		{
			double noisePosition = ran.nextGaussian(0, 1); 

			double newDetectionX = currentDetection.x + currentVx + Math.sqrt(q1 / 3) * noisePosition;  
			double newCurrentVx = currentVx + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  

			noisePosition = ran.nextGaussian(0, 1); 
			double newDetectionY = currentDetection.y + currentVy + Math.sqrt(q1 / 3) * noisePosition;  
			double newCurrentVy = currentVy + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  

			noisePosition = ran.nextGaussian(0, 1); 
			double newDetectionZ = currentDetection.z + currentVz + Math.sqrt(q1 / 3) * noisePosition;  
			double newCurrentVz = currentVz + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  
			
			if (isMotionPureIn2D) {
				newCurrentVz = 0;
			}
			
			double Vel = Math.sqrt(newCurrentVx * newCurrentVx + newCurrentVy * newCurrentVy + newCurrentVz * newCurrentVz);

			if (Vel > Vmin && Vel < Vmax) 
			{
				currentVx = newCurrentVx;
				currentVy = newCurrentVy;
				currentVz = newCurrentVz;
			} 

			TGDetection newDetection = new TGDetection(newDetectionX, newDetectionY, newDetectionZ, currentDetection.t+1);
			currentDetection = newDetection;
			// switch to another motion model
			this.isBrownianMotion = (ran.nextDouble() < probaDirectedBrownian);
			return newDetection;
		}
	}
}
