package plugins.fab.trackgenerator;

import icy.util.XMLUtil;

import java.io.File;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrackImporter {

	double snr;
	double density;
	String scenario ;
	ArrayList<Track> trackArrayList;
	
	class Detection
	{
		double x,y,z;
		int t;		
		
		public Detection( int t , double x , double y , double z ) {
		this.t = t;
		this.x = x;
		this.y = y;
		this.z = z;
		}
	}
	
	class Track
	{
		ArrayList<Detection> detectionList = new ArrayList<Detection>();
	}
	
	public TrackImporter(File value) throws IllegalArgumentException {

		Document document = XMLUtil.loadDocument( value );
				
		Element root = XMLUtil.getRootElement( document );
		
		if ( root == null )
		{
			throw new IllegalArgumentException( "can't find: <root> tag." ) ;		
		}
		
		ArrayList<Element> trackingSetList = XMLUtil.getSubElements( root , "TrackContestISBI2012" );
		
		if ( trackingSetList.size() == 0 )
		{
			throw new IllegalArgumentException( "can't find:  <root><TrackContestISBI2012> tag." ) ;
		}
		
		Element trackingSet = trackingSetList.get( 0 );
		
		if ( trackingSet == null )
		{
			throw new IllegalArgumentException( "can't find: <root><TrackContestISBI2012> tag." ) ;		
		}
		
		ArrayList<Element> particleElementArrayList = XMLUtil.getSubElements( trackingSet , "particle" );
		//System.out.println("nb particule: " + particleElementArrayList.size() );
		
		this.snr = XMLUtil.getAttributeDoubleValue(trackingSet, "SNR", -1 );
		this.density = XMLUtil.getAttributeDoubleValue(trackingSet, "density", -1 );
		this.scenario = XMLUtil.getAttributeValue(trackingSet, "scenario", "" );
		
		// if density or snr or scenario are different from possible values
		// throw new IllegalArgumentException( "invalid snr value: " + snr ) ;
		// throw new IllegalArgumentException( "invalid density value: " + density ) ;
		// throw new IllegalArgumentException( "invalid scenario value: " + scenario ) ;
		
		trackArrayList = new ArrayList<Track>();
		
		for ( Element particleElement : particleElementArrayList )
		{
			Track track = new Track();
			trackArrayList.add( track );
			
			ArrayList<Element> detectionElementArrayList =
					XMLUtil.getSubElements( particleElement , "detection" );

			for ( Element detectionElement : detectionElementArrayList )	
			{
				int t = XMLUtil.getAttributeIntValue( detectionElement, "t" , -1 );
				if ( t == -1 )
				{
					throw new IllegalArgumentException( "invalid t value: " + t ) ;				
				}				
				
				double x = XMLUtil.getAttributeDoubleValue( detectionElement, "x" , 0 );
				double y = XMLUtil.getAttributeDoubleValue( detectionElement, "y" , 0 );
				double z = XMLUtil.getAttributeDoubleValue( detectionElement, "z" , 0 );				
				
				track.detectionList.add( new Detection ( t ,x ,y ,z ) );
								
				System.out.println( t );
				System.out.println( x );
				System.out.println( y );
				System.out.println( z );
				
			}						
			
		}
		
		System.out.println( trackArrayList.size() +" track(s) succesfuly loaded.");
				
	}

}
