package plugins.fab.trackgenerator;

import icy.file.FileUtil;
import icy.file.Saver;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.util.XMLUtil;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import loci.formats.FormatException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BenchmarkSequence {

	/** index is t */
	ArrayList<VolumeImage> volumeImageList;
	
	ArrayList<Particle> particleArrayList;
	
	int width;
	int height;
	double density;
	String densityLabel ="";
	double snr;
	String scenario;
	int ndigits_t;
	int ndigits_z;

	public void save(String dataSetFolder , File XMLFile , String baseImageFile )
	{
		// save the images;
		ndigits_t = String.valueOf(volumeImageList.size()).length();
		ndigits_z = String.valueOf(volumeImageList.get(0).imageData.length).length();
		
		for ( int t = 0 ; t < volumeImageList.size() ; t++ )
		{
			VolumeImage vi = volumeImageList.get( t );
			for ( int z = 0 ; z < vi.imageData.length ; z++ )
			{
				String imageFileName = baseImageFile + " t"+getDigits(t, ndigits_t) + " z"+ getDigits(z, ndigits_z) ;
				IcyBufferedImage image = new IcyBufferedImage( width , height , 1 , DataType.UBYTE );
				image.setDataXY( 0 , vi.imageData[z] );
				
				try {
					Saver.saveImage(image, new File( imageFileName+".tif" ), true );
				} catch (FormatException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				}
				
			}
		}
		
		saveXML( XMLFile );
		
	}
	
	public void saveXML( File XMLFile )
	{
		// save the particleArrayList in XML.

		Document document = XMLUtil.createDocument( true );

		Element dataSetElement = document.createElement("TrackContestISBI2012");

		XMLUtil.getRootElement( document ).appendChild( dataSetElement );

		//XMLUtil.setAttributeValue( dataSetElement , "filename", FileUtil.getFileName( baseImageFile ) );
		XMLUtil.setAttributeDoubleValue( dataSetElement , "SNR" , snr );
		XMLUtil.setAttributeValue( dataSetElement , "density" , densityLabel );
		Date now = new Date();
		XMLUtil.setAttributeValue( dataSetElement , "generationDateTime" , now.toString() );
		XMLUtil.setAttributeValue( dataSetElement , "info" , "http://bioimageanalysis.org/track/" );
		XMLUtil.setAttributeValue( dataSetElement , "scenario" , scenario );

		for ( Particle particle: particleArrayList )
		{
			Element particleElement =  document.createElement("particle");
			dataSetElement.appendChild(particleElement);

			for ( TGDetection detection : particle.detectionArrayList )
			{
				Element detectionElement =  document.createElement("detection");
				particleElement.appendChild( detectionElement );
				XMLUtil.setAttributeDoubleValue( detectionElement , "x" , roundDecimals2(detection.x) );
				XMLUtil.setAttributeDoubleValue( detectionElement , "y" , roundDecimals2(detection.y) );
				XMLUtil.setAttributeDoubleValue( detectionElement , "z" , roundDecimals2(detection.z) );
				XMLUtil.setAttributeIntValue( detectionElement , "t" , detection.t );
			}

		}

		XMLUtil.saveDocument( document , XMLFile );
	}

	private double roundDecimals2(double value) {
		value = value * 1000d;
		value = Math.round(value);
		return value/1000d;		
	}

	String getDigits(int n, int ndigits) {
	    String digits = "00000000000" + n;
	    return digits.substring(digits.length() - ndigits);
	}

	/**
	 * @deprecated brings a "," decimal separator.
	 * @param d
	 * @return
	 */
	String roundDecimals(double d) {
		DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.getDefault());
		otherSymbols.setDecimalSeparator('.');
		otherSymbols.setGroupingSeparator(','); 
		
        DecimalFormat twoDForm = new DecimalFormat("0.000", otherSymbols);
        twoDForm.setGroupingUsed(false);
        return twoDForm.format(d);
	}

	public void displaySequence( boolean displayTrackWithTrackManager ) {

		Sequence sequence = new Sequence( );
		sequence.setName( "snr " + snr + " density " + density + " " + scenario );
		
		for ( int t = 0 ; t < volumeImageList.size() ; t++ )
		{
			VolumeImage vi = volumeImageList.get( t );
			for ( int z = 0 ; z < vi.imageData.length ; z++ )
			{				
				IcyBufferedImage image = new IcyBufferedImage( width , height , 1 , DataType.UBYTE );
				image.setDataXY( 0 , vi.imageData[z] );
				
				sequence.setImage(t, z, image);				
			}
		}
		
		Icy.addSequence( sequence );
		
		if ( displayTrackWithTrackManager )
		{
			DisplayTools.addTracks( sequence , particleArrayList );
		}
		
	}
}
