package plugins.fab.trackgenerator;

import java.util.ArrayList;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;

/**
 * the same PSF as in WFMicroscopePSF.java, the only difference 
 * is that the output values (PSF amplidute) is squared, compared to WF PSF
 *
 */

public class LSCMicroscopePSF extends PSF
{
	private int _w;
	private int _h;
	private int _z;
	private double _indexImmersion;
	private double _na;
	private int _lem;
	private double _indexSpRefr;
	private double _xySampling;
	private double _zSampling;
	private double _depth;
	
	public final static int DEFAULT_W = 128;
	public final static int DEFAULT_H = 128;
	public final static int DEFAULT_Z = 1;
	public final static double DEFAULT_INDEXIMMERSION = 1.515;
	public final static double DEFAULT_NA = 1.4;
	public final static int DEFAULT_LEM = 520;
	public final static double DEFAULT_INDEXSP = 1.33;
	public final static double DEFAULT_XYSAMPLING = 50.00;
	public final static double DEFAULT_ZSAMPLING = 200.00;
	public final static double DEFAULT_DEPTH = 0.0;
	
	public LSCMicroscopePSF(int w, int h, int z, double indexImmersion, double na, int lem, double indexSpRefr, double xySampling, double zSampling, double depth)
	{
		this._w = w;
		this._h = h;
		this._z = z;
		this._indexImmersion = indexImmersion;
		this._na = na;
		this._lem = lem;
		this._indexSpRefr = indexSpRefr;
		this._xySampling = xySampling;
		this._zSampling = zSampling;
		this._depth = depth;
	}
	
	public LSCMicroscopePSF()
	{
		this._w = DEFAULT_W;
		this._h = DEFAULT_H;
		this._z = DEFAULT_Z;
		this._indexImmersion = DEFAULT_INDEXIMMERSION;
		this._na = DEFAULT_NA;
		this._lem = DEFAULT_LEM;
		this._indexSpRefr = DEFAULT_INDEXSP;
		this._xySampling = DEFAULT_XYSAMPLING;
		this._zSampling = DEFAULT_ZSAMPLING;
		this._depth = DEFAULT_DEPTH;
	}
	
	public ArrayList<double[]> getPSFProfile( )
	{

		final DoubleFFT_2D fft = new DoubleFFT_2D(_w, _h);
		//IcyBufferedImage psf3d = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);

		int hc = _h/2;
		int wc = _w/2;
		int zc = _z/2;
		double kSampling = (2*Math.PI)/(_h*_xySampling); //Fourier space sampling
		double lambdaObj = _lem/_indexImmersion;//Wavelength of light inside the medium
		double lambdaSp = _lem/_indexSpRefr;//Wavelength of light inside the medium
		double k0 = (2*Math.PI)/_lem;//Wave vector
		double kObj = (2*Math.PI)/lambdaObj;//Wave vector in the immersion medium
		double kSp = (2*Math.PI)/lambdaSp;//Wave vector in the medium
		double kMax = (2*Math.PI*_na)/(_lem*kSampling);//Maximum aperture radius
		//double saCoeff = _depth * (_indexSpRefr-_indexImmersion);

		// Define the zero defocus pupil function
		//IcyBufferedImage pupil = new IcyBufferedImage(_w, _h, 2, DataType.FLOAT); // channel 1 is real and channel 2 is imaginary
		//float[] pupilRealBuffer = pupil.getDataXYAsFloat(0);//Real
		//float[] pupilImagBuffer = pupil.getDataXYAsFloat(1);//imaginary
		float[] pupilRealBuffer = new float[_w*_h];
		float[] pupilImagBuffer = new float[_w*_h];
		

//		IcyBufferedImage dpupil = new IcyBufferedImage(_w, _h, 2, DataType.DOUBLE); // channel 1 is real and channel 2 is imaginary
//		double[] dpupilRealBuffer = dpupil.getDataXYAsDouble(0); //Real
//		double[] dpupilImagBuffer = dpupil.getDataXYAsDouble(1); //imaginary
		double[] dpupilRealBuffer =  new double[_w*_h];; //Real
		double[] dpupilImagBuffer =  new double[_w*_h];; //imaginary

		
		//Calculate the cosine and the sine components
		//IcyBufferedImage ctheta = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);
		//double[] cthetaBuffer = ctheta.getDataXYAsDouble(0);
		double[] cthetaBuffer = new double[_w*_h];

		//IcyBufferedImage cthetaSp = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);
		//double[] cthetaSpBuffer = cthetaSp.getDataXYAsDouble(0);
		double[]  cthetaSpBuffer = new double[_w*_h];

		//IcyBufferedImage stheta = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);
		//double[] sthetaBuffer = stheta.getDataXYAsDouble(0);
		double[] sthetaBuffer =new double[_w*_h];
		
		//IcyBufferedImage sthetaSp = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);
		//double[] sthetaSpBuffer = sthetaSp.getDataXYAsDouble(0);
		double[] sthetaSpBuffer =new double[_w*_h];

		
		//Sequence psf3d = new Sequence();
		//psf3d.setName("WideField PSF");
		ArrayList<double[]> psf3d = new ArrayList<double[]>();
		
		for (int k =  0 ; k < _z; k++)
		{// Define the defocus pupils			

			double defocus = k-zc;
			defocus = defocus*_zSampling;	

			for(int x = 0; x < _w; x++)
			{
				for(int y = 0; y < _h; y++)
				{   
					double kxy = Math.sqrt( Math.pow(x-wc, 2) + Math.pow(y-hc, 2) );

					pupilRealBuffer[x+y*_w] = ((kxy < kMax) ? 1 : 0); //Pupil bandwidth constraints
					pupilImagBuffer[x+y*_w] = 0; //Zero phase 

					sthetaBuffer[x + y * _h] = Math.sin( kxy * kSampling / kObj );
					sthetaBuffer[x + y * _h] = (sthetaBuffer[x + y * _h]< 0) ? 0: sthetaBuffer[x + y * _h];
					sthetaSpBuffer[x + y * _h] = Math.sin( kxy * kSampling / kSp );
					sthetaSpBuffer[x + y * _h] = (sthetaSpBuffer[x + y * _h]< 0) ? 0: sthetaSpBuffer[x + y * _h];
					cthetaBuffer[x + y * _h] = Double.MIN_VALUE + Math.sqrt(1 - Math.pow(sthetaBuffer[x + y * _h], 2));
					cthetaSpBuffer[x + y * _h] = Double.MIN_VALUE + Math.sqrt(1 - Math.pow(sthetaSpBuffer[x + y * _h], 2));
					dpupilRealBuffer[x + y * _h] = pupilRealBuffer[x+y*_w] * Math.cos((defocus * k0 * cthetaBuffer[x + y * _h]) + (k0 * _depth * (_indexSpRefr * cthetaSpBuffer[x + y * _h]-_indexImmersion * cthetaBuffer[x + y * _h])));
					dpupilImagBuffer[x + y * _h] = pupilRealBuffer[x+y*_w] * Math.sin((defocus * k0 * cthetaBuffer[x + y * _h]) + (k0 * _depth * (_indexSpRefr * cthetaSpBuffer[x + y * _h]-_indexImmersion * cthetaBuffer[x + y * _h])));
				}
			}
			//double[] psf2d = dpupil.getDataCopyCXYAsDouble();			
			double[] psf2d = new double[_w*_h*2];
			for (int i = 0; i < dpupilImagBuffer.length; i++)
			{
				psf2d[2*i] = dpupilRealBuffer[i];
				psf2d[2*i+1] = dpupilImagBuffer[i];
			}
			fft.complexInverse(psf2d, false);

			//IcyBufferedImage timg = new IcyBufferedImage(_w, _h, 1, DataType.DOUBLE);
			double[] timg = new double[_w*_h];
			//timg.beginUpdate();
			try{
				for(int x = 0; x < (wc+1); x++)
				{
					for(int y = 0; y < (hc+1); y++)
					{
						timg[x+_w*y] = Math.pow(psf2d[(((wc-x) + (hc-y) * _h)*2)+0],2)+Math.pow(psf2d[(((wc-x) + (hc-y) * _h)*2)+1], 2);
						//timg.setDataAsDouble(x, y, 0, Math.sqrt(Math.pow(psf2d[(((wc-x) + (hc-y) * _h)*2)+0],2)+Math.pow(psf2d[(((wc-x) + (hc-y) * _h)*2)+1], 2)));
					}
					for(int y = hc+1; y < _h; y++)
					{
						timg[x+_w*y] =  Math.pow(psf2d[(((wc-x) + (y-hc) * _h)*2)+0], 2)+Math.pow(psf2d[(((wc-x) + (y-hc) * _h)*2)+1], 2);
						//timg.setDataAsDouble(x, y, 0, Math.sqrt(Math.pow(psf2d[(((wc-x) + (y-hc) * _h)*2)+0], 2)+Math.pow(psf2d[(((wc-x) + (y-hc) * _h)*2)+1], 2)));
					}

				}
				for(int x = (wc+1); x < _w; x++)
				{
					for(int y = 0; y < (hc+1); y++)
					{
						timg[x+_w*y] = Math.pow(psf2d[(((x-wc) + (hc-y) * _h)*2)+0], 2)+Math.pow(psf2d[(((x-wc) + (hc-y) * _h)*2)+1], 2);
						//timg.setDataAsDouble(x, y, 0, Math.sqrt(Math.pow(psf2d[(((x-wc) + (hc-y) * _h)*2)+0], 2)+Math.pow(psf2d[(((x-wc) + (hc-y) * _h)*2)+1], 2)));
					}
					for(int y = hc+1; y < _h; y++)
					{
						timg[x+_w*y]  = Math.pow(psf2d[(((x-wc) + (y-hc) * _h)*2)+0], 2)+Math.pow(psf2d[(((x-wc) + (y-hc) * _h)*2)+1],2);
						//timg.setDataAsDouble(x, y, 0, Math.sqrt(Math.pow(psf2d[(((x-wc) + (y-hc) * _h)*2)+0], 2)+Math.pow(psf2d[(((x-wc) + (y-hc) * _h)*2)+1],2)));
					}
				}

			}finally {
				//timg.endUpdate();
			}

			psf3d.add(timg);
		}

		return psf3d;

	}
}
