package plugins.fab.trackgenerator;

import java.util.ArrayList;
import flanagan.math.PsRandom;

public class PoissonBernouilliTrackManager implements ParticleCreatorAndTerminator
{
	double rateDisappearance;
	double meanAppearance;
	PsRandom ran;
	ParticleCreator creator;

	public PoissonBernouilliTrackManager(ParticleCreator creator, double rateDisappearance, double meanAppearance, PsRandom ran)
	{
		this.rateDisappearance = rateDisappearance;
		this.meanAppearance = meanAppearance;
		this.ran = ran;
		this.creator = creator;
	}
	
	public void createInitialTracks(int numberParticles, ArrayList<Particle> activeParticles, ArrayList<Particle> allParticles)
	{
		int t = 0;
		for ( int i = 0 ; i < numberParticles ; i ++ )
		{
			Particle newParticle = creator.createNewParticle(t);	
			activeParticles.add( newParticle );
			allParticles.add(newParticle);
		}
	}
	
	@Override
	public void createAndTerminate(ArrayList<Particle> activeParticles, ArrayList<Particle> allParticles, int t)
	{
		ArrayList<Particle> activeParticlesClone = (ArrayList<Particle>) activeParticles.clone();
		// terminate particles with a Bernouilli process
		for (Particle p:activeParticlesClone)
		{
			if (ran.nextDouble()<rateDisappearance)
			{
				activeParticles.remove(p);
			}
		}
		// create new particles with a Poisson process and uniform spatial distribution
		int numberNewTracks = (int) PoissonNoiseGenerator.nextPoissonian(meanAppearance);
		for (int n = 0; n < numberNewTracks; n++)
		{
			Particle newParticle = creator.createNewParticle(t+1);
			activeParticles.add(newParticle);
			allParticles.add(newParticle);
		}
	}
}
