package plugins.fab.trackgenerator;

import flanagan.analysis.Stat;
import flanagan.math.PsRandom;

public class PoissonNoiseGenerator {

	public static PsRandom ranG = new PsRandom();
	
	// the next piece of code is taken from the Flanagan's implenemtation of the Poisson generator, 
	// but the BUG in the Flanagan's code is fixed, so the poisson deviates are correctly 
	// generated, as described in Numerical Recipes, p295. 
	public static double nextPoissonian(double mean){
        double ran = 0.0D;
        double oldm = -1.0D;
        double expt = 0.0D;
        double em = 0.0D;
        double term = 0.0D;
        double sq = 0.0D;
        double lnMean = 0.0D;
        double yDev = 0.0D;

        if(mean < 12.0D){
            if(mean != oldm){
                oldm = mean;
                expt = Math.exp(-mean);
            }
            em = -1.0D;
            term = 1.0D;
            do{
                ++em;
                term *= ranG.nextDouble();
            }while(term>expt);
            ran = em;
        }
        else{
            if(mean != oldm){
                oldm = mean;
                sq = Math.sqrt(2.0D*mean);
                lnMean = Math.log(mean);
                expt = mean * lnMean - Stat.logGamma(mean+1.0D);
            }
            do{
                do{
                    yDev = Math.tan(Math.PI*ranG.nextDouble());
                    em = sq*yDev+mean;
                }while(em<0.0D);
                em = Math.floor(em);
                term = 0.9D*(1.0D+yDev*yDev)*Math.exp(em*lnMean - Stat.logGamma(em+1.0D)-expt);
            }while(ranG.nextDouble()>term);
            ran = em;
        }
        return ran;
    }
}
