package plugins.fab.trackgenerator;

import java.util.ArrayList;

import plugins.adufour.ezplug.EzGUI;

import flanagan.math.PsRandom;

public class TrackGenerationUtil {

	// Probably those parameters can also go to the menu at some point (ihor) ???
	static double PSF_NA = 1.4;
	static int PSF_lambda = 520;
	static double PSF_indexImmersion = 1.515;
	static double PSF_indexSpRefr = 1.33;

	static BenchmarkSequence generateSequenceBenchMark(
			int xbordersSimu,
			int ybordersSimu,
			int zbordersSimu,
			int width,
			int height,
			int depth,
			long randomSeed,
			//double halfSizePSF,
			double sliceSpacing,
			double xyPixelSize,
			//int numberParticle,
			CreatorTypes creatorEnum,
			double sigma_BROWNIAN_UNIFORM,
			double q1,
			double Vmin, 
			double Vmax, 
			double sigmaBrownian_SWITCHING_UNIFORM,
			double probaDirectedBrownian, 
			double probaBrownianDirected,
			double deseapearingRate,
			int sequenceLength,
			int warmUpPeriod,
			int minTrackLength,
			double snr, EzGUI ezGUI,
			double density,
			String densityLabel,
			Scenario scenario
	)
	{
		if ( ezGUI!=null )
		{			
			ezGUI.setProgressBarMessage("Computation started.");		
		}

		// simulate almost pure 2D (in focus) scenario or 3D scenario ? 
		boolean isMotionPureIn2D = (depth == 1) ? true : false;

		ParticleCreator creator = null;

		ArrayList<Particle> allParticles = new ArrayList<Particle>();		
		ArrayList<Particle> activeParticles = new ArrayList<Particle>();

		double minXSimu = 0 - xbordersSimu;
		double maxXSimu = width - 1 + xbordersSimu;
		double minYSimu = 0 - ybordersSimu;
		double maxYSimu = height -1 + ybordersSimu;
		double minZSimu = 0 - zbordersSimu;
		double maxZSimu = (depth - 1) * sliceSpacing / xyPixelSize + zbordersSimu;
		PsRandom ran = new PsRandom( randomSeed );

		// parameters for cutting the tracks
		double minXParticle = 0;
		double maxXParticle = width - 1;
		double minYParticle = 0;
		double maxYParticle = height - 1;

		//TODO: 
		//according to Thomann the sigma_xy and sigma_z for Gaussian approximation of the PSF are given by 
		//			 double sigma_xy = 0.21 * PSF_lambda / PSF_NA / xyPixelSize;
		double sigma_z = 0.66 * PSF_lambda * PSF_indexSpRefr / (PSF_NA * PSF_NA) / sliceSpacing;
		// SO, is if possible to substitute the parameter zGap with those automatically computed values
		// and throw away "halfSizePSF" from the GUI			
		//zGap = halfSizePSF * sliceSpacing /xyPixelSize ;
		// the halfSizePSF in Z, in [pix] is Math.sqrt(Math.log(2) * 2) * sigma_z, so 
		double zGap = Math.sqrt(Math.log(2) * 2) * sigma_z * sliceSpacing / xyPixelSize;

		double minZParticle = - zGap;
		double maxZParticle = (depth - 1) * sliceSpacing / xyPixelSize + zGap;

		double volumeCrop = (maxXParticle - minXParticle)*(maxYParticle - minYParticle)*(maxZParticle - minZParticle);
		if (volumeCrop<=0)
			throw new IllegalArgumentException("The volume of the crop has to be strictly positive");

		double volumeSimu = (maxXSimu-minXSimu)*(maxYSimu-minYSimu)*(maxZSimu-minZSimu);
		//long numberParticlesSimu = (int)Math.round(((double)numberParticle)*volumeSimu/volumeCrop);
		long numberParticlesSimu = (int)Math.round(((double)density)*volumeSimu/volumeCrop);

		if ( ezGUI !=null )
		{
			ezGUI.setProgressBarMessage("Computing tracks.");
		}

		switch (creatorEnum)
		{
		case BROWNIAN_UNIFORM:
		{
			//double sigma = 2;
			creator = new BrownianUniformParticleCreator(
					sigma_BROWNIAN_UNIFORM,
					new PointSourceShape(),
					minXSimu,
					maxXSimu,
					minYSimu,
					maxYSimu,
					minZSimu,
					maxZSimu,
					ran, 
					isMotionPureIn2D);
			break;
		}
		case SWITCHING_UNIDIRECTIONAL_UNIFORM:
		{
			creator = new SwitchingUnidirectionalParticleCreator(
					q1,
					Vmin, 
					Vmax, 
					sigmaBrownian_SWITCHING_UNIFORM,
					probaDirectedBrownian, 
					probaBrownianDirected, 
					new PointSourceShape(), 
					minXSimu, 
					maxXSimu, 
					minYSimu, 
					maxYSimu, 
					minZSimu, 
					maxZSimu, 
					ran, 
					isMotionPureIn2D);
			break;
		}
		case SWITCHING_UNIFORM:
		{
			//			double q1 = 1;
			//			double Vmin = 1;
			//			double Vmax = 5;
			//			double sigmaBrownian = 2;
			//			double probaDirectedBrownian = 0.3;
			//			double probaBrownianDirected = 0.3;
			creator = new SwitchingUniformParticleCreator(
					q1,
					Vmin, 
					Vmax, 
					sigmaBrownian_SWITCHING_UNIFORM,
					probaDirectedBrownian, 
					probaBrownianDirected, 
					new PointSourceShape(), 
					minXSimu, 
					maxXSimu, 
					minYSimu, 
					maxYSimu, 
					minZSimu, 
					maxZSimu, 
					ran, 
					isMotionPureIn2D);
			break;
		}
		case DIRECTED_MIXED:
		{
			//			double q1 = 1;
			//			double Vmin = 1;
			//			double Vmax = 5;
			creator = new DirectedMotionMixedParticleCreator(
					q1,
					Vmin,
					Vmax,
					new MicrotubuleShape(),
					minXSimu,
					maxXSimu,
					minYSimu,
					maxYSimu, 
					minZSimu, 
					maxZSimu,
					ran,
					isMotionPureIn2D);
			break;
		}

		}

		double rate = deseapearingRate;

		ParticleCreatorAndTerminator creatorTerminator = new  PoissonBernouilliTrackManager(creator, rate, rate*numberParticlesSimu, ran);
		//creatorTerminator.createInitialTracks(numberParticle, activeParticles, allParticles);
		creatorTerminator.createInitialTracks( (int)density, activeParticles, allParticles);


		for (int t = 1; t < sequenceLength-1 + warmUpPeriod; t++)
		{
			//	System.out.println(activeParticles.size());
			for (Particle p :activeParticles)
				p.move();
			creatorTerminator.createAndTerminate(activeParticles, allParticles, t);
		}

		// cut tracks in the warm up period
		cutWarmupPeriod(allParticles, warmUpPeriod );

		// cut the tracks so that they cannot re-enter the volume after quitting it
		// delete the tracks that are only staying outside the image
		// cut the tracks that are born outside the image but enter it after a delay		
		allParticles = cropAndcutTracks(allParticles, minXParticle, maxXParticle, minYParticle, maxYParticle, minZParticle, maxZParticle);

		// rescale target position according to the pixel size
		rescaleZCoordinate(allParticles, xyPixelSize, sliceSpacing );

		// delete short tracks
		//int minTrackLength = 2;
		int maxTrackLength = Integer.MAX_VALUE;
		System.out.println( "*** Number of track before filtering lenght: " + allParticles.size() );
		allParticles = lengthBasedSelection(allParticles, minTrackLength , maxTrackLength );
		System.out.println( "*** Number of track after filtering lenght: " + allParticles.size() ); 



		// count the number of active tracks per frame
		int[] numTracks = new int[sequenceLength ];
		for (Particle p:allParticles)
		{
			for (TGDetection d:p.detectionArrayList)
			{
				numTracks[d.t]++;
			}
		}
		System.out.println("numParticles");
		double average = 0;
		for (int i =0; i < numTracks.length; i++)
		{
			average += numTracks[i]; 
			System.out.println("track " + i + " " + numTracks[i]+" ");
		}
		System.out.println("AVERAGE: " + (average / numTracks.length));
		System.out.println();

		// create an image from the set of Particles
		{			
			//			ArrayList<byte[]> imageList = new ArrayList<byte[]>();
			//
			//			//						Particle ptmp = allParticles.get( 0 ); // just to isolate the first one for tests
			//			//						allParticles.clear();
			//			//						allParticles.add( ptmp );
			//
			//			for ( int i = 0 ; i < sequenceLength ; i++ )
			//			{
			//				byte data [] = new byte[width *height ];
			//				imageList.add( data );
			//			}
			//			for (Particle p:allParticles)
			//			{
			//				for (TGDetection d: p.detectionArrayList)
			//				{
			//					byte data[] = imageList.get(d.t);
			//					int x = (int)Math.round( d.x );
			//					int y = (int)Math.round( d.y );
			//					if ( x >= 0 && x < width  && y >=0 && y< height  )
			//					{
			//						data[x+y*width ] = (byte)255;
			//					}
			//				}
			//			}			

			ArrayList<VolumeImage> volumeImageList = null;
			switch ( creatorEnum  )
			{
			case BROWNIAN_UNIFORM:
			{
				int psfWidth = 512;
				int psfDepth = 512;
				int psfWidthUpSampling = 11; // only odd numbers here
				int psfDepthUpSampling = 11; // only odd numbers here

				positionAdjustmentDueToPSFUpscaling(allParticles, psfWidthUpSampling, psfDepthUpSampling);

				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating PSF.");
				PSF psf = new WFMicroscopePSF(psfWidth, psfWidth, psfDepth, PSF_indexImmersion, PSF_NA, PSF_lambda, PSF_indexSpRefr, xyPixelSize  / psfWidthUpSampling, sliceSpacing  / psfDepthUpSampling, 0);
				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating images.");
				ImageCreatorPSFlikeObjects imageCreator = new ImageCreatorPSFlikeObjects(
						allParticles, width , height , depth , sequenceLength ,
						ran, psf, psfWidth, psfDepth, xyPixelSize , sliceSpacing , psfWidthUpSampling,
						psfDepthUpSampling, snr );
				volumeImageList = imageCreator.getImage();
				break;
			}
			case SWITCHING_UNIDIRECTIONAL_UNIFORM:
			case SWITCHING_UNIFORM:
			{
				int psfWidth = 512;
				int psfDepth = 512;
				int psfWidthUpSampling = 11; // only odd numbers here
				int psfDepthUpSampling = 11; // only odd numbers here

				positionAdjustmentDueToPSFUpscaling(allParticles, psfWidthUpSampling, psfDepthUpSampling);

				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating PSF.");
				PSF psf = new LSCMicroscopePSF(psfWidth, psfWidth, psfDepth, PSF_indexImmersion, PSF_NA, PSF_lambda, PSF_indexSpRefr,
						xyPixelSize  / psfWidthUpSampling, sliceSpacing  / psfDepthUpSampling, 0);
				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating images.");
				ImageCreatorPSFlikeObjects imageCreator = new ImageCreatorPSFlikeObjects(
						allParticles , width , height , depth ,
						sequenceLength , ran, psf, psfWidth, psfDepth, xyPixelSize ,
						sliceSpacing , psfWidthUpSampling, psfDepthUpSampling, snr  );
				volumeImageList = imageCreator.getImage();
				break;
			}
			case DIRECTED_MIXED:
			{
				//defines Gaussian PSF (if sigmaX = sigmaY), otherwise - an elongated MT-like objects (with sigmaX > sigmaY)
				//				double sigmaX = 6.9;
				//				double sigmaY = 1.7;
				//				double sigmaZ = 1.7;

				// the next parameter definition is according to Thomann's paper and he Gaussian approximation of the PSF 
				double sigmaY = 0.21 * PSF_lambda / PSF_NA / xyPixelSize;
				double sigmaX = 4 * sigmaY;
				double sigmaZ = 0.66 * PSF_lambda * PSF_indexSpRefr / (PSF_NA * PSF_NA) / sliceSpacing;

				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating PSF.");
				if ( ezGUI !=null ) ezGUI.setProgressBarMessage("creating images.");
				ImageCreatorMicrotubuleLikeObjects imageCreator = new ImageCreatorMicrotubuleLikeObjects(
						allParticles, width , height , depth , 
						sequenceLength , sigmaX, sigmaY, sigmaZ, ran, xyPixelSize, sliceSpacing , snr );
				volumeImageList = imageCreator.getImage();
				break;
			}
			default:
			{
				throw new IllegalArgumentException("Invalid creator type");
			}
			}

			// TODO: decide if zeroing should be done before the image creation of after (the second 
			// way is more realistic)
			// zero the z-coordinate in order to create 2D scenario
			if (isMotionPureIn2D) {
				zeroZcoordinate(allParticles);
			}

			//			ArrayList<byte[][]> data = new ArrayList<byte[][]>();
			//			for (int i = 0; i < volumeImageList.size(); i++) {
			//				data.add(volumeImageList.get(i).imageData);
			//			}			
			//			DisplayTools.display3DImage( data, width.getValue() , height.getValue() , allParticles );


			BenchmarkSequence benchmarkSequence = new BenchmarkSequence();
			benchmarkSequence.particleArrayList = allParticles;
			benchmarkSequence.volumeImageList = volumeImageList;
			benchmarkSequence.width = width ;
			benchmarkSequence.height = height ;
			benchmarkSequence.snr = snr ;
			//benchmarkSequence.density = numberParticle ;
			benchmarkSequence.density = density ;
			benchmarkSequence.scenario = scenario.name() ;
			benchmarkSequence.densityLabel = densityLabel ;

			return benchmarkSequence;
		}


	}



	static public void cutWarmupPeriod(ArrayList<Particle> allParticles, int warmUpPeriod) {

		ArrayList<Particle> cloneParticles = (ArrayList<Particle>) allParticles.clone();
		for (Particle p:cloneParticles)
		{
			if (p.detectionArrayList.get(0).t>=warmUpPeriod)
			{
				for (TGDetection d:p.detectionArrayList)
					d.t = d.t - warmUpPeriod;
			}
			else
			{
				if (p.detectionArrayList.get(p.detectionArrayList.size()-1).t>=warmUpPeriod)
				{
					// we have to cut the particle trajectory
					ArrayList<TGDetection> cloneDetectionList = (ArrayList<TGDetection>) p.detectionArrayList.clone();
					p.detectionArrayList.clear();
					for (TGDetection d:cloneDetectionList)
					{
						if (d.t>=warmUpPeriod)
							p.detectionArrayList.add(d);
					}
					for (TGDetection d:p.detectionArrayList)
						d.t = d.t - warmUpPeriod;
				}
				else
					allParticles.remove(p);
			}
		}
	}

	static public ArrayList<Particle> cropAndcutTracks(ArrayList<Particle> allParticles, double minXParticle, double maxXParticle, double minYParticle, double maxYParticle, double minZParticle, double maxZParticle)
	{
		ArrayList<Particle> cleanSet = new ArrayList<Particle>();
		for (Particle p:allParticles)
		{
			Particle newParticle = null;
			for (TGDetection d:p.detectionArrayList)
			{
				double x = d.x;
				double y = d.y;
				double z = d.z;

				if ( x >= minXParticle && x <= maxXParticle && y >=minYParticle && y<= maxYParticle && z >=minZParticle && z <=maxZParticle)
				{
					if (newParticle == null)
					{
						newParticle = new Particle(p.shape, null);
						newParticle.detectionArrayList.add(d);
					}
					else
					{
						newParticle.detectionArrayList.add(d);
					}
				}
				else
				{
					if (newParticle != null)
					{
						// cut the track as it has went out of the image
						break;
					}
				}
			}
			if (newParticle!=null)
			{
				cleanSet.add(newParticle);
			}
		}		
		return cleanSet;
	}

	static public void zeroZcoordinate(ArrayList<Particle> allParticles)
	{
		for (Particle p:allParticles)
			for (TGDetection d:p.detectionArrayList)
				d.z = 0.0;
	}

	static public void rescaleZCoordinate(ArrayList<Particle> allParticles, double xyPixelSize, double zPixelSize)
	{
		double scalingFactor = xyPixelSize/zPixelSize;
		for (Particle p:allParticles)
			for (TGDetection d:p.detectionArrayList)
				d.z = d.z*scalingFactor;
	}

	static public ArrayList<Particle> lengthBasedSelection(ArrayList<Particle> allParticles, int minTrackLength, int maxTrackLength)
	{
		ArrayList<Particle> subset = new ArrayList<Particle>();
		for (Particle p:allParticles)
		{
			//			System.out.print( p.detectionArrayList.size() + " : " );
			if ( p.detectionArrayList.size() >= minTrackLength && p.detectionArrayList.size() <= maxTrackLength )
			{
				//				System.out.println("added");
				subset.add(p);
			}
			else
			{
				//				System.out.println("rejected");
			}
		}
		return subset;
	}

	// the PSF is sampled only for a discrete number of intervals within single pixel (using psfWidthUpSampling and psfDepthUpSampling values)
	// it means that the ground truth trajectory also has to to adjusted and has to pass through those discrete subpixel locations
	// in other words the detection coordinates cannot have any possible precision, but limited to a number of Nxy=psfWidthUpSampling and Nz=psfDepthUpSampling values
	static public void positionAdjustmentDueToPSFUpscaling(ArrayList<Particle> allParticles, int psfWidthUpSampling, int psfDepthUpSampling)
	{
		double DxXY = 1.0 / psfWidthUpSampling;
		double DxZ = 1.0 / psfDepthUpSampling;
		for (Particle p:allParticles)
			for (int i = 0; i < p.detectionArrayList.size(); i++) {
				double x = p.detectionArrayList.get(i).x;
				double y = p.detectionArrayList.get(i).y;
				double z = p.detectionArrayList.get(i).z;
				int sx = (int)((x - Math.round(x) + 0.5) / DxXY);
				int sy = (int)((y - Math.round(y) + 0.5) / DxXY);
				int sz = (int)((z - Math.round(z) + 0.5) / DxZ);
				p.detectionArrayList.get(i).x = Math.round(x) - 0.5 + DxXY * (0.5 + sx);
				p.detectionArrayList.get(i).y = Math.round(y) - 0.5 + DxXY * (0.5 + sy);
				p.detectionArrayList.get(i).z = Math.round(z) - 0.5 + DxZ * (0.5 + sz);
			}
	}


	public static BenchmarkSequence generateSequenceBenchMark(
			Scenario scenarioName, Double snr, Double density , String densityLabel,
			int depth_for_virus , 
			int depth_for_microtubule,
			int depth_for_vesicle,
			int depth_for_receptor,			
			long seed,
			int width, int height, int length
	) {

		BenchmarkSequence benchmarkSequence = null;

		switch( scenarioName )
		{
		case MICROTUBULE:
		{
			benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark( 
					100,		//				xbordersSimu,
					100,		//				ybordersSimu,
					20,		//				zbordersSimu,
					width,		//				width,
					height,		//				height,
					depth_for_microtubule,		//				depth,
					seed,		//				randomSeed,
					250,		//				sliceSpacing,
					50,		//				xyPixelSize,
					CreatorTypes.DIRECTED_MIXED	,	//				creatorEnum,
					1	,	//				sigma_BROWNIAN_UNIFORM,
					0.6,		//				q1,
					3,		//				Vmin,
					7,		//				Vmax,
					0.3,		//				sigmaBrownian_SWITCHING_UNIFORM,
					0.3,		//				probaDirectedBrownian,
					0.3,		//				probaBrownianDirected,
					0.10,		//				deseapearingRate,
					length,		//				sequenceLength,
					50,	//				warmUpPeriod,
					4,		//				minTrackLength,
					snr,		//				snr,
					null,		//				ezGUI,
					density,		//				density
					densityLabel,
					scenarioName
			);				
			break;
		}
		case VESICLE:
		{
			benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark( 
					100,		//				xbordersSimu,
					100,		//				ybordersSimu,
					20,		//				zbordersSimu,
					width,		//				width,
					height,		//				height,
					depth_for_vesicle,		//				depth,
					seed,		//				randomSeed,
					220,		//				sliceSpacing,
					67,		//				xyPixelSize,
					CreatorTypes.BROWNIAN_UNIFORM,	//				creatorEnum,
					2	,	//				sigma_BROWNIAN_UNIFORM,
					0.5,		//				q1,
					4,		//				Vmin,
					8,		//				Vmax,
					0.3,		//				sigmaBrownian_SWITCHING_UNIFORM,
					0.3,		//				probaDirectedBrownian,
					0.3,		//				probaBrownianDirected,
					0.05,		//				deseapearingRate,
					length,		//				sequenceLength,
					50,	//				warmUpPeriod,
					4,		//				minTrackLength,
					snr,		//				snr,
					null,		//				ezGUI,
					density,		//				density
					densityLabel,
					scenarioName
			);

			break;
		}
		case VIRUS:
		{
			benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark( 
					100,		//				xbordersSimu,
					100,		//				ybordersSimu,
					20,		//				zbordersSimu,
					width,		//				width,
					height,		//				height,
					depth_for_virus,		//				depth,
					seed,		//				randomSeed,
					300,		//				sliceSpacing,
					67,		//				xyPixelSize,
					CreatorTypes.SWITCHING_UNIDIRECTIONAL_UNIFORM	,	//				creatorEnum,
					3	,	//				sigma_BROWNIAN_UNIFORM,
					1.25,		//				q1,
					2,		//				Vmin,
					6,		//				Vmax,
					0.6,		//				sigmaBrownian_SWITCHING_UNIFORM,
					0.15,		//				probaDirectedBrownian,
					0.1,		//				probaBrownianDirected,
					0.05,		//				deseapearingRate,
					length,		//				sequenceLength,
					50,	//				warmUpPeriod,
					4,		//				minTrackLength,
					snr,		//				snr,
					null,		//				ezGUI,
					density,		//				density
					densityLabel,
					scenarioName
			);
			break;
		}
		case RECEPTOR:
		{
			benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark( 
					100,		//				xbordersSimu,
					100,		//				ybordersSimu,
					20,		//				zbordersSimu,
					width,		//				width,
					height,		//				height,
					depth_for_receptor,		//				depth,
					seed,		//				randomSeed,
					220,		//				sliceSpacing,
					67,		//				xyPixelSize,
					CreatorTypes.SWITCHING_UNIFORM	,	//				creatorEnum,
					1	,	//				sigma_BROWNIAN_UNIFORM,
					1.25,		//				q1,
					2,		//				Vmin,
					6,		//				Vmax,
					0.6,		//				sigmaBrownian_SWITCHING_UNIFORM,
					0.15,		//				probaDirectedBrownian,
					0.1,		//				probaBrownianDirected,
					0.05,		//				deseapearingRate,
					length,		//				sequenceLength,
					50,	//				warmUpPeriod,
					4,		//				minTrackLength,
					snr,		//				snr,
					null,		//				ezGUI,
					density,		//				density
					densityLabel,
					scenarioName
			);
			break;
		}

		}

		return benchmarkSequence;
	}

}
