package plugins.lagache.DetectionsInRois;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.point.Point5D;

import java.util.ArrayList;
import java.util.List;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarROIArray;

// Colocalisation with Ripley function K
// Significant 

public class DetectionsInRois extends Plugin implements Block {

	VarROIArray rois_in = new VarROIArray("Input Rois");
	VarROIArray detections_in = new VarROIArray("Input Detections");	
	VarROIArray detections_out = new VarROIArray("Output Detections");

	@Override
	public void run() {
		
		ArrayList<ROI> out = new ArrayList<ROI>();
		//on calcule l'union des ROIs en entre
		ROI cells_union = null;
		for (ROI c : rois_in.getValue())
		{			
			cells_union = c.getUnion(cells_union);			
		}
		if (cells_union == null){detections_out.setValue(null);return;}
		Point5D pos_cells = cells_union.getPosition5D();
		for (ROI spot : detections_in.getValue())
			// on balaye toutes les rois			
			{			
					if (cells_union.contains(spot.getPosition5D().getX(),spot.getPosition5D().getY(),pos_cells.getZ(),spot.getPosition5D().getT(),pos_cells.getC()))			
					{out.add(spot);}
			}
		ROI[] tab = new ROI[out.size()];
		int i=0;
		for (ROI r : out){tab[i]=r;i++;}
		detections_out.setValue(tab);		
	}
	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add("input rois", rois_in);
		inputMap.add("input detections", detections_in);

	}

	@Override
	public void declareOutput(VarList outputMap) {		
		outputMap.add("Output detections", detections_out);

	}
}
