package plugins.Yrvann.zhoubaoshi.SphericalParameterization;

import javax.vecmath.Vector3d;
import javax.vecmath.Matrix3d;


/** 
 *  The following method computes the area of a triangle (in three-dimensional space) as the Pythagorean sum 
 *  of the areas of the respective projections on the three principal planes
 *  
 *  @author Yrvann EMZIVAT (March 2014)
 *  
 **/

public class TriangleArea {

	public double area;
	
	public TriangleArea() {
		this.area = 0;
	}
	
	public void getArea(Vector3d v1, Vector3d v2, Vector3d v3) {
		
		Matrix3d Mx = new Matrix3d();
		double detMx = 0;
		Mx.m00 = v1.y; Mx.m01 = v2.y; Mx.m02 = v3.y;
		Mx.m10 = v1.z; Mx.m11 = v2.z; Mx.m12 = v3.z;
		Mx.m20 = 1;    Mx.m21 = 1;    Mx.m22 = 1;
		detMx = Mx.determinant();
		
		Matrix3d My = new Matrix3d();
		double detMy = 0;
		My.m00 = v1.z; My.m01 = v2.z; My.m02 = v3.z;
		My.m10 = v1.x; My.m11 = v2.x; My.m12 = v3.x;
		My.m20 = 1;    My.m21 = 1;    My.m22 = 1;
		detMy = My.determinant();
		
		Matrix3d Mz = new Matrix3d();	
		double detMz = 0;
		Mz.m00 = v1.x; Mz.m01 = v2.x; Mz.m02 = v3.x;
		Mz.m10 = v1.y; Mz.m11 = v2.y; Mz.m12 = v3.y;
		Mz.m20 = 1;    Mz.m21 = 1;    Mz.m22 = 1;
		detMz = Mz.determinant();
		
		this.area = 0.5*Math.sqrt(Math.pow(detMx,2) + Math.pow(detMy,2) + Math.pow(detMz,2));
	}
}
