package plugins.Yrvann.zhoubaoshi.SphericalParameterization;

import icy.sequence.Sequence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;

import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import plugins.adufour.activemeshes.mesh.Face;
import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.activemeshes.mesh.Vertex;
import plugins.adufour.activemeshes.painters.VTKMeshPainter;
import plugins.adufour.ezplug.EzVarFolder;


/** 
 *  The following methods are based on the algorithm published in the following article: 
 * 		3D surface filtering using spherical harmonics
 *  	Kun Zhou, Hujun Bao and Jiaoying Shi.
 *  	In: Computer-Aided Design 36(4):363-375 (2004)
 *
 *  [Part II.2 - Spherical Parameterization]
 *  - 1) Recovering the original mesh 
 *  - 2) Building the spherical parameterization
 *  
 *  @author Yrvann EMZIVAT (March 2014)
 *  
 **/

public class SplitOperations {

	public int nbOperations;
	
	public ArrayList<Integer> vAlist;
	public ArrayList<Integer> vBlist;
	
	public ArrayList<Integer> vAfaceList;
	public ArrayList<Integer> vBfaceList;
	public ArrayList<Vector3d> vAparamList;
	public ArrayList<Vector3d> vBparamList;

	public ArrayList<Integer> deadFaces;
	public ArrayList<ArrayList<Integer>> fupdatePos;
	public ArrayList<ArrayList<Face>> fupdateList;
	
	public SplitOperations() {
		nbOperations = 0;
		
		vAlist = new ArrayList<Integer>();
		vBlist = new ArrayList<Integer>();
		
		vAfaceList = new ArrayList<Integer>();
		vBfaceList = new ArrayList<Integer>();
		vAparamList = new ArrayList<Vector3d>();
		vBparamList = new ArrayList<Vector3d>();

		deadFaces = new ArrayList<Integer>();
		fupdatePos = new ArrayList<ArrayList<Integer>>();
		fupdateList = new ArrayList<ArrayList<Face>>();
	}	
	
	public void rebuild(Mesh Mp, boolean exportCondition, boolean paintCondition, EzVarFolder varFolderOut, final Sequence seq, final VTKMeshPainter meshPaint) {
		
		for (int p=this.nbOperations-1; p>-1; p--) {			
			double alpha = 0;
			double beta  = 0;
			double gamma = 0;
			
			Point3d v1 = new Point3d();
			Point3d v2 = new Point3d();
			Point3d v3 = new Point3d();

			Vector3d vAtemp = new Vector3d();
			Vector3d vBtemp = new Vector3d();

		// Adding vertex B
			alpha = this.vBparamList.get(p).x;
			beta  = this.vBparamList.get(p).y;
			gamma = this.vBparamList.get(p).z;
			v1 = Mp.vertices.get(Mp.faces.get(this.vBfaceList.get(p)).v1).position;
			v2 = Mp.vertices.get(Mp.faces.get(this.vBfaceList.get(p)).v2).position;
			v3 = Mp.vertices.get(Mp.faces.get(this.vBfaceList.get(p)).v3).position;
			
			vBtemp.x += alpha*v1.x+beta*v2.x+gamma*v3.x;
			vBtemp.y += alpha*v1.y+beta*v2.y+gamma*v3.y; 
			vBtemp.z += alpha*v1.z+beta*v2.z+gamma*v3.z;				
		
			vBtemp.normalize();
			Point3d vBnew = new Point3d(vBtemp.x, vBtemp.y, vBtemp.z);
			Vertex vBnew2 = new Vertex(vBnew);
			Mp.vertices.set(this.vBlist.get(p),vBnew2);						

		// Moving vertex A
			alpha = this.vAparamList.get(p).x;
			beta  = this.vAparamList.get(p).y;
			gamma = this.vAparamList.get(p).z;
			
			v1 = Mp.vertices.get(Mp.faces.get(this.vAfaceList.get(p)).v1).position;
			v2 = Mp.vertices.get(Mp.faces.get(this.vAfaceList.get(p)).v2).position;
			v3 = Mp.vertices.get(Mp.faces.get(this.vAfaceList.get(p)).v3).position;
			
			vAtemp.x += alpha*v1.x+beta*v2.x+gamma*v3.x;
			vAtemp.y += alpha*v1.y+beta*v2.y+gamma*v3.y; 
			vAtemp.z += alpha*v1.z+beta*v2.z+gamma*v3.z;				
			
			vAtemp.normalize();
			Point3d vAnew = new Point3d(vAtemp.x, vAtemp.y, vAtemp.z);
			Vertex vAnew2 = new Vertex(vAnew);
			Mp.vertices.set(this.vAlist.get(p),vAnew2);

				
		// Building the faces
			for (int j=0; j<this.fupdatePos.get(p).size(); j++)
				Mp.faces.set(this.fupdatePos.get(p).get(j), this.fupdateList.get(p).get(j));			

			this.deadFaces.remove(2*p+1);
			this.deadFaces.remove(2*p);
			
			if (exportCondition) {	
				File VTKexport = new File(varFolderOut.getValue().toString() + "/SphMesh" + (p) + ".vtk.txt");
				PrintStream ps = null;
				try {
					ps = new PrintStream(VTKexport);
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				}
				Mp.exportToVTK(ps);
			}
			if (p==0) {	//TODO Rcuprer le nom du maillage de dpart
				File VTKexport = new File(varFolderOut.getValue().toString() + "/SphericalMesh.vtk.txt");
				PrintStream ps = null;
				try {
					ps = new PrintStream(VTKexport);
				} catch (FileNotFoundException e) {
					e.printStackTrace();
				}
				Mp.exportToVTK(ps);
			}
			if (paintCondition) {
				SwingUtilities.invokeLater(new Runnable() {
					@SuppressWarnings("deprecation")
					public void run() {
						seq.painterChanged(meshPaint);
					}
				});
			}

			System.out.println("   Spherical Mesh n" + p + " (done)");

		}

	}
}
