package plugins.fab.manualcounting;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.math.UnitUtil;
import icy.math.UnitUtil.UnitPrefix;
import icy.painter.Overlay;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.point.Point5D.Double;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import plugins.kernel.roi.roi2d.ROI2DEllipse;

public class ManualCountingOverlay extends Overlay {

	/** static font for absolute text */
	Font absoluteFont = new Font("Arial", Font.BOLD , 15 );

	/** Detection found */
	ArrayList<ROI2D> detectionArrayList = new ArrayList<ROI2D>();
	
	/** Other ROI found considered as containing ROI */
	ArrayList<ROI2D> roiArrayList = new ArrayList<ROI2D>();
	
	int currentColor= 0;
	int maxNumberOfColor=4;
	
	public ManualCountingOverlay() {

		super( "Manual Counting" , OverlayPriority.SHAPE_LOW );			
		
	}
		
	void drawAbsoluteString( String string ,int x, int y , Graphics2D g , IcyCanvas2D canvas )
	{
		AffineTransform transform = g.getTransform();		
		g.transform( canvas.getInverseTransform() );		
		g.setFont( absoluteFont );
		g.drawString( string , x, y );
		g.setTransform( transform );
	}
	
	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if (!( canvas instanceof IcyCanvas2D )) return;
		
		IcyCanvas2D canvas2D = (IcyCanvas2D) canvas;
		
		/** row of text */
		int row =1;
		
		// retreive ROIs

		detectionArrayList.clear();
		roiArrayList.clear();
		
		for ( ROI2D roi : sequence.getROI2Ds() )
		{
			if ( roi.getName().startsWith("detect") )
			{
				detectionArrayList.add( roi );
			}else
			{
				roiArrayList.add( roi );
			}
			
		}
		
		// Count and display

		g.setColor( getCurrentSelectedColor() );
		drawAbsoluteString( "Current color", 10, 15*row++, g, canvas2D );
		
		// all detections
		int nbTotalDetection = detectionArrayList.size();
		g.setColor( Color.white );
		drawAbsoluteString( "Nb total detection:" + nbTotalDetection, 10, 15*row++, g, canvas2D );

		for ( ROI2D roi : roiArrayList )
		{
			// ROI surface
			double surface = roi.getArea();
			double surface2 = roi.getArea() * sequence.getSizeX() ;
			UnitPrefix adjUnit = UnitUtil.getBestUnit(surface2, UnitPrefix.MICRO, 2);
			double adjustedValue = UnitUtil.getValueInUnit(surface2, UnitPrefix.MICRO, adjUnit, 2);
			g.setColor( roi.getColor() );
			drawAbsoluteString( "-- ROI "+roi.getName(), 10, 15*row++, g, canvas2D );
			drawAbsoluteString( "surface: " + surface + "px " + adjustedValue + adjUnit + "m", 10, 15*row++, g, canvas2D );

			// count number of detection inside
			int nbDetectionInROI = 0;
			for ( ROI2D detectROI : detectionArrayList )
			{
				if ( roi.contains( detectROI ) )
				{
					nbDetectionInROI++;
				}
			}
			drawAbsoluteString( "nb detection: " + nbDetectionInROI, 10, 15*row++, g, canvas2D );
			
		}
		
	}
	
	@Override
	public void keyPressed(KeyEvent e, Double imagePoint, IcyCanvas canvas) {

		if ( e.getKeyChar()=='c' || e.getKeyChar()=='C' )
		{
			currentColor++;
			currentColor = currentColor % maxNumberOfColor ;		
			e.consume();
			painterChanged();
		}
		
	}
	
	@Override
	public void mouseClick(MouseEvent e, Double imagePoint, IcyCanvas canvas) {
		
		if ( e.isConsumed() ) return;
		
		if ( e.getButton() == MouseEvent.BUTTON3 )
		{			
			ROI2D bestROI = null;
			double bestDistance = java.lang.Double.MAX_VALUE;
			Point2D clickPoint = new Point2D.Double( imagePoint.getX()-4 , imagePoint.getY()-4 ); // shift to match roi.getPosition2D
			// Remove the ROI closest to the click, but at at least min than a certain distance.
			for ( ROI2D roi : canvas.getSequence().getROI2Ds() )
			{
				if ( roi.getName().startsWith("detect") )
				{
					double distance = clickPoint.distance( roi.getPosition2D() );
					if ( distance < bestDistance )
					{
						bestDistance = distance;
						bestROI = roi;
					}
				}
			}
			if ( bestDistance < 30 && bestROI !=null )
			{
				canvas.getSequence().removeROI( bestROI );
				e.consume();
				canvas.getSequence().overlayChanged( this );
			}
		}else
		{
			// add ROI
			Color ROIColor= getCurrentSelectedColor();						
			int size = 4;
			if ( ROIColor == Color.yellow )
			{
				size=6;
			}
			ROI2D roi = new ROI2DEllipse( imagePoint.getX()-size , imagePoint.getY()-size , imagePoint.getX()+size , imagePoint.getY()+size );
			roi.setName( "detect" );
			roi.setColor(ROIColor);
			canvas.getSequence().addROI( roi );
			canvas.getSequence().overlayChanged( this );
			e.consume();
		}
			
	}

	private Color getCurrentSelectedColor() {
		Color selectedColor= Color.green;
		switch ( currentColor )
		{
		case 0: 
			selectedColor = Color.green;
			break;
		case 1: 
			selectedColor = Color.red;
			break;
		case 2: 
			selectedColor = Color.blue;
			break;
		case 3: 
			selectedColor = Color.yellow;
			break;
		}
		return selectedColor;
	}
	
	
}
