package plugins.fab.imageoverlay;

import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.painter.Anchor2D;
import icy.painter.Anchor2D.Anchor2DPositionListener;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;

public class ImageBlendOverlay extends Overlay implements Anchor2DPositionListener, SequenceListener, ViewerListener  {

    IcyBufferedImage sourceImage = null;
    IcyBufferedImage finalImage = null;

    Sequence sourceSequence = null;
    Sequence outSequence = null;

    Anchor2D anchor = new Anchor2D();
    
    BufferedImage renderedImage = null;
    
	public ImageBlendOverlay( Sequence sourceSequence , Sequence outSequence ) {
		super("Overlay " + sourceSequence.getName() );
		
		
		this.sourceSequence = sourceSequence;
		this.outSequence = outSequence;
				
		outSequence.addOverlay( anchor );
		
		anchor.addPositionListener( this );

		createRenderedImage();
		
		new ToolTipFrame( "<html>Overlay's shotcuts: <ul><li>Move top-left anchor to translate the image<li>Delete: remove layer<li>Arrow keys: move by 1 px<li>r: refresh image using its original viewer</ul></html>", 20 );
		
		sourceSequence.addListener( this );
		sourceSequence.getFirstViewer().addListener( this );
		
	}
	
	private void createRenderedImage() {

		Viewer sourceViewer = sourceSequence.getViewers().get( 0 );
		renderedImage = sourceViewer.getRenderedImage( sourceViewer.getPositionT() , sourceViewer.getPositionZ(), -1, false );
		
	}

	@Override
	public void positionChanged(Anchor2D source) {
		
		painterChanged();
		
	}
	
	public void keyPressed(java.awt.event.KeyEvent e, icy.type.point.Point5D.Double imagePoint, IcyCanvas canvas) {
		
		if ( e.isConsumed() ) return;
		
		if ( e.getKeyCode() == KeyEvent.VK_LEFT )
		{
			anchor.translate( -1 , 0 );
			e.consume();
		}
		if ( e.getKeyCode() == KeyEvent.VK_RIGHT )
		{
			anchor.translate( 1 , 0 );
			e.consume();
		}
		if ( e.getKeyCode() == KeyEvent.VK_DOWN )
		{
			anchor.translate( 0 , 1 );
			e.consume();
		}
		if ( e.getKeyCode() == KeyEvent.VK_UP )
		{
			anchor.translate( 0 , -1 );
			e.consume();
		}
		if ( e.getKeyCode() == KeyEvent.VK_DELETE )
		{
			deleteOverlay();
			e.consume();
		}
		if ( e.getKeyCode() == KeyEvent.VK_R )
		{
			createRenderedImage();
			painterChanged();
			//e.consume();
		}
		
	};
	
	
	
	private void deleteOverlay() {
		
		sourceSequence.removeListener( this );
		sourceSequence.getFirstViewer().removeListener( this );
		outSequence.removeOverlay( anchor );
		outSequence.removeOverlay( this );					
		
	}



	Composite additiveComposite = new AdditiveComposite();
	
	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		if ( g == null ) return;
		
		g = (Graphics2D) g.create();

		g.setColor( Color.white );
		g.drawString("( " + (int)anchor.getX() + " , " + (int)anchor.getY() + ")", (int)anchor.getX() + 10, (int)anchor.getY() +3 );

		g.translate( anchor.getPositionX(), anchor.getPositionY() );

		g.setComposite( additiveComposite );

		g.drawImage( renderedImage , null , 0, 0 );				

		
	}

	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		if ( sequenceEvent.getSequence() == outSequence ) return;
		
		createRenderedImage();
		painterChanged();
	}

	@Override
	public void sequenceClosed(Sequence sequence) {
		if ( sequence == outSequence ) return;
		deleteOverlay();
		
	}

	@Override
	public void viewerChanged(ViewerEvent event) {		
		createRenderedImage();
		painterChanged();
	}

	@Override
	public void viewerClosed(Viewer viewer) {
		deleteOverlay();
	}
	
	
}
