/*
 * Decompiled with CFR 0.152.
 */
import bilib.commons.buttons.ButtonFactory;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GUI;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import psf.Data3D;
import psf.PSF;
import psfgenerator.About;
import psfgenerator.CollectionPSF;
import psfgenerator.MainPanel;
import psfgenerator.ResultPlanesTable;
import psfgenerator.SummaryPanel;

public class PSF_Generator
implements PoolResponder,
PlugIn,
ActionListener {
    private Settings settings = new Settings("PSFGenerator", String.valueOf(IJ.getDirectory((String)"plugins")) + "PSFGenerator.txt");
    private String[] types = new String[]{"32-bits", "8-bits", "16-bits"};
    private String[] luts = new String[]{"Fire", "Spectrum", "Grays", "Green"};
    private MainPanel panel;
    private JFrame frame;
    private HashMap<String, JButton> buttons = new HashMap();

    public void run(String arg) {
        ArrayList<PSF> psfs = CollectionPSF.getStandardCollection();
        this.buildButtons();
        this.panel = new MainPanel(this.settings, this.buttons, psfs, this.luts, this.types, this);
        this.frame = new JFrame(About.title());
        this.frame.getContentPane().add(this.panel);
        this.frame.setResizable(false);
        this.frame.pack();
        GUI.center((Window)this.frame);
        this.frame.setVisible(true);
    }

    private void buildButtons() {
        this.buttons.clear();
        this.buttons.put("run", ButtonFactory.run(false));
        this.buttons.put("stop", ButtonFactory.stop(false));
        this.buttons.put("settings", ButtonFactory.prefs(false));
        this.buttons.put("help", ButtonFactory.help(false));
        this.buttons.put("about", ButtonFactory.about(false));
        this.buttons.put("close", ButtonFactory.close(false));
        this.buttons.get("close").addActionListener(this);
    }

    public void close() {
        if (this.panel != null) {
            this.settings.storeValue("PSF-shortname", this.panel.getSelectedPSFShortname());
            this.panel.onClosed();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.settings.storeRecordedItems();
    }

    public void actionPerformed(ActionEvent event) {
        JButton bn = (JButton)event.getSource();
        if (bn == this.buttons.get("close")) {
            this.close();
        }
    }

    public void onFailure(Pool pool, JobEvent event) {
        this.panel.setEnabledRun(true);
        Exception ex = event.getException();
        if (ex != null) {
            IJ.log((String)(" POOL " + pool.getName() + "  " + pool.size()));
            StackTraceElement[] elements = ex.getStackTrace();
            IJ.log((String)("" + event));
            StackTraceElement[] stackTraceElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                IJ.log((String)element.toString());
                ++n2;
            }
        }
    }

    public void onEvent(Pool pool, JobEvent event) {
    }

    public void onSuccess(Pool pool, JobEvent event) {
        if (event.getJob() instanceof PSF) {
            int type = this.panel.getSelectedType();
            int lut = this.panel.getSelectedLUT();
            PSF psf = (PSF)event.getSource();
            this.panel.finish();
            ImagePlus imp = this.createImagePlus(psf, type);
            this.display(psf, imp, lut);
            JFrame frame = new JFrame("Characterization of PSF");
            JTabbedPane tab = new JTabbedPane();
            tab.add("Summary", new SummaryPanel(psf));
            tab.add("Plane by plane", new ResultPlanesTable(psf));
            frame.getContentPane().add(tab);
            frame.pack();
            frame.setResizable(false);
            frame.setVisible(true);
        }
        this.panel.setEnabledRun(true);
    }

    public ImagePlus createImagePlus(PSF psf, int type) {
        String name = psf.getShortname();
        Data3D data = psf.getData();
        int nx = data.nx;
        int ny = data.ny;
        int nz = data.nz;
        ImageStack stack = new ImageStack(nx, ny);
        int z = 0;
        while (z < nz) {
            if (type == 0) {
                stack.addSlice((ImageProcessor)new FloatProcessor(nx, ny, data.createAsFloat(z)));
            } else if (type == 2) {
                stack.addSlice((ImageProcessor)new ShortProcessor(nx, ny, data.createAsShort(z), null));
            } else if (type == 1) {
                stack.addSlice((ImageProcessor)new ByteProcessor(nx, ny, data.createAsByte(z)));
            }
            ++z;
        }
        return new ImagePlus("PSF " + name, stack);
    }

    private void display(PSF psf, ImagePlus imp, int lut) {
        imp.show();
        imp.setSlice(imp.getStackSize() / 2);
        imp.getCalibration().pixelHeight = psf.resLateral;
        imp.getCalibration().pixelWidth = psf.resLateral;
        imp.getCalibration().pixelDepth = psf.resAxial;
        imp.getCalibration().setUnit("nm");
        try {
            IJ.run((String)this.luts[lut]);
        }
        catch (Exception e) {
            IJ.error((String)("Unknown LUT " + this.luts[lut]));
        }
    }
}

